// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_SIGNATURE_)

#define _MTG_SIGNATURE_



MTG_BEGIN_NAMESPACE





//

//   t S i g n a t u r e

//



class tSignature {



    size_t m_nSize;

    int m_nNumOfFlags;



        // Every signature has a tag.



    int m_nTag;



        // The default number of flags is 32.



    unsigned char m_aPreallocFlag[4];

    unsigned char *m_aFlag;



        // Some helper functions.



    void init( int nNumOfFlags );

    void clear();



public:



    tSignature( int nNumOfFlags = 32 );

    tSignature( const tSignature& Sig );



    ~tSignature();



    void reset();

    void reset( int nNumOfFlags );



    tSignature& operator=( const tSignature& Sig );



    void copyFrom( const tSignature& Sig );



    tSignature* clone() const;



    bool operator==( const tSignature& Sig ) const;



    tSignature& operator&=( const tSignature& Sig );

    tSignature& operator|=( const tSignature& Sig );

    tSignature& operator^=( const tSignature& Sig );



    void setTag( int nTag ) {

        m_nTag = nTag;

    }



    int tag() const {

        return m_nTag;

    }



    void on( int nFlag ) {

        MTG_ASSERT( nFlag >= 0 && nFlag < m_nNumOfFlags );

        m_aFlag[nFlag / 8] |= ( 1 << nFlag % 8 );

    }



    void off( int nFlag ) {

        MTG_ASSERT( nFlag >= 0 && nFlag < m_nNumOfFlags );

        m_aFlag[nFlag / 8] &= ~( 1 << nFlag % 8 );

    }



    void toggle( int nFlag ) {

        MTG_ASSERT( nFlag >= 0 && nFlag < m_nNumOfFlags );

        m_aFlag[nFlag / 8] ^= ( 1 << nFlag % 8 );

    }



    bool operator[]( int nFlag ) const {

        MTG_ASSERT( nFlag >= 0 && nFlag < m_nNumOfFlags );

        return ( m_aFlag[nFlag / 8] & ( 1 << nFlag % 8 ) ) ? true : false;

    }



    bool isEmpty() const {

        for( size_t i = 0; i < m_nSize; ++i ) {

            if( m_aFlag[i] != 0 )

                return false;

        }

        return true;

    }

      

    bool isFull() const {

        return numOfFlags() == flagsOn();

    }



    tSignature& operator|=( int nFlag ) {

        on( nFlag );

        return *this;

    }



    tSignature& operator-=( int nFlag ) {

        off( nFlag );

        return *this;

    }



    int flagsOn() const;



    size_t size() const {

        return m_nSize;

    }



    int numOfFlags() const {

        return m_nNumOfFlags;

    }



    unsigned char flag( int nPos ) const {

        return m_aFlag[nPos];

    }



#if defined(_MTG_WITH_MATHLINK)

    tRetCode toMathLink( MLINK MathLink ) const;

#endif

};



MTG_END_NAMESPACE



#endif

