// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_SOCKET_)

#define _MTG_SOCKET_



MTG_BEGIN_NAMESPACE





//

//   t S o c k e t

//



class tSocket {



public:



    class tTask {

    public:

        virtual void run( tSocket& Sock ) = 0;

    };



private:



    struct tThread {

        int m_nId;

        tTask* m_pServer;

        tSocket* m_pSocket;

    };



    int m_nFd;

        

    unsigned long m_nMyNetAddr;    // network byte order

    int m_nMyPort;                 // host byte order  



    unsigned long m_nPeerNetAddr;  // network byte order

    int m_nPeerPort;               // host byte order  



    time_t m_nTimeout;



    char *m_sBuffer;

    size_t m_nSize;

    

    size_t m_nReceived;  

    size_t m_nNextChar;



    void init();



    tRetCode getMyAddr();

    tRetCode getPeerAddr();



    tRetCode getAddr();



    static void threadStub( tThread* pThread );



public:



    tSocket();

    tSocket( const tSocket& Sock );



    ~tSocket();



    void reset();



    tSocket& operator=( const tSocket& Sock );



    void copyFrom( const tSocket& Sock );



    void setTimeout( time_t nTimeout = 60 );    

    void setSize( size_t nSize = 1024 );



    tRetCode connect( unsigned long nNetAddr, int nPort );

    tRetCode connect( const char* sHost, int nPort );



    tRetCode listen( int nPort, int nOpenConnections = 5 );



    tRetCode singleServerAccept( tSocket& Child );

    tRetCode singleServerAccept( tTask& Server );



    tRetCode multiServerAccept( tTask& Server );

    tRetCode multiServerAccept( tTask& Server, int& nPid );



    void close();



    bool isConnected() const {

        return m_nFd > 0;

    }



    tRetCode readPending();

    tRetCode readPending( time_t nTimeout );



    static tRetCode readPending( tSocket& Sock1, tSocket& Sock2, int& nWho );

    static tRetCode readPending( tSocket& Sock1, tSocket& Sock2, int& nWho,

        time_t nTimeout );



    tRetCode read( char* sBuffer, size_t& nSize );

    tRetCode read();



    tRetCode write( const char* sString );

    tRetCode write( const char* sBuffer, size_t nSize );



        // read() and readChar() are

        // transparent in the following sense:

        //

        // readChar() calls read() to load the buffer if

        // it has run out of data. If read() is 

        // called before readChar() has exhausted the buffer, 

        // the remaining data in the buffer are inserted 

        // before any data that is read from the socket

        // (thus, there is no data loss). If, however, readChar()

        // is called after read(), the buffer content is completely

        // replaced, according to the philosophy that it is the

        // responsibility of the caller of read() to process the

        // buffer.

        

    tRetCode readChar( char& c );

    void unreadChar();



    const char* getMyHostName() const;

    const char* getPeerHostName() const;



    int myPort() const {

        return m_nMyPort;

    }



    int peerPort() const {

        return m_nPeerPort;

    }



        // Find out the Internet address of the local host (or a

        // address, if the host is multi-homed).



    static tRetCode getLocalAddr( unsigned long& iNetAddr );



        // Convert the host name to an Internet address in network

        // byte order.



    static tRetCode host2Addr( const char* host, unsigned long& iNetAddr );



        // Convert the Internet address in network byte order to

        // dotted-decimal notation. At return, host points to a

        // shared string!



    static tRetCode addr2DecDot( unsigned long iNetAddr, const char *&host );



        // In Windows, the WSA startup and cleanup functions are

        // hidden here:



    static tRetCode startup();

    static void cleanup();

};



MTG_END_NAMESPACE



#endif

