// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_STD_CLAIM_)

#define _MTG_STD_CLAIM_



#include "MtgClaim.h"

#include "MtgLookup.h"



MTG_BEGIN_NAMESPACE



class tParser;

class tPortfolio;





//

//   t S t d C l a i m

//

    

class tStdClaim : public tClaim {



    typedef tClaim super;



public:



    enum tType {

        xLinearCall,

        xLinearPut,

        xDigitalCall,

        xDigitalPut

    };



private:



    tType m_nType;

    bool m_bIsAmerican;

    double m_gStrike;



    void init();



    double payoff( tEngine& Engine );

    tExPolicy monitor( tEngine& Engine, double gUnitValue );



    tRetCode parseParam( tParser& Parser, tParseInfoStub& Info );

        

public:



    tStdClaim();

    tStdClaim( tType nType, bool bIsAmerican );

    tStdClaim( const tStdClaim& Claim );



    ~tStdClaim();



    tStdClaim& operator=( const tStdClaim& Claim );



    void copyFrom( const tStdClaim& Claim );



    tObject* clone() const;



    tRetCode finalize();

    tRetCode resolve( tLookup<int>& Claim, tLookup<int>& Factor,

        tHeap<tFactor*>& FactorPtr, tPortfolio& Pf );

};



MTG_END_NAMESPACE



#endif

