// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_STEP_VOL_)

#define _MTG_STEP_VOL_



#include "MtgVol.h"

#include "MtgSqTermStruct.h"



MTG_BEGIN_NAMESPACE



class tParser;





//

//   t S t e p V o l

//



class tStepVol : public tVol { 



    typedef tVol super;



    tSqTermStruct m_PriorTermStruct;

    tSqTermStruct m_MinTermStruct;

    tSqTermStruct m_MaxTermStruct;



    tRetCode parseParam( tParser& Parser, tParseInfoStub& Info );

    tRetCode parsePostfix( tParser& Parser, tParseInfoStub& Info );



public:



    tStepVol();

    tStepVol( const tStepVol& Vol );



    ~tStepVol();



    tStepVol& operator=( const tStepVol& Vol );



    void copyFrom( const tStepVol& Vol );



    tObject* clone() const;



    tRetCode finalize();



        // All requests are simply forwarded to the

        // term structure object.



    void getFwdRange( double& gMin, double& gMax ) const;



        // Recall that all time units are admissible, as long

        // as they are consistent. The most commont one is the day.



        // If nothing else is mentioned, the prior is meant:



    double forward( int nUnit ) const {

        return m_PriorTermStruct.forward( nUnit );

    }



    double forward( int nFromUnit, int nToUnit ) const {

        return m_PriorTermStruct.forward( nFromUnit, nToUnit );

    }



    double implied( int nMaturity ) const {

        return m_PriorTermStruct.implied( nMaturity );

    }



        // Otherwise, it has to be explicit:



    void forward( int nUnit, double& gMin, double& gMax ) const;

    void forward( int nFromUnit, int nToUnit,

        double& gMin, double& gMax ) const;



    void implied( int nMaturity, double& gMin, double& gMax ) const;



    void forward( int nUnit, double& gPrior, double& gMin,

        double& gMax ) const;



    void forward( int nFromUnit, int nToUnit, double& gPrior,

        double& gMin, double& gMax ) const;



    void implied( int nMaturity, double& gPrior,

        double& gMin, double& gMax ) const;

};



MTG_END_NAMESPACE



#endif

