// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_SUMMARY_)

#define _MTG_SUMMARY_



#include "MtgProfile.h"

#include "MtgMultiArray.h"



MTG_BEGIN_NAMESPACE





//

//   t S u m m a r y

//



class tSummary : public tProfile {



	typedef tProfile super;



    void init();



    tRetCode updateLocation( int nId, tItem* pItem, tLevelItem*& pLevel,

        tTaskItem*& pTask );



        // Get particular items:



    tRetCode getAlternativeItem( tAlternativeItem*& pAlternative );

    tRetCode getLatticeItem( tLatticeItem*& pLattice );

    tRetCode getSlotLayerItem( tSlotLayerItem*& pLayer );

    tRetCode getSlotLayerItem( int nId, tSlotLayerItem*& pLayer );

    tRetCode getTaskItem( tTaskItem*& pTask );

    tRetCode getTaskItem( int nId, tTaskItem*& pTask );



        // General information.



    tRetCode getBounds( tArrayBounds& Bounds );

    tRetCode getSlotLayers( tHeap<tSlotLayerItem*>& Layer );



        // Layer related information.



    tRetCode getAltOverall( int nId, tMultiArray<int>& Aggregate,

        int tAlternativeItem::* pField, int nFill );

    tRetCode getComplexity( int nId, tMultiArray<int>& Complexity );

    tRetCode getMaxComplexity( int& nMaxComplexity );

    tRetCode getDependency( int nId, tMultiArray<int>& Dependency );

    tRetCode getBoundary( int nId, tMultiArray<int>& Boundary );



    tRetCode getValOverall( int nId, tMultiArray<double>& Aggregate,

        tValueItem::tType nType, double gFill );



    tRetCode getVolatility( int nId, tMultiArray<double>& Volatility );

    tRetCode getTotal( int nId, tMultiArray<double>& Total );



        // Aggregate layer information.



    tRetCode getTotal( const tHeap<int>& LayerSign,

        tMultiArray<int>* pValid, tMultiArray<double>* pTotal );



        // Claim related information.



    tRetCode getExPolicy( int nLayer, tExPolicy nExPolicy,

        const tHeap<int>& ClaimSign, tMultiArray<int>* pExPolicy, 

        tMultiArray<double>* pPayoff );



        // No copying is allowed for summaries, so the copy constructor

        // and the assignment operator are private.



    tSummary( const tSummary& Summary ) {

        throw tException( INTERNAL_ERROR );

    }



    tSummary& operator=( const tSummary& Summary ) {

        throw tException( INTERNAL_ERROR );

        return *this;

    }



public:



    tSummary();

    tSummary( const char* sFileName );



    ~tSummary();



#if defined(_MTG_WITH_MATHLINK)



        // General information.



    tRetCode sendLattice( MLINK MathLink );

    tRetCode sendSlotLayers( MLINK MathLink );



        // Layer related information.



    tRetCode sendComplexity( MLINK MathLink, int nLayer );

    tRetCode sendMaxComplexity( MLINK MathLink );

    tRetCode sendDependency( MLINK MathLink, int nLayer );

    tRetCode sendBoundary( MLINK MathLink, int nLayer );

    tRetCode sendVolatility( MLINK MathLink, int nLayer );

    tRetCode sendTotal( MLINK MathLink, int nLayer );



        // Aggregate layer information.



    tRetCode sendTotal( MLINK MathLink, const tHeap<int>& LayerSign );



        // Claim related information.



    tRetCode sendMayExPolicy( MLINK MathLink, int nLayer,

        const tHeap<int>& ClaimSign );



    tRetCode sendMayExPayoff( MLINK MathLink, int nLayer,

        const tHeap<int>& ClaimSign );



    tRetCode sendForceExPolicy( MLINK MathLink, int nLayer,

        const tHeap<int>& ClaimSign );



    tRetCode sendForceExPayoff( MLINK MathLink, int nLayer,

        const tHeap<int>& ClaimSign );



#endif



};



MTG_END_NAMESPACE



#endif

