// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#include "MtgIncl.h"

#include "MtgSystem.h"



MTG_BEGIN_NAMESPACE





//

//   c o p y F r o m

//



void tSystem::copyFrom( const tSystem& System )



{

    if( &System == this )

        return;



    m_Creation = System.m_Creation;

    m_Base = System.m_Base;

    m_DayCount = System.m_DayCount;

    m_pVerbose = System.m_pVerbose;



    super::copyFrom( System );

}





//

//   p a r s e P a r a m

//



tRetCode tSystem::parseParam( tParser& Parser, tParseInfoStub& Info )



{

    tRetCode nRet;

    tParseInfo& I = static_cast<tParseInfo&>( Info );

 

    nRet = m_DayCount.parse( Parser );



    if( nRet == OK ) {

        if( I.m_bDayCount ) 

            return Parser.setError( "day count defined more than once" );

        I.m_bDayCount = true;

        return nRet;

    }



    if( nRet != GO )

        return nRet;

    

    switch( Parser.curToken() ) {

        case xTokBase :

            if( I.m_bBase )

                return Parser.setError( "'base' defined more than once" );

            if( ( nRet = Parser.readToken() ) != OK ||

                ( nRet = Parser.scanDate( m_Base ) ) != OK ) {

                return nRet;

            }

            I.m_bBase = true;

            break;



        default :

            return super::parseParam( Parser, Info );

    }



    return OK;

}





//

//   t S y s t e m

//



tSystem::tSystem()



{

    m_Creation = time( NULL );

    m_Base = tDate::today();

    m_DayCount = DayCountACT_365;

    m_pVerbose = &cerr;

}





//

//   t S y s t e m

//



tSystem::tSystem( const tSystem& System )



{

    m_Creation = time( NULL );

    m_Base = System.m_Base;

    m_DayCount = System.m_DayCount;

    m_pVerbose = System.m_pVerbose;

}





//

//   o p e r a t o r =

//



tSystem& tSystem::operator=( const tSystem& System )



{

    if( &System != this )

        copyFrom( System );

    return *this;

}





//

//   c l o n e

//



tObject* tSystem::clone() const



{

    return new tSystem( *this );

}





//

//   v e r b o s e A r g

//



void tSystem::verboseArg( const char* sFmt, va_list Arg ) const



{

    MTG_ASSERT( sFmt != 0 );



    m_pVerbose->flush();

    if( m_pVerbose == &cerr ) {

        vfprintf( stderr, sFmt, Arg );

    }

    else

    if( m_pVerbose == &cout ) {

        vprintf( sFmt, Arg );

    }

    else {

        char sBuffer[2048];

        int n = vsprintf( sBuffer, sFmt, Arg );



        if( n < 0 || n >= sizeof(sBuffer) )

            throw tException( INTERNAL_ERROR );

        *m_pVerbose << sBuffer;

    }

}





//

//   v e r b o s e

//



void tSystem::verbose( const char* sFmt, ... ) const 



{

    MTG_ASSERT( sFmt != 0 );



    va_list Marker;

    va_start( Marker, sFmt );



    verbose( sFmt, Marker );

}





//

//   p a r s e

//



tRetCode tSystem::parse( tParser& Parser )



{

    tRetCode nRet;

    tParseInfo Info;



    Info.m_bBase = false;

    Info.m_bDayCount = false;



    if( ( nRet = Parser.scanBeginOfObj() ) != OK )

        return nRet;



    return super::parse( Parser, &Info );

}





//

//   p a r s e

//



tRetCode tSystem::parse( tParser& Parser, tObject*& pObj )



{

    tRetCode nRet;

    tSystem* pSystem;



    pSystem = new tSystem;



    if( ( nRet = pSystem->parse( Parser ) ) != OK ) {

        delete pSystem;

        return nRet;

    }



    pObj = pSystem;

    return OK;

}



MTG_END_NAMESPACE