// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_SYSTEM_)

#define _MTG_SYSTEM_



#include "MtgDayCount.h"

#include "MtgObject.h"

#include "MtgParser.h"



MTG_BEGIN_NAMESPACE





//

//   t S y s t e m

//



class tSystem : public tObject {



    typedef tObject super;



    struct tParseInfo : super::tParseInfoStub {

        bool m_bBase;

        bool m_bDayCount;

    };



        // When was this object created?



    time_t m_Creation;



        // The base date is the date used for date-to-integer

        // conversions. (The day count convention is used for that.)

        // Default: today.



    tDate m_Base;



        // Well, this is the day count convention. Dafault: ACT/365.



    tDayCount m_DayCount;



        // Where does the verbose output go?



    ostream* m_pVerbose;



    void copyFrom( const tSystem& System );



    tRetCode parseParam( tParser& Parser, tParseInfoStub& Info );



public:



    tSystem();

    tSystem( const tSystem& System );



    tSystem& operator=( const tSystem& System );



    tObject* clone() const;



        // Retrieve parameters.



    time_t creation() const {

        return m_Creation;

    }



    tDate base() const {

        return m_Base;

    }



    const tDayCount& dayCount() const {

        return m_DayCount;

    }



    ostream& verbose() const {

        MTG_ASSERT( m_pVerbose != 0 );

        return *m_pVerbose;

    }



        // Do some calculations.



    int dateIndex( tDate Date ) const {

        MTG_ASSERT( Date >= m_Base );

        return m_DayCount.numOfDays( m_Base, Date );

    }



        // Offer some services:

    

    void verboseArg( const char* sFmt, va_list Arg ) const;

    void verbose( const char* sFmt, ... ) const;



        // For tSystem, there exists a non-static parse

        // function, since existing tSystem objects can

        // be redefined.



    tRetCode parse( tParser& Parser );



    static tRetCode parse( tParser& Parser, tObject*& pObj );

};



MTG_END_NAMESPACE



#endif

