// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_TCL_BOND_MATH_)

#define _MTG_TCL_BOND_MATH_



#include "MtgUSBondMath.h"

#include "MtgTclKernel.h"

#include "MtgTclTools.h"



MTG_BEGIN_NAMESPACE



#if defined(_MTG_WITH_TCL)



//

//   t T c l B o n d M a t h

//



class tTclBondMath : public tTclTools {



    typedef tTclTools super;



        // Helper functions:



    static bool getDate( Tcl_Obj* pObj, tDate& Date );



    static bool tTclBondMath::getArgs( Tcl_Interp *pInterp, int objc,

        Tcl_Obj *CONST objv[], char* sUsage, 

        tDate& Trade, tDate& Maturity, double& gQuantityA, 

        double* pQuantityB, tDayShift*& pShift, tBondMath*& pMath );



        // Tcl commands:



    #define MTG_DECLARE_CMD( f ) \

        static int f( ClientData ClientData, Tcl_Interp *pInterp, \

            int objc, Tcl_Obj *CONST objv[] );



    MTG_DECLARE_CMD( billPrice )

    MTG_DECLARE_CMD( billDiscount );

    MTG_DECLARE_CMD( billMMYield );

    MTG_DECLARE_CMD( billBEYield );



    MTG_DECLARE_CMD( bondDirtyPrice );

    MTG_DECLARE_CMD( bondCleanPrice );

    MTG_DECLARE_CMD( bondDirty2Yield );

    MTG_DECLARE_CMD( bondClean2Yield );



    #undef MTG_DECLARE_CMD



public:



    static tRetCode createExtension( tTclKernel& Kernel );

};



#endif



MTG_END_NAMESPACE



#endif

