// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_TCL_CGI_)

#define _MTG_TCL_CGI_



#include "MtgCgi.h"

#include "MtgTclKernel.h"



MTG_BEGIN_NAMESPACE



#if defined(_MTG_WITH_TCL) && defined(_MTG_WITH_CGI)





//

//   t T c l C g i

//



class tTclCgi : public tCgi {



    typedef tCgi super;



    enum tVarType {

        xTextVar,

        xDateVar,

        xIntVar,

        xPosIntVar,

        xNonNegIntVar,

        xDoubleVar,

        xPosDoubleVar,

        xNonNegDoubleVar

    };



        // Options valid for all variable types:

        

    static bool getOptions( Tcl_Interp* pInterp, int objc,

        Tcl_Obj *CONST objv[], int& nNextObj, tVarType& nVarType,

        Tcl_Obj*& pDefault, Tcl_Obj*& pChoices );



        // Retrieve variables by type:

        

    static tRetCode cgiGetTextVar( Tcl_Interp* pInterp, tVarType nVarType,

        char* sCgiVar, Tcl_Obj* pChoices, Tcl_Obj*& pResult );



    static tRetCode cgiGetDateVar( Tcl_Interp* pInterp, tVarType nVarType,

        char* sCgiVar, Tcl_Obj* pChoices, Tcl_Obj*& pResult );



    static tRetCode cgiGetIntVar( Tcl_Interp* pInterp, tVarType nVarType,

        char* sCgiVar, Tcl_Obj* pChoices, Tcl_Obj*& pResult );



    static tRetCode cgiGetDoubleVar( Tcl_Interp* pInterp, tVarType nVarType,

        char* sCgiVar, Tcl_Obj* pChoices, Tcl_Obj*& pResult );



        // Tcl commands:



    #define MTG_DECLARE_CMD( f ) \

        static int f( ClientData ClientData, Tcl_Interp *pInterp, \

            int objc, Tcl_Obj *CONST objv[] );



    MTG_DECLARE_CMD( cgiIsActive )

    MTG_DECLARE_CMD( cgiServerSoftware )

    MTG_DECLARE_CMD( cgiServerName )

    MTG_DECLARE_CMD( cgiGatewayInterface )

    MTG_DECLARE_CMD( cgiServerProtocol )

    MTG_DECLARE_CMD( cgiServerPort )

    MTG_DECLARE_CMD( cgiRequestMethod )

    MTG_DECLARE_CMD( cgiPathInfo )

    MTG_DECLARE_CMD( cgiPathTranslated )

    MTG_DECLARE_CMD( cgiScriptName )    

    MTG_DECLARE_CMD( cgiQueryString )

    MTG_DECLARE_CMD( cgiRemoteHost )

    MTG_DECLARE_CMD( cgiRemoteAddr )

    MTG_DECLARE_CMD( cgiAuthType )

    MTG_DECLARE_CMD( cgiRemoteUser )

    MTG_DECLARE_CMD( cgiRemoteIdent )

    MTG_DECLARE_CMD( cgiContentType )

    MTG_DECLARE_CMD( cgiAccept )

    MTG_DECLARE_CMD( cgiUserAgent )        

    MTG_DECLARE_CMD( cgiGetVar )

    MTG_DECLARE_CMD( cgiMakeHttpHeader )

    MTG_DECLARE_CMD( cgiOutHttpHeader )

    MTG_DECLARE_CMD( cgiOut )



    #undef MTG_DECLARE_CMD



public:



    static tRetCode createExtension( tTclKernel& Kernel );

};



#endif



MTG_END_NAMESPACE



#endif