// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_TCL_HTML_READER_)

#define _MTG_TCL_HTML_READER_



#include "MtgHtmlReader.h"

#include "MtgTclKernel.h"



MTG_BEGIN_NAMESPACE



#if defined(_MTG_WITH_TCL)



//

//   t T c l H t m l R e a d e r

//



class tTclHtmlReader {



    tHtmlDoc m_Doc;

    tHtmlReader* m_pReader;



    static Tcl_ObjType m_Type;



        // Internal helper functions:



    tTclHtmlReader( const char* sSource );

    ~tTclHtmlReader();



    static int setFromAnyProc( Tcl_Interp *pInterp, Tcl_Obj *pObj );

    static void updateStringProc( Tcl_Obj *pObj );

    static void dupInternalRepProc( Tcl_Obj *pSrc, Tcl_Obj *pDup );

    static void freeInternalRepProc( Tcl_Obj *pObj );



    static Tcl_Obj* newObj( const char* sSource );

    static tHtmlReader* getReader( Tcl_Interp* pInterp, Tcl_Obj* pObj );



    static int dataToList( Tcl_Interp* pInterp, tHeap<int>& Data );



    static int tTclHtmlReader::dataToList( Tcl_Interp* pInterp,

        tHeap<const char*>& Data );



    static int tTclHtmlReader::dataToList( Tcl_Interp* pInterp,

        tHeap2<const char*>& Data );



        // Tcl commands:



    #define MTG_DECLARE_CMD( f ) \

        static int f( ClientData ClientData, Tcl_Interp *pInterp, \

            int objc, Tcl_Obj *CONST objv[] );



    MTG_DECLARE_CMD( createHtmlReader )



    MTG_DECLARE_CMD( hrTop )

    MTG_DECLARE_CMD( hrPush )

    MTG_DECLARE_CMD( hrPop )



    MTG_DECLARE_CMD( hrSelectTable )

    MTG_DECLARE_CMD( hrSelectRow )

    MTG_DECLARE_CMD( hrSelectField )



    MTG_DECLARE_CMD( hrSelectNextInRow )

    MTG_DECLARE_CMD( hrSelectNextInColumn )



    MTG_DECLARE_CMD( hrValidSelection )



    MTG_DECLARE_CMD( hrReadField );

    MTG_DECLARE_CMD( hrReadRow );

    MTG_DECLARE_CMD( hrReadColumn );

    MTG_DECLARE_CMD( hrReadMatrix );



    MTG_DECLARE_CMD( hrFindSubstring );



    #undef MTG_DECLARE_CMD



public:



    static tRetCode createExtension( tTclKernel& Kernel );

};



#endif



MTG_END_NAMESPACE



#endif