// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_TCL_INTEREST_)

#define _MTG_TCL_INTEREST_



#include "MtgBondMath.h"

#include "MtgDrift.h"

#include "MtgInterestSpline.h"

#include "MtgTclKernel.h"

#include "MtgTclTools.h"



MTG_BEGIN_NAMESPACE



#if defined(_MTG_WITH_TCL)





//

//   t T c l I n t e r e s t

//



class tTclInterest : public tTclTools {



    typedef tTclTools super;

        

        // covers tInterest, tInterestSpline and tDrift



    static Tcl_ObjType m_Spline;

    static Tcl_ObjType m_Drift;



    static int setSpline( Tcl_Interp *pInterp, Tcl_Obj *pObj );

    static void updateSpline( Tcl_Obj *pObj );

    static void dupSpline( Tcl_Obj *pSrc, Tcl_Obj *pDup );

    static void freeSpline( Tcl_Obj *pObj );



    static int setDrift( Tcl_Interp *pInterp, Tcl_Obj *pObj );

    static void updateDrift( Tcl_Obj *pObj );

    static void dupDrift( Tcl_Obj *pSrc, Tcl_Obj *pDup );

    static void freeDrift( Tcl_Obj *pObj );



    static tInterestSpline* getSpline( Tcl_Interp* pInterp, Tcl_Obj* pObj );



    static bool getInterest( Tcl_Interp* pInterp, int objc,

        Tcl_Obj *CONST objv[], int& nNextObj, tInterest* pInterest,

        tDate* pBase = 0 );



    static bool getCompounder( Tcl_Interp* pInterp, int objc,

        Tcl_Obj *CONST objv[], int& nNextObj, bool& bHasCompounder,

        double& gCoupon, tBondMath*& pMath );



    static bool getDate( Tcl_Obj* pObj, tDate& Date );



    static int service( Tcl_Interp *pInterp,

        int objc, Tcl_Obj *CONST objv[], char* sUsage,

        double (tInterest::*Svc)( tDate, tDate, double ) const );



        // Tcl commands:



    #define MTG_DECLARE_CMD( f ) \

        static int f( ClientData ClientData, Tcl_Interp *pInterp, \

            int objc, Tcl_Obj *CONST objv[] );



    MTG_DECLARE_CMD( presentValue )

    MTG_DECLARE_CMD( futureValue )



    MTG_DECLARE_CMD( invPresentValue )

    MTG_DECLARE_CMD( invFutureValue )



    MTG_DECLARE_CMD( createSpline )

    MTG_DECLARE_CMD( createDrift )



    MTG_DECLARE_CMD( splineAddPayment )

    MTG_DECLARE_CMD( splineGetForwardCurve )



    #undef MTG_DECLARE_CMD



public:



    static tRetCode createExtension( tTclKernel& Kernel );

};



#endif



MTG_END_NAMESPACE



#endif

