// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#include "MtgIncl.h"

#include "MtgTclTools.h"

#include "MtgDayShift.h"

#include "MtgUSBondMath.h"



MTG_BEGIN_NAMESPACE



#if defined(_MTG_WITH_TCL)





//

//   g e t D a t e

//



bool tTclTools::getDate( Tcl_Interp* pInterp, int objc, 

    Tcl_Obj *CONST objv[], int& nNextObj, tDate& Date )



{

    if( nNextObj >= objc )

        return false;



    try {

        int nLength;

        Date = Tcl_GetStringFromObj( objv[nNextObj], &nLength );

    }

    catch( tException ) {

        return false;

    }



    ++nNextObj;

    return true;

}





//

//   g e t D a y S h i f t

//



bool tTclTools::getDayShift( Tcl_Interp* pInterp, int objc, 

    Tcl_Obj *CONST objv[], int& nNextObj, tDayShift*& pShift )



{

    MTG_ASSERT( pShift == 0 );



    if( nNextObj >= objc )

        return true;



    int nLength;

    char* sString = Tcl_GetStringFromObj( objv[nNextObj], &nLength );



    if( nLength == 0 || *sString != '-' )

        return true;



    static struct tKeyWord {

        const char* m_sName;

        int m_nId;

    } KeyWord[] = {

        { "-identity", 0 },

        { "-following", 1 },

        { "-preceding", 2 },

        { "-modified", 3 }

    };



    char* s = StrToLower( sString );

    int k = 0;



    for( k = 0; k < sizeof(KeyWord) / sizeof(tKeyWord); ++k ) {

        if( strcmp( s, KeyWord[k].m_sName ) == 0 )

            break;

    }

    delete s;



    if( k == sizeof(KeyWord) / sizeof(tKeyWord) )

        return true;



    tKeyWord& W = KeyWord[k];



    ++nNextObj;

    int n = 0;



    switch( W.m_nId ) {

        case 0:

            pShift = new tIdentityDayShift;

            break;



        case 1:

            if( nNextObj < objc && Tcl_GetIntFromObj( pInterp, 

                    objv[nNextObj], &n ) == TCL_OK ) {

                pShift = new tFollowingDayShift( n );

                ++nNextObj;

            }

            else {

                pShift = new tFollowingDayShift;

            }

            break;



        case 2:

            if( nNextObj < objc && Tcl_GetIntFromObj( pInterp, 

                    objv[nNextObj], &n ) == TCL_OK ) {

                pShift = new tPrecedingDayShift( n );

                ++nNextObj;

            }

            else {

                pShift = new tPrecedingDayShift;

            }

            break;



        case 3:

            pShift = new tModifiedDayShift;

            break;



        default:

            throw tException( INTERNAL_ERROR );

    }



    return true;

}





//

//   g e t B o n d M a t h

//



bool tTclTools::getBondMath( Tcl_Interp* pInterp, int objc,

    Tcl_Obj *CONST objv[], int& nNextObj, tBondMath*& pMath )



{

    MTG_ASSERT( pMath == 0 );



    if( nNextObj >= objc )

        return true;



    int nLength;

    char* sString = Tcl_GetStringFromObj( objv[nNextObj], &nLength );



    if( nLength == 0 || *sString != '-' )

        return true;



    static struct tKeyWord {

        const char* m_sName;

        tBondMath* m_pMath;

    } KeyWord[] = {

        { "-canada", &USBondMath },

        { "-france", &USBondMath },

        { "-germany", &USBondMath },

        { "-italy", &USBondMath },

        { "-japan", &USBondMath },

        { "-uk", &USBondMath },

        { "-us", &USBondMath },

    };



    char* s = StrToLower( sString );

    int k = 0;



    for( k = 0; k < sizeof(KeyWord) / sizeof(tKeyWord); ++k ) {

        if( strcmp( s, KeyWord[k].m_sName ) == 0 )

            break;

    }

    delete s;



    if( k == sizeof(KeyWord) / sizeof(tKeyWord) )

        return true;



    tKeyWord& W = KeyWord[k];



    if( W.m_pMath == 0 )

        return false;



    ++nNextObj;

    pMath = W.m_pMath;



    return true;

}





//

//   g e t A r g s

//



bool tTclTools::getArgs( Tcl_Interp* pInterp, int objc,

    Tcl_Obj *CONST objv[], int& nNextObj,

    tDayShift*& pShift, tBondMath*& pMath )



{

    bool bRepeatShift = false;



    if( pShift == 0 ) {

        if( ! getDayShift( pInterp, objc, objv, nNextObj, pShift ) )

            return false;

        bRepeatShift = ( pShift == 0 );

    }



    if( pMath == 0 ) {

        if( ! getBondMath( pInterp, objc, objv, nNextObj, pMath ) )

            return false;

        if( pMath == 0 )

            bRepeatShift = false;

    }

    else {

        bRepeatShift = false;

    }



    if( bRepeatShift ) {

        if( ! getDayShift( pInterp, objc, objv, nNextObj, pShift ) )

            return false;

    }



    return true;

}



#endif



MTG_END_NAMESPACE