// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#include "MtgIncl.h"

#include "MtgTimer.h"



MTG_BEGIN_NAMESPACE





//

//   t T i m e r

//



tTimer::tTimer()



{

    start();

}





//

//   t T i m e r

//



tTimer::tTimer( const tTimer& Timer )



{

    copyFrom( Timer );

}





//

//   ~ t T i m e r

//



tTimer::~tTimer()



{

}





//

//   o p e r a t o r =

//



tTimer& tTimer::operator=( const tTimer& Timer )



{

    if( &Timer != this )

        copyFrom( Timer );

    return *this;

}





//

//   c o p y F r o m

//



void tTimer::copyFrom( const tTimer& Timer )



{

    if( &Timer == this )

        return;



    m_Start = Timer.m_Start;

    m_nLast = Timer.m_nLast;

}





//

//   c l o n e

//



tTimer* tTimer::clone() const



{

    return new tTimer( *this );

}





//

//   c h e c k

//



long tTimer::check()



{

    struct timeb Now;



    ftime( &Now );



        // Avoid overflow by doing it in two steps:



    m_nLast = 1000 * ( Now.time - m_Start.time );

    m_nLast += Now.millitm - m_Start.millitm;



    return m_nLast;

}





//

//   t o D o u b l e

//



double tTimer::toDouble() const



{

    return (double) m_nLast;

}





//

//   p r i n t

//



void tTimer::print( FILE* fFile, long nMilliSec )



{

    fprintf( fFile, "%02ld:%02ld:%02ld.%02ld",

        nMilliSec / 3600000,

        ( nMilliSec / 60000 ) % 60,

        ( nMilliSec / 1000 ) % 60,

        ( nMilliSec / 10 ) % 100 );

}



MTG_END_NAMESPACE