// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_TIMER_)

#define _MTG_TIMER_



#include <sys/types.h>

#include <sys/timeb.h>



MTG_BEGIN_NAMESPACE





//

//   t T i m e r

//



class tTimer {



    struct timeb m_Start;   // Value in millisec when timer was started.

    long m_nLast;           // Value in millisec when timer was checked.



public:



    tTimer();

    tTimer( const tTimer& Timer );



    ~tTimer();



    tTimer& operator=( const tTimer& Timer );



    void copyFrom( const tTimer& Timer );



    tTimer* clone() const;



    void start() {

        ftime( &m_Start );

        m_nLast = 0;

    }



    long check();



    long last() const { 

        return m_nLast;

    }



    double toDouble() const;



    void print() const {

        print( stdout );

    }



    void print( FILE* fFile ) const {

        print( fFile, m_nLast );

    }



    static void print( long nMilliSec ) {

        print( stdout, nMilliSec );

    }



    static void print( FILE* fFile, long nMilliSec );

};



MTG_END_NAMESPACE



#endif

