// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_TRIANGLE_)

#define _MTG_TRIANGLE_



#include "MtgHeap.h"



MTG_BEGIN_NAMESPACE





//

//   t T r i a n g l e

//



template<class T>

class tTriangle {



    int m_nNumOfElems;

    int m_nElemHiwater;



    T *m_Data;

    int* m_Ofs;



    void init();

    void resize( int nNumOfElems );



    void copyFrom( const tTriangle& Triangle );

    void cleanup();



public:



    tTriangle( int nNumOfElems = 0 );

    tTriangle( const tTriangle& Triangle );



    ~tTriangle();



    void reset( int nNumOfElems = 0 );



    tTriangle& operator=( const tTriangle& Triangle );



    int numOfElems() const {

        return m_nNumOfElems;

    }



    int numOfElems( int nNumOfElems ) {

        MTG_ASSERT( nNumOfElems >= 0 );

        resize( nNumOfElems );

        return m_nNumOfElems = nNumOfElems;

    }



        // The [] operator returns a C-style array.



    T* operator[]( int nRow ) const {

        MTG_ASSERT( nRow >= 0 && nRow < m_nNumOfElems );

        return &m_Data[m_Ofs[nRow]];

    }



        // For tHeap<T>-access to a single row, a sharing

        // heap is constructed with the following function:



    void getRow( int nRow, tHeap<T>& H ) const {

        H.share( m_nNumOfElems - nRow, operator[]( nRow ) );

    }



        // This is a dangerous function: it sets the data

        // pointer to a virtual first element, shifting the

        // shortened row effectively to the right. The

        // first nRow elements of the results MUST NOT 

        // be accessed!



    void getFullRow( int nRow, tHeap<T>& H ) const {

        H.share( m_nNumOfElems, operator[]( nRow ) - nRow );

    }

};



MTG_END_NAMESPACE



#if ! defined(_MTG_TRIANGLE_BODY_)

    #define _MTG_TRIANGLE_HEADER_

    #if defined(_WIN32)

        #include "MtgTriangle.cpp"

    #else   

        #include "MtgTriangle.C"

    #endif

    #undef _MTG_TRIANGLE_HEADER_

#endif



#endif



