// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_TYPES_)

#define _MTG_TYPES_



MTG_BEGIN_NAMESPACE





//

//   t R e t C o d e

//



enum tRetCode {

    REPEAT                =     2,

    GO                    =     1,



    OK                    =     0,    // general

    BAD_ARG               =    -1,

    NOT_FOUND             =    -2,

    EMPTY                 =    -3,

    ADJUSTMENT            =    -4,

    EXCEPTION             =    -5,

    TIMEOUT               =    -6,

    END_OF_FILE           =    -7,

    HELP_REQUESTED        =    -8,

    CALLBACK_ERROR        =    -9,

    FORMAT_ERROR          =    -10,



    SYNTAX_ERROR          =   -20,    // parser 1

    ID_REDEFINITION       =   -21,

    ATTR_REDEFINITION     =   -22,

    WRONG_ARG_COUNT       =   -23,

    MALFORMED_EXPRESSION  =   -24,

    INVALID_KEYWORD       =   -25,

    INVALID_CONSTANT      =   -26,

    INVALID_STRING        =   -27,

    INVALID_DATE          =   -28,

    INVALID_TIME          =   -29,

    INVALID_ID            =   -30,

    INVALID_VOLATILITY    =   -31,

    INVALID_MATURITY      =   -32,

    INVALID_SETTLEMENT    =   -33,

    INVALID_SIZE          =   -34,

    INVALID_WIDTH         =   -35,

    MISSING_ITEM          =   -36,

    MISSING_VOLATILITY    =   -37,

    MISSING_MATURITY      =   -38,

    MISSING_DRIFT         =   -39,

    MISSING_ROOT          =   -40,

    MISSING_FACTOR        =   -41,

    MISSING_LATTICE       =   -42,

    MISSING_MODEL         =   -43,

    MISSING_PORTFOLIO     =   -44,

    MISSING_SCENARIO      =   -45,

    MISSING_SIZE          =   -46,

    MISSING_RANGE         =   -47,

    MISSING_WEIGHTS       =   -48,

    MISSING_SAMPLES       =   -49,

    MISSING_CURVES        =   -50,

    MISSING_SAVE          =   -51,

    OBJECT_MISMATCH       =   -52,

    INCONSISTENT_OBJECT   =   -53,

    NESTED_SHELL          =   -54,



    DANGLING_DEPENDENCY   =   -60,    // parser 2

    ILLEGAL_DEPENDENCY    =   -61,

    CYCLIC_DEPENDENCY     =   -62,

    ILLEGAL_MONITOR       =   -63,

    AMBIGUITY             =   -64,



    RUNTIME_ERROR         =   -80,    // runtime

    NOT_AVAILABLE         =   -81,

    DIVISION_BY_ZERO      =   -82,    

    NO_CONVERGENCE        =   -83,

    OUT_OF_RANGE          =   -84,

    DATEBASE_MISMATCH     =   -85,

    SETTLEMENT_CONFLICT   =   -86,

    FINALIZATION_FAILED   =   -87,

    NOT_AUXILIARY         =   -88,

    IMAGE_TOO_SMALL       =   -89,

    NOT_ENOUGH_DATA       =   -90,



    WINSOCK_ERROR         =  -100,    // system calls

    OPEN_ERROR            =  -101,

    BIND_ERROR            =  -102,

    CONNECT_ERROR         =  -103,

    LISTEN_ERROR          =  -104,

    ACCEPT_ERROR          =  -105,

    SELECT_ERROR          =  -106,

    READ_ERROR            =  -107,

    WRITE_ERROR           =  -108,

    FORK_ERROR            =  -109,

    SERVICE_ERROR         =  -110,

    PIPE_ERROR            =  -111,

    CGI_ERROR             =  -112,



    MATHLINK_ERROR        =  -120,    // miscellaneous

    SCRIPT_ERROR          =  -121,



    DETOUR_BAD_HEADER     =  -140,    // HTTP detour

    DETOUR_BAD_TAG        =  -141,

    DETOUR_BAD_SEQ        =  -142,

    DETOUR_PROTOCOL_ERROR =  -143,



    NOT_IMPLEMENTED       =  -998,    // fatal

    OUT_OF_MEMORY         =  -999,

    INTERNAL_ERROR        = -9999

};





//

//   t A c c u r a c y

//



enum tAccuracy {

    xExact,

    xHigh,

    xMedium,

    xLow

};





//

//   t E x P o l i c y

//



enum tExPolicy {

    xDontExercise,

    xMayExercise,

    xForceExercise

};





//

//   t S c a l e

//



enum tScale {

    xDay,

    xYear

};





//

//   t F D M e t h o d

//



enum tFDMethod {

    xExplicit,

    xImplicit   // Crank-Nicholson

};



MTG_END_NAMESPACE



#endif

