// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#include "MtgIncl.h"

#include "MtgUSBondMath.h"



MTG_BEGIN_NAMESPACE





//

//   o b j e c t s

//



tUSBondMath USBondMath;     // seminannual compounding





//

//   i n i t

//



void tUSBondMath::init( int nPeriods )



{

    m_nPeriods = nPeriods;



    // no further initialization necessary, since the default

    // values of tBondMath are those for the US market

}





//

//   c r e a t e C o m p o u n d e r

//



tCompounder* tUSBondMath::createCompounder( tDate Settlement,

    tDate Maturity ) const



{

    return new tCouponCompounder( Maturity, 

        tIdentityDayShift(), m_nPeriods );

//        tFollowingDayShift(), m_nPeriods );

}





//

//   c o p y F r o m

//



void tUSBondMath::copyFrom( const tUSBondMath& Math )



{

    if( &Math == this )

        return;



    m_nPeriods = Math.m_nPeriods;

    super::copyFrom( Math );

}





//

//   t U S B o n d M a t h

//



tUSBondMath::tUSBondMath()



{

    init( 2 );

}





//

//   t U S B o n d M a t h

//



tUSBondMath::tUSBondMath( int nPeriods )



{

    init( nPeriods );

}





//

//   t U S B o n d M a t h

//



tUSBondMath::tUSBondMath( const tUSBondMath& Math )



{

    init( 2 );

    copyFrom( Math );

}





//

//   ~ t U S B o n d M a t h

//



tUSBondMath::~tUSBondMath()



{

}





//

//   o p e r a t o r =

//



tUSBondMath& tUSBondMath::operator=( const tUSBondMath& Math )



{

    if( &Math != this )

        copyFrom( Math );

    return *this;

}



MTG_END_NAMESPACE





//#define _TEST

#if defined(_TEST)



#if defined(_WIN32)

    #include <conio.h>

#else

    #define getche getchar

#endif



MTG_USING_NAMESPACE



//

//   m a i n

//



void main( int argc, char *argv[] )



{

    printf( "\nTest tUSBondMath\n\n" );



    char sBuf[256];

    int cCmd;



    tDate Trade = System.base();

    tDate Maturity = tDate( 15, 5, 2000 );



    double gCoupon = 5;

    double gYield = 0.05;

    double gPrice = 100;

    int nSettlement = 1;



    bool bGo = true;



    while( bGo ) { 

        printf( "<T>rade <M>aturity <C>oupon <Y>ield <P>rice <S>ettle E<x>it: " );

        cCmd = getche();

        printf( "\n" );



        switch( cCmd ) {

            case 't' :

            case 'T' :

                printf( "Trade date: " );

                gets( sBuf );

                if( Trade.set( sBuf ) == 0 )

                    printf( "Format error\n" );

                break;



            case 'm' :

            case 'M' :

                printf( "Maturity: " );

                gets( sBuf );

                if( Maturity.set( sBuf ) == 0 )

                    printf( "Format error\n" );

                break;



            case 'c' :

            case 'C' :

                printf( "Coupon: " );

                gets( sBuf );

                sscanf( sBuf, "%lg", &gCoupon );

                break;



            case 'y' :

            case 'Y' :

                printf( "Yield or <Return>: " );

                gets( sBuf );

                if( sscanf( sBuf, "%lg", &gYield ) == 1 ) {

                    if( gYield > 1 )

                        gYield /= 100;

                }



                printf( "Bill price is %lg\n",

                    USBondMath.billPrice(

                        Trade, Maturity, gYield,

                        tFollowingDayShift( nSettlement ) ) );



                printf( "Bond: dirty price is %lg\n",

                    USBondMath.bondDirtyPrice(

                        Trade, Maturity, gCoupon, gYield,

                        tFollowingDayShift( nSettlement ) ) );



                printf( "Bond: clean price is %lg\n",

                    USBondMath.bondCleanPrice(

                        Trade, Maturity, gCoupon, gYield,

                        tFollowingDayShift( nSettlement ) ) );

                break;



            case 'p' :

            case 'P' :

                printf( "Price or <Return>: " );

                gets( sBuf );

                sscanf( sBuf, "%lg", &gPrice );



                printf( "Bill: discount is %lg\n",

                    USBondMath.billDiscount(

                        Trade, Maturity, gPrice,

                        tFollowingDayShift( nSettlement ) ) );



                printf( "Bill: money market yield is %lg\n",

                    USBondMath.billMMYield(

                        Trade, Maturity, gPrice,

                        tFollowingDayShift( nSettlement ) ) );



                printf( "Bill: bond equivalent yield is %lg\n",

                    USBondMath.billBEYield(

                        Trade, Maturity, gPrice,

                        tFollowingDayShift( nSettlement ) ) );



                printf( "Bond: yield from clean price is %lg\n",

                    USBondMath.bondClean2Yield(

                        Trade, Maturity, gCoupon, gPrice,

                        tFollowingDayShift( nSettlement ) ) );



                printf( "Bond: yield from dirty price is %lg\n",

                    USBondMath.bondDirty2Yield(

                        Trade, Maturity, gCoupon, gPrice,

                        tFollowingDayShift( nSettlement ) ) );

                break;



            case 's' :

            case 'S' :

                printf( "Settlement: " );

                gets( sBuf );

                sscanf( sBuf, "%d", &nSettlement );

                break;



            case 'x' :

            case 'X' :

                bGo = false;

                break;

        }

    }



#if ! defined(_WIN32)

    printf( "\n" );

#endif

}



#endif