// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_VASICEK_MODEL_)

#define _MTG_VASICEK_MODEL_



#include "MtgHeap.h"

#include "MtgMCEngine.h"

#include "MtgShortRateModel.h"

#include "MtgShortRateTermStruct.h"



MTG_BEGIN_NAMESPACE



class tParser;





//

//   t V a s i c e k M o d e l

//



class tVasicekModel : public tShortRateModel {



    typedef tShortRateModel super;



public:



        // evolution class for Vasicek model:



    class tEvolution : public tShortRateModel::tEvolution {



        typedef tShortRateModel::tEvolution super;



            // This proxy class turns out to be necessary, for

            // multiple inheritance leads to a compiler bug

            // under Visual C++ 5.0.



        struct tProxy : public tShortRateTermStruct::tEvolutionStub {

            tEvolution* m_pParent;



            tProxy() {}



            tRetCode progress( const tShortRateTermStruct& ShortRate,

                tHeap<double>& Forward ) {

                return m_pParent->progress( ShortRate, Forward );

            }

        } m_Proxy;



            // instantation means selecion of factors:

        tHeap<int> m_FactorSelect;



            // mean reversion level for entire timeline:

        tHeap<double> m_Mean;



    public:



        tEvolution( const tVasicekModel& Model,

            const tPathSpace& PathSpace );



        tRetCode prepare();



        void setInstantiation( int nInstantiation );



        tRetCode progress( const tShortRateTermStruct& ShortRate,

            tHeap<double>& Forward );



                // simulate a cross cast:



        tShortRateTermStruct::tEvolutionStub& proxy() {

            return m_Proxy;

        }

    };



private:



        // The model is sigma dW + (theta mean - alpha r[t]) dt.



    struct tFactorParam {

        tHeap<double> m_Sigma;

        tHeap<double> m_Theta;

        tHeap<double> m_Alpha;

    };



        // The pointers to the factors themselves (i.e., the

        // factor names) are contained in the super class.



    tHeap<tFactorParam*> m_FactorParam;



    tBootstrap* m_pMeanBoot;  // reference

    tDrift* m_pMeanDrift;     // reference



    double m_gConstMean;



    void init();

    void cleanup();



    void copyFrom( const tVasicekModel& Model );



    tRetCode parseFactor( tParser& Parser, tParseInfoStub& Info );

    tRetCode parseParam( tParser& Parser, tParseInfoStub& Info );

    tRetCode parsePostfix( tParser& Parser, tParseInfoStub& Info );



    friend class tEvolution;



public:



    tVasicekModel();

    tVasicekModel( const tVasicekModel& Model );



    ~tVasicekModel();



    tVasicekModel& operator=( const tVasicekModel& Model );



    tObject* clone() const;



    tRetCode finalize();



        // functions used by the MC engine:



    int numOfInstantiations() const;

    void setInstantiation( tHeap<int>& Select, int nInstantiation ) const;



    tRetCode createEvolution( const tPathSpace& PathSpace,

        tMCEngine::tEvolutionStub*& pEvolution ) const;



        // output helper routines:



    tRetCode saveWeightsHeader( ostream& Out ) const;

    tRetCode saveWeightsData( ostream& Out, tHeap<int> Select ) const;

};



MTG_END_NAMESPACE



#endif



