// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#include "MtgIncl.h"

#include "MtgVol.h"

#include "MtgParser.h"

#include "MtgStepVol.h"



MTG_BEGIN_NAMESPACE





//

//   c o p y F r o m

//



void tVol::copyFrom( const tVol& Vol )



{

    if( this == &Vol )

        return;



    super::copyFrom( Vol );



    m_nMaturity = Vol.m_nMaturity;

    m_nConstantUntil = Vol.m_nConstantUntil;

    m_nCertainUntil = Vol.m_nCertainUntil;

    m_nCertainAfter = Vol.m_nCertainAfter;

}





//

//   t V o l

//



tVol::tVol()



{

    m_nMaturity = 0;

    m_nConstantUntil = 0;

    m_nCertainUntil = 0;

    m_nCertainAfter = INT_MAX;

}





//

//   t V o l

//



tVol::tVol( const tVol& Vol )



{

    copyFrom( Vol );

}





//

//   ~ t V o l

//



tVol::~tVol()



{

}





//

//   p a r s e

//



tRetCode tVol::parse( tParser& Parser, tSystem& System, tObject*& pObj )



{

    tRetCode nRet;

    tVol* pVol;

    tParseInfo Info;



    Info.m_gPlusBand = -1;

    Info.m_gMinusBand = -1;



    if( ( nRet = Parser.scanBeginOfObj() ) != OK )

        return nRet;



    pVol = new tStepVol;

    pVol->setSystem( System );



    if( ( nRet = pVol->super::parse( Parser, &Info ) ) != OK ) {

        delete pVol;

        return nRet;

    }



    pObj = pVol;

    return OK;

}



MTG_END_NAMESPACE