// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#include "MtgIncl.h"

#include "MtgWorstCase.h"

#include "MtgFDEngine.h"

#include "MtgParser.h"



MTG_BEGIN_NAMESPACE





//

//   i n i t

//



void tWorstCase::init()



{

}





//

//   p a r s e P a r a m

//



tRetCode tWorstCase::parseParam( tParser& Parser, tParseInfoStub& Info )



{

    return super::parseParam( Parser, Info );

}





//

//   t W o r s t C a s e

//



tWorstCase::tWorstCase()



{

    init();

}





//

//   t W o r s t C a s e

//



tWorstCase::tWorstCase( const tWorstCase& Worst )



{

    init();

    copyFrom( Worst );

}





//

//   ~ t W o r s t C a s e

//



tWorstCase::~tWorstCase()



{

    reset();

}





//

//   r e s e t

//



void tWorstCase::reset()



{

    super::reset();

}





//

//   o p e r a t o r =

//



tWorstCase& tWorstCase::operator=( const tWorstCase& Worst )



{

    if( &Worst != this )

        copyFrom( Worst );

    return *this;

}





//

//   c o p y F r o m

//



void tWorstCase::copyFrom( const tWorstCase& Worst )



{

    if( &Worst == this )

        return;



    reset();

    super::copyFrom( Worst );  // Copy m_bFinalized last!

}





//

//   c l o n e

//



tObject* tWorstCase::clone() const



{

    return new tWorstCase( *this );

}





//

//   f i n a l i z e

//



tRetCode tWorstCase::finalize()



{

    return super::finalize();

}





//

//   u n d e r C o n t r o l

//



bool tWorstCase::underControl( double gMultiplier )



{

    switch( position() ) {

        case xBuyer :

            return gMultiplier >= 0 ;

        case xSeller :

            return gMultiplier <= 0 ;

    }



    throw tException( INTERNAL_ERROR );

    return false;

}





//

//   r e f i n e E x P o l i c y

//



void tWorstCase::refineExPolicy( tFDEngine& Engine, int nBaseTag,

    int nIndex, double gDontExValue, double gExValue, double gMultiplier,

    tExPolicy& nExPolicy )



{

    MTG_ASSERT( isFinalized() );



        // Formulas:

        //

        //   F(A+R) = a f(A) + r f(R)

        //   F(A+R) <= F(A) + F(R)

        //   F(A+R) >= -F(-A) + F(R)

        //

        // where f is the derivative and a, r are the multipliers.

        // The payoff is denoted by A and R, respectively. Note that

        // gExValue = A, gDontExValue = f(A), and gMultiplier = a



    double gValue;

    int nTag;



    if( nExPolicy == xMayExercise ) {

        if( Engine.isLinear() || Engine.accuracy() == xLow ) {

                // We have linearity for singletons. (Otherwise,

                // there would be a cycle.)



            if( gExValue > gDontExValue )

                nExPolicy = xForceExercise;

            else

                nExPolicy = xDontExercise;

        }

        else {

            MTG_ASSERT( nBaseTag % 2 == 0 );



            if( gMultiplier >= 0 ) {

                if( position() == xBuyer )

                    nTag = 0;   // minimize total and instrument

                else

                    nTag = 1;   // maximize total, minimize instrument



                if( gExValue > gDontExValue ) {

                    if( Engine.accuracy() == xHigh ) {

                            // use heuristic

                            // F(A+R) <= a f(a) + F(R) < a A + F(R)

                        nExPolicy = xForceExercise;

                    }

                    else {

                        MTG_ASSERT( Engine.accuracy() == xExact );



                            // be exact; use inverse tag

                        Engine.getClaim( nIndex,

                            nBaseTag + 1 - nTag, gValue );

                        if( gExValue > gValue )

                            nExPolicy = xForceExercise;

                    }

                }

                else {

                        // Note that gValue represents the worst-case

                        // value of the instrument, exercised at any

                        // time *but not now*.



                    Engine.getClaim( nIndex, nBaseTag + nTag, gValue );

                    if( gExValue <= gValue )

                        nExPolicy = xDontExercise;

                }

            }

            else {

                if( position() == xSeller )

                    nTag = 0;   // maximize total and instrument

                else

                    nTag = 1;   // minimize total, maximize instrument



                if( gExValue <= gDontExValue ) {

                    if( Engine.accuracy() == xHigh ) {

                            // use heuristic

                            // F(A+R) <= a f(a) + F(R) <= a A + F(R)



                            // (a is negative!), and we're buying the 

                            // instrument if position == seller, it is our

                            // goal to alleviate the worst case scenario.

                            // So don't exercise. If, on the other hand,

                            // position == buyer, we're minimizing as well.

                        nExPolicy = xDontExercise;

                    }

                    else {

                        MTG_ASSERT( Engine.accuracy() == xExact );



                            // be exact; use inverse tag

                        Engine.getClaim( nIndex,

                            nBaseTag + 1 - nTag, gValue );

                        if( gExValue <= gValue )

                            nExPolicy = xDontExercise;

                    }

                }

                else {

                    Engine.getClaim( nIndex, nBaseTag + nTag, gValue );

                        // (We would need ">=" at this point if gValue

                        // included possible exercise.)

                    if( gExValue > gValue )

                        nExPolicy = xForceExercise;

                }

            }



            if( isExhaustive() ) {

                double gDummy;

                Engine.getClaim( nIndex, nBaseTag, gDummy );             

                Engine.getClaim( nIndex, nBaseTag + 1, gDummy );             

            }

        }

    }

}





//

//   r e f i n e E x P o l i c y

//



void tWorstCase::refineExPolicy( tFDEngine& Engine, int nBaseTag,

    int nIndex, double gDontExValue, double gExValue, double gMultiplier,

    tExPolicy& nExPolicy, tExPolicy& nExPolicy0 )



{

    if( Engine.isLinear() || Engine.accuracy() != xMedium ) {

        refineExPolicy( Engine, nBaseTag, nIndex, gDontExValue, gExValue,

            gMultiplier, nExPolicy );

    }



    if( nExPolicy == xMayExercise ) {

        if( gMultiplier >= 0 ) {

            if( gExValue > gDontExValue )

                nExPolicy0 = xForceExercise;

            else

                nExPolicy0 = xDontExercise;

        }

        else { 

            if( gExValue <= gDontExValue )

                nExPolicy0 = xDontExercise;

            else

                nExPolicy0 = xForceExercise;

        }

    }

    else {

        nExPolicy0 = nExPolicy;

    }

}





//

//   s e l e c t V o l

//



double tWorstCase::selectVol( int nTag, double gGamma, double gPrior,

    double gMin, double gMax )



{

    MTG_ASSERT( gMin <= gPrior && gPrior <= gMax );



    if( nTag % 2 == 0 ) {

        switch( position() ) {

            case xBuyer :

                if( gGamma <= 0 )

                    return gMax;

                return gMin;



            case xSeller :

                if( gGamma >= 0 )

                    return gMax;

                return gMin;

        }

    }

    else {  // reverse

        switch( position() ) {

            case xBuyer :

                if( gGamma >= 0 )

                    return gMax;

                return gMin;



            case xSeller :

                if( gGamma <= 0 )

                    return gMax;

                return gMin;

        }

    }



    throw tException( INTERNAL_ERROR );

    return 0;

}





//

//   e n d u r e O v e r

//



bool tWorstCase::endureOver( int nTag, double gNewTotal, double gOldTotal )



{

    if( nTag % 2 == 0 ) {

        switch( position() ) {

            case xBuyer :   // minimize

                return gNewTotal < gOldTotal;



            case xSeller :  // maximize

                return gNewTotal > gOldTotal;

        }

    }

    else {  // reverse

        switch( position() ) {

            case xBuyer :   // maximize

                return gNewTotal > gOldTotal;



            case xSeller :  // minimize

                return gNewTotal < gOldTotal;

        }

    }



    throw tException( INTERNAL_ERROR );

    return false;

}





//

//   c h o o s e O v e r

//



bool tWorstCase::chooseOver( int nTag, double gNewTotal, double gOldTotal )



{

    if( nTag % 2 == 0 ) {

        switch( position() ) {

            case xBuyer :   // maximize

                return gNewTotal > gOldTotal;



            case xSeller :  // minimize

                return gNewTotal < gOldTotal;

        }

    }

    else {  // reverse

        switch( position() ) {

            case xBuyer :   // minimize

                return gNewTotal < gOldTotal;



            case xSeller :  // maximize

                return gNewTotal > gOldTotal;

        }

    }



    throw tException( INTERNAL_ERROR );

    return false;

}



MTG_END_NAMESPACE