// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#if ! defined(_MTG_YIELD_CURVE_)

#define _MTG_YIELD_CURVE_



#include "MtgCurve.h"

#include "MtgCurveInstance.h"

#include "MtgInterest.h"



MTG_BEGIN_NAMESPACE





//

//   t Y i e l d C u r v e

//



class tYieldCurve : public tCurve {



    typedef tCurve super;



        // How is the yield to be computed?



    tInterest m_Interest;



        // This is the curve instance:



    class tYieldCurveInstance : public tCurveInstance {



        typedef tCurveInstance super;



    public:



        tYieldCurveInstance( const tYieldCurve& Curve,

            tEngine& Engine );



        ~tYieldCurveInstance();



        tRetCode evaluate( double gWeight );

        tRetCode postProcess( double gWeight = -1 );



        bool containsEvaluationOf( const tCurveInstance& Instance ) const;

    };



    void copyFrom( const tYieldCurve& Curve );



    tRetCode parseParam( tParser& Parser, tParseInfoStub& Info );

    tRetCode parsePostfix( tParser& Parser, tParseInfoStub& Info );



public:



    tYieldCurve();



        // Passed on to the tCurve constructor (see tDateBase.h

        // for changing the values manually):



    tYieldCurve( tScale nScale );

    tYieldCurve( tScale nScale, int nNumOfPeriods );

    tYieldCurve( tScale nScale, const tDayCount& DayCount );

    tYieldCurve( tScale nScale, int nNumOfPeriods,

        const tDayCount& DayCount );

    tYieldCurve( tScale nScale, const tDayCount& DayCount,

        tDate Base );

    tYieldCurve( tScale nScale, int nNumOfPeriods,

        const tDayCount& DayCount, tDate Base );



    tYieldCurve( const tYieldCurve& Curve );



    ~tYieldCurve();



    tYieldCurve& operator=( const tYieldCurve& Curve );



    tObject* clone() const;



    tRetCode finalize();



    const tInterest& interest() const {

        return m_Interest;

    }



    tRetCode createInstance( tEngine& Engine,

        tCurveInstance*& pCurve ) const;

};



MTG_END_NAMESPACE



#endif

