// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#include <iostream.h>

#include <iomanip.h>



#include "Mtg.h"

MTG_USING_NAMESPACE



// This example accepts two dates as input and lists

// the number of days between them, relative to all

// day count conventions implemented in MtgLib.

 



//

//   m a i n

//



void main()



{

    while( true ) {

        char s[512];



        cout << "Enter two dates: ";

        cin.get( s, sizeof( s ) );



        tDate A, B; 

        const char* q = s;



            // scan the string for two dates



        if( ( q = A.set( q ) ) == 0 || B.set( q ) == 0 )

            break;



            // list the number of days, and the

            // day count fraction of the period [A,B]:



        cout << "ACT/ACT         " << setw( 3 )

             << DayCountACT_ACT.numOfDays( A, B ) << " "

             << DayCountACT_ACT.fraction( A, B ) << "\n";

        cout << "ACT/365         " << setw( 3 )

             << DayCountACT_365.numOfDays( A, B ) << " "

             << DayCountACT_365.fraction( A, B ) << "\n";

        cout << "ACT/365.25      " << setw( 3 )

             << DayCountACT_365_25.numOfDays( A, B ) << " "

             << DayCountACT_365_25.fraction( A, B ) << "\n";

        cout << "ACT/365 NL      " << setw( 3 )

             << DayCountACT_365_NL.numOfDays( A, B ) << " "

             << DayCountACT_365_NL.fraction( A, B ) << "\n";

        cout << "ACT/365 ISDA    " << setw( 3 )

             << DayCountACT_365_ISDA.numOfDays( A, B ) << " "

             << DayCountACT_365_ISDA.fraction( A, B ) << "\n";

        cout << "ACT/360         " << setw( 3 )

             << DayCountACT_360.numOfDays( A, B ) << " "

             << DayCountACT_360.fraction( A, B ) << "\n";

        cout << "30/360 ISDA     " << setw( 3 )

             << DayCount30_360_ISDA.numOfDays( A, B ) << " "

             << DayCount30_360_ISDA.fraction( A, B ) << "\n";

        cout << "30/360 PSA      " << setw( 3 )

             << DayCount30_360_PSA.numOfDays( A, B ) << " "

             << DayCount30_360_PSA.fraction( A, B ) << "\n";

        cout << "30/360 SIA      " << setw( 3 )

             << DayCount30_360_SIA.numOfDays( A, B ) << " "

             << DayCount30_360_SIA.fraction( A, B ) << "\n";

        cout << "30E/360         " << setw( 3 )

             << DayCount30E_360.numOfDays( A, B ) << " "

             << DayCount30E_360.fraction( A, B ) << "\n";

    }

}

