// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#include <iostream.h>

#include <limits.h>



#include "Mtg.h"

MTG_USING_NAMESPACE



// Compute the true yield, as opposed to the yield-to-maturity

// for a coupon bearing bond.

 



//

//   m a i n

//



void main()



{

    char s[512];



        // specify coupon structure

        

    cout << "Enter maturity, coupon rate[%] and number of coupons: ";

    cin.get( s, sizeof( s ) );



    tDate Maturity;

    double gCoupon;

    int nPeriods;



    const char* q = Maturity.set( s );



    if( q == 0 || sscanf( q, "%lg %d", &gCoupon, &nPeriods ) != 2 )

        return;



        // specify policy for non-businessdays



    int nPolicy, nMove;



    cout << "Specify policy for non-businessdays, as in\n";

    cout << "1=no change 2=following 3=preceding 4=modified following: ";

    cin >> nPolicy;



    if( nPolicy == 2 || nPolicy == 3 ) {

        cout << "Parameter (-1, 0, or positive): ";

        cin >> nMove;

    }



    tDayShift* pShift;



    switch( nPolicy ) {

        case 1  : pShift = new tIdentityDayShift();         break;

        case 2  : pShift = new tFollowingDayShift( nMove ); break;

        case 3  : pShift = new tPrecedingDayShift( nMove ); break;

        case 4  : pShift = new tModifiedDayShift();         break;

        default : return;

    }



        // define the compounder



    tCouponCompounder Compounder( Maturity, *pShift, nPeriods );

    delete pShift;  // no longer needed



    tDate M = Compounder.maturity();



    if( M != Maturity ) {

        Maturity = M;

        cout << "The adjusted maturity date is "

             << Maturity.month() << "/"

             << Maturity.day() << "/"

             << Maturity.year() << "\n";

    }



        // we use ACT/365 and exact compounding for true yield



    tInterest MM(

        tInterest::xExponential,

        tInterest::xYield,

        DayCountACT_365 );



    while( true ) {

        cout << "Enter the settlement date and the clean price: ";

        cin.ignore( INT_MAX, '\n' );

        cin.get( s, sizeof( s ) );



        tDate Settlement;    // settlement date

        double gPrice;   // clean price



        const char* q = s;



            // scan the string for two dates



        if( ( q = Settlement.set( q ) ) == 0 || 

            sscanf( q, "%lg", &gPrice ) != 1 ) {

            break;

        }



            // initialize the interest spline



        tInterestSpline TrueYield( MM );

            

            // use only one constraint



        TrueYield.addPayment( Settlement, gPrice,

            100, gCoupon, Compounder );



            // recall that maturity is adjusted



        cout << "True yield is "

             << TrueYield.yield( Settlement, Maturity ) << "\n";



            // for comparison, get the yield-to-maturity



        tBondEquation Eq( tBondEquation::xStandard );



        cout << "Yield to maturity is " 

             << Eq.clean2Yield( Settlement, gCoupon, gPrice, &Compounder )

             << "\n";

    }

}

