// Copyright 1999, 2002 Robert Buff

// Contact: http://robertbuff.com/uvm

//

// This file is part of Mtg-Book.

//

// Mtg-Book is free software; you can redistribute it and/or modify

// it under the terms of the GNU General Public License as published

// by the Free Software Foundation; either version 2 of the License,

// or (at your option) any later version.

//

// Mtg-Book is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with Mtg-Book; if not, write to the 

//

// Free Software Foundation, Inc.

// 59 Temple Place, Suite 330

// Boston, MA 02111-1307

// USA



#include <iostream.h>

#include <limits.h>



#include "Mtg.h"

MTG_USING_NAMESPACE



// This example demonstrates tInterestSpline and the

// bootstrapping method for forward rate curves.





//

//   g e t I n t e r e s t

//



tInterest getInterest( const char* sPrompt )



{

    cout << sPrompt;



        // get day count convention



    cout << "1=ACT/ACT     2=ACT/365   3=ACT/365NL\n"

         << "4=ACT/365ISDA 5=ACT/360   6=30/360ISDA\n"

         << "7=30/360PSA   8=30/360SIA 9=30E/360\n";



    int c;



    cout << "Enter the day count convention: ";

    cin >> c;



    tDayCount DayCount;



    switch( c ) {

        case 1 : DayCount = DayCountACT_ACT;      break;

        case 2 : DayCount = DayCountACT_365;      break;

        case 3 : DayCount = DayCountACT_365_NL;   break;

        case 4 : DayCount = DayCountACT_365_ISDA; break;

        case 5 : DayCount = DayCountACT_360;      break;

        case 6 : DayCount = DayCount30_360_ISDA;  break;

        case 7 : DayCount = DayCount30_360_PSA;   break;

        case 8 : DayCount = DayCount30_360_SIA;   break;

        case 9 : DayCount = DayCount30E_360;      break;

        default: exit( 1 );

    }



        // get type: exponential or linear, and number

        // of compounding periods per year (for simplicity,

        // no explicit compounding dates):



    char sType[32];

    int nPeriods;



    cout << "Enter type (<e>exp or <l>inear) and number of periods: ";

    cin >> sType >> nPeriods;



    tInterest::tType nType;



    if( sType[0] == 'e' || sType[0] == 'E' )

        nType = tInterest::xExponential;

    else

        nType = tInterest::xLinear;



        // get quoting comvention:



    char sQuote[32];



    cout << "Enter quoting convention (<y>ield or <d>iscount): ";

    cin >> sQuote;



    tInterest::tQuote nQuote;



    if( sQuote[0] == 'y' || sQuote[0] == 'Y' )

        nQuote = tInterest::xYield;

    else

        nQuote = tInterest::xDiscount;



    return tInterest( nType, nQuote, DayCount,

        tPeriodCompounder( nPeriods ) );

}





//

//   m a i n

//



void main()



{

    char s[512];



        // specify interest conventions



    tInterest InputInterest =

        getInterest( "*** Interest conventions for input data\n" );



    tInterest OutputInterest =

        getInterest( "*** Interest conventions for output curve\n" );



    tInterestSpline IS( tInterestSpline::xExtraCompounding, InputInterest );



        // collect input data



    cout << "*** Input data\n";



    while( false ) {

        char sData[32];



        cout << "Enter type of input data "

             << "(<i>mpl, <f>wd, <p>ayment <s>top): ";

        cin >> sData;



        if( sData[0] == 'i' || sData[0] == 'I' ) {

                // implied rate



            tDate Start, End;

            double gRate;



            cout << "Enter start and end date and implied rate[%]: ";

            cin.ignore( INT_MAX, '\n' );

            cin.get( s, sizeof( s ) );



            const char* q = s;



            if( ( q = Start.set( s ) ) == 0 ||

                ( q = End.set( q ) ) == 0 ||

                sscanf( q, "%lg", &gRate ) != 1 ) {

                return;

            }



            IS.addImplied( Start, End, gRate / 100 );

        }

        else 

        if( sData[0] == 'f' || sData[0] == 'F' ) {

                // forward rate



            tDate Start, End;

            double gRate;



            cout << "Enter start and end date and forward rate[%]: ";

            cin.ignore( INT_MAX, '\n' );

            cin.get( s, sizeof( s ) );



            const char* q = s;



            if( ( q = Start.set( s ) ) == 0 ||

                ( q = End.set( q ) ) == 0 ||

                sscanf( q, "%lg", &gRate ) != 1 ) {

                return;

            }



            IS.addForward( Start, End, gRate / 100 );

        }

        else

        if( sData[0] == 'p' || sData[0] == 'P' ) {

                // payment structure



            tHeap<tPayment> Payment;

            double gPrice, gCash;

            tDate Start, Date;



                // present value and start of structure



            cout << "Enter start date and price: ";

            cin.ignore( INT_MAX, '\n' );

            cin.get( s, sizeof( s ) );



            const char* q = s;



            if( ( q = Start.set( s ) ) == 0 ||

                sscanf( q, "%lg", &gPrice ) != 1 ) {

                return;

            }



                // get individual payments



            while( true ) {

                cout << "Enter payment date and amount, or <return>: ";

                cin.ignore( INT_MAX, '\n' );

                cin.get( s, sizeof( s ) );



                const char* q = s;



                if( ( q = Date.set( s ) ) == 0 ||

                    sscanf( q, "%lg", &gCash ) != 1 ) {

                    break;

                }

                Payment.append( tPayment( Date, gCash ) );

            }



                // now register payment

                

            IS.addPayment( Start, gPrice, Payment );

        }

        else {

            break;

        }

    }



        // consolidate regions with equal forward rate



    IS.merge();



        // output forward rate



    cout << "*** Forward rate curve with extra compounding\n";

    cout << "*** ...under input interest conventions\n";



    tDate End;

    double gRate;



    IS.getFirstLeg( End, gRate );

    do {

        cout << "Leg to "

             << End.month() << "/" 

             << End.day() << "/"

             << End.year() << " at rate " << 100 * gRate << "\n";

    } while( IS.getNextLeg( End, gRate ) );



    cout << "*** ...under output interest conventions\n";



    IS.getFirstLeg( End, gRate, OutputInterest );

    do {

        cout << "Leg to "

             << End.month() << "/" 

             << End.day() << "/"

             << End.year() << " at rate " << 100 * gRate << "\n";

    } while( IS.getNextLeg( End, gRate, OutputInterest ) );



        // now repeat the analysis with aggregating instead

        // of extra compounding



    tInterestSpline IS1 = IS;

    IS1.set( tInterestSpline.xAggregate );



        // note that the entire curve will be redone automatically



    IS1.merge();



        // output forward rate



    cout << "*** Forward rate curve with aggregating\n";

    cout << "*** ...under input interest conventions\n";



    IS1.getFirstLeg( End, gRate );

    do {

        cout << "Leg to "

             << End.month() << "/" 

             << End.day() << "/"

             << End.year() << " at rate " << 100 * gRate << "\n";

    } while( IS1.getNextLeg( End, gRate ) );



    cout << "*** ...under output interest conventions\n";



    IS1.getFirstLeg( End, gRate, OutputInterest );

    do {

        cout << "Leg to "

             << End.month() << "/" 

             << End.day() << "/"

             << End.year() << " at rate " << 100 * gRate << "\n";

    } while( IS1.getNextLeg( End, gRate, OutputInterest ) );

}

