(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     65502,       2347]*)
(*NotebookOutlinePosition[     66153,       2370]*)
(*  CellTagsIndexPosition[     66109,       2366]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(Needs["\<RB`MtgMath`\>"]\)], "Input"],

Cell[BoxData[
    \(c1 = ECALL[60, 95]; \nc2 = ECALL[60, 100]; \nc3 = ECALL[60, 110]; \n
    c4 = ECALL[60, 115]; \)], "Input"],

Cell[BoxData[
    \(\(pf1 = PORTFOLIO[LONG[c1], SHORT[c2], SHORT[c3], LONG[c4]]; \)\)], 
  "Input"],

Cell[BoxData[
    \(v1 = VOL[IMPLIED[60, {10}]]; \nv2 = VOL[IMPLIED[60, {10, 30}]]; \n
    v3 = VOL[IMPLIED[60, {30}]]; \)], "Input"],

Cell[BoxData[
    \(r1 = DRIFT[IMPLIED[60, 3]]; \nq1 = DRIFT[IMPLIED[60, 0]]; \)], "Input"],

Cell[BoxData[
    \(s1 = SCENARIO[WORSTCASE[SELLER]]; \ns2 = SCENARIO[WORSTCASE[BUYER]]; \n
    s3 = SCENARIO[SHOCK[SELLER], Duration -> 5, Periodicity -> 1, 
        Frequency -> 1]; \n
    s4 = SCENARIO[SHOCK[BUYER], Duration -> 5, Periodicity -> 1, 
        Frequency -> 1]; \)], "Input"],

Cell[BoxData[
    \(price1 = 
      MakePriceFunc[{asset}, pf1, v1, r1, q1, s1, AssetPrice -> asset]; \n
    price2 = MakePriceFunc[{asset}, pf1, v2, r1, q1, s1, 
        AssetPrice -> asset]; \n
    price3 = MakePriceFunc[{asset}, pf1, v2, r1, q1, s2, 
        AssetPrice -> asset]; \n
    price4 = MakePriceFunc[{asset}, pf1, v3, r1, q1, s1, 
        AssetPrice -> asset]; \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot[{price1[a], price2[a], price3[a], price4[a]}, {a, 70, 140}, 
      PlotStyle -> {Green, Blue, Red, Yellow}]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.928572 0.0136054 0.0147151 0.127042 [
[.15986 .00222 -6 -9 ]
[.15986 .00222 6 0 ]
[.29592 .00222 -6 -9 ]
[.29592 .00222 6 0 ]
[.43197 .00222 -9 -9 ]
[.43197 .00222 9 0 ]
[.56803 .00222 -9 -9 ]
[.56803 .00222 9 0 ]
[.70408 .00222 -9 -9 ]
[.70408 .00222 9 0 ]
[.84014 .00222 -9 -9 ]
[.84014 .00222 9 0 ]
[.97619 .00222 -9 -9 ]
[.97619 .00222 9 0 ]
[.01131 .14176 -6 -4.5 ]
[.01131 .14176 0 4.5 ]
[.01131 .2688 -6 -4.5 ]
[.01131 .2688 0 4.5 ]
[.01131 .39584 -6 -4.5 ]
[.01131 .39584 0 4.5 ]
[.01131 .52289 -6 -4.5 ]
[.01131 .52289 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.15986 .01472 m
.15986 .02097 L
s
[(80)] .15986 .00222 0 1 Mshowa
.29592 .01472 m
.29592 .02097 L
s
[(90)] .29592 .00222 0 1 Mshowa
.43197 .01472 m
.43197 .02097 L
s
[(100)] .43197 .00222 0 1 Mshowa
.56803 .01472 m
.56803 .02097 L
s
[(110)] .56803 .00222 0 1 Mshowa
.70408 .01472 m
.70408 .02097 L
s
[(120)] .70408 .00222 0 1 Mshowa
.84014 .01472 m
.84014 .02097 L
s
[(130)] .84014 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(140)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.05102 .01472 m
.05102 .01847 L
s
.07823 .01472 m
.07823 .01847 L
s
.10544 .01472 m
.10544 .01847 L
s
.13265 .01472 m
.13265 .01847 L
s
.18707 .01472 m
.18707 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.2415 .01472 m
.2415 .01847 L
s
.26871 .01472 m
.26871 .01847 L
s
.32313 .01472 m
.32313 .01847 L
s
.35034 .01472 m
.35034 .01847 L
s
.37755 .01472 m
.37755 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45918 .01472 m
.45918 .01847 L
s
.48639 .01472 m
.48639 .01847 L
s
.51361 .01472 m
.51361 .01847 L
s
.54082 .01472 m
.54082 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.62245 .01472 m
.62245 .01847 L
s
.64966 .01472 m
.64966 .01847 L
s
.67687 .01472 m
.67687 .01847 L
s
.73129 .01472 m
.73129 .01847 L
s
.7585 .01472 m
.7585 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.81293 .01472 m
.81293 .01847 L
s
.86735 .01472 m
.86735 .01847 L
s
.89456 .01472 m
.89456 .01847 L
s
.92177 .01472 m
.92177 .01847 L
s
.94898 .01472 m
.94898 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .14176 m
.03006 .14176 L
s
[(1)] .01131 .14176 1 0 Mshowa
.02381 .2688 m
.03006 .2688 L
s
[(2)] .01131 .2688 1 0 Mshowa
.02381 .39584 m
.03006 .39584 L
s
[(3)] .01131 .39584 1 0 Mshowa
.02381 .52289 m
.03006 .52289 L
s
[(4)] .01131 .52289 1 0 Mshowa
.125 Mabswid
.02381 .04012 m
.02756 .04012 L
s
.02381 .06553 m
.02756 .06553 L
s
.02381 .09094 m
.02756 .09094 L
s
.02381 .11635 m
.02756 .11635 L
s
.02381 .16717 m
.02756 .16717 L
s
.02381 .19257 m
.02756 .19257 L
s
.02381 .21798 m
.02756 .21798 L
s
.02381 .24339 m
.02756 .24339 L
s
.02381 .29421 m
.02756 .29421 L
s
.02381 .31962 m
.02756 .31962 L
s
.02381 .34503 m
.02756 .34503 L
s
.02381 .37043 m
.02756 .37043 L
s
.02381 .42125 m
.02756 .42125 L
s
.02381 .44666 m
.02756 .44666 L
s
.02381 .47207 m
.02756 .47207 L
s
.02381 .49748 m
.02756 .49748 L
s
.02381 .54829 m
.02756 .54829 L
s
.02381 .5737 m
.02756 .5737 L
s
.02381 .59911 m
.02756 .59911 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 1 0 r
.5 Mabswid
.02381 .01472 m
.06244 .01472 L
.08255 .01472 L
.0932 .01472 L
.10458 .01472 L
.11009 .01472 L
.11531 .01472 L
.11999 .01472 L
.12127 .01472 L
.12197 .01472 L
.12263 .01472 L
.12379 .01472 L
.12507 .01472 L
.12753 .01472 L
.12874 .01472 L
.12987 .01472 L
.13088 .01472 L
.13197 .01472 L
.13426 .01472 L
.13554 .01472 L
.13693 .01472 L
.13824 .01472 L
.13945 .01472 L
.14191 .01472 L
.14415 .01472 L
.14531 .01472 L
.14656 .01472 L
.14775 .01472 L
.14885 .01472 L
.15124 .01472 L
.15252 .01472 L
.15318 .01472 L
.15389 .01472 L
.15507 .01472 L
.15616 .01472 L
.15829 .01472 L
.15956 .01472 L
.16075 .01472 L
.16182 .01472 L
.16298 .01472 L
.16545 .01472 L
.16809 .01472 L
.16929 .01472 L
.17056 .01472 L
.17165 .01472 L
.17284 .01472 L
.17553 .01472 L
.17701 .01472 L
.17774 .01472 L
.17842 .01472 L
Mistroke
.17973 .01473 L
.18115 .01473 L
.18364 .01473 L
.18493 .01473 L
.18564 .01473 L
.18629 .01473 L
.18746 .01474 L
.18873 .01474 L
.19161 .01475 L
.19287 .01475 L
.19353 .01475 L
.19423 .01476 L
.19552 .01476 L
.19671 .01477 L
.19905 .01478 L
.20153 .01479 L
.2042 .01481 L
.20877 .01486 L
.21306 .01491 L
.21554 .01496 L
.21815 .01501 L
.21923 .01503 L
.22038 .01506 L
.22165 .0151 L
.22282 .01514 L
.2254 .01522 L
.22781 .0153 L
.22903 .01535 L
.23033 .01542 L
.23309 .01558 L
.23888 .01597 L
.24421 .01646 L
.2468 .01676 L
.24962 .01718 L
.25211 .01754 L
.25347 .01775 L
.25475 .01796 L
.25712 .01851 L
.25975 .01911 L
.26437 .02031 L
.26906 .02193 L
.27419 .02405 L
.27918 .02657 L
.28453 .03001 L
.29411 .03794 L
.30303 .04795 L
.31325 .06317 L
.32435 .08471 L
.34449 .13895 L
.36434 .21054 L
Mistroke
.38538 .29974 L
.42323 .45771 L
.44266 .5204 L
.45357 .54692 L
.45839 .55633 L
.46354 .56551 L
.46871 .57255 L
.47115 .57588 L
.47222 .57724 L
.4734 .57832 L
.4745 .57915 L
.47566 .58005 L
.47811 .58193 L
.48038 .58367 L
.4815 .58453 L
.48254 .58523 L
.48384 .58563 L
.48452 .58575 L
.48525 .58587 L
.48772 .58629 L
.48909 .58653 L
.49058 .58679 L
.49126 .5869 L
.49198 .58703 L
.49326 .58705 L
.49444 .58664 L
.49554 .58618 L
.49802 .58514 L
.50075 .584 L
.50195 .5835 L
.50327 .58292 L
.50454 .58182 L
.50573 .58064 L
.50832 .57804 L
.51119 .5752 L
.51244 .57395 L
.5131 .57328 L
.5138 .57259 L
.51508 .57073 L
.51626 .56888 L
.5186 .56523 L
.52374 .5572 L
.5335 .53721 L
.54233 .51515 L
.58247 .38107 L
.6211 .23518 L
.6407 .17109 L
.66217 .1146 L
.67206 .09372 L
.68265 .07519 L
Mistroke
.70173 .05082 L
.71194 .04131 L
.72303 .03342 L
.7335 .02782 L
.73815 .02596 L
.74316 .02395 L
.74575 .0232 L
.74821 .02254 L
.75283 .02128 L
.76188 .01939 L
.77174 .01785 L
.77732 .01721 L
.78002 .01691 L
.7825 .01669 L
.78757 .01634 L
.79019 .01616 L
.79158 .01606 L
.79306 .01596 L
.79437 .01589 L
.79557 .01584 L
.7979 .01574 L
.80302 .01553 L
.80523 .01544 L
.80759 .01536 L
.81018 .0153 L
.81257 .01524 L
.81698 .01513 L
.82162 .01505 L
.8265 .01498 L
.83098 .01492 L
.83348 .0149 L
.83581 .01488 L
.84108 .01484 L
.84326 .01483 L
.84441 .01482 L
.84563 .01481 L
.84669 .01481 L
.84786 .0148 L
.84992 .01479 L
.85486 .01478 L
.8572 .01477 L
.85833 .01476 L
.85936 .01476 L
.86057 .01476 L
.86185 .01476 L
.86457 .01475 L
.86951 .01474 L
.87063 .01474 L
.87181 .01474 L
.87311 .01474 L
Mistroke
.8743 .01474 L
.8788 .01473 L
.88361 .01473 L
.88427 .01473 L
.88499 .01473 L
.8863 .01472 L
.88876 .01472 L
.89441 .01472 L
.89695 .01472 L
.89764 .01472 L
.89828 .01472 L
.89895 .01472 L
.89969 .01472 L
.90222 .01472 L
.90455 .01472 L
.9091 .01472 L
.91035 .01472 L
.911 .01472 L
.91169 .01472 L
.91296 .01472 L
.91413 .01472 L
.91694 .01472 L
.91949 .01472 L
.92197 .01472 L
.92432 .01472 L
.92562 .01472 L
.92635 .01472 L
.92703 .01472 L
.9295 .01472 L
.93519 .01472 L
.93796 .01472 L
.93918 .01472 L
.93987 .01472 L
.94051 .01472 L
.94255 .01472 L
.94471 .01472 L
.94925 .01472 L
.95129 .01472 L
.95229 .01472 L
.95321 .01472 L
.95428 .01472 L
.95544 .01472 L
.95746 .01472 L
.97619 .01472 L
Mfstroke
0 0 1 r
.02381 .0171 m
.02846 .0174 L
.03279 .01765 L
.03754 .01802 L
.04262 .01852 L
.05212 .01952 L
.06244 .02076 L
.07379 .02266 L
.08451 .02462 L
.10458 .02973 L
.12442 .03656 L
.14545 .04634 L
.16498 .0591 L
.18328 .07382 L
.22205 .11092 L
.24319 .13904 L
.26328 .17429 L
.30147 .23582 L
.32114 .27958 L
.34212 .32942 L
.3837 .41484 L
.42376 .51616 L
.44214 .55029 L
.45258 .56892 L
.45767 .57967 L
.46008 .5849 L
.46114 .58723 L
.46232 .58982 L
.46346 .59031 L
.46468 .59059 L
.46726 .59127 L
.46967 .5921 L
.47075 .59254 L
.47194 .59305 L
.4732 .5929 L
.47389 .59289 L
.47453 .59296 L
.47568 .59339 L
.4769 .59384 L
.48225 .59584 L
.48758 .59873 L
.49026 .60071 L
.4918 .60197 L
.49248 .60254 L
.49321 .60317 L
.4945 .60332 L
.49573 .60313 L
.49843 .60279 L
.501 .6026 L
.50211 .60255 L
Mistroke
.50332 .60235 L
.50401 .60137 L
.50464 .60051 L
.50589 .59885 L
.50863 .59548 L
.51356 .58948 L
.51636 .58667 L
.51896 .58482 L
.52028 .58413 L
.52168 .58355 L
.52324 .58306 L
.52392 .5829 L
.52466 .58274 L
.52592 .5823 L
.5266 .58191 L
.52724 .58156 L
.52963 .5803 L
.53244 .57899 L
.53367 .57844 L
.53433 .57815 L
.53502 .57784 L
.53621 .57507 L
.53732 .5721 L
.53974 .56564 L
.54482 .55212 L
.58637 .47381 L
.6264 .40305 L
.66492 .337 L
.70589 .27398 L
.74535 .21633 L
.78328 .17003 L
.82368 .12935 L
.86255 .09896 L
.90388 .07396 L
.94369 .05623 L
.97619 .04512 L
Mfstroke
1 0 0 r
.02381 .01472 m
.02846 .01472 L
.03279 .01472 L
.03754 .01472 L
.0389 .01472 L
.0402 .01472 L
.04136 .01472 L
.04262 .01472 L
.05205 .01472 L
.05706 .01472 L
.05982 .01472 L
.06048 .01472 L
.06118 .01472 L
.06244 .01472 L
.06316 .01472 L
.06382 .01472 L
.06531 .01472 L
.06794 .01472 L
.07308 .01472 L
.07849 .01472 L
.08134 .01472 L
.0829 .01472 L
.08366 .01472 L
.08435 .01472 L
.0856 .01472 L
.08694 .01472 L
.08978 .01472 L
.09477 .01472 L
.09943 .01472 L
.10209 .01472 L
.10458 .01472 L
.10571 .01472 L
.10689 .01472 L
.10819 .01472 L
.10939 .01472 L
.11449 .01472 L
.12366 .01472 L
.12615 .01472 L
.12751 .01472 L
.1288 .01472 L
.13 .01472 L
.1313 .01472 L
.13249 .01472 L
.13358 .01472 L
.13881 .01472 L
.14443 .01472 L
.14949 .01472 L
.15189 .01472 L
.15297 .01472 L
.15412 .01472 L
Mistroke
.15529 .01472 L
.15634 .01472 L
.15877 .01473 L
.16319 .01473 L
.1683 .01474 L
.17099 .01474 L
.17382 .01474 L
.17631 .01474 L
.17699 .01474 L
.17772 .01474 L
.17904 .01475 L
.18033 .01476 L
.18154 .01476 L
.18383 .01478 L
.19351 .01483 L
.19606 .01485 L
.19881 .01486 L
.20007 .01486 L
.2014 .01486 L
.20254 .01487 L
.20378 .01489 L
.20493 .01492 L
.20598 .01495 L
.20832 .01501 L
.21254 .01512 L
.21715 .01523 L
.21977 .01528 L
.22221 .01533 L
.22475 .01536 L
.22707 .01539 L
.22835 .01541 L
.22956 .01552 L
.23222 .01578 L
.24143 .01665 L
.24394 .01685 L
.24661 .01703 L
.2514 .01728 L
.25267 .01733 L
.25335 .01735 L
.25405 .01738 L
.25536 .0177 L
.25655 .01808 L
.26224 .01985 L
.2725 .02238 L
.27494 .02278 L
.27754 .02312 L
.2786 .02324 L
.27975 .02337 L
.28101 .0236 L
.28219 .02457 L
Mistroke
.29088 .03129 L
.29581 .03432 L
.30032 .03636 L
.30512 .03782 L
.30644 .03813 L
.30716 .03831 L
.30784 .03847 L
.30848 .03937 L
.30917 .04052 L
.31036 .04251 L
.31991 .05607 L
.34085 .0786 L
.36041 .09797 L
.38187 .12548 L
.3843 .12711 L
.38558 .12784 L
.38694 .12849 L
.38813 .12893 L
.38943 .12936 L
.39062 .12964 L
.39174 .12986 L
.39242 .12997 L
.39313 .13061 L
.3944 .13352 L
.39727 .13942 L
.39971 .14373 L
.40105 .14584 L
.40231 .1476 L
.4035 .14878 L
.40478 .14987 L
.40703 .15136 L
.40814 .15189 L
.40931 .15232 L
.41032 .15255 L
.41142 .15263 L
.41272 .15354 L
.4139 .15423 L
.41518 .15485 L
.41585 .15512 L
.41657 .15541 L
.41785 .15576 L
.41904 .15603 L
.42027 .15618 L
.42138 .15627 L
.42259 .15654 L
.42372 .15884 L
.42628 .16345 L
.42898 .16746 L
.43016 .16895 L
.43144 .17041 L
Mistroke
.43263 .1714 L
.43373 .17202 L
.43479 .1725 L
.4359 .17287 L
.43708 .17312 L
.43818 .17322 L
.43938 .17318 L
.44068 .17296 L
.44135 .17272 L
.44206 .17308 L
.44335 .17376 L
.44487 .17439 L
.44559 .17463 L
.44626 .17482 L
.44757 .1751 L
.44826 .1752 L
.44899 .17528 L
.45021 .1753 L
.45091 .17528 L
.45156 .17523 L
.45285 .17534 L
.45407 .17735 L
.45637 .18062 L
.45883 .18336 L
.46023 .1846 L
.46152 .18555 L
.46265 .18617 L
.46385 .18636 L
.46505 .18641 L
.46636 .18629 L
.4675 .18604 L
.46872 .18563 L
.46987 .18509 L
.47091 .18448 L
.47156 .18404 L
.47224 .18364 L
.47347 .18416 L
.47479 .1846 L
.47554 .18479 L
.47625 .18494 L
.47751 .18514 L
.47867 .18518 L
.47931 .18518 L
.48001 .18516 L
.48128 .18499 L
.48197 .18487 L
.48271 .18471 L
.48341 .18451 L
.48405 .18498 L
.48527 .18644 L
Mistroke
.48656 .18774 L
.48786 .18882 L
.48924 .18975 L
.49004 .19017 L
.49076 .19049 L
.49145 .19074 L
.49218 .19095 L
.49347 .19119 L
.49467 .1909 L
.49596 .1904 L
.49737 .18966 L
.49991 .18783 L
.50229 .18549 L
.50347 .18405 L
.50473 .18439 L
.50592 .18461 L
.507 .18473 L
.50827 .1848 L
.50898 .18482 L
.50964 .18476 L
.51086 .18461 L
.51214 .18435 L
.51337 .184 L
.51469 .1835 L
.51594 .18381 L
.51708 .18462 L
.51841 .18533 L
.51916 .18563 L
.51986 .18584 L
.52114 .18606 L
.52179 .1861 L
.5225 .18609 L
.52367 .18595 L
.52489 .18566 L
.52594 .18513 L
.52709 .18427 L
.53205 .17911 L
.53429 .17596 L
.53555 .17394 L
.53669 .17407 L
.53776 .17411 L
.53891 .17409 L
.54001 .17402 L
.54102 .17392 L
.54226 .17366 L
.54345 .17337 L
.54451 .173 L
.54568 .17254 L
.54693 .17192 L
.54764 .17158 L
Mistroke
.54827 .17182 L
.54952 .17215 L
.55069 .17227 L
.55179 .17221 L
.55295 .17199 L
.55395 .17168 L
.55504 .17121 L
.55621 .17058 L
.55747 .16975 L
.55866 .16866 L
.55975 .16746 L
.58037 .15063 L
.62023 .11854 L
.65856 .07972 L
.6679 .06416 L
.66922 .06161 L
.67045 .05921 L
.67174 .05773 L
.67242 .05755 L
.67314 .05735 L
.67795 .05595 L
.68093 .05489 L
.68374 .05367 L
.68899 .05055 L
.69396 .04641 L
.69935 .04107 L
.70183 .03841 L
.70448 .03547 L
.70577 .03401 L
.70699 .0327 L
.70809 .03253 L
.70928 .03235 L
.71429 .03156 L
.71717 .03102 L
.71979 .03044 L
.72452 .02906 L
.72957 .02713 L
.73863 .02306 L
.74116 .02186 L
.7424 .02126 L
.74352 .02072 L
.74471 .02065 L
.74598 .02058 L
.74868 .02041 L
.75348 .0201 L
.75792 .01971 L
.76305 .01911 L
.76863 .01831 L
.7735 .01755 L
.77619 .01713 L
Mistroke
.77875 .01673 L
.77992 .01654 L
.78116 .01637 L
.78188 .01636 L
.78253 .01635 L
.78379 .01632 L
.78841 .01624 L
.79312 .01613 L
.79746 .016 L
.80256 .01581 L
.80808 .01558 L
.8129 .01538 L
.81556 .01526 L
.81687 .0152 L
.81808 .01515 L
.81926 .0151 L
.82051 .0151 L
.82316 .01508 L
.8278 .01506 L
.83689 .015 L
.8467 .01491 L
.85198 .01486 L
.85486 .01483 L
.85627 .01481 L
.85754 .0148 L
.85874 .01479 L
.85987 .01479 L
.86236 .01479 L
.86762 .01478 L
.87687 .01477 L
.887 .01475 L
.89254 .01474 L
.89524 .01473 L
.89643 .01473 L
.89772 .01473 L
.89894 .01473 L
.90007 .01473 L
.90231 .01473 L
.90724 .01473 L
.91772 .01472 L
.92658 .01472 L
.93124 .01472 L
.93616 .01472 L
.93743 .01472 L
.93813 .01472 L
.93879 .01472 L
.93957 .01472 L
.94028 .01472 L
.94168 .01472 L
.94674 .01472 L
Mistroke
.95671 .01472 L
.97532 .01472 L
.97619 .01472 L
Mfstroke
1 1 0 r
.02381 .0167 m
.03279 .01721 L
.04262 .01783 L
.053 .01881 L
.05753 .01919 L
.05991 .01938 L
.06122 .01949 L
.06244 .0196 L
.06309 .0197 L
.06379 .01981 L
.06526 .02005 L
.06786 .02046 L
.07298 .02116 L
.07876 .02188 L
.08161 .02223 L
.083 .0224 L
.08426 .02256 L
.08552 .02282 L
.08671 .0231 L
.08933 .02372 L
.09487 .02485 L
.10458 .0266 L
.10923 .02773 L
.11434 .02944 L
.12466 .03206 L
.14313 .03869 L
.18355 .05814 L
.22246 .08431 L
.26382 .12191 L
.30367 .15988 L
.342 .20122 L
.38278 .23949 L
.42205 .26654 L
.42702 .27138 L
.42944 .27386 L
.4305 .27495 L
.43164 .27612 L
.43284 .27677 L
.43397 .27717 L
.43646 .27804 L
.44174 .27973 L
.44627 .28068 L
.45051 .28158 L
.45161 .28181 L
.45264 .28203 L
.45384 .2829 L
.45493 .28374 L
.45746 .28565 L
.4598 .28743 L
.461 .28835 L
Mistroke
.46213 .28921 L
.46343 .28955 L
.46461 .28968 L
.46735 .28998 L
.46855 .29011 L
.46986 .29026 L
.47099 .29038 L
.47204 .29038 L
.47314 .29034 L
.47433 .29033 L
.47915 .29026 L
.48183 .29022 L
.48257 .29021 L
.48335 .2902 L
.48402 .29037 L
.48475 .29071 L
.48731 .29191 L
.49006 .2932 L
.49137 .2938 L
.49208 .29414 L
.49274 .29444 L
.49391 .29479 L
.49519 .29461 L
.5 .29393 L
.50913 .29193 L
.51134 .29141 L
.51372 .29084 L
.51442 .29068 L
.51509 .29052 L
.51634 .29066 L
.5175 .29086 L
.51877 .29107 L
.52144 .29153 L
.5229 .29177 L
.52427 .292 L
.52543 .29219 L
.52669 .29172 L
.52936 .2907 L
.5391 .28661 L
.54453 .28421 L
.54585 .28363 L
.54658 .28331 L
.54726 .28301 L
.54807 .28281 L
.54881 .28273 L
.55025 .28258 L
.55516 .28205 L
.5565 .28191 L
.55724 .28183 L
.55793 .28175 L
Mistroke
.55915 .28105 L
.56049 .28026 L
.58065 .268 L
.61944 .24448 L
.66068 .21413 L
.70041 .18173 L
.73863 .15161 L
.77929 .1221 L
.81844 .09757 L
.86004 .07594 L
.90013 .05937 L
.9387 .04696 L
.97619 .03793 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo000_Ool0
0`00Oomoo`02Ool00`00Oomoo`0MOol20004Ool00`00Oomoo`0HOol50002Ool00`00Oomoo`02Ool0
0`00Oomoo`0FOol:0002Ool00`00Oomoo`0FOol5000017oo000000000goo00<007ooOol05Woo1@00
00=oo`00000017oo00<007ooOol05goo1@000Woo0`000Woo00<007ooOol01goo000^Ool00`00Ool0
0002Ool00`00Ool0000POol01P00Oomoo`00Ool001]oo`07001oogooOol007oo00000Woo00<007oo
00006Goo00<007ooOol00Woo00L007ooOomoo`00Ool0000IOol01@00Oomoogoo000017oo00<007oo
00006Goo00<007ooOol00goo00H007ooOol007oo000JOol00`00Oomoo`03Ool01P00Oomoo`00Ool0
00Qoo`00;Woo00<007oo00000Woo00<007oo00007goo0P000Woo00<007oo00006goo00L007ooOomo
o`00Ool00002Ool00`00Ool0000IOol00`00Oomoo`02Ool01`00Oomoogoo001oo`0001Uoo`03001o
ogoo009oo`07001oogooOol007oo00006Goo00<007ooOol00Woo00L007ooOomoo`00Ool0000JOol0
1000Oomoogoo100000Aoo`00Ool000Qoo`00;goo00L007ooOomoo`00Ool0000NOol00`00Ool00002
Ool00`00Ool0000KOol01`00Oomoogoo001oo`00009oo`03001oo`0001Uoo`03001oogoo009oo`07
001oogooOol007oo00006Goo00<007ooOol00Woo00L007ooOomoo`00Ool0000IOol00`00Oomoo`03
Ool01P00Oomoo`00Ool001Yoo`07001oogooOol007oo00000Woo00<007oo000027oo000^Ool00`00
Ool00002Ool00`00Ool0000NOol00`00Ool00002Ool00`00Ool0000KOol01`00Oomoogoo001oo`00
009oo`03001oo`0001Uoo`03001oogoo009oo`07001oogooOol007oo00006Goo00L007ooOomoo`00
Ool00002Ool00`00Ool0000IOol01`00Oomoogoo001oo`00009oo`03001oo`0001Yoo`03001oogoo
009oo`80009oo`03001oo`0000Qoo`00;goo00<007ooOol00Woo00<007ooOol07Woo0P000goo00<0
07ooOol06Goo0P0017oo00<007ooOol00Woo00<007ooOol05goo0P000goo0P0017oo00<007ooOol0
5goo0P0017oo00<007ooOol00Woo00<007ooOol05goo0P0017oo00<007ooOol00Woo00<007ooOol0
67oo0P001Goo00D007ooOomoo`0000Uoo`00ogoo8Goo000=Ool00`00Oomoo`3oOolAOol000eoo`03
001oogoo0?mooa5oo`003Goo00<007ooOol0ogoo4Goo000=Ool00`00Oomoo`3oOolAOol000Moo`H0
03el098003Il00L000Moo`003Goo3GoP0Woo00<007ooOol01Goo00<007ooOol017oo00<007ooOol0
17oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo1g`000<007ooOol01Goo00<007oo
Ool017oo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007oo
Ool017oo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007oo
Ool017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol017oo00<007ooOol01Goo00<007oo
Ool017oo00<007ooOol00goo27`000<3h000Ool01Woo00<007ooOol017oo00<007ooOol017oo00<0
07ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol017oo00<007ooOol037oo000=
Ool00`00Oomoo`07Ool201l8On0AOol00`00Oomoo`0KOol4O004Ool00`00Oomoo`0ROol00`00Oomo
o`0ROol00`00Oomoo`0ROol00`00Oomoo`05Ool5O0020n0FOol00`00Oomoo`0ROol00`00Oomoo`0<
Ool000eoo`03001oogoo00eoo`@07`Aoh2eoo`83h09l07Moo`9l0003Ool3h7oo04ioo`003Goo00<0
07ooOol04Goo100O0goP;7oo00@3h7ooO01l079oo`=l0003Ool3h0?P051oo`003Goo00<007ooOol0
5Goo0`0O0goP:Woo0P?P00=oog`0Ool0KGoo17`000=oo`?P0n00DWoo000=Ool00`00Oomoo`0HOol3
01l2On0ZOol00`?POoml0002O01ZOol2O002Ool20n14Ool2On0>Ool000eoo`8001aoo`807`=oh2Qo
o`040n1oogooO01ZOol017`0Oomoo`?P@Woo17oP47oo000=Ool00`00Oomoo`0MOol201l00gooOn1o
h00VOol010?POomoog`0JGoo00Al07ooOol3h41oo`=oh0Aoo`807`ioo`003Goo00<007ooOol07goo
00<07gooOol00WoP9Goo00@3h7ooOoml06Moo`04O01oogoo0n0nOol3On04Ool301l@Ool000eoo`03
001oogoo021oo`807`9oo`9oh2Aoo`040n1oogooO01TOol2O002Ool00`?POomoo`0iOol4On04Ool3
01lCOol000eoo`03001oogoo029oo`807`9oo`9oh2=oo`040n1oogooO01POol3O003Ool00`?POomo
o`0fOol4On05Ool301lFOol000eoo`03001oogoo02Aoo`0401moogooOol2On0QOol01@?POomoogoo
O000GWoo00=l07ooOol00goo00<3h7ooOol0=7oo0goP1goo0P0O6Goo000=Ool00`00Oomoo`0UOol0
0`0OOomoo`02Ool2On0POol01@?POomoogooO000G7oo00=l07ooOol017oo00<3h7ooOol0<Woo0WoP
27oo0P0O6goo000=Ool2000WOol201l4Ool00goPOomoo`0NOol01@?POomoogooO000FWoo00=l07oo
Ool017oo00<3h7ooOol0<Goo0WoP27oo0P0O7Goo000=Ool00`00Oomoo`0XOol00`0OOomoo`02Ool2
On0NOol00`?POomoo`02Ool00g`0Oomoo`1GOol00g`0Oomoo`03Ool00`?POomoo`0`Ool2On08Ool2
01lOOol000eoo`03001oogoo02Uoo`0301moogoo00=oo`9oh1eoo`030n1oogoo009oo`03O01oogoo
05Eoo`03O01oogoo00=oo`030n1oogoo02moo`9oh0Qoo`807b5oo`003Goo00<007ooOol0:Woo00<0
7gooOol017oo00=oh7ooOol06Woo00<3h7ooOol00goo00=l07ooOol0E7oo00=l07ooOol00goo00<3
h7ooOol0;Goo0WoP27oo0P0O8goo000=Ool00`00Oomoo`0[Ool00`0OOomoo`04Ool2On0KOol00`?P
Oomoo`03Ool00g`0Oomoo`1BOol00g`0Oomoo`03Ool00`?POomoo`0/Ool2On09Ool00`0OOomoo`0S
Ool000eoo`03001oogoo02aoo`0301moogoo00Eoo`03On1oogoo01Qoo`030n1oogoo00Aoo`03O01o
ogoo051oo`03O01oogoo00Aoo`030n1oogoo02Yoo`9oh0Uoo`807bIoo`003Goo00<007ooOol0;Goo
00<07gooOol01Goo00=oh7ooOol05goo00<3h7ooOol01Goo00=l07ooOol0CWoo00=l07ooOol017oo
00<3h7ooOol0:Goo0WoP2Goo0P0O:7oo000=Ool2000_Ool00`0OOomoo`05Ool00goPOomoo`0GOol0
0`?POomoo`04Ool00g`0Oomoo`1=Ool00g`0Oomoo`05Ool00`?POomoo`0WOol2On0:Ool00`0OOomo
o`0XOol000eoo`03001oogoo02moo`0301moogoo00Eoo`03On1oogoo01Ioo`030n1oogoo00Eoo`03
O01oogoo04]oo`03O01oogoo00Eoo`030n1oogoo02Ioo`9oh0Yoo`807b]oo`003Goo00<007ooOol0
<7oo00<07gooOol01Goo00=oh7ooOol05Woo00<3h7ooOol01Goo00=l07ooOol0BGoo00=l07ooOol0
1Goo00<3h7ooOol09Woo00=oh7ooOol02Goo00<07gooOol0:goo000=Ool00`00Oomoo`0aOol00`0O
Oomoo`05Ool2On0FOol00`?POomoo`06Ool00g`0Oomoo`17Ool00g`0Oomoo`06Ool00`?POomoo`0T
Ool2On0:Ool201l^Ool000eoo`03001oogoo039oo`0301moogoo00Ioo`03On1oogoo01=oo`030n1o
ogoo00Moo`03O01oogoo04Eoo`03O01oogoo00Ioo`030n1oogoo02=oo`9oh0]oo`0301moogoo02io
o`003Goo00<007ooOol0<goo00<07gooOol01Woo00=oh7ooOol04goo00<3h7ooOol01goo00=l07oo
Ool0@goo00=l07ooOol01goo00<3h7ooOol08Goo0WoP37oo00<07gooOol0;goo000=Ool00`00Oomo
o`0dOol00`0OOomoo`06Ool00goPOomoo`0BOol00`?POomoo`07Ool00g`0Oomoo`12Ool00g`0Oomo
o`07Ool00`?POomoo`0POol2On0<Ool201lbOol000eoo`8003Ioo`0301moogoo00Ioo`03On1oogoo
019oo`030n1oogoo00Moo`03O01oogoo041oo`03O01oogoo00Qoo`030n1oogoo01ioo`9oh0eoo`03
01moogoo039oo`003Goo00<007ooOol0=Goo00<07gooOol01goo00=oh7ooOol04Goo00<3h7ooOol0
27oo00=l07ooOol0?Woo00=l07ooOol027oo00<3h7ooOol07Woo00=oh7ooOol037oo00<07gooOol0
<goo000=Ool00`00Oomoo`0fOol00`0OOomoo`07Ool00goPOomoo`0@Ool00`?POomoo`09Ool00g`0
Oomoo`0kOol2O00;Ool00`?POomoo`0LOol2On0=Ool201lfOol000eoo`03001oogoo03Moo`0301mo
ogoo00Moo`03On1oogoo011oo`030n1oogoo00Uoo`=l03Uoo`03O01oogoo00]oo`030n1oogoo01]o
o`03On1oogoo00aoo`0301moogoo03Ioo`003Goo00<007ooOol0>7oo00<07gooOol01goo00=oh7oo
Ool03goo00<3h7ooOol02goo00=l07ooOol0=Woo00=l07ooOol02goo00<3h7ooOol06goo00=oh7oo
Ool037oo00<07gooOol0=goo0005Ool50003Ool00`00Oomoo`0hOol00`0OOomoo`08Ool00goPOomo
o`0?Ool00`?POomoo`0;Ool00g`0Oomoo`0dOol00g`0Oomoo`0<Ool00`?POomoo`0IOol2On0>Ool0
0`0OOomoo`0hOol000Moo`03001oogoo00=oo`03001oogoo03Uoo`0301moogoo00Qoo`03On1oogoo
00ioo`030n1oogoo00]oo`03O01oogoo03=oo`03O01oogoo00eoo`030n1oogoo01Qoo`03On1oogoo
00eoo`0301moogoo03Uoo`001goo00<007ooOol00goo0`00>Woo00<07gooOol027oo00=oh7ooOol0
3Goo00<3h7ooOol037oo00=l07ooOol0<7oo0W`047oo00<3h7ooOol05goo00=oh7ooOol03Goo00<0
7gooOol0>Woo0007Ool00`00Oomoo`03Ool00`00Oomoo`0jOol00`0OOomoo`09Ool00goPOomoo`0=
Ool00`?POomoo`0;Ool2O00`Ool00g`0Oomoo`0?Ool00`?POomoo`0FOol2On0?Ool00`0OOomoo`0k
Ool000Moo`03001oogoo00=oo`03001oogoo03]oo`0301moogoo00Uoo`03On1oogoo00aoo`030n1o
ogoo00aoo`9l02ioo`03O01oogoo011oo`030n1oogoo01Eoo`03On1oogoo00ioo`0301moogoo03ao
o`001Woo0P001Goo00<007ooOol0?7oo00<07gooOol02Goo00=oh7ooOol02goo00<3h7ooOol03Woo
0g`0:Woo00=l07ooOol04Goo00<3h7ooOol057oo00=oh7ooOol03Woo00<07gooOol0?Goo000=Ool0
0`00Oomoo`0lOol00`0OOomoo`0:Ool00goPOomoo`0:Ool00`?POomoo`0@Ool2O00XOol00g`0Oomo
o`0AOol00`?POomoo`0DOol00goPOomoo`0>Ool00`0OOomoo`0nOol000eoo`03001oogoo03eoo`03
01moogoo00Yoo`03On1oogoo00Yoo`030n1oogoo015oo`03O01oogoo02Aoo`03O01oogoo019oo`03
0n1oogoo01=oo`03On1oogoo00ioo`0301moogoo03moo`003Goo00<007ooOol0?Woo00<07gooOol0
2Woo00=oh7ooOol02Goo00<3h7ooOol04Goo00=l07ooOol08goo00=l07ooOol04goo00<3h7ooOol0
4Goo0WoP47oo00<07gooOol0@7oo000=Ool2000oOol00`0OOomoo`0;Ool00goPOomoo`08Ool00`?P
Oomoo`0BOol2O00QOol2O00EOol00`?POomoo`0AOol00goPOomoo`0?Ool00`0OOomoo`11Ool000eo
o`03001oogoo03moo`0301moogoo00]oo`03On1oogoo00Moo`030n1oogoo01=oo`Al01Qoo`Il01Mo
o`030n1oogoo011oo`03On1oogoo00moo`0301moogoo049oo`003Goo00<007ooOol0@7oo00<07goo
Ool02goo00=oh7ooOol01goo00<3h7ooOol05Goo17`05Goo00=l07ooOol06Woo00<3h7ooOol03goo
00=oh7ooOol03goo00<07gooOol0@goo000=Ool00`00Oomoo`10Ool00`0OOomoo`0<Ool00goPOomo
o`06Ool00`?POomoo`0HOol00g`0Oomoo`0BOol00g`0Oomoo`0JOol00`?POomoo`0?Ool00goPOomo
o`0@Ool00`0OOomoo`13Ool000eoo`03001oogoo045oo`0301moogoo00]oo`03On1oogoo00Ioo`03
0n1oogoo01Uoo`03O01oogoo00El00Aoo`El0003Ooml07`001eoo`030n1oogoo00ioo`03On1oogoo
011oo`0301moogoo04Aoo`003Goo00<007ooOol0@Goo00<07gooOol037oo00=oh7ooOol01Goo00<3
h7ooOol06Woo0g`00goo0W`00Woo0W`00goo0g`07Woo00<3h7ooOol037oo0WoP4Woo00<07gooOol0
AGoo000=Ool20013Ool00`0OOomoo`0<Ool00goPOomoo`05Ool00`?POomoo`0POol3O00UOol00`?P
Oomoo`0<Ool00goPOomoo`0AOol00`0OOomoo`16Ool000eoo`03001oogoo04=oo`0301moogoo00ao
o`03On1oogoo00Aoo`030n1oogoo04Qoo`030n1oogoo00]oo`03On1oogoo019oo`0301moogoo04Io
o`003Goo00<007ooOol0@goo00<07gooOol03Goo00=oh7ooOol00goo00<3h7ooOol0B7oo00<3h7oo
Ool02Goo0WoP57oo00<07gooOol0Agoo000=Ool00`00Oomoo`14Ool00`0OOomoo`0=Ool00goPOomo
o`02Ool00`?POomoo`17Ool00`?POomoo`09Ool00goPOomoo`0COol00`0OOomoo`18Ool000eoo`03
001oogoo04Aoo`0301moogoo00ioo`03On1oogoo009oo`030n1oogoo04Ioo`030n1oogoo00Qoo`03
On1oogoo01=oo`0301moogoo04Uoo`003Goo00<007ooOol0AGoo00<07gooOol03Woo00Eoh7ooOomo
o`?P04Moo`030n1oogoo00Moo`9oh1Ioo`0301moogoo04Uoo`003Goo00<007ooOol0AGoo00<07goo
Ool03goo00Aoh7ooOol3h4Moo`030n1oogoo00Ioo`03On1oogoo01Eoo`0301moogoo04Yoo`003Goo
0P00Agoo00<07gooOol03goo00=oh7oo0n00Agoo00<3h7ooOol01Goo00=oh7ooOol05Goo00<07goo
Ool0Bgoo000=Ool00`00Oomoo`17Ool00`0OOomoo`0?Ool2On000`?POomoo`13Ool00`?POomoo`04
Ool2On0GOol00`0OOomoo`1<Ool000eoo`03001oogoo04Moo`0301moogoo015oo`03On1oogoo04=o
o`030n1oogoo00=oo`03On1oogoo01Moo`0301moogoo04aoo`003Goo00<007ooOol0B7oo00<07goo
Ool047oo00<3h7oPOol0@goo00<3h7ooOol00Woo00=oh7ooOol05goo00<07gooOol0CGoo000=Ool0
0`00Oomoo`18Ool00`0OOomoo`0@Ool00`?POomoh012Ool00`?POomoo`02Ool00goPOomoo`0GOol0
0`0OOomoo`1>Ool000eoo`03001oogoo04Uoo`0301moogoo011oo`030n1oogoP045oo`050n1oogoo
Oomoh00JOol00`0OOomoo`1>Ool000eoo`03001oogoo04Uoo`0301moogoo011oo`040n1oogooOn10
Ool010?POomoh7oP6Woo00<07gooOol0Cgoo000=Ool2001;Ool00`0OOomoo`0?Ool010?POomoogoo
0WoP?Woo00<3h7oPOol06Woo00<07gooOol0D7oo000=Ool00`00Oomoo`1:Ool00`0OOomoo`0?Ool0
0`?POomoo`03Ool00goPOomoo`0jOol00`?POn1oo`0KOol00`0OOomoo`1@Ool000eoo`03001oogoo
04]oo`0301moogoo00moo`030n1oogoo00=oo`03On1oogoo03Qoo`9oh1aoo`0301moogoo055oo`00
3Goo00<007ooOol0Bgoo00<07gooOol03goo00<3h7ooOol017oo0WoP=Woo0WoP00=oo`?POol06Woo
00<07gooOol0DWoo000=Ool00`00Oomoo`1<Ool00`0OOomoo`0>Ool00`?POomoo`06Ool00goPOomo
o`0aOol2On03Ool00`?POomoo`0HOol00`0OOomoo`1COol000Ioo`<000Aoo`03001oogoo04aoo`03
01moogoo00ioo`030n1oogoo00Moo`03On1oogoo02ioo`9oh0Aoo`030n1oogoo01Uoo`0301moogoo
05=oo`001Woo00<007ooOol017oo00<007ooOol0C7oo00<07gooOol03goo00<3h7ooOol01goo0WoP
;7oo0WoP1Woo00<3h7ooOol067oo00<07gooOol0E7oo0007Ool00`00Oomoo`03Ool3001=Ool00`0O
Oomoo`0>Ool00`?POomoo`09Ool00goPOomoo`0XOol00goPOomoo`06Ool00`?POomoo`0GOol00`0O
Oomoo`1EOol000Moo`03001oogoo00=oo`03001oogoo04eoo`0301moogoo00ioo`030n1oogoo00Yo
o`03On1oogoo02Eoo`9oh0Uoo`030n1oogoo01Moo`0301moogoo05Eoo`001Woo00<007oo000017oo
00<007ooOol0CWoo00<07gooOol03Goo00<3h7ooOol02goo0WoP8goo0WoP2Woo00<3h7ooOol05goo
00<07gooOol0EWoo0007Ool00`00Oomoo`03Ool00`00Oomoo`1>Ool00`0OOomoo`0>Ool00`?POomo
o`0;Ool5On0NOol00goPOomoo`0:Ool00`?POomoo`0FOol00`0OOomoo`1GOol000eoo`03001oogoo
04ioo`0301moogoo00ioo`030n1oogoo011oo`9oh1Moo`Eoh0eoo`030n1oogoo01Ioo`0301moogoo
05Moo`003Goo00<007ooOol0Cgoo00<07gooOol03Goo00<3h7ooOol04Woo00=oh7ooOol04Woo0WoP
4Woo00<3h7ooOol05Goo00<07gooOol0F7oo000=Ool00`00Oomoo`1?Ool00`0OOomoo`0=Ool00`?P
Oomoo`0COol7On06Ool4On000gooOn1oh00COol00`?POomoo`0EOol00`0OOomoo`1IOol000eoo`80
055oo`0301moogoo00eoo`030n1oogoo01Uoo`Moh09oo`9oh1Eoo`030n1oogoo01Eoo`0301moogoo
05Uoo`003Goo00<007ooOol0D7oo00<07gooOol03Goo00<3h7ooOol0>Goo00<3h7ooOol057oo00<0
7gooOol0FWoo000=Ool00`00Oomoo`1AOol00`0OOomoo`0<Ool00`?POomoo`0iOol00`?POomoo`0C
Ool00`0OOomoo`1KOol000eoo`03001oogoo055oo`0301moogoo00aoo`030n1oogoo03Qoo`030n1o
ogoo01Aoo`0301moogoo05]oo`003Goo00<007ooOol0DGoo00<07gooOol037oo00<3h7ooOol0>7oo
00<3h7ooOol04goo00<07gooOol0G7oo000=Ool00`00Oomoo`1BOol00`0OOomoo`0<Ool00`?POomo
o`0gOol00`?POomoo`0COol00`0OOomoo`1LOol000eoo`03001oogoo059oo`0301moogoo00aoo`03
0n1oogoo03Moo`030n1oogoo019oo`0301moogoo05eoo`003Goo0P00E7oo00<07gooOol02goo00<3
h7ooOol0=Woo00<3h7ooOol04Woo00<07gooOol0GWoo000=Ool00`00Oomoo`1COol00`0OOomoo`0;
Ool00`?POomoo`0fOol00`?POomoo`0BOol00`0OOomoo`1NOol000eoo`03001oogoo05Aoo`0301mo
ogoo00]oo`030n1oogoo03Eoo`030n1oogoo015oo`0301moogoo05moo`003Goo00<007ooOol0E7oo
00<07gooOol02goo00<3h7ooOol0=Goo00<3h7ooOol047oo00<07gooOol0H7oo000=Ool00`00Oomo
o`1DOol00`0OOomoo`0;Ool00`?POomoo`0dOol00`?POomoo`0AOol00`0OOomoo`1POol000eoo`03
001oogoo05Eoo`0301moogoo00Yoo`030n1oogoo03Aoo`030n1oogoo011oo`0301moogoo065oo`00
3Goo00<007ooOol0EGoo00<07gooOol02goo00<3h7ooOol0<goo00<3h7ooOol03goo00<07gooOol0
HWoo000=Ool2001GOol00`0OOomoo`0:Ool00`?POomoo`0cOol00`?POomoo`0?Ool00`0OOomoo`1R
Ool000eoo`03001oogoo05Ioo`0301moogoo00Yoo`030n1oogoo039oo`030n1oogoo00moo`0301mo
ogoo06=oo`003Goo00<007ooOol0Egoo00<07gooOol02Goo00<3h7ooOol0<Woo00<3h7ooOol03goo
00<07gooOol0Hgoo000=Ool00`00Oomoo`1GOol00`0OOomoo`09Ool00`?POomoo`0bOol00`?POomo
o`0>Ool00`0OOomoo`1TOol000eoo`03001oogoo05Qoo`0301moogoo00Uoo`030n1oogoo035oo`03
0n1oogoo00ioo`0301moogoo06Aoo`003Goo00<007ooOol0F7oo00<07gooOol02Goo00<3h7ooOol0
<7oo00<3h7ooOol03Woo00<07gooOol0IGoo000=Ool00`00Oomoo`1IOol00`0OOomoo`08Ool00`?P
Oomoo`0`Ool00`?POomoo`0>Ool00`0OOomoo`1UOol000eoo`8005Yoo`0301moogoo00Qoo`030n1o
ogoo031oo`030n1oogoo00eoo`0301moogoo06Ioo`003Goo00<007ooOol0FWoo00<07gooOol027oo
00<3h7ooOol0;goo00<3h7ooOol037oo00<07gooOol0Igoo000=Ool00`00Oomoo`1JOol00`0OOomo
o`08Ool00`?POomoo`0^Ool00`?POomoo`0=Ool00`0OOomoo`1WOol000eoo`03001oogoo05]oo`03
01moogoo00Moo`030n1oogoo02ioo`030n1oogoo00aoo`0301moogoo06Qoo`003Goo00<007ooOol0
Fgoo00<07gooOol01goo00<3h7ooOol0;Woo00<3h7ooOol037oo00<07gooOol0J7oo0006Ool20005
Ool00`00Oomoo`1LOol00`0OOomoo`07Ool00`?POomoo`0/Ool00`?POomoo`0<Ool00`0OOomoo`1Y
Ool000Qoo`03001oogoo009oo`03001oogoo05aoo`0301moogoo00Moo`030n1oogoo02aoo`030n1o
ogoo00aoo`0301moogoo06Uoo`001goo00<007ooOol00goo0`00GGoo00<07gooOol01Woo00<3h7oo
Ool0;7oo00<3h7ooOol02goo00<07gooOol0JWoo0008Ool00`00Oomoo`02Ool00`00Oomoo`1MOol0
0`0OOomoo`06Ool00`?POomoo`0[Ool00`?POomoo`0<Ool00`0OOomoo`1ZOol000Ioo`03001oo`00
00Aoo`03001oogoo05ioo`0301moogoo00Ioo`030n1oogoo02Yoo`030n1oogoo00]oo`0301moogoo
06]oo`001goo00<007ooOol00goo00<007ooOol0GWoo00<07gooOol01Woo00<3h7ooOol0:Woo00<3
h7ooOol02Woo00<07gooOol0K7oo000=Ool00`00Oomoo`1OOol00`0OOomoo`05Ool00`?POomoo`0Z
Ool00`?POomoo`0:Ool00`0OOomoo`1/Ool000eoo`03001oogoo05moo`0301moogoo00Eoo`030n1o
ogoo02Uoo`030n1oogoo00Yoo`0301moogoo06eoo`003Goo00<007ooOol0Ggoo00<07gooOol01Goo
00<3h7ooOol0:Goo00<3h7ooOol02Woo00<07gooOol0KGoo000=Ool2001QOol00`0OOomoo`05Ool0
0`?POomoo`0XOol00`?POomoo`09Ool00`0OOomoo`1^Ool000eoo`03001oogoo061oo`0301moogoo
00Eoo`030n1oogoo02Moo`030n1oogoo00Yoo`0301moogoo06ioo`003Goo00<007ooOol0HGoo00<0
7gooOol017oo00<3h7ooOol09goo00<3h7ooOol02Goo00<07gooOol0Kgoo000=Ool00`00Oomoo`1Q
Ool00`0OOomoo`04Ool00`?POomoo`0WOol00`?POomoo`08Ool00`0OOomoo`1`Ool000eoo`03001o
ogoo065oo`0301moogoo00Eoo`030n1oogoo02Eoo`030n1oogoo00Uoo`0301moogoo071oo`003Goo
00<007ooOol0HWoo00<07gooOol017oo00<3h7ooOol09Goo00<3h7ooOol027oo00<07gooOol0LGoo
000=Ool00`00Oomoo`1ROol00`0OOomoo`04Ool00`?POomoo`0UOol00`?POomoo`08Ool00`0OOomo
o`1aOol000eoo`8006Aoo`0301moogoo00=oo`030n1oogoo02Eoo`030n1oogoo00Moo`0301moogoo
079oo`003Goo00<007ooOol0Hgoo00<07gooOol017oo00<3h7ooOol08goo00<3h7ooOol01goo00<0
7gooOol0Lgoo000=Ool00`00Oomoo`1SOol00`0OOomoo`04Ool00`?POomoo`0SOol00`?POomoo`07
Ool00`0OOomoo`1cOol000eoo`03001oogoo06Aoo`0301moogoo00=oo`030n1oogoo02=oo`030n1o
ogoo00Ioo`0301moogoo07Aoo`003Goo00<007ooOol0I7oo00<07gooOol00goo00<3h7ooOol08Woo
00<3h7ooOol01goo00<07gooOol0M7oo000=Ool00`00Oomoo`1UOol00`0OOomoo`03Ool00`?POomo
o`0QOol00`?POomoo`06Ool00`0OOomoo`1eOol000eoo`03001oogoo06Eoo`0301moogoo00=oo`03
0n1oogoo025oo`030n1oogoo00Ioo`0301moogoo07Eoo`003Goo0P00IWoo00<07gooOol00goo00<3
h7ooOol087oo00<3h7ooOol01Woo00<07gooOol0MWoo000=Ool00`00Oomoo`1VOol00`0OOomoo`03
Ool00`?POomoo`0OOol00`?POomoo`05Ool00`0OOomoo`1gOol000eoo`03001oogoo06Ioo`0301mo
ogoo00=oo`030n1oogoo01moo`030n1oogoo00Eoo`0301moogoo07Moo`003Goo00<007ooOol0IWoo
00<07gooOol00goo00<3h7ooOol07Woo00<3h7ooOol01Goo00<07gooOol0N7oo000=Ool00`00Oomo
o`1WOol00`0OOomoo`03Ool00`?POomoo`0MOol00`?POomoo`05Ool00`0OOomoo`1hOol000eoo`03
001oogoo06Moo`0301moogoo00=oo`030n1oogoo01eoo`030n1oogoo00Aoo`0301moogoo07Uoo`00
3Goo00<007ooOol0J7oo00<07gooOol00goo00<3h7ooOol077oo00<3h7ooOol017oo00<07gooOol0
NGoo000=Ool2001YOol00`0OOomoo`03Ool00`?POomoo`0KOol00`?POomoo`04Ool00`0OOomoo`1j
Ool000eoo`03001oogoo06Qoo`0301moogoo00=oo`030n1oogoo01]oo`030n1oogoo00Aoo`0301mo
ogoo07Yoo`003Goo00<007ooOol0JGoo00<07gooOol00goo00<3h7ooOol06Woo00<3h7ooOol00goo
00<07gooOol0Ngoo000=Ool00`00Oomoo`1YOol00`0OOomoo`03Ool00`?POomoo`0IOol00`?POomo
o`04Ool00`0OOomoo`1kOol000eoo`03001oogoo06Yoo`0301moogoo009oo`030n1oogoo01Uoo`03
0n1oogoo00=oo`0301moogoo07aoo`001goo0`000goo00<007ooOol0JWoo00<07gooOol00goo00<3
h7ooOol067oo00<3h7ooOol00Woo00<07gooOol0OGoo0008Ool00`00Oomoo`02Ool00`00Oomoo`1[
Ool00`0OOomoo`02Ool00`?POomoo`0GOol00`?POomoo`03Ool00`0OOomoo`1mOol000Ioo`@000=o
o`<006]oo`0301moogoo009oo`030n1oogoo01Moo`030n1oogoo009oo`0301moogoo07ioo`001Woo
00<007oo000017oo00<007ooOol0K7oo00<07gooOol00Woo00<3h7ooOol05Goo00<3h7ooOol00goo
00<07gooOol0OWoo0007Ool20004Ool00`00Oomoo`1/Ool00`0OOomoo`02Ool00`?POomoo`0EOol0
0`?POomoo`02Ool00`0OOomoo`1oOol000Qoo`03001oogoo009oo`03001oogoo06eoo`0301moogoo
009oo`030n1oogoo01=oo`030n1oogoo00=oo`0301moogoo07moo`003Goo00<007ooOol0KGoo00<0
7gooOol00Woo00<3h7ooOol04goo00<3h7ooOol00Woo00<07gooOol0P7oo000=Ool00`00Oomoo`1^
Ool00`0OOomoo`02Ool00`?POomoo`0AOol00`?POomoo`03Ool00`0OOomoo`20Ool000eoo`8006mo
o`0301moogoo009oo`030n1oogoo015oo`030n1oogoo009oo`0301moogoo085oo`003Goo00<007oo
Ool0Kgoo00D07gooOomoo`?P01=oo`030n1oogoo009oo`0301moogoo085oo`003Goo00<007ooOol0
L7oo00D07gooOomoo`?P015oo`030n1oogoo009oo`0301moogoo089oo`003Goo00<007ooOol0L7oo
00D07gooOomoo`?P015oo`030n1oogoo009oo`0301moogoo089oo`003Goo00<007ooOol0LGoo00D0
7gooOomoo`?P00moo`030n1oogoo009oo`0301moogoo08=oo`003Goo00<007ooOol0LGoo00D07goo
Oomoo`?P00ioo`030n1oogoo00=oo`0301moogoo08=oo`003Goo00<007ooOol0LWoo00D07gooOomo
o`?P00eoo`030n1oogoo00=oo`0301moogoo08=oo`003Goo0P00M7oo00D07gooOomoo`?P00]oo`03
0n1oogoo00=oo`0301moogoo08Aoo`003Goo00<007ooOol0Lgoo00@07gooOomoo`83h0Uoo`030n1o
ogoo00Aoo`0301moogoo08Aoo`003Goo00<007ooOol0M7oo00@07gooOomoo`83h0Moo`030n1oogoo
00=oo`<07hIoo`003Goo00<007ooOol0M7oo00<07gooOol00Woo0P?P17oo0P?P0goo100OR7oo000=
Ool00`00Oomoo`1eOol00`0OOomoo`02Ool60n04Ool00`0OOomoo`29Ool000eoo`03001oogoo07Eo
o`<07`]oo`0301moogoo08Yoo`003Goo00<007ooOol0Mgoo1@0O1Woo00<07gooOol0Rgoo000=Ool2
001mOol00`0OOomoo`02Ool00`0OOomoo`2<Ool000eoo`03001oogoo07eoo`@07hmoo`003Goo00<0
07ooOol0ogoo4Goo000=Ool00`00Oomoo`3oOolAOol000eoo`03001oogoo0?mooa5oo`003Goo00<0
07ooOol0ogoo4Goo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {66.2691, -0.358154, 
  0.269521, 0.028864}}]
}, Open  ]],

Cell[BoxData[
    \(price5 = 
      MakePriceFunc[{asset}, pf1, v2, r1, q1, s3, AssetPrice -> asset]; \n
    price6 = MakePriceFunc[{asset}, pf1, v2, r1, q1, s4, 
        AssetPrice -> asset]; \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot[{price5[a], price6[a]}, {a, 70, 140}, PlotStyle -> {Blue, Red}]; 
    \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.928572 0.0136054 0.0147151 0.160109 [
[.15986 .00222 -6 -9 ]
[.15986 .00222 6 0 ]
[.29592 .00222 -6 -9 ]
[.29592 .00222 6 0 ]
[.43197 .00222 -9 -9 ]
[.43197 .00222 9 0 ]
[.56803 .00222 -9 -9 ]
[.56803 .00222 9 0 ]
[.70408 .00222 -9 -9 ]
[.70408 .00222 9 0 ]
[.84014 .00222 -9 -9 ]
[.84014 .00222 9 0 ]
[.97619 .00222 -9 -9 ]
[.97619 .00222 9 0 ]
[.01131 .09477 -18 -4.5 ]
[.01131 .09477 0 4.5 ]
[.01131 .17482 -6 -4.5 ]
[.01131 .17482 0 4.5 ]
[.01131 .25488 -18 -4.5 ]
[.01131 .25488 0 4.5 ]
[.01131 .33493 -6 -4.5 ]
[.01131 .33493 0 4.5 ]
[.01131 .41499 -18 -4.5 ]
[.01131 .41499 0 4.5 ]
[.01131 .49504 -6 -4.5 ]
[.01131 .49504 0 4.5 ]
[.01131 .5751 -18 -4.5 ]
[.01131 .5751 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.15986 .01472 m
.15986 .02097 L
s
[(80)] .15986 .00222 0 1 Mshowa
.29592 .01472 m
.29592 .02097 L
s
[(90)] .29592 .00222 0 1 Mshowa
.43197 .01472 m
.43197 .02097 L
s
[(100)] .43197 .00222 0 1 Mshowa
.56803 .01472 m
.56803 .02097 L
s
[(110)] .56803 .00222 0 1 Mshowa
.70408 .01472 m
.70408 .02097 L
s
[(120)] .70408 .00222 0 1 Mshowa
.84014 .01472 m
.84014 .02097 L
s
[(130)] .84014 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(140)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.05102 .01472 m
.05102 .01847 L
s
.07823 .01472 m
.07823 .01847 L
s
.10544 .01472 m
.10544 .01847 L
s
.13265 .01472 m
.13265 .01847 L
s
.18707 .01472 m
.18707 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.2415 .01472 m
.2415 .01847 L
s
.26871 .01472 m
.26871 .01847 L
s
.32313 .01472 m
.32313 .01847 L
s
.35034 .01472 m
.35034 .01847 L
s
.37755 .01472 m
.37755 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45918 .01472 m
.45918 .01847 L
s
.48639 .01472 m
.48639 .01847 L
s
.51361 .01472 m
.51361 .01847 L
s
.54082 .01472 m
.54082 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.62245 .01472 m
.62245 .01847 L
s
.64966 .01472 m
.64966 .01847 L
s
.67687 .01472 m
.67687 .01847 L
s
.73129 .01472 m
.73129 .01847 L
s
.7585 .01472 m
.7585 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.81293 .01472 m
.81293 .01847 L
s
.86735 .01472 m
.86735 .01847 L
s
.89456 .01472 m
.89456 .01847 L
s
.92177 .01472 m
.92177 .01847 L
s
.94898 .01472 m
.94898 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .09477 m
.03006 .09477 L
s
[(0.5)] .01131 .09477 1 0 Mshowa
.02381 .17482 m
.03006 .17482 L
s
[(1)] .01131 .17482 1 0 Mshowa
.02381 .25488 m
.03006 .25488 L
s
[(1.5)] .01131 .25488 1 0 Mshowa
.02381 .33493 m
.03006 .33493 L
s
[(2)] .01131 .33493 1 0 Mshowa
.02381 .41499 m
.03006 .41499 L
s
[(2.5)] .01131 .41499 1 0 Mshowa
.02381 .49504 m
.03006 .49504 L
s
[(3)] .01131 .49504 1 0 Mshowa
.02381 .5751 m
.03006 .5751 L
s
[(3.5)] .01131 .5751 1 0 Mshowa
.125 Mabswid
.02381 .03073 m
.02756 .03073 L
s
.02381 .04674 m
.02756 .04674 L
s
.02381 .06275 m
.02756 .06275 L
s
.02381 .07876 m
.02756 .07876 L
s
.02381 .11078 m
.02756 .11078 L
s
.02381 .12679 m
.02756 .12679 L
s
.02381 .1428 m
.02756 .1428 L
s
.02381 .15881 m
.02756 .15881 L
s
.02381 .19084 m
.02756 .19084 L
s
.02381 .20685 m
.02756 .20685 L
s
.02381 .22286 m
.02756 .22286 L
s
.02381 .23887 m
.02756 .23887 L
s
.02381 .27089 m
.02756 .27089 L
s
.02381 .2869 m
.02756 .2869 L
s
.02381 .30291 m
.02756 .30291 L
s
.02381 .31892 m
.02756 .31892 L
s
.02381 .35094 m
.02756 .35094 L
s
.02381 .36696 m
.02756 .36696 L
s
.02381 .38297 m
.02756 .38297 L
s
.02381 .39898 m
.02756 .39898 L
s
.02381 .431 m
.02756 .431 L
s
.02381 .44701 m
.02756 .44701 L
s
.02381 .46302 m
.02756 .46302 L
s
.02381 .47903 m
.02756 .47903 L
s
.02381 .51105 m
.02756 .51105 L
s
.02381 .52706 m
.02756 .52706 L
s
.02381 .54308 m
.02756 .54308 L
s
.02381 .55909 m
.02756 .55909 L
s
.02381 .59111 m
.02756 .59111 L
s
.02381 .60712 m
.02756 .60712 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.02381 .01473 m
.02846 .01473 L
.03279 .01473 L
.03754 .01474 L
.0389 .01474 L
.0402 .01474 L
.04136 .01474 L
.04262 .01474 L
.05205 .01477 L
.05706 .01478 L
.05982 .01479 L
.06118 .01479 L
.06244 .01479 L
.06311 .0148 L
.06382 .0148 L
.06531 .01481 L
.06794 .01483 L
.07308 .01487 L
.07888 .01491 L
.08173 .01493 L
.08298 .01494 L
.08364 .01494 L
.08435 .01495 L
.08563 .01497 L
.08683 .01499 L
.08945 .01504 L
.09496 .01513 L
.09963 .01521 L
.10458 .0153 L
.10579 .01533 L
.10709 .01535 L
.10784 .01538 L
.10852 .01541 L
.10986 .01547 L
.11475 .01568 L
.12004 .01589 L
.12582 .01615 L
.12827 .01625 L
.12892 .01628 L
.12962 .01631 L
.1309 .0164 L
.13219 .01652 L
.13337 .01664 L
.13562 .01687 L
.14594 .01782 L
.15061 .01828 L
.15185 .0184 L
.15319 .01853 L
.15446 .01869 L
.15563 .01893 L
Mistroke
.16037 .01992 L
.1647 .02071 L
.1747 .02267 L
.17608 .02295 L
.17681 .0231 L
.17758 .02325 L
.17825 .02339 L
.17899 .02366 L
.18029 .02418 L
.18534 .02622 L
.19623 .03009 L
.20653 .03518 L
.21656 .04154 L
.22096 .04448 L
.22582 .04777 L
.2305 .05195 L
.23488 .05716 L
.24449 .06662 L
.24926 .07182 L
.25185 .07465 L
.25312 .07603 L
.25426 .07728 L
.25553 .07948 L
.25689 .08194 L
.25975 .08713 L
.26478 .095 L
.28562 .13185 L
.30482 .17202 L
.34333 .28328 L
.38279 .40052 L
.42073 .50485 L
.44185 .55289 L
.45185 .56671 L
.45626 .57488 L
.45876 .57981 L
.46112 .58456 L
.46221 .58696 L
.46335 .58775 L
.4646 .58825 L
.46575 .58871 L
.46697 .58943 L
.4681 .59018 L
.46935 .59122 L
.47067 .5927 L
.47133 .59353 L
.47202 .59417 L
.47278 .59432 L
.47348 .59447 L
.47612 .59507 L
.48108 .59618 L
Mistroke
.48225 .59645 L
.4835 .59673 L
.48422 .59712 L
.48487 .59752 L
.48614 .59831 L
.48846 .59973 L
.49096 .60128 L
.49214 .60214 L
.49338 .60332 L
.49445 .60306 L
.49561 .60263 L
.49671 .60223 L
.49788 .60198 L
.49899 .60184 L
.5 .60181 L
.5012 .6019 L
.50232 .6022 L
.50354 .60205 L
.50484 .60079 L
.50942 .59634 L
.51955 .58752 L
.5291 .57983 L
.53328 .57648 L
.53443 .57581 L
.53565 .57439 L
.5368 .57209 L
.53785 .57001 L
.54242 .56092 L
.54723 .55134 L
.55734 .53313 L
.57562 .49662 L
.61562 .39567 L
.65411 .29595 L
.69505 .20223 L
.73447 .13312 L
.75429 .10752 L
.77238 .08596 L
.79184 .06915 L
.80269 .0606 L
.81274 .05355 L
.83178 .04374 L
.84247 .03885 L
.85252 .03476 L
.86241 .03158 L
.8731 .02895 L
.89172 .0246 L
.89633 .02367 L
.90126 .02289 L
.90667 .02223 L
.91171 .02162 L
Mistroke
.9328 .01917 L
.93775 .01866 L
.93896 .01854 L
.94025 .01845 L
.94167 .01837 L
.94301 .0183 L
.94877 .01798 L
.95409 .01768 L
.97423 .01661 L
.97619 .01652 L
Mfstroke
1 0 0 r
.02381 .01472 m
.03279 .01472 L
.03543 .01472 L
.03793 .01472 L
.03902 .01472 L
.04018 .01472 L
.04145 .01472 L
.04262 .01472 L
.04758 .01472 L
.05288 .01473 L
.05788 .01473 L
.06006 .01473 L
.06121 .01473 L
.06244 .01473 L
.06314 .01473 L
.06377 .01473 L
.065 .01474 L
.06743 .01474 L
.0728 .01475 L
.07785 .01476 L
.08006 .01476 L
.0825 .01477 L
.08316 .01477 L
.08387 .01477 L
.08515 .01477 L
.08591 .01478 L
.08662 .01478 L
.08796 .01479 L
.09387 .01483 L
.09896 .01486 L
.10166 .01487 L
.10458 .01488 L
.10585 .01489 L
.10654 .01489 L
.10718 .01489 L
.10831 .01491 L
.10956 .01493 L
.11423 .01501 L
.12449 .01517 L
.12669 .0152 L
.12784 .01521 L
.12907 .01522 L
.13014 .01523 L
.13132 .01527 L
.1334 .01536 L
.13838 .01558 L
.14291 .01577 L
.1454 .01587 L
.14812 .01598 L
.15069 .01605 L
Mistroke
.15192 .01608 L
.15307 .0161 L
.15421 .01614 L
.15543 .01626 L
.15757 .01649 L
.16236 .01699 L
.16717 .01745 L
.16982 .0177 L
.17232 .01792 L
.17528 .01812 L
.17668 .01819 L
.17798 .01826 L
.1792 .01847 L
.1805 .01877 L
.18325 .01939 L
.19356 .02157 L
.19602 .02207 L
.19861 .02248 L
.201 .02277 L
.20217 .02291 L
.20323 .02305 L
.20434 .02356 L
.20553 .0241 L
.20805 .02524 L
.21325 .02748 L
.21862 .02964 L
.2243 .03159 L
.22661 .03214 L
.2279 .03243 L
.22907 .03304 L
.22974 .03358 L
.23046 .03418 L
.23178 .03526 L
.23431 .03734 L
.24353 .04417 L
.26434 .06321 L
.27452 .07472 L
.27695 .07664 L
.27828 .07754 L
.27951 .07835 L
.28057 .07903 L
.2817 .08089 L
.28409 .08575 L
.28889 .0955 L
.29407 .10447 L
.2998 .11411 L
.30509 .12058 L
.30632 .12175 L
.30701 .1224 L
.30765 .12301 L
Mistroke
.30891 .12591 L
.31005 .12908 L
.31256 .13598 L
.31531 .14359 L
.32641 .16908 L
.34655 .2187 L
.38477 .32214 L
.42543 .41819 L
.43017 .43205 L
.43458 .44201 L
.43919 .45023 L
.44424 .45874 L
.44562 .46059 L
.44692 .46207 L
.44809 .46306 L
.44936 .46403 L
.45073 .46477 L
.45202 .4653 L
.45266 .46552 L
.45336 .46674 L
.45484 .4695 L
.4599 .47893 L
.46107 .48111 L
.46233 .48344 L
.46351 .48446 L
.46458 .48527 L
.46718 .48725 L
.47003 .48941 L
.47278 .4913 L
.47423 .49246 L
.47502 .49305 L
.47576 .4935 L
.47707 .49409 L
.47776 .49434 L
.47851 .49442 L
.47983 .49452 L
.48103 .49431 L
.48226 .49394 L
.48295 .49363 L
.48359 .49329 L
.48476 .49389 L
.48601 .49459 L
.48863 .49605 L
.49001 .49682 L
.49147 .49763 L
.49274 .49834 L
.49347 .49874 L
.49414 .49857 L
.49533 .49808 L
.4966 .49755 L
Mistroke
.50618 .49416 L
.50682 .49402 L
.50751 .49385 L
.50876 .4934 L
.51006 .49265 L
.51149 .49164 L
.5128 .49037 L
.51405 .48894 L
.51639 .48641 L
.52214 .4822 L
.52748 .47666 L
.53711 .46288 L
.54762 .44862 L
.55818 .42984 L
.56813 .40643 L
.58673 .37057 L
.62527 .28057 L
.66626 .18933 L
.68668 .1564 L
.69665 .13797 L
.70137 .12892 L
.70574 .12057 L
.70687 .11831 L
.70792 .11749 L
.70903 .11666 L
.71024 .11574 L
.71514 .11188 L
.71943 .10754 L
.72406 .10145 L
.73423 .088 L
.73919 .08132 L
.74135 .07841 L
.74249 .07687 L
.7437 .07533 L
.74494 .07474 L
.74608 .07419 L
.74832 .07312 L
.75326 .07054 L
.75584 .06884 L
.75825 .06684 L
.76373 .06221 L
.77455 .05301 L
.77713 .0508 L
.77855 .04958 L
.77988 .04844 L
.78113 .04743 L
.78183 .04724 L
.78248 .04706 L
.78483 .04642 L
.78945 .04508 L
Mistroke
.79453 .04315 L
.79967 .04064 L
.8051 .03799 L
.80967 .03574 L
.81463 .03329 L
.8169 .03217 L
.81814 .03155 L
.81931 .03099 L
.8203 .03084 L
.82137 .03069 L
.82364 .03036 L
.83386 .02849 L
.84318 .0261 L
.85318 .02352 L
.85592 .0228 L
.85742 .02242 L
.85816 .02222 L
.85884 .02213 L
.85948 .02209 L
.86016 .02204 L
.8616 .02194 L
.8641 .02177 L
.87366 .0209 L
.88417 .01961 L
.88984 .01891 L
.89521 .01825 L
.89755 .01796 L
.89873 .01785 L
.90003 .01781 L
.90276 .01773 L
.90528 .01765 L
.91011 .01748 L
.91532 .01722 L
.92476 .01672 L
.93474 .01618 L
.93747 .01603 L
.93819 .016 L
.93897 .01595 L
.93971 .01593 L
.94039 .01592 L
.94315 .01589 L
.94566 .01586 L
.94939 .01581 L
.95288 .01576 L
.95652 .01568 L
.96052 .01559 L
.97619 .01526 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo003oOolQ
Ool003Moo`03001oogoo009oo`03001oogoo01]oo`8000Aoo`03001oogoo01Qoo`D0009oo`03001o
ogoo009oo`03001oogoo01Ioo`X0009oo`03001oogoo01Ioo`D00004Ool000000003Ool00`00Oomo
o`0EOol500000goo00000004Ool00`00Oomoo`0FOol50002Ool30002Ool00`00Oomoo`03Ool003Io
o`03001oo`00009oo`03001oo`0001ioo`06001oogoo001oo`006goo00L007ooOomoo`00Ool00002
Ool00`00Ool0000IOol00`00Oomoo`02Ool01`00Oomoogoo001oo`0001Uoo`05001oogooOol00004
Ool00`00Ool0000HOol00`00Oomoo`03Ool01P00Oomoo`00Ool001Uoo`03001oogoo00=oo`06001o
ogoo001oo`0017oo000fOol00`00Ool00002Ool00`00Ool0000MOol20002Ool00`00Ool0000KOol0
1`00Oomoogoo001oo`00009oo`03001oo`0001Uoo`03001oogoo009oo`07001oogooOol007oo0000
6Goo00<007ooOol00Woo00L007ooOomoo`00Ool0000HOol00`00Oomoo`02Ool01`00Oomoogoo001o
o`0001Uoo`04001oogooOol4000017oo001oo`0017oo000gOol01`00Oomoogoo001oo`0001aoo`03
001oo`00009oo`03001oo`0001]oo`07001oogooOol007oo00000Woo00<007oo00006Goo00<007oo
Ool00Woo00L007ooOomoo`00Ool0000IOol00`00Oomoo`02Ool01`00Oomoogoo001oo`0001Qoo`03
001oogoo00=oo`06001oogoo001oo`006Goo00L007ooOomoo`00Ool00002Ool00`00Ool00004Ool0
03Ioo`03001oo`00009oo`03001oo`0001aoo`03001oo`00009oo`03001oo`0001]oo`07001oogoo
Ool007oo00000Woo00<007oo00006Goo00<007ooOol00Woo00L007ooOomoo`00Ool0000IOol01`00
Oomoogoo001oo`00009oo`03001oo`0001Qoo`07001oogooOol007oo00000Woo00<007oo00006Goo
00<007ooOol00Woo0P000Woo00<007oo000017oo000gOol00`00Oomoo`02Ool00`00Oomoo`0LOol2
0003Ool00`00Oomoo`0IOol20004Ool00`00Oomoo`02Ool00`00Oomoo`0GOol20003Ool20004Ool0
0`00Oomoo`0GOol20004Ool00`00Oomoo`02Ool00`00Oomoo`0FOol20004Ool00`00Oomoo`02Ool0
0`00Oomoo`0GOol20005Ool01@00Oomoogoo00001Goo003oOolQOol001Eoo`03001oogoo0?moo`Uo
o`005Goo00<007ooOol0ogoo2Goo000EOol00`00Oomoo`3oOol9Ool001Eoo`03001oogoo0?moo`Uo
o`003Woo1`009G`0c@0047`01P000goo000EOol00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomo
o`04Ool00`00Oomoo`04Ool00`0001l07`0501l8O006Ool00`00Oomoo`05Ool00`00Oomoo`04Ool0
0`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`05Ool0
0`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`04Ool0
0`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool0
0`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`05Ool0
0`00Oomoo`04Ool00`00Oomoo`04Ool01000Oomoogoo2g`0300O0goo00<007ooOol01goo000EOol0
0`00Oomoo`0ROol00`0001l07`0301l2Ool5O00GOol00`00Oomoo`0ROol00`00Oomoo`0ROol00`00
Oomoo`0QOol00`00Oomoo`0ROol00`00Ooml0008O004Ool701l?Ool00`00Oomoo`07Ool001Eoo`03
001oogoo02Qoo`807`Eoo`9l0:Qoo`9l00Yoo`<07b1oo`005Goo0P00:goo0`0O17oo0g`0Wgoo1W`0
1Goo1`0O8goo000EOol00`00Oomoo`0]Ool201l5Ool2O02LOol2O007Ool301lZOol001Eoo`03001o
ogoo02moo`807`Eoo`03O01oogoo09Ioo`=l00Moo`807beoo`005Goo00<007ooOol0<Goo00<07goo
Ool00goo00=l07ooOol0U7oo00=l07ooOol01goo00<07gooOol0;Goo000EOol00`00Oomoo`0bOol0
0`0OOomoo`03Ool00g`0Oomoo`2?Ool4O008Ool201l`Ool001Eoo`8003Aoo`807`Aoo`03O01oogoo
08aoo`9l00Uoo`<07c9oo`005Goo00<007ooOol0=Goo00<07gooOol00Woo0W`0Rgoo0W`027oo0P0O
=Goo000EOol00`00Oomoo`0fOol00`0OOomoo`03Ool00g`0Oomoo`27Ool00g`0Oomoo`07Ool00`0O
Oomoo`0eOol001Eoo`03001oogoo03Moo`0301moogoo00=oo`03O01oogoo08Eoo`03O01oogoo00Mo
o`0301moogoo03Ioo`005Goo0P00>7oo00<07gooOol017oo00=l07ooOol0Pgoo00=l07ooOol01goo
00<07gooOol0=goo000EOol00`00Oomoo`0hOol201l5Ool00g`0Oomoo`21Ool00g`0Oomoo`07Ool0
0`0OOomoo`0hOol001Eoo`03001oogoo03Yoo`0301moogoo009oo`03O01oogoo07moo`9l00Uoo`03
01moogoo03Uoo`005Goo00<007ooOol0>Woo0P0O17oo00=l07ooOol0O7oo0W`02Woo00<07gooOol0
>Woo000EOol2000lOol00`0OOomoo`03Ool2O01kOol2O009Ool201lmOol001Eoo`03001oogoo03ao
o`0301moogoo00=oo`03O01oogoo07Uoo`03O01oogoo00Moo`0301moogoo03eoo`001Goo00<007oo
Ool00Woo00<007ooOol00Woo00<007ooOol00goo00<007ooOol0?7oo00<07gooOol017oo00=l07oo
Ool0Mgoo00=l07ooOol01goo00<07gooOol0?Woo0004Ool00`00Ool00007Ool00`00Ool00004Ool0
0`00Oomoo`0mOol00`0OOomoo`03Ool00g`0Oomoo`1fOol00g`0Oomoo`07Ool00`0OOomoo`0oOol0
00Aoo`03001oo`0000Uoo`03001oogoo009oo`<003eoo`0301moogoo00Aoo`03O01oogoo07Aoo`03
O01oogoo00Moo`0301moogoo041oo`0017oo00<007oo00001goo0P001Goo00<007ooOol0?Woo00<0
7gooOol00goo00=l07ooOol0M7oo00=l07ooOol01goo00<07gooOol0@7oo0004Ool00`00Ool00007
Ool00`00Oomoo`04Ool00`00Oomoo`0oOol00`0OOomoo`03Ool00g`0Oomoo`1bOol00g`0Oomoo`07
Ool00`0OOomoo`11Ool000Eoo`03001oogoo00Ioo`<000Aoo`03001oogoo03moo`0301moogoo00Ao
o`03O01oogoo071oo`03O01oogoo00Moo`0301moogoo049oo`005Goo00<007ooOol0@7oo00<07goo
Ool00goo00=l07ooOol0Kgoo00=l07ooOol01goo00<07gooOol0@goo000EOol20011Ool00`0OOomo
o`04Ool00g`0Oomoo`1]Ool00g`0Oomoo`07Ool00`0OOomoo`14Ool001Eoo`03001oogoo045oo`03
01moogoo00=oo`9l06eoo`03O01oogoo00Moo`0301moogoo04Eoo`005Goo00<007ooOol0@Goo00<0
7gooOol01Goo00=l07ooOol0JGoo00=l07ooOol01goo00<07gooOol0AWoo000EOol00`00Oomoo`12
Ool00`0OOomoo`04Ool00g`0Oomoo`1XOol00g`0Oomoo`08Ool00`0OOomoo`16Ool001Eoo`8004=o
o`0301moogoo00Eoo`03O01oogoo06Moo`03O01oogoo00Moo`0301moogoo04Moo`005Goo00<007oo
Ool0@goo00<07gooOol017oo00=l07ooOol0IWoo00=l07ooOol01goo00<07gooOol0B7oo000EOol0
0`00Oomoo`14Ool00`0OOomoo`04Ool00g`0Oomoo`1UOol00g`0Oomoo`06Ool00`0OOomoo`19Ool0
01Eoo`03001oogoo04Aoo`0301moogoo00Aoo`03O01oogoo06Aoo`03O01oogoo00Ioo`0301moogoo
04Yoo`005Goo0P00AWoo00<07gooOol00goo00=l07ooOol0Hgoo00=l07ooOol01goo00<07gooOol0
BWoo000EOol00`00Oomoo`15Ool00`0OOomoo`03Ool00g`0Oomoo`1SOol00g`0Oomoo`06Ool00`0O
Oomoo`1;Ool001Eoo`03001oogoo04Ioo`0301moogoo009oo`03O01oogoo069oo`03O01oogoo00Mo
o`0301moogoo04]oo`005Goo00<007ooOol0AWoo00<07gooOol00goo00=l07ooOol0HGoo00=l07oo
Ool01Woo00<07gooOol0C7oo000EOol00`00Oomoo`17Ool00`0OOomoo`02Ool00g`0Oomoo`1POol0
0g`0Oomoo`07Ool00`0OOomoo`1<Ool001Eoo`8004Qoo`0301moogoo00=oo`03O01oogoo05ioo`03
O01oogoo00Moo`0301moogoo04eoo`005Goo00<007ooOol0B7oo00<07gooOol00Woo00=l07ooOol0
GWoo00=l07ooOol01goo00<07gooOol0CGoo000=Ool50003Ool00`00Oomoo`18Ool00`0OOomoo`03
Ool00g`0Oomoo`1LOol00g`0Oomoo`07Ool00`0OOomoo`1>Ool000moo`03001oogoo00=oo`03001o
ogoo04Uoo`0301moogoo009oo`03O01oogoo05aoo`03O01oogoo00Ioo`0301moogoo04moo`003goo
00<007ooOol00goo0`00BGoo00<07gooOol00Woo00=l07ooOol0Fgoo00=l07ooOol01goo00<07goo
Ool0Cgoo000?Ool00`00Oomoo`03Ool00`00Oomoo`1:Ool00`0OOomoo`02Ool00g`0Oomoo`1JOol0
0g`0Oomoo`06Ool00`0OOomoo`1@Ool000moo`03001oogoo00=oo`03001oogoo04Yoo`0301moogoo
009oo`03O01oogoo05Uoo`03O01oogoo00Moo`0301moogoo051oo`003Woo0P001Goo00<007ooOol0
BWoo00<07gooOol00goo00=l07ooOol0F7oo00=l07ooOol01Woo00<07gooOol0DGoo000EOol2001<
Ool00`0OOomoo`02Ool00g`0Oomoo`1GOol00g`0Oomoo`07Ool00`0OOomoo`1AOol001Eoo`03001o
ogoo04]oo`0301moogoo00=oo`03O01oogoo05Ioo`03O01oogoo00Ioo`0301moogoo059oo`005Goo
00<007ooOol0Bgoo00<07gooOol00goo00=l07ooOol0EGoo00=l07ooOol01goo00<07gooOol0DWoo
000EOol00`00Oomoo`1<Ool00`0OOomoo`03Ool00g`0Oomoo`1DOol00g`0Oomoo`06Ool00`0OOomo
o`1COol001Eoo`03001oogoo04aoo`0301moogoo00=oo`03O01oogoo05=oo`03O01oogoo00Moo`03
01moogoo05=oo`005Goo0P00CGoo00<07gooOol017oo00=l07ooOol0DWoo00=l07ooOol01Woo00<0
7gooOol0E7oo000EOol00`00Oomoo`1=Ool00`0OOomoo`03Ool00g`0Oomoo`1AOol00g`0Oomoo`07
Ool00`0OOomoo`1DOol001Eoo`03001oogoo04eoo`0301moogoo00Aoo`03O01oogoo051oo`03O01o
ogoo00Ioo`0301moogoo05Eoo`005Goo00<007ooOol0CGoo00<07gooOol017oo00=l07ooOol0Cgoo
00=l07ooOol01goo00<07gooOol0EGoo000EOol2001?Ool00`0OOomoo`03Ool00g`0Oomoo`1?Ool0
0g`0Oomoo`06Ool00`0OOomoo`1FOol001Eoo`03001oogoo04ioo`0301moogoo00Aoo`03O01oogoo
04ioo`03O01oogoo00Ioo`0301moogoo05Ioo`005Goo00<007ooOol0CWoo00<07gooOol017oo00=l
07ooOol0CGoo00=l07ooOol01goo00<07gooOol0EWoo000EOol00`00Oomoo`1?Ool00`0OOomoo`03
Ool00g`0Oomoo`1=Ool00g`0Oomoo`06Ool00`0OOomoo`1GOol001Eoo`80051oo`0301moogoo00Ao
o`03O01oogoo04]oo`03O01oogoo00Moo`0301moogoo05Moo`005Goo00<007ooOol0Cgoo00<07goo
Ool017oo00=l07ooOol0Bgoo00=l07ooOol01Woo00<07gooOol0F7oo000EOol00`00Oomoo`1@Ool0
0`0OOomoo`04Ool00g`0Oomoo`19Ool00g`0Oomoo`07Ool00`0OOomoo`1HOol000=oo`D0009oo`03
001oogoo009oo`03001oogoo00=oo`03001oogoo051oo`0301moogoo00Aoo`03O01oogoo04Uoo`03
O01oogoo00Moo`0301moogoo05Qoo`001Goo00<007ooOol01Woo00<007oo000017oo00<007ooOol0
D7oo00<07gooOol017oo00=l07ooOol0BGoo00=l07ooOol01Woo00<07gooOol0FGoo0005Ool00`00
Oomoo`08Ool00`00Oomoo`02Ool3001AOol00`0OOomoo`04Ool00g`0Oomoo`17Ool00g`0Oomoo`07
Ool00`0OOomoo`1IOol000Eoo`03001oogoo00Ioo`8000Eoo`03001oogoo055oo`0301moogoo00Ao
o`03O01oogoo04Moo`03O01oogoo00Ioo`0301moogoo05Yoo`001Goo00<007ooOol01Woo00<007oo
Ool017oo00<007ooOol0DGoo00<07gooOol017oo00=l07ooOol0AWoo00=l07ooOol01goo00<07goo
Ool0FWoo0004Ool20008Ool30004Ool00`00Oomoo`1BOol00`0OOomoo`04Ool00g`0Oomoo`15Ool0
0g`0Oomoo`06Ool00`0OOomoo`1KOol001Eoo`8005=oo`0301moogoo00Aoo`03O01oogoo04Aoo`03
O01oogoo00Moo`0301moogoo05]oo`005Goo00<007ooOol0DWoo00<07gooOol017oo00=l07ooOol0
A7oo00=l07ooOol01goo00<07gooOol0Fgoo000EOol00`00Oomoo`1COol00`0OOomoo`04Ool00g`0
Oomoo`12Ool00g`0Oomoo`07Ool00`0OOomoo`1LOol001Eoo`03001oogoo05=oo`0301moogoo00Ao
o`03O01oogoo049oo`03O01oogoo00Moo`0301moogoo05aoo`005Goo0P00E7oo00<07gooOol017oo
00=l07ooOol0@Woo00=l07ooOol01Woo00<07gooOol0GGoo000EOol00`00Oomoo`1DOol00`0OOomo
o`04Ool00g`0Oomoo`10Ool00g`0Oomoo`07Ool00`0OOomoo`1MOol001Eoo`03001oogoo05Aoo`03
01moogoo00Aoo`03O01oogoo041oo`03O01oogoo00Ioo`0301moogoo05ioo`005Goo00<007ooOol0
E7oo00<07gooOol01Goo00=l07ooOol0?Woo00=l07ooOol01goo00<07gooOol0GWoo000EOol00`00
Oomoo`1EOol00`0OOomoo`04Ool00g`0Oomoo`0nOol00g`0Oomoo`07Ool00`0OOomoo`1NOol001Eo
o`8005Ioo`0301moogoo00Aoo`03O01oogoo03ioo`03O01oogoo00Ioo`0301moogoo05moo`005Goo
00<007ooOol0EGoo00<07gooOol01Goo00=l07ooOol0?7oo00=l07ooOol01goo00<07gooOol0Ggoo
000EOol00`00Oomoo`1FOol00`0OOomoo`04Ool00g`0Oomoo`0lOol00g`0Oomoo`06Ool00`0OOomo
o`1POol001Eoo`03001oogoo05Ioo`0301moogoo00Aoo`03O01oogoo03]oo`03O01oogoo00Moo`03
01moogoo061oo`005Goo0P00Egoo00<07gooOol01Goo00=l07ooOol0>Woo00=l07ooOol01goo00<0
7gooOol0H7oo000EOol00`00Oomoo`1GOol00`0OOomoo`04Ool00g`0Oomoo`0iOol00g`0Oomoo`07
Ool00`0OOomoo`1QOol000ioo`<000Aoo`03001oogoo05Moo`0301moogoo00Aoo`03O01oogoo03Uo
o`03O01oogoo00Moo`0301moogoo065oo`003Woo00<007ooOol017oo00<007ooOol0Egoo00<07goo
Ool01Goo00=l07ooOol0>7oo00=l07ooOol01Woo00<07gooOol0HWoo000?Ool00`00Oomoo`03Ool3
001HOol00`0OOomoo`04Ool00g`0Oomoo`0gOol00g`0Oomoo`07Ool00`0OOomoo`1ROol000moo`03
001oogoo00=oo`03001oogoo05Qoo`0301moogoo00Eoo`03O01oogoo03Ioo`03O01oogoo00Moo`03
01moogoo069oo`003Woo00<007oo000017oo00<007ooOol0FGoo00<07gooOol017oo00=l07ooOol0
=Goo00=l07ooOol01goo00<07gooOol0Hgoo000?Ool00`00Oomoo`03Ool00`00Oomoo`1IOol00`0O
Oomoo`05Ool00g`0Oomoo`0dOol00g`0Oomoo`07Ool00`0OOomoo`1SOol001Eoo`03001oogoo05Uo
o`0301moogoo00Eoo`03O01oogoo03Aoo`03O01oogoo00Ioo`0301moogoo06Aoo`005Goo0P00Fgoo
00<07gooOol017oo00=l07ooOol0<goo00=l07ooOol01goo00<07gooOol0I7oo000EOol00`00Oomo
o`1JOol00`0OOomoo`05Ool00g`0Oomoo`0bOol00g`0Oomoo`06Ool00`0OOomoo`1UOol001Eoo`03
001oogoo05Yoo`0301moogoo00Eoo`03O01oogoo035oo`03O01oogoo00Moo`0301moogoo06Eoo`00
5Goo00<007ooOol0Fgoo00<07gooOol01Goo00=l07ooOol0<7oo00=l07ooOol01goo00<07gooOol0
IGoo000EOol2001LOol00`0OOomoo`05Ool00g`0Oomoo`0_Ool00g`0Oomoo`07Ool00`0OOomoo`1V
Ool001Eoo`03001oogoo05]oo`0301moogoo00Ioo`03O01oogoo02ioo`03O01oogoo00Moo`0301mo
ogoo06Ioo`005Goo00<007ooOol0G7oo00<07gooOol01Goo00=l07ooOol0;Goo00=l07ooOol01goo
00<07gooOol0Igoo000EOol00`00Oomoo`1LOol00`0OOomoo`05Ool00g`0Oomoo`0]Ool00g`0Oomo
o`07Ool00`0OOomoo`1WOol001Eoo`8005eoo`0301moogoo00Ioo`03O01oogoo02]oo`03O01oogoo
00Qoo`0301moogoo06Moo`005Goo00<007ooOol0GGoo00<07gooOol01Goo00=l07ooOol0:goo00=l
07ooOol01goo00<07gooOol0J7oo000EOol00`00Oomoo`1MOol00`0OOomoo`06Ool00g`0Oomoo`0Y
Ool00g`0Oomoo`08Ool00`0OOomoo`1XOol001Eoo`03001oogoo05eoo`0301moogoo00Ioo`03O01o
ogoo02Uoo`03O01oogoo00Moo`0301moogoo06Uoo`005Goo0P00Ggoo00<07gooOol01Goo00=l07oo
Ool0:7oo00=l07ooOol027oo00<07gooOol0JGoo000EOol00`00Oomoo`1NOol00`0OOomoo`06Ool0
0g`0Oomoo`0WOol00g`0Oomoo`08Ool00`0OOomoo`1YOol001Eoo`03001oogoo05ioo`0301moogoo
00Ioo`03O01oogoo02Ioo`03O01oogoo00Qoo`0301moogoo06Yoo`0017oo0`000goo00<007ooOol0
0Woo00<007ooOol00goo00<007ooOol0Ggoo00<07gooOol01Woo00=l07ooOol09Goo00=l07ooOol0
27oo00<07gooOol0JWoo0004Ool00`00Oomoo`07Ool00`00Ool00004Ool00`00Oomoo`1OOol00`0O
Oomoo`06Ool00g`0Oomoo`0TOol00g`0Oomoo`09Ool00`0OOomoo`1ZOol000Eoo`03001oogoo00Qo
o`03001oogoo009oo`<005moo`0301moogoo00Moo`03O01oogoo02=oo`03O01oogoo00Qoo`0301mo
ogoo06]oo`001Goo00<007ooOol01Woo0P001Goo00<007ooOol0H7oo00<07gooOol01Woo00=l07oo
Ool08Woo00=l07ooOol02Goo00<07gooOol0Jgoo0004Ool00`00Ool00007Ool00`00Oomoo`04Ool0
0`00Oomoo`1POol00`0OOomoo`06Ool00g`0Oomoo`0ROol00g`0Oomoo`08Ool00`0OOomoo`1/Ool0
00Eoo`03001oogoo00Ioo`<000Aoo`03001oogoo065oo`0301moogoo00Ioo`03O01oogoo021oo`03
O01oogoo00Uoo`0301moogoo06aoo`005Goo0P00HWoo00<07gooOol01Woo00=l07ooOol087oo00=l
07ooOol02Goo00<07gooOol0K7oo000EOol00`00Oomoo`1QOol00`0OOomoo`07Ool00g`0Oomoo`0N
Ool00g`0Oomoo`09Ool00`0OOomoo`1]Ool001Eoo`03001oogoo069oo`0301moogoo00Ioo`03O01o
ogoo01ioo`03O01oogoo00Uoo`0301moogoo06eoo`005Goo00<007ooOol0HWoo00<07gooOol01goo
00=l07ooOol077oo00=l07ooOol02Woo00<07gooOol0KGoo000EOol2001SOol00`0OOomoo`08Ool0
0g`0Oomoo`0KOol00g`0Oomoo`09Ool00`0OOomoo`1^Ool001Eoo`03001oogoo06=oo`0301moogoo
00Moo`03O01oogoo01Yoo`03O01oogoo00Yoo`0301moogoo06ioo`005Goo00<007ooOol0Hgoo00<0
7gooOol01goo00=l07ooOol06Goo00=l07ooOol02Woo00<07gooOol0Kgoo000EOol00`00Oomoo`1S
Ool00`0OOomoo`08Ool00g`0Oomoo`0HOol00g`0Oomoo`0:Ool00`0OOomoo`1_Ool001Eoo`03001o
ogoo06Aoo`0301moogoo00Moo`9l01Qoo`03O01oogoo00]oo`0301moogoo06moo`005Goo0P00IGoo
00<07gooOol027oo0W`05Woo00=l07ooOol02goo00<07gooOol0L7oo000EOol00`00Oomoo`1TOol0
0`0OOomoo`0:Ool00g`0Oomoo`0BOol00g`0Oomoo`0<Ool00`0OOomoo`1`Ool001Eoo`03001oogoo
06Eoo`0301moogoo00Uoo`03O01oogoo019oo`03O01oogoo00aoo`0301moogoo071oo`005Goo00<0
07ooOol0IGoo00<07gooOol02Woo00=l07ooOol047oo00=l07ooOol037oo00<07gooOol0LGoo000E
Ool2001WOol00`0OOomoo`09Ool00g`0Oomoo`0?Ool00g`0Oomoo`0=Ool00`0OOomoo`1aOol001Eo
o`03001oogoo06Ioo`0301moogoo00Yoo`03O01oogoo00eoo`03O01oogoo00eoo`0301moogoo079o
o`003Woo0P001Goo00<007ooOol0IWoo00<07gooOol02Woo0W`03Goo00=l07ooOol03Woo00<07goo
Ool0LWoo000@Ool00`00Oomoo`02Ool00`00Oomoo`1WOol00`0OOomoo`0;Ool2O009Ool2O00AOol0
0`0OOomoo`1bOol000moo`03001oogoo00=oo`<006Moo`0301moogoo00aoo`Al00Aoo`=l015oo`03
01moogoo07=oo`0047oo00<007ooOol00Woo00<007ooOol0Igoo00<07gooOol047oo17`057oo00<0
7gooOol0Lgoo000>Ool00`00Ool00004Ool00`00Oomoo`1XOol00`0OOomoo`0WOol00`0OOomoo`1c
Ool000moo`03001oogoo00=oo`03001oogoo06Qoo`0301moogoo02Ioo`0301moogoo07Aoo`005Goo
00<007ooOol0J7oo00<07gooOol09Woo00<07gooOol0M7oo000EOol2001ZOol00`0OOomoo`0TOol0
0`0OOomoo`1eOol001Eoo`03001oogoo06Uoo`0301moogoo02Aoo`0301moogoo07Eoo`005Goo00<0
07ooOol0JWoo00<07gooOol08Woo00<07gooOol0MWoo000EOol00`00Oomoo`1ZOol00`0OOomoo`0R
Ool00`0OOomoo`1fOol001Eoo`8006aoo`0301moogoo021oo`0301moogoo07Moo`005Goo00<007oo
Ool0Jgoo00<07gooOol087oo00<07gooOol0Mgoo000EOol00`00Oomoo`1/Ool00`0OOomoo`0NOol0
0`0OOomoo`1hOol001Eoo`03001oogoo06aoo`0301moogoo01eoo`0301moogoo07Uoo`005Goo0P00
KWoo00<07gooOol077oo00<07gooOol0NGoo000EOol00`00Oomoo`1]Ool00`0OOomoo`0KOol00`0O
Oomoo`1jOol001Eoo`03001oogoo06ioo`0301moogoo01Yoo`0301moogoo07Yoo`005Goo00<007oo
Ool0KWoo00<07gooOol06Goo00<07gooOol0Ngoo000EOol00`00Oomoo`1_Ool00`0OOomoo`0HOol0
0`0OOomoo`1kOol001Eoo`80071oo`0301moogoo01Moo`0301moogoo07aoo`005Goo00<007ooOol0
L7oo00<07gooOol05Goo00<07gooOol0OGoo0004Ool20004Ool00`00Oomoo`02Ool00`00Oomoo`03
Ool00`00Oomoo`1`Ool00`0OOomoo`0EOol00`0OOomoo`1mOol000Ioo`03001oogoo00Eoo`03001o
o`0000Aoo`03001oogoo075oo`0301moogoo01=oo`0301moogoo07ioo`001Goo00<007ooOol027oo
00<007ooOol00Woo0`00LGoo00<07gooOol04Woo0P0OP7oo0006Ool00`00Oomoo`05Ool20005Ool0
0`00Oomoo`1bOol00`0OOomoo`0@Ool00`0OOomoo`20Ool000Aoo`03001oo`0000Moo`03001oogoo
00Aoo`03001oogoo07=oo`0301moogoo00eoo`807h=oo`001Goo00<007ooOol01Woo0`0017oo00<0
07ooOol0Lgoo0P0O3Goo00<07gooOol0Pgoo000EOol2001eOol201l;Ool00`0OOomoo`24Ool001Eo
o`03001oogoo07Eoo`<07`Uoo`0301moogoo08Aoo`005Goo00<007ooOol0N7oo0P0O1Goo0P0OQgoo
000EOol00`00Oomoo`1jOol501n9Ool001Eoo`03001oogoo07]oo`0301moogoo08Yoo`005Goo0P00
ogoo2Woo000EOol00`00Oomoo`3oOol9Ool001Eoo`03001oogoo0?moo`Uoo`00ogoo8Goo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {64.1714, -0.309837, 
  0.272768, 0.0231787}}]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 1280}, {0, 958}},
WindowSize->{722, 722},
WindowMargins->{{20, Automatic}, {Automatic, 22}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 57, 1, 30, "Input"],
Cell[1769, 52, 127, 2, 90, "Input"],
Cell[1899, 56, 99, 2, 30, "Input"],
Cell[2001, 60, 133, 2, 70, "Input"],
Cell[2137, 64, 91, 1, 50, "Input"],
Cell[2231, 67, 291, 5, 90, "Input"],
Cell[2525, 74, 388, 8, 90, "Input"],

Cell[CellGroupData[{
Cell[2938, 86, 151, 2, 50, "Input"],
Cell[3092, 90, 35288, 1313, 186, 16316, 1074, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]],
Cell[38395, 1406, 206, 4, 50, "Input"],

Cell[CellGroupData[{
Cell[38626, 1414, 112, 2, 30, "Input"],
Cell[38741, 1418, 26745, 926, 186, 10794, 725, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

