//

//   12/5/98 Robert Buff

//



#if ! defined(_MTG_MINIMIZER_)

#define _MTG_MINIMIZER_





//

//   t M t g M i n i m i z e r

//



class tMtgMinimizer {



        // This minimizer is based on BFGS.



        // Numerical tolerance. Default: 1e-6.



    double m_gTolerance;



        // Print progress report while optimizing?

        // Default: on for Debug, off for Release.



    bool m_bVerbose;



        // The result is put here:



    double m_gResult;



protected:



        // eval() must take Lambda as input and compute

        // gValue and Gradient. If anything goes wrong,

        // this function must terminate with an exception.



    virtual void eval( int nDim, const double Lambda[],

        double& gValue, double Gradient[] ) = 0;



public:



    tMtgMinimizer();



    void setTolerance( double gTolerance = 1e-6 );

    void setVerbose( bool bVerbose = true );



        // minimize() takes LoBound and HiBound as input and

        // computes Lambda, Gradient and gValue.



    void minimize( int nDim, const double LoBound[], const double HiBound[],

        double Lambda[], double Gradient[] );



    void minimize( int nDim, double gLoBound, double gHiBound,

        double Lambda[], double Gradient[] );



    void minimize( int nDim, const double LoBound[], const double HiBound[],

        double Lambda[] );



    void minimize( int nDim, double gLoBound, double gHiBound,

        double Lambda[] );



        // The result itself is often uninteresting.

        // For that reason, it must be retrieved explicitely:



    double result() const {

        return m_gResult;

    }

};



#endif

