C
C      FLOW AROUND ELLIPTICS      
C      -----------------------------------------------------
C OUTPUT:
C   NXT:    Number of x stations
C   KASE:   = 1, 2-D flow
C           = 2, axisymmetric flow
C   KDIS:   = 1, input s (surface distance)
C             otherwise, input x,y coordinates
C   UREF    Reference velocity
C   BIGL    Reference length, L
C   CNU     Kinematic viscosity
C   X(I)    x/L
C   UE(I)   ue/UREF, ue is the external velocity
C   R(I)    y/L for 2-D flow or r/L for axisymmetric flow
C   S(I)    s/L
C Output
C ===================================================
      DIMENSION S(300),X(300),Y(300),UE(300), THETA(300)
      CHARACTER*80 output_name
      WRITE(6,*) "Enter output file name"
      READ(5,*) output_name
      OPEN(unit=6,file=output_name)                                                  
      NXT = 100
      DX = 2.0*asin(1.0)/NXT
      UREF = 0.8*1000
      t = 1.0/4.0
      KASE = 1.0
      CNU = 1.6e-4
      BIGL = 2.0
      NXT = NXT+1
      DO I =1, NXT
         THETA(I) = 2.0*asin(1.0) - (I-1)*DX
         X(I)     = 1.0 + cos(THETA(I))
         Y(I)     = 0.25 * sin(THETA(I))
         beta     = atan(-t/tan(THETA(I)))
         UE(I)    = UREF*(1+t)*cos(beta) 
      ENDDO
      WRITE(6,8000) NXT,KASE,KDIS,UREF,BIGL,CNU
      WRITE(6,8100) (X(I)/BIGL,Y(I)/BIGL,UE(I)/UREF,I=1,NXT)
      
      WRITE( 6,*)
      WRITE( 6,*)
      WRITE( 6,*)
      WRITE( 6,*) "-----------Data Explanation--see p. 80-------"
      WRITE( 6,*) "NXT,KASE,KDIS,UREF,BIGL,CNU"
      WRITE( 6,*) "X(1),  R(1),   UE(1) "
      WRITE( 6,*) "      ."
      WRITE( 6,*) "      ."
      WRITE( 6,*) "      ."
      WRITE( 6,*) "X(NXT),R(NXT),UE(NXT)"


      open(88,file='elliptic.iqwik',form='unformatted')
      iqwik  = 88
      write(iqwik) ' X      ',NXT,(X(I),  I=1,NXT)
      write(iqwik) ' Y      ',NXT,(Y(I),  I=1,NXT)
      write(iqwik) ' Ue     ',NXT,(UE(I), I=1,NXT)
      write(iqwik) ' THETA  ',NXT,(THETA(I), I=1,NXT)

      STOP
C -------------------------------------------------------------------
 8000  FORMAT(3(I3,1X), 3(F10.5,1X))
 8100  FORMAT(3F15.5)
       END

