      PROGRAM transition
C***********************************************************************
C  This program determines the transition location with Michel method (p. 177)
C  with boundary-layer parameters determined from Thwaites' method
C  And also, if needed, compute the initial values for Head's method
C
C  find out the transition point output (RS, RTHETA)
C
C  Input:   the result from Thwaites computation
C  Output:  
C 
C
      INTEGER NXT, KASE, ITRANSITION
      real*4  UREF,BIGL,CNU
      real*4  RS(200), RTHETA(200), tmp(200),THETA(200)
      real*4  distance, temp
      real*4  X(200), R(200), UE(200), S(200)
      CHARACTER*160 ACARD
      CHARACTER*80 input_name, output_name,thwaites_out

C **  INPUT
C     WRITE(6,*) "Enter boundary-layer methods"
C     WRITE(6,*) "   0  differential method"
C     WRITE(6,*) "   1  integral method"
C     READ(5, *) IMETHOD
      IMETHOD = 1

      IF ( IMETHOD .EQ. 0 ) THEN
         WRITE(6,*) "Enter file name of blp2d output"
         READ(5,*) input_name
	   OPEN(unit=55,file=input_name,STATUS="OLD")
	   IFLAG = 0
	   K = 0
 72	   READ(55,'(A160)',ERR=51,END=51) ACARD
	   IF ( (ACARD(1:23) .EQ. "  I      S           RS") .AND. 
     *       (IFLAG .EQ. 0)) THEN
	       IFLAG = 1
	       GOTO 72
         ENDIF
	   IF (IFLAG .EQ. 1 ) THEN
	     IF (ACARD(1:20) .EQ. "                    ") GOTO 51
	     K = K + 1
C	     READ(ACARD,77) NX,XC,S(K),UE(K),VW,CF,DLS,THETA(K)
C 77       FORMAT(I5,2F8.4,5E11.4)
C	     RS(K) = UE(K) * S(K) /CNU
C          RTHETA(K) = UE(K) * THETA(K) /CNU

           READ(ACARD,77) NX,S(K),RS(K),UE(K),DLS,THETA(K)

     *                      ,VW,CF,RTHETA(K)

 77        FORMAT(I3,8E12.4)
           ISEPARATION = K
           GOTO 72
	   ELSE
	     GOTO 72
	   ENDIF
 51      CLOSE(55)
         NXT = ISEPARATION + 1
         ITRANSPOSITION = 0  
      ELSE
	   WRITE(6,*) "Enter file name of Thwaites' output"
	   READ(5,*) thwaites_out

	   OPEN(unit=55,file=thwaites_out,STATUS="OLD")
         READ(55,9000) NXT,KASE,UREF,BIGL,CNU
         READ (55, * ) 
         K = 0
 10      READ(55,'(A160)',ERR=20,END=20) ACARD
         IF (ACARD(1:5) .EQ. ' FLOW' ) THEN
            ISEPARATION = K
            GO TO 20
         ELSE
            K = K+1
       READ(ACARD, 9300)I,XX,SS,RS(K),UE(K),DELS,THETA(K),H,CF,RTHETA(K)
            GOTO 10
         ENDIF 
 20      CONTINUE
	   CLOSE(55)

	   WRITE(6,*) "Enter file name of corresponding Thwaites' input"
	   READ(5,*) input_name

	   OPEN(unit=33,file=input_name,STATUS="OLD")
         rewind 33
         read(33,*) NXT,KASE,KDIS,UREF,BIGL,CNU
C     print*, "NXT=",NXT
         DO I = 1, NXT
            read(33, *) X(I),R(I),UE(I)
         ENDDO
         CLOSE(33)
 111     FORMAT(3I3,3F10.5) 

         IF (KDIS .EQ. 1) GO TO 123
         S(1) = 0.0
         DO I = 2, NXT
           S(I) = S(I-1)+SQRT((X(I)-X(I-1))**2+(R(I)-R(I-1))**2)
         ENDDO

C        print*, "S =", (S(I), I=1, NXT)
         GOTO 234
 123     DO I = 1, NXT
            S(I) = X(I)
         ENDDO

 234  WRITE(6,*) "Specify transition station by entering any integer ",
     *   "other than 0 or ",
     *   "Enter 0 for calculating transition with Michel's  Method"
 235	   READ(5,*) ITRANSPOSITION

 	   IF ( ITRANSPOSITION .GT. ISEPARATION) THEN
	   WRITE(6,*) "Flow has already separated before the specified ",
     *              "transition location"
	     GOTO 234 
	   ENDIF
      ENDIF
C============================================

	IF ( ITRANSPOSITION .LE. 0 ) THEN
C  Use Michel method to compute transition location
         ITRANSITION = 2 
         tmp(2) =  1.174*(1.0 + 22400.0/RS(2))*RS(2)**(0.46)
         tmp(1) = tmp(2)
         DO I = 3, ISEPARATION
            tmp(I) = 1.174*(1.0 + 22400.0/RS(I))*RS(I)**(0.46)
         ENDDO

C      OPEN(66, file='trans.xq', form='unformated')
c      rewind 66
c     WRITE(66) "Rx      ",NXT-1,(RS(I), I=2,NXT)
c      WRITE(66) "RTHETA  ",NXT-1,(RTHETA(I),I=2,NXT)
c      WRITE(66) "F6_4_1  ",NXT-1,(tmp(I),I=2,NXT)
c      CLOSE(66)
      
         distance = RTHETA(2) - tmp(2)
         DO I = 3, ISEPARATION
            temp = RTHETA(I) - tmp(I)
            tmp(I) = temp
            if ( temp * distance .le. 0 ) then
              go to 555
            endif
            if ( abs(temp) .lt. abs(distance))then
              istance = temp
              ITRANSITION = I
            endif 
          ENDDO

          IF ( ISEPARATION .lt. NXT ) THEN
             ITRANSITION = ISEPARATION 
             GOTO 555
          ENDIF
          go to 333

 555      IF ( IMETHOD .EQ. 0    ) THEN

             WRITE(6,991) ITRANSITION-1, S(ITRANSITION-1)

          ELSE

          WRITE(6,999) ITRANSITION-1, S(ITRANSITION-1), X(ITRANSITION-1)

	    ENDIF

 991      FORMAT("Michel's method finds transition point at ",I4,

     *           " (S/C)tr = ", F10.5)
 999      FORMAT("Michel's method finds transition point at ",I4, /,
     *           " (S/C)tr = ", F10.5, " (X/C)tr=", F10.5)
      ELSE
C  User specified transition position
	  ITRANSITION = ITRANSPOSITION + 1    
      ENDIF
      
	IF (IMETHOD .NE. 0 ) THEN
         RL = UREF*BIGL/CNU
         T1 = THETA(ITRANSITION-1)
         H1 = 1.4
	   WRITE(6,*) "Assign a file name for Head's input data"
	   READ(5, *) output_name
	   WRITE(6,*)"==========================================="
	WRITE(6,*) "Generating Head's input file ", output_name," with"
	WRITE(6,*) "NXT      RL        T1          H1 "
	   WRITE(6,22) NXT-ITRANSITION+2,RL,T1,H1
C generate Head's input file
         OPEN(55, file = output_name)
         rewind 55
         WRITE(55,22) NXT-ITRANSITION+2,RL,T1,H1, ITRANSITION-1 
         WRITE(55,34) (S(I),  I=ITRANSITION-1, NXT)
         WRITE(55,34) (UE(I), I=ITRANSITION-1,NXT)

	   WRITE(55,34) (X(I), I=ITRANSITION-1,NXT)
         WRITE(55,*)" "
	   WRITE(55,*)" "
	   WRITE(55,*)" "
	   WRITE(55,*)"==========================================="
	   WRITE(55,*) "NXT      RL        T1        H1        Itrans" 
	   WRITE(55,*) "S(1) ... S(NXT)"
	   WRITE(55,*) "UE(1) ... UE(NXT)" 

	   WRITE(55,*) "X(1) ... X(NXT)"   
         CLOSE(55)

C Overwrite thwaites output file so that results before transition are shown

         OPEN(55, file=thwaites_out)

	   REWIND 55

  717	   READ(55,'(A160)',ERR=132,END=132) ACARD

         IF ( ACARD(1:12) .EQ."   I     X/C") THEN

	      DO I = 1, ITRANSITION-2

	         READ(55,*)

		  ENDDO

		  DO I = ITRANSITION-1, NXT

		     WRITE(55,*)

		  ENDDO

		  GOTO 132

	    ELSE

		   GOTO 717

		ENDIF   

  132     CLOSE(55)

C================================================

 22      FORMAT(I5,1X,F10.1,1X, E12.4,1X, F10.5, 1X, I5)
 34      FORMAT(6(F10.5,1X))

      
 9000    FORMAT(1H ,5HNXT =,I3,14X,5HKASE=,I3/1H ,5HUREF=,E14.6,3X,
     1        5HBIGL=,E14.6,3X,5HNU  =,E14.6/)
 9300    FORMAT(1H ,I3,9E12.4)
      WRITE(6,*)"Hit any key to end this application and you are ready",
     *  " to run Head's method with generated input file",output_name
	ELSE
	  WRITE(6,*)"Change xctr in blp2d input data."
	  WRITE(6,*)"Hit any key to close this window"
	ENDIF
	READ(5,*)
	
 333  STOP
      END
