C     EXAMPLE 9.1
      IMPLICIT REAL*8 (A-H,O-Z)
      PARAMETER (NY_MAX = 10000)
      REAL*8 T0(NY_MAX)
      REAL*8 T1(NY_MAX)
      CHARACTER*80 input_name, output_name

      WRITE(6,*) "Enter input file name (include extension name)"
      READ(5,*) input_name
      WRITE(6,*) "Enter output file name"
      READ(5,*) output_name
      OPEN(unit=5,file=input_name,STATUS="OLD")
      OPEN(unit=6,file=output_name)
	  
	READ(5,*)
	READ(5,*) NY, NX, IY   
C      NY = 11
C      NX = 1000
      ifactor = 2
      if (NX .ge. 500) ifactor=5

      DX = 1.0d0/NX
      DY = 1.0d0/(NY-1.0d0)
      ALPHA = 1.0d0
      RAT   = ALPHA * DX/DY/DY
      WRITE(6, 1001) NY, DY, NX, DX, RAT
1001  FORMAT("NY =", I5, "   DY = ", F6.4, /
     *       "NX =", I6,  "  DX = ", F6.4, "  Ratio=", F6.4)
      XFINAL = 1.0d0
      X_print = DX
C Initial condition
      DO I = 2, NY-1
        Y = (I-1)*DY
        T0(I) = DI_CON(Y)
      ENDDO
      T0(1) = B_CON(0.D0, 0.0D0)
      T0(NY) = B_CON(1.D0, 0.0D0)
      
100   CX = CX + DX
      DO I = 2, NY-1
         T1(I) = T0(I) + RAT * (T0(I+1) - 2.0 * T0(I) + T0(I-1) )
      ENDDO
      T1(1) = B_CON(0.D0, CX)
      T1(NY) = B_CON(1.D0, CX)

C PRINT OUT RESULTS
      
      IF ( CX .eq. DX ) THEN
         WRITE(6, *)  
	   if ( IY .GE. 0 ) THEN
            WRITE(6, 33) (IY-1.d0) * DY 
33          FORMAT(" At Y = ", F6.4)
         
            WRITE(6, *) "  X         FDS         AS",
     *               "          Diff       %Error"
	   else
	      write(6,*) "   X        Y=0.1     Y=0.2      "
     *		  ,"Y=0.3      Y=0.4      Y=0.5       Y=0.6"
	   endif
      ENDIF
      IF (dabs(CX -  X_print) .le. 0.00001d0 ) THEN 
         if ( IY .GE. 0 ) THEN
	      T_A = TANALYTICAL((IY-1.0D0)*DY, CX)
            T_ERROR = T1(IY)-T_A
            WRITE(6, 1000)  CX, T1(IY), T_A, T_ERROR, T_ERROR/T_A
	   else
	      WRITE(6, 2000)  CX, (T1(III),  III=2,7)
2000        FORMAT(f5.3, 6(" ", F11.4 ) )
	   endif
         if ( dabs(X_print - DX).le. 0.00001d0 )  then
	      X_print = ifactor*DX
	   else
            X_print = X_print + ifactor*DX
	   endif 
      ENDIF

C SWAPE T0 and T1
      DO I = 1, NY
         T0(I) = T1(I)
      ENDDO

      IF ( CX .lt.  XFINAL ) GO TO 100
1000  FORMAT(f5.3, 4("   ", F9.4 ) )     
      STOP
      END

      REAL*8 FUNCTION B_CON(Y, X)
      IMPLICIT REAL*8 (A-H,O-Z)
      B_CON = 0.0
      RETURN
      END

      REAL*8 FUNCTION DI_CON(Y)
      IMPLICIT REAL*8 (A-H,O-Z)
      IF ( Y .le. 0.5 ) DI_CON = 2.0*Y
      IF ( Y .gt. 0.5 ) DI_CON = 2.0*(1-Y) 
      RETURN
      END

      REAL*8 FUNCTION TANALYTICAL(Y, X)
      IMPLICIT REAL*8 (A-H,O-Z)
      PI = 2.0 *dasin(1.d0)
      TANALYTICAL = 0.0
      DO n = 0, 20 
         TANALYTICAL = TANALYTICAL + (-1.0)**n/(2.0*n+1.0)**2 
     1 *dexp(-(2.d0*n+1.d0)**2*PI**2*X)*dsin((2.d0*n+1.d0)*PI*Y)  
      ENDDO
      
      TANALYTICAL = TANALYTICAL * 8.0 /PI**2
      RETURN
      END
