C     EXAMPLE 9.3
      COMMON/BLC0/NXT,IWBCOE,IEBCOE,ITURB,ICOORD,INDEX,N,NP,PR,VGP,
     +            GWA,REY,CEL,ETA(81),UP(81),DETA(81),A(81),YP(81),
     +            X(101),GW(101),PW(101),GE(101),G(81,2),P(81,2)
      COMMON/BLC1/ S1(81),S2(81),S3(81),R1(81),R2(81),A1(81,2),A2(81,2)
      COMMON /BLCS/ ANU(101), AG(101)
      CHARACTER*80 output_name
C
      WRITE(6,*) "Enter dx = "
      READ(5,*) DX  
      WRITE(6,*) "Enter output file name"
      READ(5,*) output_name
      OPEN(unit=6,file=output_name)
      

      NXT = 100
      ETAE = 1.0
      DETA(1) = 0.1
C      DX = 1.0/1000.0
      DO I = 1, NXT
        X(I) = (I-1)*DX
      ENDDO
      IWBCOE = 1
      IEBCOE = 1

      NP= ETAE/DETA(1)+1.0001
  30  IF(NP .LE. 51) GO TO 40
      WRITE(6,9100)
      STOP
  40  ETA(1)=0.0
      WRITE(6,9001) NXT, DX, NP,DETA(1), DX/DETA(1)/DETA(1)
C
C INITIAL PROFILE AT X=X0
      G(1,2)= 0.0
      P(1,2)= 2.0
      DO  50  J= 2, NP
      YP(J)= 0.0
      if ( (J-1)* DETA(1) .le. 0.5 ) then
         G(J,2) = 2.0 * (J-1.0)* DETA(1)
         P(J,2) = 2
      else
         G(J,2) = 2.0 * ( 1.0 - (J-1.0)* DETA(1) ) 
         P(J,2) = -2
      endif
      if ( (J-1)* DETA(1) .eq. 0.5 ) then
         P(J,2) = 0.0
      endif
      A1(J,2)= 1.0
      A2(J,2)= 0.0
C
C GENERATION OF GRID SYSTEM
      DETA(J)=DETA(J-1)
      ETA(J)=ETA(J-1)+DETA(J-1)
 50   A(J) = 0.5*DETA(J-1)

      N=1
 60   WRITE(6,9200) N,X(N)
      IF(N .EQ. 1) GO TO 80
      CEL = 1.0/(X(N)-X(N-1))
C COEFFS OF THE FINITE DIFFERENCE EQUATIONS
      DO J=2,NP
        CGB=0.5*(G(J,1)+G(J-1,1))
        S1(J)=  1.0/DETA(J-1)
        S2(J)= -1.0/DETA(J-1)
        S3(J)= -CEL
        R1(J) = - (P(J,1) - P(J-1,1) )/DETA(J-1) -2.0*CGB*CEL
        R2(J-1)=0.0
      ENDDO
      CALL SOLV2

C PRINT OUT G(J) 
80    WRITE(6,9300) (J,ETA(J),G(J,2),J=1,NP)
      IF(N.EQ.NXT) STOP
      N=N+1
C SHIFT PROFILES FOR NEXT STATION CALCULATION
      DO J=1,51
        G(J,1)=G(J,2)
        P(J,1)=P(J,2)
      ENDDO

      GO TO 60
 9001 FORMAT(1H0,7HNXT   =I3,14X,"DX=",F6.4, 10X, "NP=",I4, 
     1       /, 10X,"DETA=",f6.4, 10X,"RATIO=",f6.4)
 9100 FORMAT(1H0,35HNP EXCEEDED 51-- PROGRAM TERMINATED)
 9200 FORMAT(/1H0,2HN=,I3,5X,3HX =,E14.6)
 9300 FORMAT(1H0,2X,1HJ,3X,3HETA,10X,1HG/
     1       (1H ,I3,F10.5,1E14.6))
      END

      SUBROUTINE SOLV2
      COMMON/BLC0/ NXT,IWBCOE,IEBCOE,ITURB,ICOORD,INDEX,N,NP,PR,VGP,
     1             GWA,REY,CEL,ETA(81),UP(81),DETA(81),A(81),YP(81),
     2             X(101),GW(101),PW(101),GE(101),G(81,2),P(81,2)
      COMMON/BLC1/ S1(81),S2(81),S3(81),R1(81),R2(81),A1(81,2),A2(81,2)
      DIMENSION G11(81),G12(81),A11(81),A12(81),A21(81),A22(81),W1(81),
     1          W2(81),DEN(81)
C----------------------------------------------------------------------
      IF(IWBCOE.EQ.0) GO TO 10
C*****SPECIFIED WALL TEMPERATURE BOUNDARY CONDITION***************
      ALFA0=1.0
      ALFA1=0.0
C     gw(n) = 0.0
C     G(1,2)= GW(N)
      G(1,2)= 0.0
      P(1,2)= 0.0
      GO TO 20
C
C*****SPECIFIED WALL HEAT FLUX*********************************
  10  ALFA0=0.0
      ALFA1=1.0
      G(1,2)=0.0
      P(1,2)=PW(N)
  20  GAMMA0=ALFA0*G(1,2)+ALFA1*P(1,2)
      R1(1)=GAMMA0
      IF(IEBCOE.EQ.0) GO TO 30
C*****SPECIFIED EDGE TEMPERATURE
      BETA0=1.0
      BETA1=0.0
C     ge(n) = 0.0
C     G(NP,2)=GE(N)
      G(NP,2)= 0.0
      P(NP,2)=0.0
      GO TO 40
C*****SPECIFIED EDGE TEMPERATURE GRADIENT*********************
  30  BETA0=0.0
      BETA1=1.0
      G(NP,2)=0.0
      P(NP,2)=0.0
  40  GAMMA1=BETA0*G(NP,2)+BETA1*P(NP,2)
      R2(NP)=GAMMA1
C*****  W  ELEMENTS FOR J=1
      W1(1)=R1(1)
      W2(1)=R2(1)
C*****  ALFA ELEMENTS FOR J=1***********************************
      A11(1)=ALFA0
      A12(1)=ALFA1
      A21(1)=-1.0
      A22(1)=-0.5*DETA(1)
C*****  GAMMA ELEMENTS FOR J=2*******************************
      DET=ALFA1-0.5*DETA(1)*ALFA0
      G11(2)=(S2(2)-0.5*DETA(1)*S3(2))/DET
      G12(2)=(ALFA0*S2(2)-ALFA1*S3(2))/DET
C*****  FORWARD SWEEP***************************************
      DO 60 J=2,NP
      DEN(J)=A11(J-1)*A22(J-1)-A21(J-1)*A12(J-1)
      IF(J.EQ.2) GO TO 50
      G11(J)=(S3(J)*A22(J-1)-S2(J)*A21(J-1))/DEN(J)
      G12(J)=(S2(J)*A11(J-1)-S3(J)*A12(J-1))/DEN(J)
 50   A11(J)=S3(J)-G12(J)
      A12(J)=S1(J)+A(J)*G12(J)
      A21(J)=-1.0
      A22(J)=-A(J+1)
      W1(J)=R1(J)-G11(J)*W1(J-1)-G12(J)*W2(J-1)
      W2(J)=R2(J)
  60  CONTINUE
C*****  BACKWARD SWEEP**************************************
      DENO=A11(NP)*BETA1-A12(NP)*BETA0
      G(NP,2)=(W1(NP)*BETA1-W2(NP)*A12(NP))/DENO
      P(NP,2)=(W2(NP)*A11(NP)-BETA0*W1(NP))/DENO
      J=NP
  70  J=J-1
      E1=W2(J)-G(J+1,2)+A(J+1)*P(J+1,2)
      G(J,2)=(W1(J)*A22(J)-E1*A12(J))/DEN(J+1)
      P(J,2)=(E1*A11(J)-W1(J)*A21(J))/DEN(J+1)
      IF(J.GT.1) GO TO 70
      RETURN
      END
