      PROGRAM pinterface
C***********************************************************************
C  This program generates input data for integral (Thwaites, Head)
C  and differential (blp2d) stability (stp2d) programs
C  
C
C  Input:  the output file of the PANEL (HSPM) code
C  OUTPUT: thwaitesInp.txt       (input file for Thwaites method)
C          headInp.txt           (input file for Head's method)
C          blp2dInp.txt          (input file for blp2d program)
C          stp2dInp.txt          (input file for stp2d program)
C
      real*8  X(201), Y(201), alpha,UE(201)
      real*8  XC(201), YC(201), UEC(201)
      real*8 S(201)
	CHARACTER*160 RLINE
      CHARACTER*21 junk
      character*27 PANEL

	write(6,*) "Enter flow type"
	write(6,*) " 0  laminar flow only"
	write(6,*) " 1  laminar and turbulent flow"
	write(6,*) " 2  turbulent flow only"
	read(5,*) IFLOW

      WRITE(6,*) "Flow parameters"
      WRITE(6,*) "ENTER Reference length BIGL = (1. for example)"
      READ(5, *) BIGL
      WRITE(6,*) "Enter reference velocity"
	READ(5, *) UREF
      WRITE(6,*) "Enter  kinematic viscosity ",
     1           "CNU = (1.6e-4 for example)"
	READ(5,*) CNU
C     UREF = RL*CNU/BIGL
      RL = UREF * BIGL/CNU

C      write(6,*) "Select Boundary Layer Methods"
C      write(6,*) " 0  Differential (blp2d & stp2d) Method"
C      write(6,*) " 1  integral (Thwaites & Head) Method "
C      read(5, *) method
      method = 1

      WRITE(6,*)"Identify whether the geometry and velocity data ",
     *          "are provided by"  
	WRITE(6,*)"  0    panel method"
	WRITE(6,*)"  1    input [ x(I) s(I) Ue(I)]"
	READ(5, *) IGEOMETRY
      
	I = 0
	IF ( IGEOMETRY .EQ. 1 ) THEN
C One surface only
	   WRITE(6,*)"Enter input file name (note your file must be ",
     *             "in the format X(I) Y(I) UE(I) in three columns)"
         READ (5,*) PANEL
	   OPEN(55, file=PANEL,status='old')
 213	   READ(55,'(A160)',ERR=232,END=232) RLINE
         IF(RLINE(1:20) .EQ. '                    ')THEN
	      GOTO 232
	   ELSE
	      I = I + 1
	      READ(RLINE,*) X(I),Y(I),UE(I)
	      GOTO 213
	   ENDIF
 232     CLOSE(55)
         NUMUP = I
          DO I = 1, NUMUP
	      XC(I) = X(I)
	      YC(I) = Y(I)
	      UEC(I) = UE(I)
 	   ENDDO
	ELSE
C for both surfaces
	   WRITE(6,*)"Enter input file name (its format must be ",
     *         "the same as the HSPM output file eg. panelOut.txt)"
         READ (5, *) PANEL
         NUMUP = 0
         OPEN(55, file=PANEL,status='old')
          READ (55,*)
          READ (55,*)
          READ (55,444) junk,alpha
          READ (55,*)
          READ (55,*)
          READ (55,*)
 444     FORMAT(A21,F10.5)
          I = 0
 201      READ(55,'(A160)',ERR=202,END=202) RLINE
         IF(RLINE(1:20) .EQ. '                    ')THEN
	     IF ( J .EQ. I ) THEN
	       NODTOT = I
	       GOTO 202
	     ELSE
	       WRITE(6,*) "Errors in Input file: ",PANEL
	       GOTO 202
	     ENDIF
	   ELSE
	     I = I + 1
	     READ(RLINE,*) J, X(I),Y(I),Cp,UE(I)
           IF ( UE(I) .LE. 0.0 ) NUMUP = I
	     GOTO 201
	   ENDIF  
 202     close(55)         
C define upper or lower surface
         write(6,*) "Choose Upper or Lower Surfaces"
         write(6,*) "     0  upper_surface"
         write(6,*) "     1  lower_surface"
         read(5, *) isurface
         J = 0
         IF ( isurface .ne. 1 ) THEN
C   Upper surface
C   SWAP X, Y and Ue with Xc, Yc, Uec
	      IF ( ABS(UE(NUMUP+1)) .GE. 0.0001) THEN 
	         XC(1) = X(NUMUP) - UE(NUMUP)*(X(NUMUP+1)-X(NUMUP))
     *                 /(UE(NUMUP+1)-UE(NUMUP))
 	         YC(1) = Y(NUMUP) - UE(NUMUP)*(Y(NUMUP+1)-Y(NUMUP))
     *                 /(UE(NUMUP+1)-UE(NUMUP))
c	         XC(1) = 0.5*(X(NUMUP)+X(NUMUP+1))
c	         YC(1) = 0.5*(Y(NUMUP)+Y(NUMUP+1))
	         UEC(1) = 0.0
	         J = 1
	      ENDIF
            DO I = NUMUP+1, NODTOT
	         J = J + 1
               XC(J) = X(I)
               YC(J) = Y(I)
               UEC(J) = UE(I) 
            ENDDO
         ELSE
C   Lower surface
C   SWAP X, Y and Ue with Xc, Yc, Uec
	     IF ( ABS(UE(NUMUP)) .GE. 0.005) THEN 
	        XC(1) = 0.5*(X(NUMUP)+X(NUMUP+1))
	        YC(1) = 0.5*(Y(NUMUP)+Y(NUMUP+1))
	        UEC(1) = 0.0
	        J = 1
	     ENDIF
           DO I = NUMUP, 1, -1
	       J = J + 1
             XC(J) = X(I)
             YC(J) = Y(I)
             UEC(J) = -UE(I)
           END DO
         ENDIF
	   NUMUP = J
	ENDIF

C Compute distance from initial point
      S(1) = 0.0
      DO I = 2, NUMUP
	   S(I) = S(I-1) + SQRT((XC(I)-XC(I-1))**2+(YC(I)-YC(I-1))**2)
	ENDDO

      KASE = 1
      KDIS = 0

C Generate input data for boundary-layer method
      IF ( method .eq. 1  ) THEN
C Generate input data for integral method
C       Generate Head's method input file
         IF ( IFLOW .EQ. 2 ) THEN
	      WRITE(6,*) "Enter Theta"
	      READ(5,*) Theta
	      H1 = 1.4
	      WRITE(6,*) "Generate head's method input file headInput.txt"
		  OPEN(12, FILE="headInput.txt")
	      WRITE(12,222) NUMUP,RL,Theta,H1
 222        FORMAT(I5,3F16.4)
            WRITE(12,223) (S(I), I=1, NUMUP)
		  WRITE(12,223) (UEC(I),I=1,NUMUP) 
 223        FORMAT(6F10.6)
            WRITE(12,*)
	      WRITE(12,*)
            WRITE(12,*)
		  WRITE(12,*) "-------------Data Explanation-----------------"
		  WRITE(12,*) "NXT, RL, T(1), H(1)"
	      WRITE(12,*) "X(1), ... X(NXT)"
	      WRITE(12,*) "UE(1) ... UE(NXT)"
	      WRITE(12,*) 
            WRITE(12,*) "NXT --- The number of x-station"
	      WRITE(12,*) "RL  --- Reynolds number"
	    WRITE(12,*)"T(1) -- Initial dimensionless momentum thickness"
	      WRITE(12,*) "H(1) -- Shape factor at first station"
	      WRITE(12,*) "X(I) -- Surface distance station"
	      WRITE(12,*) "UE(I) - The external velocity distribution"
            CLOSE(12)
	   ELSE
C Generate input file for Thwaites method
           KASE = 1.0
           KDIS = 0.0
	     WRITE(6,*)
	     WRITE(6,*) "Generate input file, thwaitesInp.txt ",
     *                "for Thwaites method with"
	     WRITE(6,*) "  NXT = ",NUMUP," KASE =",KASE," KDIS=",KDIS
	     WRITE(6,*) " UREF =",UREF," BIGL=",BIGL,"CNU=",CNU
           OPEN(12,file='thwaitesInp.txt')
	     REWIND 12
           WRITE(12,443) NUMUP, KASE,KDIS,UREF,BIGL,CNU
           DO I = 1, NUMUP
              WRITE(12,555) XC(I),YC(I),UEC(I)
C	write(12,*) I, XC(I),YC(I), UEC(I)
           ENDDO
           WRITE(12,*)
           WRITE(12,*)
           WRITE(12,*)
           WRITE(12,*) "-----------Data Explanation--see p. 80-------"
           WRITE(12,*) "NXT,KASE,KDIS,UREF,BIGL,CNU"
           WRITE(12,*) "X(1),  R(1),   UE(1) "
           WRITE(12,*) "      ."
           WRITE(12,*) "      ."
           WRITE(12,*) "      ."
           WRITE(12,*) "X(NXT),R(NXT),UE(NXT)"
c           WRITE(12,*)
C           WRITE(12,*) "NXT ---- Number of X stations"
c           WRITE(12,*) "KASE ---"
c           WRITE(12,*) "KDIS --- Switch for the surface distances (1)"
c           WRITE(12,*) "         or y-coordinates (0)"
c           WRITE(12,*) "UREF --- Reference velocity"
c           WRITE(12,*) "BIGL --- Length scale"
c           WRITE(12,*) "CNU  --- nu"
c           WRITE(12,*) "X(I) --- dimensionless x/c-coordinate"
c          WRITE(12,*) "R(I) --- dimensionless y/c-coordinates ",
c     *                 "or distance"
c           WRITE(12,*) "UE(I)--- dimensionless External velocity ",
c     *                 "profiles"
           CLOSE(12)
	   ENDIF
      ELSE
C Generate input data for BLP2D program
         ETAE = 8.0
C         WRITE (6, *) "Enter variable grid parameter VGP"
C         READ(5,*) VGP
         VGP = 1.14
         IF (VGP .LT. 1.0 ) VGP = 1.0
	   IF (IFLOW .EQ. 1 ) THEN
            WRITE (6, *) "Specify transition location, XCTR"
            WRITE (6, *) "     0.0 if transition location is ",
     *             "calculated later"
            READ(5,*) XCTR
	   ELSE
	      XCTR = 0.0
	   ENDIF
         IF ( XCTR .LE. 0.0 ) THEN
C Laminar flow computation
            XCTR = 2.0
            DETA = 0.1
         ELSE
C turbulent flow computation with smaller initial step deltaEta
            DETA = 0.01
         ENDIF
	WRITE(6,*) " Enter dimensionless pressure gradient, m, p2(1)"
	WRITE(6,*) "     P2 = 1 for airfoil"
      WRITE(6,*) "     P2 = 0 for flat plate"
	READ(5,*) P2
	   WRITE(6,*) " "
	   WRITE(6,*) "============================================"
	   WRITE(6,*) "Generate blp2d input file blp2dInp.txt with "
	   WRITE(6,*) "NXT = ",NUMUP,"  NPT = 81"
	   WRITE(6,*) " RL     XCTR     ETAE     VGP     DETA     P2"
	   WRITE(6,88) RL, XCTR, ETAE,VGP,DETA,P2
	   WRITE(6,*) " "

         OPEN(13,file='blp2dInp.txt')
           WRITE(13,*) NUMUP, 81
           WRITE(13,88) ( XC(I), I=1, NUMUP)
           WRITE(13,88) ( YC(I), I=1, NUMUP)
           WRITE(13,88) (UEC(I), I=1, NUMUP)
           WRITE(13,88) RL, XCTR, ETAE,VGP,DETA,P2
           WRITE(13,*)
           WRITE(13,*)
           WRITE(13,*)
           WRITE(13,*) "-----------Data Explanation-------------"
           WRITE(13,*) "NXT NPT"
           WRITE(13,*) "X(1)  ...  X(NXT)"
           WRITE(13,*) "Y(1)  ...  Y(NXT)"
           WRITE(13,*) "UE(1) ...  UE(NXT)"
           WRITE(13,*) "RL,XCTR,ETAE,VGP,DETA(1),P2(1)"
           WRITE(13,*)
           WRITE(13,*) "NXT   ---  The number of x-stations"
           WRITE(13,*) "NPT   ---  The number of normal grid points"
           WRITE(13,*) "X(I)  ---  The x-coordinate of geometry"
           WRITE(13,*) "Y(I)  ---  The y-coordinate of geometry"
           WRITE(13,*) "UE(I) ---  The external velocity"
           WRITE(13,*) "RL    ---  Reynolds number"
           WRITE(13,*) "XCTR  ---  Transition location"
           WRITE(13,*) "ETAE  ---  The boundary layer thickness"
           WRITE(13,*) "VGP   ---  The variable grid paramemter"
           WRITE(13,*) "DETA(1)--  The size of first normal grid"
           WRITE(13,*) "P2(1)  --  Initial pressure at first x-station"
         CLOSE(13)
      ENDIF
 443  FORMAT(3I3,2F10.5,F10.7)
 555  FORMAT(3F10.5)
 501  FORMAT(I5,6F10.5)
 88   FORMAT(5F15.5)

	IF( (METHOD .NE. 1) .AND. (IFLOW .EQ. 1) .AND. 
     *    (XCTR .EQ. 2.0))  THEN 
C Generate input data for stp2d program
		icounter = 0
      WRITE(6, *)"Enter the NX0 station to begin stability computations"
 234		READ (5, *) NX0
		R = sqrt(UEC(NX0)*S(NX0)*RL)
		IF (R .LE. 300 ) THEN
			icounter = icounter + 1
          WRITE(6, *) "Warning: R based on NX0, is possibly too small"
			if (icounter .ge. 5 ) then
				go to 345
			endif
			WRITE(6,*) "Re-enter larger NX0"
			GO TO  234
		ENDIF
 345		WRITE(6, *) "Obtain initial eigenvalue (ALPHA, OMEGA) ",
     1                "guess from figure 6.4 with R=",R
		WRITE(6, *) "Enter initial egenvalue guess ALPHA ="
		READ(5,  *) ALFA
		WRITE(6, *) "Enter initial egenvalue guess OMEGA ="
		READ(5,  *) OMEGA
		WRITE(6, *) "Enter the number of instability lines"
		WRITE(6, *) " 0 for computing neutral stability curve only."
		READ (5, *) IXT
		IF ( IXT .le. 0 ) IXT = 0
          WRITE(6,*) "============================================="
          WRITE(6,*) "Generate stp2d input file stp2dInp.txt with"
	    WRITE(6,*)  "NXT=",NUMUP, " NX0 =", NX0, " IXT = ",IXT,
     *           " UREF=",UREF," BIGL=",BIGL, " RL=",RL,
     *         " ALFA=",ALFA,"  OMEGA =",OMEGA
		open ( 14, file='stp2dInp.txt')
		  WRITE(14,8000) NUMUP, NX0, IXT
		  WRITE(14, 8010) UREF, BIGL, RL
		  WRITE(14, 8101) ALFA, 0.0, OMEGA
		  WRITE(14, 8101) (XC(I), I=1,NUMUP)
		  WRITE(14, 8101) (S(I),  I=1,NUMUP)
		  WRITE(14, 8101) (UEC(I),I=1,NUMUP)
		  WRITE(14,*)
		  WRITE(14,*)
		  WRITE(14,*)
		  WRITE(14,*) "------------Data Explanation-------------"
		  WRITE(14,*) "NXT NX0 IXT"
		  WRITE(14,*) "UINF  BIGL  RL"
		  WRITE(14,*) "ALFA OMEGA"
		  WRITE(14,*) "X(1) ... X(NXT)"
		  WRITE(14,*) "S(1) ... S(NXT)"
		  WRITE(14,*) "UE(1) ... UE(NXT)"
		  WRITE(14,*)
		  WRITE(14,*) "NXT  --- The number of x-station"
        WRITE(14,*) "NX0  --- The x-station at which computation starts"
		  WRITE(14,*) "IXT  --- Number of lines"
        WRITE(14,*) "         0 -- compute neutral stability curve only"
		 WRITE(14,*) "UINF --- The reference velocity"
		 WRITE(14,*) "BIGL --- The reference length"
		  WRITE(14,*) "RL   --- The Reynolds number"
        WRITE(14,*) "(ALFA OMEGA)---initial eigenvalue guess at X(NX0)"
		  WRITE(14,*) "X(I) --- The x-coordinate"
		  WRITE(14,*) "S(I) --- The surface distance"
		  WRITE(14,*) "UE(I) -- The external velocity"
		close(14)
	ENDIF

      PRINT*," "
	PRINT*," "
	PRINT*,"Hit any key to end the application."
	READ(5,*)

 8000 FORMAT(20I3)
 8101 FORMAT(7F10.5)
 8010 FORMAT(2F10.5, F10.1)

      STOP
      END
