C
C      THWAITES METHOD
C      -----------------------------------------------------
C Input:
C   NXT:    Number of x stations
C   KASE:   = 1, 2-D flow
C           = 2, axisymmetric flow
C   KDIS:   = 1, input s (surface distance)
C             otherwise, input x,y coordinates
C   UREF    Reference velocity
C   BIGL    Reference length, L
C   CNU     Kinematic viscosity
C   X(I)    x/L
C   UE(I)   ue/UREF, ue is the external velocity
C   R(I)    y/L for 2-D flow or r/L for axisymmetric flow
C   S(I)    s/L
C Output
C   S(I)    s/L
C   RS      Local Reynolds number based on s
C   DELS    Displacement thickness
C   THETA   Momentum thickness
C   H       Shape factor
C   CF      Skin friction coefficient
C   RTHETA  Reynolds number based on momentum thickness
C ===================================================
       DIMENSION S(300),X(300),R(300),UE(300)

	 CHARACTER*80 input_name, output_name
C **  INPUT

	WRITE(6,*) "Enter input file name (include extension name)"

	READ(5,*) input_name

	OPEN(unit=55,file=input_name,STATUS="OLD")

	WRITE(6,*) "Enter output file name"

	READ(5,*) output_name

	OPEN(unit=66,file=output_name)                                                  


       READ(55,8000) NXT,KASE,KDIS,UREF,BIGL,CNU
       WRITE(66,9000) NXT,KASE,UREF,BIGL,CNU
       IF (KDIS .EQ. 1) GO TO 100
       READ(55,8100) (X(I),R(I),UE(I),I=1,NXT)
C **  CALCULATION OF SURFACE DISTANCE
       S(1)=0.0
       DO 50 I=2,NXT
   50  S(I) = S(I-1)+SQRT((X(I)-X(I-1))**2+(R(I)-R(I-1))**2)
       GO TO 400
  100  READ(55,8100) (S(I),R(I),UE(I),I=1,NXT)
C **  THWAITES METHOD
  400  WRITE(66,9200)
       CF    = 0.0
       URSUM = 0.0
       RL    = UREF*BIGL/CNU
       F2    = 0.0
       DO 500 I=1,NXT
       R2    = 1.0
       IF (KASE .EQ. 2) R2 = R(I)**2
       F2    = UE(I)**5*R2
       IF (I .EQ. 1) GO TO 480
       URSUM = URSUM + 0.5*(F1+F2)*(S(I)-S(I-1))
       DUEDS = (UE(I)-UE(I-1))/(S(I)-S(I-1))
       CONST = 0.45/(F2*UE(I))
       THTATM= CONST*URSUM
       GO TO 495
  480  DUEDS = (UE(2)-UE(1))/S(2)
       THTATM= 0.0
       IF (KASE .EQ. 1) THTATM = 0.075/DUEDS
       IF (KASE .EQ. 2) THTATM = 0.056/DUEDS
  495  THETA = SQRT(THTATM/RL)*BIGL
       RTHETA= THETA*UE(I)/CNU*UREF
       RS    = UE(I)*S(I)/CNU*UREF*BIGL
       CLMBDA= THTATM*DUEDS
       IF (CLMBDA .LT. 0.0) GO TO 496
       H     = 2.61-3.75*CLMBDA+5.24*CLMBDA**2
       CL    = 0.22+1.57*CLMBDA-1.8*CLMBDA**2
       GO TO 497
  496  H     = 0.0731/(0.14+CLMBDA)+2.088
         CL    = 0.22+1.402*CLMBDA+0.018*CLMBDA/(CLMBDA+0.107)
  497  DELS  = THETA*H
       IF (I .GT. 1) CF = 2.0*CL/(UE(I)*THETA/BIGL*RL)
       WRITE(66,9300) I,X(I),S(I),RS,UE(I),DELS/BIGL,THETA/BIGL,

     *                H,CF,RTHETA
       IF ( (I .GT. 1) .and. (CF .le. 0.0) ) THEN
          WRITE(66,9400)
          STOP
       ENDIF
       F1    = F2
  500  CONTINUE
       STOP
C -------------------------------------------------------------------
 8000  FORMAT(3I3,3F10.5)
 8100  FORMAT(3F10.5)
 9000  FORMAT(1H ,5HNXT =,I3,14X,5HKASE=,I3/1H ,5HUREF=,E14.6,3X,
     1        5HBIGL=,E14.6,3X,5HNU  =,E14.6/)
 9200  FORMAT(1H ,2X,1HI,5X,3HX/C,9X,3HS/C,11X,2HRS,9X,2HUE,9X,5HDELST,
     1        7X,5HTHETA,9X,1HH,11X,2HCF,9X,6HRTHETA)
 9300  FORMAT(1H ,I3,9E12.4)
 9400  FORMAT(1H ,36HFLOW SEPARATES AND CALCULATION STOPS)
       END

