c*********************************************************************
c
c     11.8ba  fortran program (analytical) for test case 2
c                 constant heat flux
c
c*********************************************************************
c
      dimension x(100),beta(30),phi(30),cnl(100),cns(100) 
     + ,title(20)
	CHARACTER*80 input_name, output_name
c
c     open(unit=5,file='pr11_8bainp.txt',status='old')
c     open(unit=6,file='pr11_8baout.txt')
      WRITE(6,*) "Enter input file name (include extension name)"
	READ(5,*) input_name
	WRITE(6,*) "Enter output file name"
	READ(5,*) output_name
	OPEN(unit=5,file=input_name,STATUS="OLD")
	OPEN(unit=6,file=output_name)           

      read(5,8150) title
      read(5,*) nxt 
      read(5,*) (x(i), i=1,nxt)

      write(6,8150) title
c
c  data in Kays' book   ! better results
      beta(1)  =25.68
      beta(2)  =83.86
      beta(3)  =174.20
      phi(1)   =7.630e-3
      phi(2)   =2.058e-3
      phi(3)   =9.010e-4
c
      mm       =25  
c
c  add beta & phi to total # of mm
c
      do i = 4,mm
         bm  =  4. * i + 4./3.
         beta(i) = bm**2
         phi (i) = 0.358 / bm**2.32
      enddo
c
      pe     = 2.
      do 50 j=1,nxt
         sum1=0.0
         do 30 i=1,mm 
            xx=x(j)/pe 
            e1=exp(-beta(i)*xx)
            sum1=sum1-e1/(beta(i)**2*phi(i)) 
  30     continue
         if(xx.gt.1.e-4)then
c
c  analytic formula for large xx
            cnl(j)=1./(0.5*sum1+11./48.)
         else
            cnl(j)=0.0
         end if
         if(xx.le.0.001) then
c
c  analytic formula for small xx
            cns(j)=1.639/(xx**(1./3.))
         else
            cns(j)=0.0
         end if
  50  continue         
      write(6,100)(i, x(i),x(i)/pe,cnl(i),cns(i),i=1,nxt)
 100  format(//'result summary'//2x, 'i', 6x, 'x ',10x,'x/pe', 
     1       8x, 'cnl ', 10x, 'cns'/ (i3, 4e12.4))
 8150 format(20a4)
      stop
      end  
