c*********************************************************************
c
c     11.8c fortran program for test case 3
c     turbulent flow with constant heat flux on smooth pipe 
c
c*********************************************************************
c
      common/blc0/nxt,iwbcoe,iebcoe,iturb,icoord,index,n,np,npt,igwall,
     +        pr,vgp,gwa,rey,cel,eta(81),up(81),deta(81),a(81),yp(81),
     +        x(101),gw(101),pw(101),ge(101),g(81,2),p(81,2)

      common/blc1/ s1(81),s2(81),s3(81),r1(81),r2(81),a1(81,2),a2(81,2)
     +            ,etae
      common/blc2/expy0a(81),expy0b(81),y0a(81),y0b(81),prt(81),aplus,
     1            ro_ks,f,rp(81),dudy(81)

      dimension title(20)
	CHARACTER*80 input_name, output_name
c
c  read in and print out parameters
c
c     open(unit=5,file='pr11_8cinp.txt',status='old')
c     open(unit=6,file='pr11_8cout.txt')
      WRITE(6,*) "Enter input file name (include extension name)"
	READ(5,*) input_name
	WRITE(6,*) "Enter output file name"
	READ(5,*) output_name
	OPEN(unit=5,file=input_name,STATUS="OLD")
	OPEN(unit=6,file=output_name)           

      read(5,8150) title
      read(5,*) nxt,iwbcoe,iebcoe,iturb,etae,deta(1),vgp,pr,gwa,rey
      read(5,*) (x(i), i=1,nxt)

      write(6,8150) title
      write(6,9000) nxt,iwbcoe,iebcoe,iturb,etae,deta(1),vgp,pr,gwa,rey
      npt = 61
      if((vgp-1.0) .gt. 0.0001) go to 20
      np= etae/deta(1)+1.0001
      go to 30
  20  np=alog((etae/deta(1))*(vgp-1.0)+1.0)/alog(vgp)+1.0001
  30  if(np .le. npt) go to 40
      write(6,9100)
      stop
  40  eta(1)=0.0
      do j = 2,npt
c
c generation of grid system
c
         deta(j)=deta(j-1)*vgp
         eta(j)=eta(j-1)+deta(j-1)
         a(j) = 0.5*deta(j-1)
      enddo
c
c initial temperature profile at x=x0
c
      do j= 1,npt
         yp(j)= 0.0
         g(j,2)= 1.0
         p(j,2)= 0.0
         p(j,1)= p(j,2)
         g(j,1)= g(j,2)
         a1(j,2)= 1.0
         a2(j,2)= 0.0
      enddo
c
      if(iwbcoe .eq. 0) then
         do j=1,np
            p(j,2)=exp(-50.0*eta(j)/eta(np))
            g(j,2)=-eta(np)/50.0*p(j,2)+1.0
            p(j,1)= p(j,2)
            g(j,1)= g(j,2)
         enddo
      endif
c
      if(iturb .eq. 1 ) then          
c
c  calculate turbulent data &  velocity profile using C. S. model
c
         call turbpf
      endif
c
      igwall = 0
      n=1
      icoord = 1
      index =0
      if(iwbcoe .eq. 0) pw(1) = 1.0
c
 60   write(6,9200) n,x(n)
      if(n .eq. 1) go to 80
      if(icoord.eq. 2) cel = 1.0/(x(n)-x(n-1))
      if(icoord.eq. 1) cel = 0.5*(x(n)+x(n-1))/(x(n)-x(n-1))
      igrow= 0
 70   call coef
      call solv2
c
c check for boundary layer growth
c
      if(icoord.eq.2 .or. np.eq.npt) go to 80
      if(igrow.ge.3 .or. abs(p(np,2)).lt.1.e-04) go to 80
      xswitch= 1.0/eta(np+1)**2
      if(x(n).ge.xswitch) go to 80
      np= np+1
      igrow=igrow+1
      g(np,1)=g(np-1,1)
      p(np,1)=0.0
      go to 70
  80  call output
      go to 60
c-----------------------------------------------------------------
 8000 format(4i5,6f10.0)
 8100 format(8f10.0)
 8150 format(20a4)
 9000 format(1h0,7hnxt   =i3,14x,7hiwbcoe=,i3,14x,7hiebcoe=,i3,14x,
     1       7hiturb =,i3/1h ,7hetae  =,e14.6,3x,7hdeta1 =e14.6,3x,
     2    7hvgp   =,e14.6,3x,7hpr    =,e14.6/1h,7hgwa   =,e14.6,3x,
     3       7hrey   =,e14.6)
 9100 format(1h0,35hnp exceeded npt-- program terminated)
 9200 format(/1h0,2hn=,i3,5x,3hx =,e14.6)
      end

      subroutine coef
      real k,kh
      common/blc0/nxt,iwbcoe,iebcoe,iturb,icoord,index,n,np,npt,igwall,
     +        pr,vgp,gwa,rey,cel,eta(81),up(81),deta(81),a(81),yp(81),
     +        x(101),gw(101),pw(101),ge(101),g(81,2),p(81,2)
      common/blc1/ s1(81),s2(81),s3(81),r1(81),r2(81),a1(81,2),a2(81,2)
     +            ,etae
      common/blc2/expy0a(81),expy0b(81),y0a(81),y0b(81),prt(81),aplus,
     1            ro_ks,f,rp(81),dudy(81)
      common/blc3/nps,yps(81),dudys(81),edvs(81),ups(81),prts(81)
      dimension c(5),edv(81)
      data k,kh/0.4,0.44/
      data c/34.96,28.79,33.95,6.3,-1.186/
c---------------------------------------------------------------------
      if(icoord.eq.2) then 
         switch=0.0
         xp1=1.0
         jj=np
         do j = 1,jj
            yp(j) = eta(j)
            rp(j)=1.0-yp(j)
         enddo
      else
         switch=1.0
         xp1=sqrt(x(n))
         ge(n)=1.0
         do 5 j=1,npt
            yp(j)=xp1*eta(j)
            rp(j)=1.0-yp(j)
            if(yp(j).gt.1.0) go to 10
   5     continue
         jj= npt
         go to 15
  10     jj=j-1
  15     continue
      endif
c
      if(iturb.ne.1) then 
c  laminar flow
         do j=1,jj
            up(j)=2.0*(1.0-rp(j)**2)
            a1(j,2)=rp(j)
            a2(j,2)=up(j)*rp(j)
         enddo
c  turbulent flow
      else
         js   = 1
         do j = 1,jj
            do j1 = js,nps
               j2 = j1
               if(yps(j1) .ge. yp(j)) goto 35 
            enddo
   35       if(j2 .eq. 1) then
               edv(j) = edvs(j2)
               up(j)  = ups(j2)
               prt(j) = prts(j2)
            else
               edv(j) = edvs(j2-1)+(edvs(j2)-edvs(j2-1))/
     1               (yps(j2)-yps(j2-1))*(yp(j)-yps(j2-1))
               up (j) = ups (j2-1)+(ups(j2)-ups(j2-1))/
     1               (yps(j2)-yps(j2-1))*(yp(j)-yps(j2-1))
               prt(j) = prts(j2-1)+(prts(j2)-prts(j2-1))/
     1               (yps(j2)-yps(j2-1))*(yp(j)-yps(j2-1))
            endif
            js     = j2
            a1(j,2)=rp(j)*(1.0+pr/prt(j)*edv(j))
            a2(j,2)=rp(j)*up(j)
         enddo
      endif
c
      if(iwbcoe .eq. 1) then
c
c  for constant wall temperature
c
         if(igwall.eq.0) then 
            gw(n)=0.5*(1.0+cos(3.14159*(x(n)-x(1))/gwa))
            if(x(n).ge.(x(1)+gwa)) then
               gw(n)=0.0
               igwall=1
            endif
         else
            gw(n)=0.0
         endif
      else
c
c  for constant heat flux
c
         pw(n)=1.0
         if(icoord.eq.2) pw(n)=etae
      endif

c coeffs of the finite difference equations
      do j=2,np
         etab=0.5*(eta(j)+eta(j-1))
         cgb=0.5*(g(j,1)+g(j-1,1))
         cpb=0.5*(p(j,1)+p(j-1,1))
         a2b=0.5*(a2(j,2)+a2(j-1,2))
         ca2b=0.5*(a2(j,1)+a2(j-1,1))
         dera1p=(a1(j,1)*p(j,1)-a1(j-1,1)*p(j-1,1))/deta(j-1)
         s1(j)=a1(j,2)/deta(j-1)+0.25*etab*a2b*switch
         s2(j)=-a1(j-1,2)/deta(j-1)+0.25*etab*a2b*switch
         s3(j)=-0.5*(ca2b+a2b)*cel
         r1(j)=2.0*s3(j)*cgb-dera1p-0.5*ca2b*etab*cpb*switch
         r2(j-1)=0.0
      enddo
      return
      end
      subroutine turbpf
      real k,kh
      common/blc0/nxt,iwbcoe,iebcoe,iturb,icoord,index,n,np,npt,igwall,
     +        pr,vgp,gwa,rey,cel,eta(81),up(81),deta(81),a(81),yp(81),
     +        x(101),gw(101),pw(101),ge(101),g(81,2),p(81,2)
      common/blc1/s1(81),s2(81),s3(81),r1(81),r2(81),a1(81,2),a2(81,2)
     +            ,etae
      common/blc2/expy0a(81),expy0b(81),y0a(81),y0b(81),prt(81),aplus,
     1            ro_ks,f,rp(81),dudy(81)
      common/blc3/nps,yps(81),dudys(81),edvs(81),ups(81),prts(81) 
      dimension c(5),edv(81),edvi(81),cmix(81)
      dimension upm(50),fs(50),ggns(50)
      data k,kh/0.4,0.44/
      data c/34.96,28.79,33.95,6.3,-1.186/
c--------------------------------------------------------------------
c
c  calculate velocity profile & eddy viscosity using T. C. 
c  two layer eddy viscosity model & satisfying mass flux 
c
c  first, generate grid across the pipe
c
      yps(1) = 0.0
      nps    = 81
      do j = 2,nps
         yps(j) = yps(j-1) + deta(j-1) 
         deta(j)= vgp * deta(j-1)
      enddo
      ypsm = yps(nps)
      do j = 1,nps
         yps(j) = yps(j) / ypsm
         yp(j)  = yps(j)
      enddo
c
      alogpr=alog10(pr)
      sum=c(1)
      do i=2,5
         sum=sum+c(i)*alogpr**(i-1)
      enddo
      aplus=26.0
      bplus=sum/sqrt(pr)
      prts(1)=k/kh*bplus/aplus
c
c  estimate dudy using mixing-length formula
c
      f=0.3164/(2.*rey)**0.25
      cy0a=0.5*rey/aplus*sqrt(0.5*f)
      cy0b=cy0a*aplus/bplus
      prts(1)=k/kh*bplus/aplus
      up(1) = 0.0
      do j=1,nps
         rp(j)=1.0-yp(j)
         y0a(j)=yp(j)*cy0a
         y0b(j)=yp(j)*cy0b
         expy0a(j)=0.0
         expy0b(j)=0.0
         if(y0a(j).lt.50.0) expy0a(j)=exp(-y0a(j))
         if(y0b(j).lt.50.0) expy0b(j)=exp(-y0b(j))
         cmix(j)=(0.14-rp(j)**2*(0.08+0.06*rp(j)**2))*(1.-expy0a(j))
         dudy(j)=0.25*rey*f*rp(j)/(1.+sqrt(1.+0.5*f*rp(j)*
     +           (rey*cmix(j))**2))
         edv (j)=cmix(j)**2*dudy(j)*rey
         if(j.gt.1) then 
            up(j)=up(j-1)+0.5*(dudy(j)+dudy(j-1))*(yp(j)-yp(j-1))
            prts(j)=k/kh*(1.-expy0a(j))/(1.0-expy0b(j))
         endif
         ups(j) = up(j)
         dudys(j) = dudy(j)
      enddo
      upm(1) = up(nps)
      itl    = 1
      iter   = 1
      itmax  = 20
      errm   = 0.0025 
c
c  iterate: dudy & up for C. S. model  
c
 15   edvo    = 0.0
      cmix(1) = 0.0
      do j=2,nps 
         cmix(j)=k*yp(j)*(1-expy0a(j))
         edvo=edvo+(up(nps)-up(j))*(yp(j)-yp(j-1))
      enddo
      edvo=edvo*0.0168*rey
      do j = 1,nps
         c1= cmix(j)**2*rey
         c2= (1.0-yp(j))*rey*f/8.0
         c0= c1 * c2
         edvi(j) = -0.5 + sqrt(0.25+c0)
      enddo
c
      up(1)  =0.0
      dudy(1)=(1.0-yp(1))/(1.0+edvi(1))*rey*f/8.0
      iflg   = 0
      edv(1) = edvi(1)
      do j=2,nps 
         if(iflg .eq. 0 ) then
            if(edvi(j) .le. edvo) then
               edv(j)= edvi(j) 
            else
               edv(j)= edvo   
               iflg  = 1
            endif
         else
            edv(j)= edvo   
         endif
         dudy(j)=(1.0-yp(j))/(1.0+edv(j))*rey*f/8.0
         up(j)=up(j-1)+0.5*(dudy(j)+dudy(j-1))*(yp(j)-yp(j-1))
      enddo
c
      dudym= -99999.
      jm   = 1
      do j = 1,nps
         up(j) = 0.5 * (up(j) + ups(j))
         dudy(j) = 0.5 * (dudy(j) + dudys(j))
         dudyj   = abs(dudy(j)-dudys(j))
         if(dudyj.gt. dudym) then
            dudym = dudyj
            jm    = j
         endif
         ups(j)  = up(j)
         dudys(j)= dudy(j)
      enddo
c
      upm(iter) = up(nps)
      if(iter .gt. 1) then
c
c  check for inner loop convergence
c
         dupm = (upm(iter) - upm(iter-1))
         if(abs(dupm) .gt. 0.0005 .or. abs(dudym/dudy(1)) 
     1       .gt. 0.0005 ) then 
            if(iter.lt.itmax) then
               iter = iter + 1
               goto 15
            else
               write(6,*) 'sol. fails to converge. cal. stop'
               stop
            endif
         endif
      else
         iter = iter + 1
         goto 15
      endif
c
c  inner loop has converged; check for mass flux 
c
      ggn = 0.0
      ru1 = (1.-yp(1))*up(1)
      do j = 2,nps
         ru2 = (1.-yp(j))*up(j)
         ggn = ggn + (ru1  +ru2)*(yp(j) - yp(j-1))
         ru1 = ru2
      enddo
      err= ggn-1.0
      write(6,130)itl ,ggn,err,f 
 130  format(3x,'itl,mass flux,err,f',i5,3e13.5)
c
      if(abs(err) .gt. errm) then
         ggns(itl) = ggn-1.0 
         fs  (itl) = f
         if(itl .lt. itmax) then
            if(itl .eq. 1) then
               f = 1.025 * f
            else
               prod = ggns(itl) * ggns(itl-1)
               if(prod .gt. 0.0) then
                  df= (fs(itl)-fs(itl-1))/(ggns(itl)-ggns(itl-1))
     1                   *(0.0 - ggns(itl))
                  f = fs(itl)+0.50*df
                  if(abs(ggns(itl)) .gt. abs(ggns(itl-1))) then
                      ggns(itl) = ggns(itl-1)
                      fs(itl)   = fs(itl-1)
                  endif
               else
                  f = 0.5 * (fs(itl) + fs(itl-1))
               endif
            endif
            itl = itl + 1
            iter= 1
c
c  calculate expyoas & expyobs because of the change in f
c 
            cy0a=0.5*rey/aplus*sqrt(0.5*f)
            cy0b=cy0a*aplus/bplus
            do j=1,nps
               y0a(j)=yp(j)*cy0a
               expy0a(j)=0.0
               expy0b(j)=0.0
               y0b(j)=yp(j)*cy0b
               if(y0a(j).lt.50.0) expy0a(j)=exp(-y0a(j))
               if(y0b(j).lt.50.0) expy0b(j)=exp(-y0b(j))
               if(j .gt. 1)
     1            prts(j)=k/kh*(1.-expy0a(j))/(1.0-expy0b(j))
            enddo
            goto 15
         else
            write(6,*) 'mass flux fails to converge.  cal. stops' 
            stop
         endif
      endif
c
c  solutions converges. save data
c
      write(6,1111)
1111  format('cal. trubulent profiles : j,yp,prt,edv,dudy,up')
      do j = 1,nps
         edvs(j) = edv(j)
         dudys(j)= dudy(j)
         ups(j)  = up(j)
         write(6,1112) j,yps(j),prts(j),edv(j),dudy(j),up(j)
1112     format(i5,5e13.5)
      enddo
      return
      end
      subroutine output
      common/blc0/nxt,iwbcoe,iebcoe,iturb,icoord,index,n,np,npt,igwall,
     +        pr,vgp,gwa,rey,cel,eta(81),up(81),deta(81),a(81),yp(81),
     +        x(101),gw(101),pw(101),ge(101),g(81,2),p(81,2)
      common/blc1/ s1(81),s2(81),s3(81),r1(81),r2(81),a1(81,2),a2(81,2)
     +            ,etae
      common /blcs/ anu(101), ag(101), xsave(101)
c
c print out dimensionless temperature profile
c
      xsave(n) = x(n)
      write(6,9100) (j,eta(j),g(j,2),p(j,2),up(j),yp(j),j=1,np)
      if(n.eq.1) go to 15
c
c calculate and print out dimensionless mix temperature and nusselt #
c
      if(icoord.eq.2) then
         cnuxo=2.0*p(1,2)
         c=0.0
      else
         c=1.0
         cnuxo=2.0*p(1,2)/sqrt(x(n))
      endif
c
      gmix=0.0
      f2  =0.0
      do j=2,np
         f1=f2
         f2=2.*(1.-yp(j))*up(j)*(g(j,2)-c)
         gmix=gmix+0.5*(f1+f2)*(yp(j)-yp(j-1))
      enddo
      gmix=gmix+c
      cnuxm=cnuxo/(gmix-g(1,2))
      write(6,9200)gmix,cnuxm
      write(9,9500)x(n),cnuxm
      ag(n)  = gmix
      anu(n) = cnuxm
c
  15  if(n.eq.nxt) then
         write (6,9555) (i, xsave(i), ag(i), anu(i), i = 2, nxt)
 9555    format(///2x, 'result summary'/
     1    /2x, 'i', 6x, 's ', 10x, 'gmix', 10x, 'nu'/ (i3, 3e12.4))
         stop
      endif
c
c  check for switch location
c
      eps = 1.e-7
      if(icoord.eq.1) then
         if(index .eq. 0) then
            xswitch = 1./eta(np)**2
            if(x(n+1).ge.(xswitch-eps)) then
               x(n+1) = xswitch
               x(n+2) = 0.25*(x(n+1)+2.*x(n+2)+x(n+3))
               index  = 1
            endif
            etae = eta(np)
         else
c
c switch to primitive variables
c
            sqx=sqrt(x(n))
            do j=1,np
               eta(j)=eta(j)*sqx
               deta(j)=deta(j)*sqx
               p(j,2)=p(j,2)/sqx
               if(j.gt.1) a(j)=0.5*deta(j-1)
            enddo
            icoord= 2
            iebcoe= 0
            index = 0
            write(6,9300)
         endif
      endif
c
c shift profiles for next station calculation
c
      if(iwbcoe.eq.0 .and. n .le. 10 .and. n.gt.1) then
         do j=1,npt
            g(j,1)=0.5*(g(j,1)+g(j,2))
            p(j,1)=0.5*(p(j,1)+p(j,2))
            a1(j,1)=0.5*(a1(j,2)+a1(j,1))
            a2(j,1)=0.5*(a2(j,2)+a2(j,1))
         enddo
         x(n)= 0.5 * (x(n) + x(n-1))
      else
         do j=1,npt
            g(j,1)=g(j,2)
            p(j,1)=p(j,2)
            a1(j,1)=a1(j,2)
            a2(j,1)=a2(j,2)
         enddo
      endif
      n  = n + 1
      return
c
c----------------------------------------------------------------------
c
 9100 format(1h0,2x,1hj,3x,3heta,10x,1hg,13x,1hp,12x,2hup,12x,2hyp/
     1       (1h ,i3,f10.5,4e14.6))
 9200 format(1h0,6hgmix =,e14.6,3x,6hnuxm =,e14.6)
 9300 format(1h0,31h***** primitive variables *****)
 9500 format(2e14.6)
      end


      subroutine solv2
      common/blc0/nxt,iwbcoe,iebcoe,iturb,icoord,index,n,np,npt,igwall,
     +        pr,vgp,gwa,rey,cel,eta(81),up(81),deta(81),a(81),yp(81),
     +        x(101),gw(101),pw(101),ge(101),g(81,2),p(81,2)
      common/blc1/ s1(81),s2(81),s3(81),r1(81),r2(81),a1(81,2),a2(81,2)
     +            ,etae
      dimension g11(81),g12(81),a11(81),a12(81),a21(81),a22(81),w1(81),
     1          w2(81),den(81)
c----------------------------------------------------------------------
      if(iwbcoe.eq.0) go to 10
c*****specified wall temperature boundary condition***************
      alfa0=1.0
      alfa1=0.0
      g(1,2)= gw(n)
      p(1,2)= 0.0
      go to 20
c
c*****specified wall heat flux*********************************
  10  alfa0=0.0
      alfa1=1.0
      g(1,2)=0.0
      p(1,2)=pw(n)
  20  gamma0=alfa0*g(1,2)+alfa1*p(1,2)
      r1(1)=gamma0
      if(iebcoe.eq.0) go to 30
c*****specified edge temperature
      beta0=1.0
      beta1=0.0
      g(np,2)=ge(n)
      p(np,2)=0.0
      go to 40
c*****specified edge temperature gradient*********************
  30  beta0=0.0
      beta1=1.0
      g(np,2)=0.0
      p(np,2)=0.0
  40  gamma1=beta0*g(np,2)+beta1*p(np,2)
      r2(np)=gamma1
c*****  w  elements for j=1
      w1(1)=r1(1)
      w2(1)=r2(1)
c*****  alfa elements for j=1***********************************
      a11(1)=alfa0
      a12(1)=alfa1
      a21(1)=-1.0
      a22(1)=-0.5*deta(1)
c*****  gamma elements for j=2*******************************
      det=alfa1-0.5*deta(1)*alfa0
      g11(2)=(s2(2)-0.5*deta(1)*s3(2))/det
      g12(2)=(alfa0*s2(2)-alfa1*s3(2))/det
c*****  forward sweep***************************************
      do 60 j=2,np
      den(j)=a11(j-1)*a22(j-1)-a21(j-1)*a12(j-1)
      if(j.eq.2) go to 50
      g11(j)=(s3(j)*a22(j-1)-s2(j)*a21(j-1))/den(j)
      g12(j)=(s2(j)*a11(j-1)-s3(j)*a12(j-1))/den(j)
 50   a11(j)=s3(j)-g12(j)
      a12(j)=s1(j)+a(j)*g12(j)
      a21(j)=-1.0
      a22(j)=-a(j+1)
      w1(j)=r1(j)-g11(j)*w1(j-1)-g12(j)*w2(j-1)
      w2(j)=r2(j)
  60  continue
c*****  backward sweep**************************************
      deno=a11(np)*beta1-a12(np)*beta0
      g(np,2)=(w1(np)*beta1-w2(np)*a12(np))/deno
      p(np,2)=(w2(np)*a11(np)-beta0*w1(np))/deno
      j=np
  70  j=j-1
      e1=w2(j)-g(j+1,2)+a(j+1)*p(j+1,2)
      g(j,2)=(w1(j)*a22(j)-e1*a12(j))/den(j+1)
      p(j,2)=(e1*a11(j)-w1(j)*a21(j))/den(j+1)
      if(j.gt.1) go to 70
      return
      end
