C     MAIN  panel.f
      COMMON /BOD/ NODTOT,X(201),Y(201),
     +             XMID(200),YMID(200),COSTHE(200),SINTHE(200)
      COMMON /NUM/ PI,PI2INV
      DIMENSION TITLE(20)
	CHARACTER*80 input_name, output_name

      PI      = 3.1415926585
      PI2INV  = .5/PI
	WRITE(6,*) "Enter input file name (include extension name)"
	READ(5,*) input_name
	OPEN(unit=55,file=input_name,STATUS="OLD")
	WRITE(6,*) "Enter output file name"
	READ(5,*) output_name
	OPEN(unit=66,file=output_name)               

      READ (55,*) NODTOT
      READ (55,*)(X(I),I=1,NODTOT+1)
      READ (55,*)(Y(I),I=1,NODTOT+1)
      DO 100  I = 1,NODTOT
C     XMI AND YMI
      XMID(I) = .5*(X(I) + X(I+1))
      YMID(I) = .5*(Y(I) + Y(I+1))
      DX      = X(I+1) - X(I)
      DY      = Y(I+1) - Y(I)
      DIST    = SQRT(DX*DX +DY*DY)
C     
      SINTHE(I) = DY/DIST
      COSTHE(I) = DX/DIST
 100  CONTINUE
      READ (55,*) ALPHA
      WRITE (66,1030) ALPHA
 1030 FORMAT (//,' SOLUTION AT ALPHA = ',F10.5,/)
      COSALF  = COS(ALPHA*PI/180.)
      SINALF  = SIN(ALPHA*PI/180.)
      CALL COEF(SINALF,COSALF)
      CALL GAUSS(1)
      CALL VPDIS(SINALF,COSALF)
      CALL CLCM(SINALF,COSALF)
      STOP
      END

      SUBROUTINE COEF(SINALF,COSALF)
      COMMON /BOD/ NODTOT,X(201),Y(201),
     +             XMID(200),YMID(200),COSTHE(200),SINTHE(200)
      COMMON /COF/ A(201,201),BV(201),KUTTA
      COMMON /NUM/ PI,PI2INV
      KUTTA   = NODTOT + 1
      DO 90   J = 1,KUTTA
 90   A(KUTTA,J)   = 0.0
      DO 120  I = 1,NODTOT
      A(I,KUTTA) = 0.0
      DO 110  J = 1,NODTOT
      FLOG    = 0.0
      FTAN    = PI
      IF (J .EQ. I)     GO TO 100
      DXJ     = XMID(I) - X(J)
      DXJP    = XMID(I) - X(J+1)
      DYJ     = YMID(I) - Y(J)
      DYJP    = YMID(I) - Y(J+1)
C     FLOG IS LN(R(I,J+1)/R(I,J))
      FLOG    = .5*ALOG((DXJP*DXJP+DYJP*DYJP)/(DXJ*DXJ+DYJ*DYJ))
C     FTAN IS BETA(I,J)
      FTAN    = ATAN2(DYJP*DXJ-DXJP*DYJ,DXJP*DXJ+DYJP*DYJ)
C     CTIMTJ IS COS(THETA(I)-THETA(J))
 100  CTIMTJ  = COSTHE(I)*COSTHE(J) + SINTHE(I)*SINTHE(J)
C     STIMTJ IS SIN(THETA(I)-THETA(J))
      STIMTJ  = SINTHE(I)*COSTHE(J) - COSTHE(I)*SINTHE(J)
C     ELEMENTS OF THE COEFFICEINT MATRIX, A(I,J)
      A(I,J)  = PI2INV*(FTAN*CTIMTJ + FLOG*STIMTJ)
      B       = PI2INV*(FLOG*CTIMTJ - FTAN*STIMTJ)
C     ELEMENTS OF THE COEFFICEINT MATRIX, A(I,N+1)
      A(I,KUTTA) = A(I,KUTTA) + B
      IF ((I .GT. 1) .AND. (I .LT. NODTOT))GO TO 110
C     ELEMENTS OF THE COEFFICEINT MATRIX, A(N+1,J)
      A(KUTTA,J) = A(KUTTA,J) - B
C     ELEMENT OF THE COEFFICEINT MATRIX, A(N+1,N+1)
      A(KUTTA,KUTTA) = A(KUTTA,KUTTA) + A(I,J)
 110  CONTINUE
C     ELEMENTS OF VECTOR B FOR I=1,...,N, 
      BV(I) = SINTHE(I)*COSALF - COSTHE(I)*SINALF
 120  CONTINUE
C     ELEMENT OF VECTOR B FOR I=N+1, 
      BV(KUTTA) = - (COSTHE(1) + COSTHE(NODTOT))*COSALF
     +                   - (SINTHE(1) + SINTHE(NODTOT))*SINALF
      RETURN
      END

      SUBROUTINE CLCM(SINALF,COSALF)
      COMMON /BOD/ NODTOT,X(201),Y(201),
     +             XMID(200),YMID(200),COSTHE(200),SINTHE(200)
      COMMON /CPD/ UE(200),CP(200)
      CFX     = 0.0
      CFY     = 0.0
      CM      = 0.0
      DO 100  I = 1,NODTOT
      DX      = X(I+1) - X(I)
      DY      = Y(I+1) - Y(I)
      CFX     = CFX + CP(I)*DY
      CFY     = CFY - CP(I)*DX
      CM      = CM + CP(I)*(DX*XMID(I) + DY*YMID(I))
 100  CONTINUE
      CL      = CFY*COSALF - CFX*SINALF
      WRITE (66,1000) CL,CM
 1000 FORMAT(//,'    CL =',F10.5,'    CM =',F10.5)
      RETURN
      END

      SUBROUTINE GAUSS(M)
      COMMON /COF/ A(201,201),B(201,1),N
      DO 100  K = 1,N-1
      KP      = K + 1
      DO 100  I = KP,N
      R       = A(I,K)/A(K,K)
      DO 200  J = KP,N
 200  A(I,J)  = A(I,J) - R*A(K,J)
      DO 100  J = 1,M
 100  B(I,J)    = B(I,J) - R*B(K,J)
      DO 300  K = 1,M
      B(N,K) = B(N,K)/A(N,N)
      DO 300  I = N-1,1,-1
      IP      = I + 1
      DO 400  J = IP,N
 400  B(I,K)    = B(I,K) - A(I,J)*B(J,K)
 300  B(I,K)    = B(I,K)/A(I,I)
      RETURN
      END

      SUBROUTINE VPDIS(SINALF,COSALF)
      COMMON /BOD/ NODTOT,X(201),Y(201),
     +             XMID(200),YMID(200),COSTHE(200),SINTHE(200)
      COMMON /COF/ A(201,201),BV(201),KUTTA
      COMMON /CPD/ UE(200),CP(200)
      COMMON /NUM/ PI,PI2INV
      DIMENSION Q(200)
      WRITE (66,1000)
      DO 50   I = 1,NODTOT
 50   Q(I)    = BV(I)
      GAMMA   = BV(KUTTA)
      DO 130  I = 1,NODTOT
C     CONTRIBUTION TO VT(I) FROM FREESTREAM VELOCITY, 
      VTANG   = COSALF*COSTHE(I) + SINALF*SINTHE(I)
      DO 120  J = 1,NODTOT
      FLOG    = 0.0
      FTAN    = PI
      IF (J .EQ. I) GO TO 100
      DXJ     = XMID(I) - X(J)
      DXJP    = XMID(I) - X(J+1)
      DYJ     = YMID(I) - Y(J)
      DYJP    = YMID(I) - Y(J+1)
C     FLOG IS LN(R(I,J+1)/R(I,J)),
      FLOG    = .5*ALOG((DXJP*DXJP+DYJP*DYJP)/(DXJ*DXJ+DYJ*DYJ))
C     FTAN IS BETA(I,J), 
      FTAN    = ATAN2(DYJP*DXJ-DXJP*DYJ,DXJP*DXJ+DYJP*DYJ)
C     CTIMTJ IS COS(THETA(I)-THETA(J))
 100  CTIMTJ  = COSTHE(I)*COSTHE(J) + SINTHE(I)*SINTHE(J)
C     STIMTJ IS SIN(THETA(I)-THETA(J))
      STIMTJ  = SINTHE(I)*COSTHE(J) - COSTHE(I)*SINTHE(J)
C     AA IS BT(I,J)=AN(I,J), 
      AA      = PI2INV*(FTAN*CTIMTJ + FLOG*STIMTJ)
C     B IS -AT(I,J), 
      B       = PI2INV*(FLOG*CTIMTJ - FTAN*STIMTJ)
C     CONTRIBUTION TO VT(I) FROM SINGULARITIES, 
      VTANG   = VTANG - B*Q(J) +GAMMA*AA
 120  CONTINUE
      CP(I)   = 1.0 - VTANG*VTANG
      UE(I)   = VTANG
C     WRITE (6,1050) I,XMID(I),YMID(I),Q(I),GAMMA,CP(I),UE(I)
	WRITE (66,1050) I,XMID(I),YMID(I),CP(I),UE(I)
 130  CONTINUE
 1000 FORMAT(4X,'J',4X,'X(J)',6X,'Y(J)',6X,'CP(J)',6X,'UE(J)',/)
C1000 FORMAT(/,4X,'J',4X,'X(J)',6X,'Y(J)',6X,'Q(J)',5X,'GAMMA',5X,
C    + 'CP(J)',6X,'V(J)',/)

 1050 FORMAT(I5,4F10.5)
 1055 FORMAT(3F10.5)
C1050 FORMAT(I5,6F10.5)
      RETURN
      END
