C*********************************************************************
C
C      11.2 FORTRAN PROGRAM FOR COMPRESSIBLE BOUNDARY LAYER FLOWS
C
C*********************************************************************
C     MAIN                                                                      
      PARAMETER(NXM=200, NYM=201)
      COMMON /INPT2/ ETAE,VGP                                                   
      COMMON /BLC0/ NP,NPT,NX,NXT,NTR,IT,IFLAG                                  
      COMMON /AK1/ RMUI,TI,RMI,UI,PR,HE                                         
      COMMON /GRD/ X(NXM),ETA(NYM),DETA(NYM),A(NYM),T(NYM),THE(NYM)    
      COMMON /BLC3/ DELF(NYM),DELU(NYM),DELV(NYM),DELG(NYM),DELP(NYM)
      COMMON /BLC1/ 
     +  F(NYM,2),U(NYM,2),V(NYM,2),B(NYM,2),G(NYM,2),P(NYM,2),
     +  C(NYM,2),D(NYM,2),E(NYM,2),RMU(NYM),BC(NYM),CP(NYM,2)
      COMMON /EDGE/ UE(NXM),TE(NXM),RHOE(NXM),RMUE(NXM),
     +    PE(NXM),P1(NXM),P2(NXM)        

      COMMON /SAVE1/ RXSAVE(NXM),DELSSAVE(NXM),THETASAVE(NXM),
     +    HSAVE(NXM),CF2SAVE(NXM),RDELSSAVE(NXM),RTHETASAVE(NXM) 
      
      SAVE
C                                                                               
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -         
C                                                                               
      OPEN(UNIT=5,FILE='pr11_2Inp.txt',STATUS='OLD')
      OPEN(UNIT=6,FILE='pr11_2Out.txt')
      NPT = NYM
      ITMAX = 6                                                                 
      NX    = 1                                                                 
      CALL INPUT                                                                
C                                                                               
C  GRID GENERATION                                                              
      IF((VGP-1.0) .LE. 0.001) GO TO 5                                          
      NP    = ALOG((ETAE/DETA(1))*(VGP-1.0)+1.0)/ALOG(VGP) + 1.0001             
      GO TO 10                                                                  
5     NP    = ETAE/DETA(1) + 1.0001                                             
10    IF(NP .LE. NPT) GO TO 15                                                   
      WRITE(6,9000)                                                             
      STOP                                                                      
15    ETA(1)= 0.0                                                               
      DO 20 J=2,NPT                                                             
      DETA(J)=VGP*DETA(J-1)                                                     
      A(J)  = 0.5*DETA(J-1)                                                     
20    ETA(J)= ETA(J-1)+DETA(J-1)                                                
      CALL IVPL                                                                 
C                                                                               
30    WRITE(6,9100) NX,X(NX)                                                    
      IT    = 0                                                                 
40    IT    = IT+1                                                              
C                                                                               
C  FLUID PROPERTIES                                                             
11    DO 51 J=1,NP                                                              
      T(J) = (HE*G(J,2) - 0.5*(UE(NX)*U(J,2))**2)/1004.3                        
      RMU(J) = 1.45E-6*(T(J)**1.5)/(T(J) + 110.33)                              
      C(J,2) = T(J)/TE(NX)                                                      
      BC(J) = RMU(J)/RMUE(NX)/C(J,2)                                            
      D(J,2) = BC(J)*(UE(NX)**2)*(1.0 - 1.0/PR)/HE                              
C                                                                               
      IF(NX .GE. NTR) GO TO 51                                                  
      B(J,2) = BC(J)                                                            
      E(J,2) = BC(J)/PR                                                         
51    CONTINUE                                                                  
      IF (IT .LE.  ITMAX) GO TO 60                                              
      WRITE(6,2500)                                                             
      GO TO 130
      STOP                                                                      
C                                                                               
60    IF(NX .GE. NTR) CALL EDDY                                                 
      CALL COEF                                                                 
      CALL SOLV5                                                                
      WRITE (6,3000) V(1,2), DELV(1)                                            
C                                                                               
C  CHECK FOR CONVERGENCE                                                        
      IF(NX .GE. NTR) GO TO 80                                                  
C   LAMINAR FLOW                                                                
      IF(ABS(DELV(1)) .GT. 1.0E-05) GO TO 40                                    
      GO TO 100                                                                 
C   TURBULENT FLOW                                                              
80    IF(ABS(DELV(1)/(V(1,2)+0.5*DELV(1))) .GT. 0.02) GO TO 40                  
C                                                                               
C  CHECK FOR GROWTH                                                             
100   IF(V(1,2) .LT. 0.0) THEN
        WRITE(6, *) "FLOW SEPARATED"
        STOP                                                  
      ENDIF
      IF(NP .EQ. NPT) GO TO 120                                                 
      IF(ABS(V(NP,2)) .LE. 1.0E-03) GO TO 120                                   
      NPO   = NP                                                                
      NP1   = NP+1                                                              
      NP    = NP+1                                                              
      IF(NP .GT. NPT) NP = NPT                                                  
C                                                                               
C  DEFINITION OF PROFILES FOR NEW NP                                            
      DO 110 L=1,2                                                              
      DO 110 J=NP1,NP                                                           
      F(J,L) = F(NPO,L) + ETA(J) - ETA(NPO)                                     
      U(J,L) = 1.0                                                              
      V(J,L) = 0.0                                                              
      B(J,L)= B(NPO,L)                                                          
      G(J,L)= G(NPO,L)                                                          
      P(J,L)= 0.0                                                               
      C(J,L) = C(NPO,L)                                                         
      D(J,L) = D(NPO,L)                                                         
      E(J,L) = E(NPO,L)                                                         
110   CONTINUE                                                                  
      IT    = 0                                                                 
      GO TO 40                                                                  
120   CALL OUTPUT                                                               
      GO TO 30                                                                  
130   WRITE(6,9300)(I, X(I), RXSAVE(I),DELSSAVE(I),THETASAVE(I),HSAVE(I)
     +            ,CF2SAVE(I),RDELSSAVE(I),RTHETASAVE(I), I= 1, NX-1) 
9300  FORMAT(///2X,'*** BOUNDARY LAYER PARAMETERS  '/
     +  /3X,'NX',5X,'S',
     +  8X,'RX',8X,'DELS',6X,'THETA',8X,'H',9X,'CF2',7X,'RDELS',
     +  6X,'RTHETA',/
     +  (I5, F8.4, 7E11.4))
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -         
2500  FORMAT(1H0,16X,25HITERATIONS EXCEEDED ITMAX)                              
3000  FORMAT(1H ,8HV(WALL)=,E13.6,1X,6HDELV =,E13.6)                            
9000  FORMAT(1H0,'  NP EXCEEDED NPT -- PROGRAM TERMINATED')                     
9100  FORMAT(1H0,4HNX =,I3,5X,3HX =,F10.3)                                      
      END                                                                       

      SUBROUTINE INPUT                                                          
      PARAMETER(NXM=200, NYM=201)
      COMMON /INPT2/ ETAE,VGP                                                   
      COMMON /AK1/ RMUI,TI,RMI,UI,PR,HE                                         
      COMMON /INPT1/ WW(NXM),ALFA0,ALFA1  
      COMMON /BLC0/ NP,NPT,NX,NXT,NTR,IT,IFLAG                                  
      COMMON /GRD/ X(NXM),ETA(NYM),DETA(NYM),A(NYM),T(NYM),THE(NYM)
      COMMON /EDGE/ UE(NXM),TE(NXM),RHOE(NXM),
     +              RMUE(NXM),PE(NXM),P1(NXM),P2(NXM)        
      DIMENSION XC(NXM), YC(NXM)

      SAVE

C                                                                               
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -         
C                                                                               
C     ALFA0 = 1.0  ,  ALFA1 = 0.0    SPECIFIED WALL TEMP                        
C     ALFA0 = 0.0  ,  ALFA1 = 1.0    SPECIFIED HEAT FLUX                        
C     WW  EITHER G(1,2) FOR WALL TEMP. SPECIFIED                                
C         OR     P(1,2) FOR HEAT FLUX SPECIFIED                                 
      ETAE = 8.0                                                                

      READ(5,*) NXT,NTR,P2(1),DETA(1),VGP                                    
C     READ(5,*) RMI,TI,PI,PR,ALFA0,ALFA1                                   
      READ(5,*) RMI,TI,RI,PR,ALFA0,ALFA1                                   
      READ(5,*) (XC(I),I=1,NXT)                                   
      READ(5,*) (YC(I),I=1,NXT)                                   
      READ(5,*) (UE(I),I=1,NXT)                                   
C  CALCULATION OF SURFACE DISTANCE
      X(1)=0.0
      DO I=2,NXT
        X(I) = X(I-1)+SQRT((XC(I)-XC(I-1))**2+(YC(I)-YC(I-1))**2)
      ENDDO
      
C     READ(5,8000) NXT,NTR,P2(1),DETA(1),VGP                                    
C     READ(5,8100) RMI,TI,PI,PR,ALFA0,ALFA1                                   
C     READ(5,8200) (X(I),UE(I),WW(I),I=1,NXT)                                   
      WRITE(6,9010)                                                             
C                                                                               
C   FREE-STREAM CONDITIONS                                                      
      RMUI = 1.45E-6*(TI**1.5)/(TI+110.33)                                      
      UI = 20.04*RMI*SQRT(TI)                                                   
      RHOI = RMUI*RI/UI 
Cshao RHOI = PI/TI/287
      PI = RHOI * TI *287.0 
      HE = 1004.3*TI + 0.5*UI**2                                                
      WRITE(6,9100) RMI,TI,PI,UI,RHOI,HE,NTR                               
C                                                                               
C   EDGE CONDITIONS                                                             
      DO 20 I=1,NXT                                                             
CCC   UE(I) = UE(I)/UI                                                          
      TE(I) = TI*(1.0 - 0.2*(RMI**2)*(UE(I)**2 - 1.0))                          
      RMUE(I) = 1.45E-6*(TE(I)**1.5)/(TE(I)+110.33)                             
      PE(I) = PI*(TE(I)/TI)**3.5                                                
      RHOE(I) = PE(I)/(287.0*TE(I))                                             
      UE(I) = UI*UE(I)                                                          
20    CONTINUE                                                                  
C                                                                               
C  CALCULATION OF PRESSURE-GRADIENT PARAMETER P=P2                              
      P1(1) = 0.5*(P2(1) + 1.0)                                                 
      DO 80 I=2,NXT                                                             
      IF(I .EQ. NXT) GO TO 60                                                   
      A1    = (X(I)-X(I-1))*(X(I+1)-X(I-1))                                     
      A2    = (X(I)-X(I-1))*(X(I+1)-X(I))                                       
      A3    = (X(I+1)-X(I))*(X(I+1)-X(I-1))                                     
      DUDS  = -(X(I+1)-X(I))/A1*UE(I-1) + (X(I+1)-2.0*X(I)+X(I-1))/             
     +             A2*UE(I) + (X(I)-X(I-1))/A3*UE(I+1)                          
      GO TO 70                                                                  
60    A1    = (X(I-1)-X(I-2))*(X(I)-X(I-2))                                     
      A2    = (X(I-1)-X(I-2))*(X(I)-X(I-1))                                     
      A3    = (X(I)-X(I-1))*(X(I)-X(I-2))                                       
      DUDS  = (X(I)-X(I-1))/A1*UE(I-2) - (X(I)-X(I-2))/A2*UE(I-1) +             
     +             (2.0*X(I)-X(I-2)-X(I-1))/A3*UE(I)                            
70    P2(I) = X(I)/UE(I)*DUDS                                                   
      P1(I) = 0.5*(1.0 + P2(I) + X(I)*(RHOE(I)*RMUE(I) - RHOE(I-1)*             
     +             RMUE(I-1))/(X(I)-X(I-1))/RHOE(I)/RMUE(I))                    
80    CONTINUE                                                                  
90    WRITE(6,9200) (I,UE(I),TE(I),RHOE(I),RMUE(I),P1(I),P2(I),I=1,NXT)         
      WRITE(6,9300)                                                             
      RETURN                                                                    
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -         
8000  FORMAT(2I3,3F10.5)                                                        
8100  FORMAT(3F10.5,3F10.1)                                                     
8200  FORMAT(3F10.7)                                                            
9000  FORMAT(1H0,6HNXT  =,I3,14X,6HNTR  =,I3/1H ,6HDETA1=,E14.6,3X,             
     +            6HVGP  =,E14.6,3X,3HPR=,F7.3)                                 
9010  FORMAT(1H0,30X,'INPUT DATA'///)                                           
9100  FORMAT(1H0,'MACH NO =',E12.5,3X,'T INF. =',E12.5,3X,'PI =',               
     +       E12.5/1H0,'UI =',E12.5,3X,'RHOI =',              
     +       E12.5,3X,'HE =',E12.5,3X,'NTR= ',I3)   
9300  FORMAT(1H0,30X,'OUTPUT DATA'///)                                          
9200  FORMAT(1H0,2HNX,8X,2HUE,13X,2HTE,12X,4HRHOE,11X,4HRMUE,12X,2HP1,          
     +              13X,2HP2/(1H ,I3,6E15.5))                                   
      END                                                                       
      SUBROUTINE SOLV5                                                          
      PARAMETER(NXM=200, NYM=201)
      COMMON /INPT1/ WW(NXM),ALFA0,ALFA1                                         
      COMMON /BLC0/ NP,NPT,NX,NXT,NTR,IT,IFLAG                                  
      COMMON /GRD/ X(NXM),ETA(NYM),DETA(NYM),A(NYM),T(NYM),THE(NYM)                   
      COMMON /BLC1/ 
     +    F(NYM,2),U(NYM,2),V(NYM,2),B(NYM,2),G(NYM,2),P(NYM,2),
     +    C(NYM,2),D(NYM,2),E(NYM,2),RMU(NYM),BC(NYM),CP(NYM,2)
      COMMON /BLC3/ DELF(NYM),DELU(NYM),DELV(NYM),DELG(NYM),DELP(NYM)                
      COMMON/BLC6/ 
     +    S1(NYM),S2(NYM),S3(NYM),S4(NYM),S5(NYM),S6(NYM),S7(NYM),
     +    S8(NYM),B1(NYM),B2(NYM),B3(NYM),B4(NYM),B5(NYM),B6(NYM),
     +    B7(NYM),B8(NYM),B9(NYM),B10(NYM),R(5,NYM) 
      DIMENSION    
     +    A11(NYM),A12(NYM),A13(NYM),A14(NYM),A15(NYM),A21(NYM),
     +    A22(NYM),A23(NYM),A24(NYM),A25(NYM),A31(NYM),A32(NYM),
     +    A33(NYM),A34(NYM),A35(NYM),G11(NYM),G12(NYM),G13(NYM),
     +    G14(NYM),G15(NYM),G21(NYM),G22(NYM),G23(NYM),G24(NYM),
     +    G25(NYM),G31(NYM),G32(NYM),G33(NYM),G34(NYM),G35(NYM),
     +    W1(NYM),W2(NYM),W3(NYM),W4(NYM),W5(NYM)              

      SAVE

C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -         
C  ELEMENTS OF TRIANGLE MATRIX                        
      A11(1)=1.0                                                                
      A12(1)=0.0                                                                
      A13(1)=0.0                                                                
      A14(1)=0.0                                                                
      A15(1)=0.0                                                                
C                                                                               
      A21(1)=0.0                                                                
      A22(1)=1.0                                                                
      A23(1)=0.0                                                                
      A24(1)=0.0                                                                
      A25(1)=0.0                                                                
C                                                                               
      A31(1)=0.0                                                                
      A32(1)=0.0                                                                
      A33(1)=0.0                                                                
      A34(1)=ALFA0                                                              
      A35(1)=ALFA1                                                              
C                                                                               
C  ELEMENTS O  W-VECTOR      
      W1 (1)=R(1,1)                                                             
      W2 (1)=R(2,1)                                                             
      W3 (1)=R(3,1)                                                             
      W4 (1)=R(4,1)                                                             
      W5 (1)=R(5,1)                                                             
C - FORWARD SWEEP                                                               
C  DEFINITIONS                                                                  
      DO 30 J=2,NP                                                              
      AA1=A(J)*A24(J-1)-A25(J-1)                                                
      AA2=A(J)*A34(J-1)-A35(J-1)                                                
      AA3=A(J)*A12(J-1)-A13(J-1)                                                
      AA4=A(J)*A22(J-1)-A23(J-1)                                                
      AA5=A(J)*A32(J-1)-A33(J-1)                                                
      AA6=A(J)*A14(J-1)-A15(J-1)                                                
      AA7=A(J)*S6(J)-S2(J)                                                      
      AA8=S8(J)*A(J)                                                            
      AA9=A(J)*B6(J)-B10(J)                                                     
      AA10=A(J)*B8(J)-B2(J)                                                     
C                                                                               
C  ELEMENTS OF TRIANGLE MATRIX
      DET=A11(J-1)*(AA4*AA2-AA1*AA5)-A21(J-1)*(AA3*AA2-AA5*AA6)+                
     +         A31(J-1)*(AA3*AA1-AA4*AA6)                                       
      G11(J)=(-(AA4*AA2-AA5*AA1)+A(J)**2*(A21(J-1)*AA2-A31(J-1)*AA1))/          
     +            DET                                                           
      G12(J)=((AA3*AA2-AA5*AA6)-A(J)**2*(A11(J-1)*AA2-A31(J-1)*AA6))/DET        
      G13(J)=(-(AA3*AA1-AA4*AA6)+A(J)**2*(A11(J-1)*AA1-A21(J-1)*AA6))/          
     +            DET                                                           
      G14(J)=G11(J)*A12(J-1)+G12(J)*A22(J-1)+G13(J)*A32(J-1)+A(J)               
      G15(J)=G11(J)*A14(J-1)+G12(J)*A24(J-1)+G13(J)*A34(J-1)                    
      G21(J)=(S4(J)*(AA2*AA4-AA1*AA5)+A31(J-1)*(AA1*AA7-AA4*AA8)+               
     +            A21(J-1)*(AA5*AA8-AA7*AA2))/DET                               
      G22(J)=(A11(J-1)*(AA2*AA7-AA5*AA8)+A31(J-1)*(AA3*AA8-AA6*AA7)+            
     +            S4(J)*(AA5*AA6-AA2*AA3))/DET                                  
      G23(J)=(A11(J-1)*(AA4*AA8-AA1*AA7)+S4(J)*(AA3*AA1-AA4*AA6)+               
     +            A21(J-1)*(AA7*AA6-AA3*AA8))/DET                               
      G24(J)=G21(J)*A12(J-1)+G22(J)*A22(J-1)+G23(J)*A32(J-1)-S6(J)              
      G25(J)=G21(J)*A14(J-1)+G22(J)*A24(J-1)+G23(J)*A34(J-1)-S8(J)              
      G31(J)=(B4(J)*(AA4*AA2-AA5*AA1)-AA9*(A21(J-1)*AA2-A31(J-1)*AA1)+          
     +            AA10*(A21(J-1)*AA5-A31(J-1)*AA4))/DET                         
      G32(J)=(-B4(J)*(AA3*AA2-AA5*AA6)+AA9*(A11(J-1)*AA2-A31(J-1)*AA6)-         
     +            AA10*(A11(J-1)*AA5-A31(J-1)*AA3))/DET                         
      G33(J)=(B4(J)*(AA3*AA1-AA4*AA6)-AA9*(A11(J-1)*AA1-A21(J-1)*AA6)+          
     +            AA10*(A11(J-1)*AA4-A21(J-1)*AA3))/DET                         
      G34(J)=G31(J)*A12(J-1)+G32(J)*A22(J-1)+G33(J)*A32(J-1)-B6(J)              
      G35(J)=G31(J)*A14(J-1)+G32(J)*A24(J-1)+G33(J)*A34(J-1)-B8(J)              
C                                                                               
C  ELEMENTS OF TRIANGLE MATRIX
      A11(J)=1.0                                                                
      A12(J)=-A(J)-G14(J)                                                       
      A13(J)=A(J)*G14(J)                                                        
      A14(J)=-G15(J)                                                            
      A15(J)=A(J)*G15(J)                                                        
      A21(J)=S3(J)                                                              
      A22(J)=S5(J)-G24(J)                                                       
      A23(J)=S1(J)+A(J)*G24(J)                                                  
      A24(J)=-G25(J)+S7(J)                                                      
      A25(J)=A(J)*G25(J)                                                        
      A31(J)=B3(J)                                                              
      A32(J)=B5(J)-G34(J)                                                       
      A33(J)=B9(J)+A(J)*G34(J)                                                  
      A34(J)=B7(J)-G35(J)                                                       
      A35(J)=B1(J)+A(J)*G35(J)                                                  
C                                                                               
C  ELEMENTS OF W-VECTOR
      W1(J) =R(1,J)-G11(J)*W1(J-1)-G12(J)*W2(J-1)-G13(J)*W3(J-1)-               
     +            G14(J)*W4(J-1)-G15(J)*W5(J-1)                                 
      W2(J) =R(2,J)-G21(J)*W1(J-1)-G22(J)*W2(J-1)-G23(J)*W3(J-1)-               
     +            G24(J)*W4(J-1)-G25(J)*W5(J-1)                                 
      W3(J) =R(3,J)-G31(J)*W1(J-1)-G32(J)*W2(J-1)-G33(J)*W3(J-1)-               
     +            G34(J)*W4(J-1)-G35(J)*W5(J-1)                                 
      W4(J) =R(4,J)                                                             
      W5(J) =R(5,J)                                                             
30    CONTINUE                                                                  
C - BACKWARD SWEEP                                                              
      J      =NP                                                                
C  DEFINITIONS                                                                  
      DP =    -(A31(J)*(A13(J)*W2(J)-W1(J)*A23(J))-A32(J)*(A11(J)*              
     +            W2(J)-W1(J)*A21(J)) + W3(J)*(A11(J)*A23(J)-A13(J)*A21(
     +           J)))    
      DV =    -(A31(J)*(W1(J)*A25(J)-W2(J)*A15(J))-W3(J)*(A11(J)*A25(J)         
     +        -A15(J)*A21(J))+A35(J)*(A11(J)*W2(J)-W1(J)*A21(J)))               
      DF =    -(W3(J)*(A13(J)*A25(J)-A23(J)*A15(J))-A33(J)*(W1(J)*A25(J)        
     +        -A15(J)*W2(J)) + A35(J)*(W1(J)*A23(J)-A13(J)*W2(J)))              
      D1 =   -(A31(J)*(A13(J)*A25(J)-A23(J)*A15(J))-A33(J)*(A11(J)*             
     +         A25(J)-A21(J)*A15(J))+A35(J)*(A11(J)*A23(J)-A21(J)*A13(J)
     +         ))      
C                                                                               
C  ELEMENTS OF DELTA-VECTOR FOR J=NP
      DELP(J) = DP/D1                                                           
      DELV(J) = DV/D1                                                           
      DELF(J) = DF/D1                                                           
      DELG(J) = 0.0                                                             
      DELU(J) = 0.0                                                             
40    J = J-1                                                                   
C  DEFINITIONS                                                                  
      BB1=DELU(J+1)-A(J+1)*DELV(J+1)-W4(J)                                      
      BB2=DELG(J+1)-A(J+1)*DELP(J+1)-W5(J)                                      
      CC1=W1(J)-A12(J)*BB1-A14(J)*BB2                                           
      CC2=W2(J)-A22(J)*BB1-A24(J)*BB2                                           
      CC3=W3(J)-A32(J)*BB1-A34(J)*BB2                                           
      DD1=A13(J)-A12(J)*A(J+1)                                                  
      DD2=A23(J)-A22(J)*A(J+1)                                                  
      DD3=A33(J)-A32(J)*A(J+1)                                                  
      EE1=A15(J)-A14(J)*A(J+1)                                                  
      EE2=A25(J)-A24(J)*A(J+1)                                                  
      EE3=A35(J)-A34(J)*A(J+1)                                                  
      DETT=A11(J)*DD2*EE3+A21(J)*DD3*EE1+A31(J)*DD1*EE2                         
     +          -A31(J)*DD2*EE1-A21(J)*DD1*EE3-A11(J)*DD3*EE2                   
C                                                                               
C  ELEMENTS OF DELTA-VECTOR
      DELF(J)=(CC1*DD2*EE3+CC2*DD3*EE1+CC3*DD1*EE2-CC3*DD2*EE1                  
     +             -CC2*DD1*EE3-CC1*DD3*EE2)/DETT                               
      DELV(J)=(A11(J)*CC2*EE3+A21(J)*CC3*EE1+A31(J)*CC1*EE2-                    
     +             A31(J)*CC2*EE1-A21(J)*CC1*EE3-A11(J)*CC3*EE2)/DETT           
      DELP(J)=(A11(J)*CC3*DD2+A21(J)*CC1*DD3+A31(J)*CC2*DD1-                    
     +             A31(J)*CC1*DD2-A21(J)*CC3*DD1-A11(J)*CC2*DD3)/DETT           
      DELU(J)=BB1-A(J+1)*DELV(J)                                                
      DELG(J)= BB2-A(J+1)*DELP(J)                                               
      IF(J .GT. 1) GO TO 40                                                     
C                                                                               
C  NEW VALUES OF F,U,V,G,P
      DO 50 J=1,NP                                                              
      F(J,2)=F(J,2)+DELF(J)                                                     
      U(J,2)=U(J,2)+DELU(J)                                                     
      V(J,2)=V(J,2)+DELV(J)                                                     
      G(J,2)=G(J,2)+DELG(J)                                                     
      P(J,2)=P(J,2)+DELP(J)                                                     
50    CONTINUE                                                                  
      U(1,2) = 0.0                                                              
      RETURN                                                                    
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -         
      END                                                                       
      SUBROUTINE IVPL                                                           
      PARAMETER(NXM=200, NYM=201)
      COMMON /AK1/ RMUI,TI,RMI,UI,PR,HE                                         
      COMMON /BLC0/ NP,NPT,NX,NXT,NTR,IT,IFLAG                                  
      COMMON /GRD/ X(NXM),ETA(NYM),DETA(NYM),A(NYM),T(NYM),THE(NYM)                   
      COMMON /BLC1/ 
     +   F(NYM,2),U(NYM,2),V(NYM,2),B(NYM,2),G(NYM,2),P(NYM,2),
     +   C(NYM,2),D(NYM,2),E(NYM,2),RMU(NYM),BC(NYM),CP(NYM,2)
      COMMON /BLC3/ DELF(NYM),DELU(NYM),DELV(NYM),DELG(NYM),DELP(NYM)

      SAVE

C                                                                               
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -         
C                                                                               
C   GENERATE INITIAL PROFILE BY SOLVING THE INCOMPRESSIBLE FLOW                 
      ETANPQ= 0.25*ETA(NP)                                                      
      ETAU15= 1.5/ETA(NP)                                                       
C                                                                               
      DO 30 J=1,NP                                                              
      ETAB  = ETA(J)/ETA(NP)                                                    
      ETAB2 = ETAB**2                                                           
      F(J,2)= ETANPQ*ETAB2*(3.0-0.5*ETAB2)                                      
      U(J,2)= 0.5*ETAB*(3.0-ETAB2)                                              
      V(J,2)= ETAU15*(1.0-ETAB2)                                                
CCC   G(J,2) = ETAB                                                             
CCC   P(J,2) = 1.0/ETA(NP)                                                      
      G(J,2) = 1.0
      P(J,2) = 0.0
      B(J,2) = 1.0                                                              
      C(J,2) = 1.0                                                              
      E(J,2) = 1.0/PR                                                           
      D(J,2) = 0.0                                                              
30    CONTINUE                                                                  
C                                                                               
      IT = 0                                                                    
50    IT = IT + 1                                                               
      IF(IT .LE. 8) GO TO 70                                                    
      WRITE(6,9900)                                                             
      STOP                                                                      
70    CONTINUE                                                                  
      CALL COEF                                                                 
      CALL SOLV5                                                                
      IF(ABS(DELV(1)) .GT. 1.0E-05) GO TO 50                                    
C                                                                               
      RETURN                                                                    
9900  FORMAT(1H0,'INCOMPRESSIBLE DID NOT CONVERGE')                             
      END                                                                       
      SUBROUTINE EDDY                                                           
      PARAMETER(NXM=200, NYM=201)
      COMMON /OTPT1/ RX,CNUE                                                    
      COMMON /AK1/ RMUI,TI,RMI,UI,PR,HE                                         
      COMMON /BLC0/ NP,NPT,NX,NXT,NTR,IT,IFLAG                                  
      COMMON /GRD/ X(NXM),ETA(NYM),DETA(NYM),A(NYM),T(NYM),THE(NYM)
      COMMON /BLC1/ 
     +   F(NYM,2),U(NYM,2),V(NYM,2),B(NYM,2),G(NYM,2),P(NYM,2),
     +   C(NYM,2),D(NYM,2),E(NYM,2),RMU(NYM),BC(NYM),CP(NYM,2)
      COMMON /EDGE/ UE(NXM),TE(NXM),RHOE(NXM),RMUE(NXM),
     +     PE(NXM),P1(NXM),P2(NXM)        
      DATA ITRN,PRT/0,0.9/                                                      

      SAVE

C                                                                               
C   -----------------                                                           
C                                                                               
      IED = 0                                                                   
      IF(NX .NE. NTR)  GO TO 5                                                  
      RXNTR = UE(NTR-1)*X(NTR-1)*RHOE(NTR-1)/RMUE(NTR-1)                        
      GG = 8.33E-4*UE(NTR-1)**3/(CNUE**2*(RXNTR**1.34))                         
5     IF(IT .GT. 1) GO TO 30                                                    
      IF(ITRN .EQ. 1) GO TO 30                                                  
C                                                                               
C   CALCULATE GAMMA TRANSITION                                                  
      UEING = 0.0                                                               
      U1 = 1.0/UE(NTR-1)                                                        
      DO 10 I=NTR,NX                                                            
      U2 = 1.0/UE(I)                                                            
      UEING = UEING + 0.5*(U1+U2)*(X(I) - X(I-1))                               
      U1 = U2                                                                   
10    CONTINUE                                                                  
C                                                                               
      ROING = X(NX) - X(NTR-1)                                                  
      EXPT = GG*ROING*UEING                                                     
      IF(EXPT .LE. 10.0) GO TO 20                                               
      ITRN = 1                                                                  
      GAMTR = 1.0                                                               
      GO TO 30                                                                  
20    GAMTR = 1.0 - EXP(-EXPT)                                                  
30    CONTINUE                                                                  
C                                                                               
      TERMP = C(1,2)                                                            
      SUM = 0.0                                                                 
      CII = 0.0                                                                 
C                                                                               
      DO 40 J=2,NP                                                              
      CII = CII + A(J)*(C(J-1,2) + C(J,2))                                      
      TERM = C(J,2)*(1.0 - U(J,2))                                              
      SUM = SUM + A(J)*(TERM+TERMP)                                             
      TERMP = TERM                                                              
40    CONTINUE                                                                  
C                                                                               
      CI = 0.0                                                                  
      PPLUS = P2(NX)/(RX**0.25)*(RMU(NP)/(RMU(1)*V(1,2)))**1.5                  
      CN = SQRT(1.0 - 11.8*PPLUS*RMU(1)/RMU(NP)*C(1,2)**2)                      
      CYA = CN*(RX**0.25)*SQRT(BC(1)*V(1,2))/26.0                               
      DO 100 J=2,NP                                                             
      CI = CI + A(J)*(C(J-1,2) + C(J,2))                                        
      EDVO = 0.0168*SUM*(RX**0.5)/BC(J)/C(J,2)**2                               
      GAMINT = 1.0/(1.0 + 5.5*(CI/CII)**6)                                      
      EDVO = EDVO*GAMTR*GAMINT                                                  
      IF(IED .EQ. 1) GO TO 50                                                   
      YOA = CYA*CI/BC(J)/C(J,2)**1.5                                            
      EL = 1.0                                                                  
      IF(YOA .LE. 10.0) EL = 1.0 - EXP(-YOA)                                    
C                                                                               
      EDVI = 0.16*SQRT(RX)*GAMTR*V(J,2)*(CI*EL)**2/BC(J)/C(J,2)**3              
      IF(EDVI .LT. EDVO) GO TO 70                                               
      IED = 1                                                                   
50    EDV = EDVO                                                                
      GO TO 90                                                                  
70    EDV = EDVI                                                                
90    B(J,2) = (1.0 + EDV)*BC(J)                                                
      E(J,2) = BC(J)*((1.0 + EDV*PR/PRT)/PR)                                    
100   CONTINUE                                                                  
      B(1,2) = BC(1)                                                            
      E(1,2) = BC(1)/PR                                                         
C                                                                               
      RETURN                                                                    
      END                                                                       
      SUBROUTINE COEF                                                           
      PARAMETER(NXM=200, NYM=201)
      COMMON /INPT1/ WW(NXM),ALFA0,ALFA1
      COMMON /BLC0/ NP,NPT,NX,NXT,NTR,IT,IFLAG
      COMMON /BLC1/ 
     +   F(NYM,2),U(NYM,2),V(NYM,2),B(NYM,2),G(NYM,2),P(NYM,2),
     +   C(NYM,2),D(NYM,2),E(NYM,2),RMU(NYM),BC(NYM),CP(NYM,2)
      COMMON /GRD/ X(NXM),ETA(NYM),DETA(NYM),A(NYM),T(NYM),THE(NYM)                   
      COMMON /EDGE/ 
     +   UE(NXM),TE(NXM),RHOE(NXM),RMUE(NXM),PE(NXM),P1(NXM),P2(NXM)        
      COMMON/BLC6/ 
     +   S1(NYM),S2(NYM),S3(NYM),S4(NYM),S5(NYM),S6(NYM),S7(NYM),
     +   S8(NYM),B1(NYM),B2(NYM),B3(NYM),B4(NYM),B5(NYM),B6(NYM),
     +   B7(NYM),B8(NYM),B9(NYM),B10(NYM),R(5,NYM)

      SAVE

C                                                                               
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -         
C                                                                               
      IF(IT .GT. 1) GO TO 5                                                     
      CEL = 0.0                                                                 
      IF(NX .GT. 1) CEL = 0.5*(X(NX)+X(NX-1))/(X(NX)-X(NX-1))                   
      P1P = P1(NX) + CEL                                                        
      P2P = P2(NX) + CEL                                                        
      IF(ALFA0 .GT. 0.1) G(1,2) = WW(NX)                                        
      IF(ALFA1 .GT. 0.1) P(1,2) = WW(NX)                                        
5     CONTINUE                                                                  
C                                                                               
      DO 100 J=2,NP                                                             
C  PRESENT STATION                                                              
      USB   = 0.5*(U(J,2)**2+U(J-1,2)**2)                                       
      FVB   = 0.5*(F(J,2)*V(J,2)+F(J-1,2)*V(J-1,2))                             
      FPB   = 0.5*(F(J,2)*P(J,2)+F(J-1,2)*P(J-1,2))                             
      UGB   = 0.5*(U(J,2)*G(J,2)+U(J-1,2)*G(J-1,2))                             
      UB    = 0.5*(U(J,2)+U(J-1,2))                                             
      VB    = 0.5*(V(J,2)+V(J-1,2))                                             
      FB    = 0.5*(F(J,2)+F(J-1,2))                                             
      GB    = 0.5*(G(J,2)+G(J-1,2))                                             
      PB    = 0.5*(P(J,2)+P(J-1,2))                                             
      CB = 0.5*(C(J,2) + C(J-1,2))                                              
      DERBV = (B(J,2)*V(J,2)-B(J-1,2)*V(J-1,2))/DETA(J-1)                       
      DEREP = (E(J,2)*P(J,2)-E(J-1,2)*P(J-1,2))/DETA(J-1)                       
      DRDUV = (D(J,2)*U(J,2)*V(J,2) - D(J-1,2)*U(J-1,2)*V(J-1,2))/              
     +              DETA(J-1)                                                   
      IF(NX.GT.1)GO TO 10
C  PREVIOUS STATION                                                             
      CFB   = 0.0                                                               
      CVB   = 0.0                                                               
      CPB   = 0.0                                                               
      CUB   = 0.0                                                               
      CGB   = 0.0                                                               
      CUGB  = 0.0                                                               
      CFPB  = 0.0                                                               
      CFVB  = 0.0                                                               
      CUSB  = 0.0                                                               
      CDERBV = 0.0                                                              
      CDEREP = 0.0                                                              
      CRB = -P2(NX)*CB                                                          
      CTB = 0.0                                                                 
      GO TO 20
10    CFB   = 0.5*(F(J,1)+F(J-1,1))                                             
      CVB   = 0.5*(V(J,1)+V(J-1,1))                                             
      CPB   = 0.5*(P(J,1)+P(J-1,1))                                             
      CUB   = 0.5*(U(J,1)+U(J-1,1))                                             
      CGB   = 0.5*(G(J,1)+G(J-1,1))                                             
      CFVB  = 0.5*(F(J,1)*V(J,1)+F(J-1,1)*V(J-1,1))                             
      CFPB  = 0.5*(F(J,1)*P(J,1)+F(J-1,1)*P(J-1,1))                             
      CUGB  = 0.5*(U(J,1)*G(J,1)+U(J-1,1)*G(J-1,1))                             
      CUSB  = 0.5*(U(J,1)**2+U(J-1,1)**2)                                       
      CCB = 0.5*(C(J,1) + C(J-1,1))                                             
      CDERBV= (B(J,1)*V(J,1)-B(J-1,1)*V(J-1,1))/DETA(J-1)                       
      CDEREP= (E(J,1)*P(J,1)-E(J-1,1)*P(J-1,1))/DETA(J-1)                       
      CDRDUV = (D(J,1)*U(J,1)*V(J,1) - D(J-1,1)*U(J-1,1)*V(J-1,1))/             
     +              DETA(J-1)                                                   
C                                                                               
      CLB = CDERBV + P1(NX-1)*CFVB + P2(NX-1)*(CCB-CUSB)                        
      CRB = -CLB - P2(NX)*CB - CEL*CUSB + CEL*CFVB                              
      CMB = CDEREP + CDRDUV + P1(NX-1)*CFPB                                     
      CTB = -CMB + CEL*(CFPB-CUGB)                                              
C                                                                               
C  COEFFICIENTS OF THE DIFFERENCED MOMENTUM EQ.                                 
20    CONTINUE
      S1(J) = B(J,2)/DETA(J-1) + 0.5*P1P*F(J,2) - 0.5*CEL*CFB                   
      S2(J) = -B(J-1,2)/DETA(J-1) + 0.5*P1P*F(J-1,2) - 0.5*CEL*CFB              
      S3(J) = 0.5*(P1P*V(J,2) + CEL*CVB)                                        
      S4(J) = 0.5*(P1P*V(J-1,2) + CEL*CVB)                                      
      S5(J) = -P2P*U(J,2)                                                       
      S6(J) = -P2P*U(J-1,2)                                                     
      S7(J) = 0.0                                                               
      S8(J) = 0.0                                                               
C                                                                               
      R(2,J) = CRB - (DERBV + P1P*FVB - P2P*USB + CEL*(FB*CVB-VB*CFB))          
C                                                                               
C  COEFFICIENTS OF DIFFERENCED ENERGY EQ.                                       
      B1(J) = E(J,2)/DETA(J-1) + 0.5*P1P*F(J,2) - 0.5*CEL*CFB                   
      B2(J) = -E(J-1,2)/DETA(J-1) + 0.5*P1P*F(J-1,2) - 0.5*CEL*CFB              
      B3(J) = 0.5*(P1P*P(J,2) + CEL*CPB)                                        
      B4(J) = 0.5*(P1P*P(J-1,2) + CEL*CPB)                                      
      B5(J) = D(J,2)*V(J,2)/DETA(J-1) - 0.5*CEL*(G(J,2)-CGB)                    
      B6(J) = -D(J-1,2)*V(J-1,2)/DETA(J-1) - 0.5*CEL*(G(J-1,2)-CGB)             
      B7(J) = -0.5*CEL*(U(J,2)+CUB)                                             
      B8(J) = -0.5*CEL*(U(J-1,2)+CUB)                                           
      B9(J) = D(J,2)*U(J,2)/DETA(J-1)                                           
      B10(J) = -D(J-1,2)*U(J-1,2)/DETA(J-1)                                     
C                                                                               
      R(3,J) = CTB - (DEREP + DRDUV + P1P*FPB - CEL*(UGB-CGB*UB+CUB*GB)+        
     +                CEL*(CPB*FB-CFB*PB))                                      
C                                                                               
C  DEFINITIONS OF RJ                                                            
      R(1,J)= F(J-1,2)-F(J,2)+DETA(J-1)*UB                                      
      R(4,J-1) = U(J-1,2)-U(J,2)+DETA(J-1)*VB                                   
      R(5,J-1) = G(J-1,2)-G(J,2)+DETA(J-1)*PB                                   
100   CONTINUE                                                                  
      R(1,1) = 0.0                                                              
      R(2,1) = 0.0                                                              
      R(3,1) = 0.0                                                              
      R(4,NP)=0.0                                                               
      R(5,NP)=0.0                                                               
      RETURN                                                                    
      END                                                                       
      SUBROUTINE OUTPUT                                                         
      PARAMETER(NXM=200, NYM=201)
      COMMON /OTPT1/ RX,CNUE                                                    
      COMMON /AK1/ RMUI,TI,RMI,UI,PR,HE                                         
      COMMON /BLC0/ NP,NPT,NX,NXT,NTR,IT,IFLAG                                  
      COMMON /GRD/ X(NXM),ETA(NYM),DETA(NYM),A(NYM),T(NYM),THE(NYM)                   
      COMMON /BLC1/ 
     +    F(NYM,2),U(NYM,2),V(NYM,2),B(NYM,2),G(NYM,2),P(NYM,2),
     +    C(NYM,2),D(NYM,2),E(NYM,2),RMU(NYM),BC(NYM),CP(NYM,2)
      COMMON /EDGE/ 
     +    UE(NXM),TE(NXM),RHOE(NXM),RMUE(NXM),PE(NXM),P1(NXM),P2(NXM)
      COMMON /SAVE1/ RXSAVE(NXM),DELSSAVE(NXM),THETASAVE(NXM),
     +    HSAVE(NXM),CF2SAVE(NXM),RDELSSAVE(NXM),RTHETASAVE(NXM) 
      SAVE

C                                                                               
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -         
C                                                                               
      DO 10 J=1,NP                                                              
      THE(J) = (T(J)-TI)/(T(1)-TI)                                              
10    CONTINUE                                                                  
      WRITE(6,4400)                                                             
      WRITE(6,4500) (J,ETA(J),F(J,2),U(J,2),V(J,2),G(J,2),P(J,2),               
     +                    B(J,2),J=1,NP,8)                                      
      IF(J .NE. (NP+8)) WRITE(6,4500) NP,ETA(NP),F(NP,2),U(NP,2),               
     +           V(NP,2),G(NP,2),P(NP,2),B(NP,2)                                
      IF(NX .EQ. 1) GO TO 210                                                   
      TERMP = 0.0                                                               
      SUM = 0.0                                                                 
      SUMC = 0.0                                                                
      DO 20 J=2,NP                                                              
      SUMC = SUMC + A(J)*(C(J,2) + C(J-1,2))                                    
      TERM = U(J,2)*(1.0 - U(J,2))                                              
      SUM = SUM + A(J)*(TERM + TERMP)                                           
      TERMP = TERM                                                              
20    CONTINUE                                                                  
      DELS = X(NX)/SQRT(RX)*(SUMC - F(NP,2))                                    
      RDELS = SQRT(RX)*(SUMC - F(NP,2))                                         
      THETA = X(NX)/SQRT(RX)*SUM                                                
      RTHETA = SQRT(RX)*SUM                                                     
      H = DELS/THETA                                                            
      CF2 = BC(1)*V(1,2)/SQRT(RX)                                               
      IF(ABS(G(1,2)-1.0) .LT. 0.00001) GO TO 200                                
      ANUX = P(1,2)*C(1,2)*SQRT(RX)/(1.0 - G(1,2))                              
      STX = ANUX/RX/PR                                                          
      WRITE(6,9000) RX,DELS,THETA,ANUX,H,CF2,RDELS,RTHETA,STX                   
      GO TO 210                                                                 
200   CONTINUE                                                                  
      WRITE(6,9100) RX,DELS,THETA,H,CF2,RDELS,RTHETA                            

210   RXSAVE(NX)    = RX
      DELSSAVE(NX)  = DELS
      THETASAVE(NX) = THETA
      HSAVE(NX)     = H
      CF2SAVE(NX)   = CF2
      RDELSSAVE(NX) = RDELS
      RTHETASAVE(NX)=RTHETA

      NX = NX+1                                                              
      IF(NX .GT. NXT) STOP                                                      
      CNUE = RMUE(NX)/RHOE(NX)                                                  
      RX = UE(NX)*X(NX)/CNUE                                                    
C                                                                               
C  SHIFT PROFILES                                                               
      DO 250 J=1,NP                                                             
      F(J,1)= F(J,2)                                                            
      U(J,1)= U(J,2)                                                            
      V(J,1)= V(J,2)                                                            
      G(J,1)= G(J,2)                                                            
      P(J,1)= P(J,2)                                                            
      E(J,1)= E(J,2)                                                            
      C(J,1) = C(J,2)                                                           
      D(J,1) = D(J,2)                                                           
250   B(J,1)= B(J,2)                                                            
      RETURN                                                                    
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -         
4400  FORMAT(1H0,2X,1HJ,4X,3HETA,9X,1HF,13X,1HU,13X,1HV,13X,1HG                 
     +            ,13X,1HP,13X,1HB)                                             
4500  FORMAT(1H ,I3,F10.3,6E14.6)                                               
9000  FORMAT(1H0,5HRX  =,E12.5,3X,6HDELS =,E12.5,3X,7HTHETA =,E12.5,            
     +            3X,'NUSSELT NO=',E12.5,3X,2HH=,E12.5/1H0,5HCF/2=,
     +            E12.5,3X,
     +            6HRDELS=,E12.5,3X,7HRTHETA=,E12.5,3X,'STANTON NO =',
     +             E12.5/    
     +          1H0,'   ----------------------------------'/)                 
9100  FORMAT(1H0,5HRX  =,E12.5,3X,6HDELS =,E12.5,3X,7HTHETA =,E12.5,            
     +            3X,2HH=,E12.5/1H0,5HCF/2=,E12.5,3X,6HRDELS=,E12.5,
     + 3X,7HRTHETA=,E12.5/1H0,'---------------------------------'/)
      END                                                                       
