C*********************************************************************
C 11_5  WALL JET AND FILM HEATING
C
C*********************************************************************
C     MAIN
      COMMON /AK1/ RL,PR,UC,FR
      COMMON /EDGE/ P1(60),P2(60)
      COMMON /INPT1/ FN,ALFA0,ALFA1
      COMMON /BLC0/ NP,NPT,NX,NXT,NTR,IT,NXS
      COMMON /BLC1/ F(99,2),U(99,2),V(99,2),B(99,2),G(99,2),P(99,2),
     1              E(99,2)
      COMMON /GRD/ X(60),ETA(99),DETA(99),A(99)
      COMMON /BLC3/ DELF(99),DELU(99),DELV(99),DELG(99),DELP(99)
      COMMON /GRD2/ DETA1,DETA2,DETA3,DETA4,XETA1,XETA2,ETAC,ETAE
      COMMON /STORE/ FS(99),US(99),VS(99),GS(99),PS(99)
      COMMON /BLCS/ VW(60), PW(60)
      DIMENSION      Z(60),TITLE(20)
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C
C  FN = -1.0  COOLING I.E. BUOYANCY FORCE AGAINST THE DN OF THE FLOW
C  FN =  1.0  HEATING I.E. BUOYANCY FORCE IN THE DN OF THE FLOW
C  ALFA0 = 1.0  ,  ALFA1 = 0.0  SPECIFIED WALL TEMP  (G(1,2) = 1.0)
C  ALFA0 = 0.0  ,  ALFA1 = 1.0  SPECIFIED HEAT FLUX  (P(1,2) IS READ)
C
C   *******************   INPUT DATA    ******************
      ITMAX = 6
      NX    = 1
      NPT = 99
      OPEN(UNIT=5,FILE='pr11_5inp.txt')
      OPEN(UNIT=6,FILE='pr11_5out.txt')
      READ(5,8150) TITLE
      READ(5,8000) NXT,NXS,NXSM
      READ(5,8100) DETA(1),VGP,ETAE,ETAC,XETA1,XETA2,ALFA0,ALFA1
      READ(5,8100) PR,FN,RL,UAV,FR,DETA2,DETA3
      READ(5,8100) (Z(I),I=1,NXT)
      UC = 6.0*UAV
C
      WRITE(6,8150) TITLE
      WRITE(6,7000) PR,FN,UAV,FR
      WRITE(6,7100) NXT,NTR,NXS,NXSM,ETAE,DETA(1),DETA2,DETA3,VGP
      DO 20 I=1,NXT
   20 X(I) = Z(I)/FR
C
C  GRID IS GENERATED IN IVPL
      CALL IVPL
C
   30 IT    = 0
      DX = (X(NX) - X(1))*FR
      WRITE(6,9100) NX,X(NX),DX,Z(NX)
      P1(NX) = 0.0
      P2(NX) = 0.0
      IF(NX .GT. NXS) P1(NX) = 0.5
      IF(NX .EQ. 1) GO TO 100
C
   40 IT    = IT+1
      IF(IT .LE. ITMAX) GO TO 60
      WRITE(6,2500)
      GO TO 80
C
   60 CONTINUE
      CALL COEF
      CALL SOLV5
      WRITE(6,3000) V(1,2),DELV(1)
C
C  CHECK FOR CONVERGENCE
      IF(ABS(DELV(1)) .GT. 1.0E-05) GO TO 40
      IF(V(1,2) .LT. 0.0) STOP
   80 CONTINUE
C
      IF(NP .GE. NPT) GO TO 100
      IF(ABS(V(NP,2)) .LT. 0.0005) GO TO 100
      NP = NP + 1
      DO 90 L=1,2
      DO 85 J=NP,NP
      U(J,L) = U(J-1,L)
      V(J,L) = 0.0
      G(J,L) = 0.0
      P(J,L) = 0.0
      F(J,L) = F(J-1,L) + DETA(J-1)*U(J,L)
      B(J,L) = B(J-1,L)
      E(J,L) = E(J-1,L)
   85 CONTINUE
   90 CONTINUE
C
      IT = 1
      WRITE(6,4600)
      GO TO 40
  100 CONTINUE
C
C  OUTPUT DATA
      WRITE(6,4400)
      WRITE(6,4500) (J,ETA(J),F(J,2),U(J,2),V(J,2),G(J,2),P(J,2),
     1               B(J,2),J=1,NP)
      IF(NX .NE. NXSM) GO TO 120
      NXSM = 1000
      X1 = X(NX) - X(NX-1)
      X2 = X(NX-1) - X(NX-2)
      DO 110 J=1,NP
      F(J,1) = 0.5*(X2*(F(J,2)+F(J,1)) + X1*(F(J,1)+FS(J)))/(X1+X2)
      U(J,1) = 0.5*(X2*(U(J,2)+U(J,1)) + X1*(U(J,1)+US(J)))/(X1+X2)
      V(J,1) = 0.5*(X2*(V(J,2)+V(J,1)) + X1*(V(J,1)+VS(J)))/(X1+X2)
      G(J,1) = 0.5*(X2*(G(J,2)+G(J,1)) + X1*(G(J,1)+GS(J)))/(X1+X2)
      P(J,1) = 0.5*(X2*(P(J,2)+P(J,1)) + X1*(P(J,1)+PS(J)))/(X1+X2)
  110 CONTINUE
      IT = 1
      GO TO 40
  120 CONTINUE
C
C
      IF(NX .EQ. NXS) P1(NX) = 0.5
C
C SAVE RESULTS IN X- STATIONS AT THE WALL
      VW(NX) = V(1,2)
      PW(NX) = P(1,2)

      NX    = NX+1
      IF(NX .GT. NXT) GO TO 166
C
C  SHIFT PROFILES
      DO 140 J=1,NP
      F(J,1)= F(J,2)
      U(J,1)= U(J,2)
      V(J,1)= V(J,2)
      G(J,1)= G(J,2)
      P(J,1)= P(J,2)
      E(J,1)= E(J,2)
      B(J,1)= B(J,2)
  140 CONTINUE
C
      IF(NX .NE. (NXSM-2)) GO TO 30
      DO 160 J=1,NPT
      US(J)= U(J,2)
      VS(J)= V(J,2)
      GS(J)= G(J,2)
      PS(J)= P(J,2)
      FS(J)= F(J,2)
      IF(J .LE. NP) GO TO 160
      US(J) = US(J-1)
      VS(J) = 0.0
      GS(J) = 0.0
      PS(J) = 0.0
      FS(J) = FS(J-1) + DETA(J-1)
  160 CONTINUE
      GO TO 30
  166 WRITE (6,9200) (I, Z(I), VW(I), PW(I), I= 1, NX-1)
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 8000 FORMAT(8I3)
 8100 FORMAT(8F10.0)
 8150 FORMAT(20A4)
 3000 FORMAT(1H ,8HV(WALL)=,E13.6,2X,6HDELV =,E13.6)
 4400 FORMAT(1H ,2X,1HJ,4X,3HETA,9X,1HF,13X,1HU,13X,1HV,13X,1HG,13X,1HP,
     1       13X,1HB)
 4500 FORMAT(1H ,I3,F10.3,6E14.6)
 4600 FORMAT(1H )
 7000 FORMAT(1H ,'PR =',F6.2,3X,'FN =',F5.2,3X,'UAV =',F6.2,3X,
     1           'FR NO =',F6.2/)
 7100 FORMAT(1H ,'NXT=',I3,2X,'NTR=',I3,2X,'NXS=',I3,2X,'NXSM=',I2,
     1       3X,'ETAE=',F5.2,2X,'DETA1=',F5.3,2X,'DETA2=',F5.3,2X,
     2       'DETA3=',F5.3,2X,'VGP=',F5.3/)
 2500 FORMAT(1H ,16X,25HITERATIONS EXCEEDED ITMAX)
 9100 FORMAT(1H ,4HNX =,I3,5X,3HX =,F10.4,3X,'X-X0 =',E12.5,10X,
     1       'Z  =',E12.5/)
 9200 FORMAT(///2X, 'RESULT SUMMARY'/
     1   /2X, 'I', 6X, 'Z ', 10X, 'VW', 10X, 'PW'/ (I3, 3E12.4))
      END

      SUBROUTINE COEF
      COMMON /INPT1/ FN,ALFA0,ALFA1
      COMMON /BLC0/ NP,NPT,NX,NXT,NTR,IT,NXS
      COMMON /BLC1/ F(99,2),U(99,2),V(99,2),B(99,2),G(99,2),P(99,2),
     1              E(99,2)
      COMMON /GRD/ X(60),ETA(99),DETA(99),A(99)
      COMMON /EDGE/ P1(60),P2(60)
      COMMON/BLC6/ S1(99),S2(99),S3(99),S4(99),S5(99),S6(99),S7(99),
     1             S8(99),B1(99),B2(99),B3(99),B4(99),B5(99),B6(99),
     2             B7(99),B8(99),B9(99),B10(99),R(5,99)
C
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C
      IF(IT .GT. 1) GO TO 10
      CEL = 1.0/(X(NX) - X(NX-1))
      XB = 1.0
      IF(NX .LE. NXS) GO TO 5
      CEL = 0.5*(X(NX) + X(NX-1))/(X(NX) - X(NX-1))
      XB = 0.5*(X(NX) + X(NX-1))
    5 CONTINUE
      P1P = P1(NX) + CEL
      P2P = P2(NX) + CEL
   10 CONTINUE
C
      DO 100 J=2,NP
C  PRESENT STATION
      USB   = 0.5*(U(J,2)**2+U(J-1,2)**2)
      FVB   = 0.5*(F(J,2)*V(J,2)+F(J-1,2)*V(J-1,2))
      FPB   = 0.5*(F(J,2)*P(J,2)+F(J-1,2)*P(J-1,2))
      UGB   = 0.5*(U(J,2)*G(J,2)+U(J-1,2)*G(J-1,2))
      UB    = 0.5*(U(J,2)+U(J-1,2))
      VB    = 0.5*(V(J,2)+V(J-1,2))
      FB    = 0.5*(F(J,2)+F(J-1,2))
      GB    = 0.5*(G(J,2)+G(J-1,2))
      PB    = 0.5*(P(J,2)+P(J-1,2))
      DERBV = (B(J,2)*V(J,2)-B(J-1,2)*V(J-1,2))/DETA(J-1)
      DEREP = (E(J,2)*P(J,2)-E(J-1,2)*P(J-1,2))/DETA(J-1)
      CFB   = 0.5*(F(J,1)+F(J-1,1))
      CVB   = 0.5*(V(J,1)+V(J-1,1))
      CPB   = 0.5*(P(J,1)+P(J-1,1))
      CUB   = 0.5*(U(J,1)+U(J-1,1))
      CGB   = 0.5*(G(J,1)+G(J-1,1))
      CFVB  = 0.5*(F(J,1)*V(J,1)+F(J-1,1)*V(J-1,1))
      CFPB  = 0.5*(F(J,1)*P(J,1)+F(J-1,1)*P(J-1,1))
      CUGB  = 0.5*(U(J,1)*G(J,1)+U(J-1,1)*G(J-1,1))
      CUSB  = 0.5*(U(J,1)**2+U(J-1,1)**2)
      CDERBV= (B(J,1)*V(J,1)-B(J-1,1)*V(J-1,1))/DETA(J-1)
      CDEREP= (E(J,1)*P(J,1)-E(J-1,1)*P(J-1,1))/DETA(J-1)
C
      CLB = CDERBV + P1(NX-1)*CFVB + P2(NX-1)*(1.0-CUSB)
      CRB = -CLB - CEL*CUSB + CEL*CFVB - CGB*FN*XB
      CMB = CDEREP + P1(NX-1)*CFPB
      CTB = -CMB + CEL*(CFPB-CUGB)
C
C  COEFFICIENTS OF THE DIFFERENCED MOMENTUM EQ.
   20 CONTINUE
      S1(J) = B(J,2)/DETA(J-1) + 0.5*P1P*F(J,2) - 0.5*CEL*CFB
      S2(J) = -B(J-1,2)/DETA(J-1) + 0.5*P1P*F(J-1,2) - 0.5*CEL*CFB
      S3(J) = 0.5*(P1P*V(J,2) + CEL*CVB)
      S4(J) = 0.5*(P1P*V(J-1,2) + CEL*CVB)
      S5(J) = -P2P*U(J,2)
      S6(J) = -P2P*U(J-1,2)
      S7(J) = 0.5*FN*XB
      S8(J) = S7(J)
C
      R(2,J) = CRB - (DERBV + P1P*FVB - P2P*USB + CEL*(FB*CVB-VB*CFB) +
     1         GB*FN*XB)
C
C  COEFFICIENTS OF DIFFERENCED ENERGY EQ.
      B1(J) = E(J,2)/DETA(J-1) + 0.5*P1P*F(J,2) - 0.5*CEL*CFB
      B2(J) = -E(J-1,2)/DETA(J-1) + 0.5*P1P*F(J-1,2) - 0.5*CEL*CFB
      B3(J) = 0.5*(P1P*P(J,2) + CEL*CPB)
      B4(J) = 0.5*(P1P*P(J-1,2) + CEL*CPB)
      B5(J) = - 0.5*CEL*(G(J,2)-CGB)
      B6(J) = - 0.5*CEL*(G(J-1,2)-CGB)
      B7(J) = -0.5*CEL*(U(J,2)+CUB)
      B8(J) = -0.5*CEL*(U(J-1,2)+CUB)
      B9(J) = 0.0
      B10(J) = 0.0
C
      R(3,J) = CTB - (DEREP + P1P*FPB - CEL*(UGB-CGB*UB+CUB*GB)+
     1           CEL*(CPB*FB-CFB*PB))
C
C  DEFINITIONS OF RJ
      R(1,J)= F(J-1,2)-F(J,2)+DETA(J-1)*UB
      R(4,J-1) = U(J-1,2)-U(J,2)+DETA(J-1)*VB
      R(5,J-1) = G(J-1,2)-G(J,2)+DETA(J-1)*PB
  100 CONTINUE
      R(1,1) = 0.0
      R(2,1) = 0.0
      R(3,1) = 0.0
      R(4,NP)=0.0
      R(5,NP)=0.0
      RETURN
      END
      SUBROUTINE HER (NC,NMJ,J,YC,Y)
      COMMON /BLC1/ F(99,2),U(99,2),V(99,2),B(99,2),G(99,2),P(99,2),
     1              E(99,2)
      DIMENSION Y(1)
C ----------
C
      Y12 = Y(NC)- Y(NMJ)
      Y12SQ = Y12*Y12
C
      SY1 = (1.0-2.0*(Y(J)-Y(NC))/Y12)*((Y(J)-Y(NMJ))/Y12)**2
      SY2 = (1.0+2.0*(Y(J)-Y(NMJ))/Y12)*((Y(NC)-Y(J))/Y12)**2
      CSY1= (Y(J)-Y(NC))*((Y(J)-Y(NMJ))/Y12)**2
      CSY2= (Y(J)-Y(NMJ))*((Y(NC)-Y(J))/Y12)**2
      DSY1 = (2.0*(Y(J)-Y(NMJ))*(1.0-2.0*(Y(J)-Y(NC))/Y12)-2.0/Y12*
     1         (Y(J)-Y(NMJ))**2)/Y12SQ
      DSY2 = (-2.0*(Y(NC)-Y(J))*(1.0+2.0*(Y(J)-Y(NMJ))/Y12)+2.0/Y12*
     1         (Y(NC)-Y(J))**2)/Y12SQ
      DCSY1 = (2.0*(Y(J)-Y(NC))*(Y(J)-Y(NMJ))+(Y(J)-Y(NMJ))**2)/Y12SQ
      DCSY2 = (-2.0*(Y(NC)-Y(J))*(Y(J)-Y(NMJ))+(Y(NC)-Y(J))**2)/Y12SQ
C
      PY1 =((1.0-2.0*(Y(J)-Y(NC))/Y12)*(Y(J)-Y(NMJ))**3/3.0+(Y(J)-
     1       Y(NMJ))**4/(6.0*Y12))/Y12SQ
      CPY1 = ((Y(J)-Y(NC))*(Y(J)-Y(NMJ))**3/3.0 -(Y(J)-Y(NMJ))**4/12.0)/
     1         Y12SQ
      PY2 = ((1.0+2.0*(Y(J)-Y(NMJ))/Y12)*(Y(J)-Y(NC))**3/3.0 - (Y(J)-
     1        Y(NC))**4/(6.0*Y12))/Y12SQ
      CPY2 = ((Y(J)-Y(NMJ))*(Y(J)-Y(NC))**3/3.0-(Y(J)-Y(NC))**4/12.0)/
     1         Y12SQ
C
      U(J,2) = U(NC,2)*SY1+U(NMJ,2)*SY2+V(NC,2)*CSY1+V(NMJ,2)*CSY2
      V(J,2) = U(NC,2)*DSY1+U(NMJ,2)*DSY2+V(NC,2)*DCSY1+V(NMJ,2)*DCSY2
C
      RETURN
      END
      SUBROUTINE IVPL
      COMMON /BLC0/ NP,NPT,NX,NXT,NTR,IT,NXS
      COMMON /BLC1/ F(99,2),U(99,2),V(99,2),B(99,2),G(99,2),P(99,2),
     1              E(99,2)
      COMMON /GRD2/ DETA1,DETA2,DETA3,DETA4,XETA1,XETA2,ETAC,ETAE
      COMMON /GRD/ X(60),ETA(99),DETA(99),A(99)
      COMMON /AK1/ RL,PR,UC,FR
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C
C     NC LAST POINT FOR JET
C     NMJ LAST POINT FOR  HER.POLY
C     DETA1 SPACING FOR JET REGION
C     DETA2 SPACING FOR HER.POLY REGION
C     DETA3 SPACING FOR BL REGION
C-----------------
C
      PI = 3.14159
      U0 = 1.0
      DETA1 = DETA(1)
      ETA1 = XETA1*ETAC
      ETA2 = XETA2*ETAC
      NC = ETA1/DETA1 + 1.0001
      NMJ= (ETA2-ETA1)/DETA2 + NC
      NC1= NC+1
      NP = (ETAE-ETA2)/DETA3 + NMJ
C
C  CREATION OF THE GRID
      ETA(1) = 0.0
      DO 10 J=2,NC
   10 ETA(J) = ETA(J-1) + DETA1
      DO 20 J=NC1,NMJ
   20 ETA(J) = ETA(J-1) + DETA2
      NMJ1 = NMJ +1
      DO 30 J=NMJ1,NPT
   30 ETA(J) = ETA(J-1) + DETA3
C
C   *****************    COMPUTATION OF U,V PROFILES   **********
C     *****************   LOWER PART (JET)
C
      DO 50 J=1,NC1
      EBETAC = ETA(J)/ETAC
      U(J,2) = UC*EBETAC*(1.0-EBETAC)
      V(J,2) = UC/ETAC*(1.0-2.0*EBETAC)
   50 CONTINUE
C
C     **********************   UPPER PART    ********
      DO 60 J=NMJ,NP
      U(J,2) = U0*SIN(0.5*PI*(ETA(J)-ETAC)/(ETA(NP)-ETAC))
      V(J,2) = 0.5*PI*U0*COS(0.5*PI*(ETA(J)-ETAC)/(ETA(NP)-ETAC))/
     1         (ETA(NP)-ETAC)
   60 CONTINUE
C
      DO 70 J=NC1,NMJ
   70 CALL HER(NC1,NMJ,J,ETAC,ETA)
C
      DO 140 J=1,NP
      G(J,2) = 0.5*(1.0 - TANH(2.0*(ETA(J) - ETAC)))
      P(J,2) = -1.0/COSH(2.0*(ETA(J) - ETAC))**2
      B(J,2) = 1.0
      E(J,2) = B(J,2)/PR
  140 CONTINUE
      P(NP,2) = 0.0
      P(1,2) = 0.0
      SQFR = 1.0
      DO 150 J=2,NPT
      ETA(J) = ETA(J)/SQFR
      DETA(J-1) = ETA(J) - ETA(J-1)
      A(J)      = 0.5*DETA(J-1)
  150 CONTINUE
C
      DO 160 J=1,NP
      V(J,2) = V(J,2)*SQFR
      P(J,2) = P(J,2)*SQFR
      IF(J .EQ. 1) GO TO 160
      F(J,2) = F(J-1,2) + A(J)*(U(J,2) + U(J-1,2))
  160 CONTINUE
C
      WRITE(6,9000) ETAC,XETA1,XETA2,ETA(NC),ETA(NMJ)
      WRITE(6,9500)(J,ETA(J),F(J,2),U(J,2),V(J,2),G(J,2),P(J,2),J=1,NP)
      RETURN
 9000 FORMAT(1H0,5HETAC=,F10.6,5X,6HXETA1=,F10.6,5X,6HXETA2=,F10.6,5X,
     1                5HETA1=,F10.6,5X,5HETA2=,F10.6)
 9500 FORMAT(1H0,2X,1HJ,7X,3HETA,14X,1HF,17X,1HU,17X,1HV,17X,1HG,17X,1HP
     1          /(1H ,I4,F12.5,5E18.6))
      END
      SUBROUTINE SOLV5
      COMMON /INPT1/ FN,ALFA0,ALFA1
      COMMON /BLC0/ NP,NPT,NX,NXT,NTR,IT,NXS
      COMMON /GRD/ X(60),ETA(99),DETA(99),A(99)
      COMMON /BLC1/ F(99,2),U(99,2),V(99,2),B(99,2),G(99,2),P(99,2),
     1              E(99,2)
      COMMON /BLC3/ DELF(99),DELU(99),DELV(99),DELG(99),DELP(99)
      COMMON/BLC6/ S1(99),S2(99),S3(99),S4(99),S5(99),S6(99),S7(99),
     1             S8(99),B1(99),B2(99),B3(99),B4(99),B5(99),B6(99),
     2             B7(99),B8(99),B9(99),B10(99),R(5,99)
      DIMENSION    A11(99),A12(99),A13(99),A14(99),A15(99),A21(99),
     1             A22(99),A23(99),A24(99),A25(99),A31(99),A32(99),
     2             A33(99),A34(99),A35(99),G11(99),G12(99),G13(99),
     3             G14(99),G15(99),G21(99),G22(99),G23(99),G24(99),
     4             G25(99),G31(99),G32(99),G33(99),G34(99),G35(99),
     5             W1(99),W2(99),W3(99),W4(99),W5(99)
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      A11(1)=1.0
      A12(1)=0.0
      A13(1)=0.0
      A14(1)=0.0
      A15(1)=0.0
C
      A21(1)=0.0
      A22(1)=1.0
      A23(1)=0.0
      A24(1)=0.0
      A25(1)=0.0
C
      A31(1)=0.0
      A32(1)=0.0
      A33(1)=0.0
      A34(1)=ALFA0
      A35(1)=ALFA1
C
      W1 (1)=R(1,1)
      W2 (1)=R(2,1)
      W3 (1)=R(3,1)
      W4 (1)=R(4,1)
      W5 (1)=R(5,1)
C - FORWARD SWEEP
      DO 30 J=2,NP
      AA1=A(J)*A24(J-1)-A25(J-1)
      AA2=A(J)*A34(J-1)-A35(J-1)
      AA3=A(J)*A12(J-1)-A13(J-1)
      AA4=A(J)*A22(J-1)-A23(J-1)
      AA5=A(J)*A32(J-1)-A33(J-1)
      AA6=A(J)*A14(J-1)-A15(J-1)
      AA7=A(J)*S6(J)-S2(J)
      AA8=S8(J)*A(J)
      AA9=A(J)*B6(J)-B10(J)
      AA10=A(J)*B8(J)-B2(J)
      DET=A11(J-1)*(AA4*AA2-AA1*AA5)-A21(J-1)*(AA3*AA2-AA5*AA6)+
     1    A31(J-1)*(AA3*AA1-AA4*AA6)
      G11(J)=(-(AA4*AA2-AA5*AA1)+A(J)**2*(A21(J-1)*AA2-A31(J-1)*AA1))/
     1       DET
      G12(J)=((AA3*AA2-AA5*AA6)-A(J)**2*(A11(J-1)*AA2-A31(J-1)*AA6))/DET
      G13(J)=(-(AA3*AA1-AA4*AA6)+A(J)**2*(A11(J-1)*AA1-A21(J-1)*AA6))/
     1       DET
      G14(J)=G11(J)*A12(J-1)+G12(J)*A22(J-1)+G13(J)*A32(J-1)+A(J)
      G15(J)=G11(J)*A14(J-1)+G12(J)*A24(J-1)+G13(J)*A34(J-1)
      G21(J)=(S4(J)*(AA2*AA4-AA1*AA5)+A31(J-1)*(AA1*AA7-AA4*AA8)+
     1       A21(J-1)*(AA5*AA8-AA7*AA2))/DET
      G22(J)=(A11(J-1)*(AA2*AA7-AA5*AA8)+A31(J-1)*(AA3*AA8-AA6*AA7)+
     1       S4(J)*(AA5*AA6-AA2*AA3))/DET
      G23(J)=(A11(J-1)*(AA4*AA8-AA1*AA7)+S4(J)*(AA3*AA1-AA4*AA6)+
     1       A21(J-1)*(AA7*AA6-AA3*AA8))/DET
      G24(J)=G21(J)*A12(J-1)+G22(J)*A22(J-1)+G23(J)*A32(J-1)-S6(J)
      G25(J)=G21(J)*A14(J-1)+G22(J)*A24(J-1)+G23(J)*A34(J-1)-S8(J)
      G31(J)=(B4(J)*(AA4*AA2-AA5*AA1)-AA9*(A21(J-1)*AA2-A31(J-1)*AA1)+
     1       AA10*(A21(J-1)*AA5-A31(J-1)*AA4))/DET
      G32(J)=(-B4(J)*(AA3*AA2-AA5*AA6)+AA9*(A11(J-1)*AA2-A31(J-1)*AA6)-
     1       AA10*(A11(J-1)*AA5-A31(J-1)*AA3))/DET
      G33(J)=(B4(J)*(AA3*AA1-AA4*AA6)-AA9*(A11(J-1)*AA1-A21(J-1)*AA6)+
     1       AA10*(A11(J-1)*AA4-A21(J-1)*AA3))/DET
      G34(J)=G31(J)*A12(J-1)+G32(J)*A22(J-1)+G33(J)*A32(J-1)-B6(J)
      G35(J)=G31(J)*A14(J-1)+G32(J)*A24(J-1)+G33(J)*A34(J-1)-B8(J)
      A11(J)=1.0
      A12(J)=-A(J)-G14(J)
      A13(J)=A(J)*G14(J)
      A14(J)=-G15(J)
      A15(J)=A(J)*G15(J)
      A21(J)=S3(J)
      A22(J)=S5(J)-G24(J)
      A23(J)=S1(J)+A(J)*G24(J)
      A24(J)=-G25(J)+S7(J)
      A25(J)=A(J)*G25(J)
      A31(J)=B3(J)
      A32(J)=B5(J)-G34(J)
      A33(J)=B9(J)+A(J)*G34(J)
      A34(J)=B7(J)-G35(J)
      A35(J)=B1(J)+A(J)*G35(J)
      W1(J) =R(1,J)-G11(J)*W1(J-1)-G12(J)*W2(J-1)-G13(J)*W3(J-1)-
     1       G14(J)*W4(J-1)-G15(J)*W5(J-1)
      W2(J) =R(2,J)-G21(J)*W1(J-1)-G22(J)*W2(J-1)-G23(J)*W3(J-1)-
     1       G24(J)*W4(J-1)-G25(J)*W5(J-1)
      W3(J) =R(3,J)-G31(J)*W1(J-1)-G32(J)*W2(J-1)-G33(J)*W3(J-1)-
     1       G34(J)*W4(J-1)-G35(J)*W5(J-1)
      W4(J) =R(4,J)
      W5(J) =R(5,J)
   30 CONTINUE
C - BACKWARD SWEEP
      J      =NP
      DP =    -(A31(J)*(A13(J)*W2(J)-W1(J)*A23(J))-A32(J)*(A11(J)*
     1       W2(J)-W1(J)*A21(J)) + W3(J)*(A11(J)*A23(J)-A13(J)*A21(J)))
      DV =    -(A31(J)*(W1(J)*A25(J)-W2(J)*A15(J))-W3(J)*(A11(J)*A25(J)
     1   -A15(J)*A21(J))+A35(J)*(A11(J)*W2(J)-W1(J)*A21(J)))
      DF =    -(W3(J)*(A13(J)*A25(J)-A23(J)*A15(J))-A33(J)*(W1(J)*A25(J)
     1   -A15(J)*W2(J)) + A35(J)*(W1(J)*A23(J)-A13(J)*W2(J)))
      D1 =   -(A31(J)*(A13(J)*A25(J)-A23(J)*A15(J))-A33(J)*(A11(J)*
     1    A25(J)-A21(J)*A15(J))+A35(J)*(A11(J)*A23(J)-A21(J)*A13(J)))
      DELP(J) = DP/D1
      DELV(J) = DV/D1
      DELF(J) = DF/D1
      DELG(J) = 0.0
      DELU(J) = 0.0
   40 J = J-1
      BB1=DELU(J+1)-A(J+1)*DELV(J+1)-W4(J)
      BB2=DELG(J+1)-A(J+1)*DELP(J+1)-W5(J)
      CC1=W1(J)-A12(J)*BB1-A14(J)*BB2
      CC2=W2(J)-A22(J)*BB1-A24(J)*BB2
      CC3=W3(J)-A32(J)*BB1-A34(J)*BB2
      DD1=A13(J)-A12(J)*A(J+1)
      DD2=A23(J)-A22(J)*A(J+1)
      DD3=A33(J)-A32(J)*A(J+1)
      EE1=A15(J)-A14(J)*A(J+1)
      EE2=A25(J)-A24(J)*A(J+1)
      EE3=A35(J)-A34(J)*A(J+1)
      DETT=A11(J)*DD2*EE3+A21(J)*DD3*EE1+A31(J)*DD1*EE2
     1     -A31(J)*DD2*EE1-A21(J)*DD1*EE3-A11(J)*DD3*EE2
      DELF(J)=(CC1*DD2*EE3+CC2*DD3*EE1+CC3*DD1*EE2-CC3*DD2*EE1
     1        -CC2*DD1*EE3-CC1*DD3*EE2)/DETT
      DELV(J)=(A11(J)*CC2*EE3+A21(J)*CC3*EE1+A31(J)*CC1*EE2-
     1        A31(J)*CC2*EE1-A21(J)*CC1*EE3-A11(J)*CC3*EE2)/DETT
      DELP(J)=(A11(J)*CC3*DD2+A21(J)*CC1*DD3+A31(J)*CC2*DD1-
     1        A31(J)*CC1*DD2-A21(J)*CC3*DD1-A11(J)*CC2*DD3)/DETT
      DELU(J)=BB1-A(J+1)*DELV(J)
      DELG(J)= BB2-A(J+1)*DELP(J)
      IF(J .GT. 1) GO TO 40
      DO 50 J=1,NP
      F(J,2)=F(J,2)+DELF(J)
      U(J,2)=U(J,2)+DELU(J)
      V(J,2)=V(J,2)+DELV(J)
      G(J,2)=G(J,2)+DELG(J)
      P(J,2)=P(J,2)+DELP(J)
 50   CONTINUE
      U(1,2) = 0.0
      RETURN
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END
