C*********************************************************************
C
C 11.6 FORTRAN PROGRAM FOR TURBULENT FREE JET
C
C*********************************************************************
C     MAIN
      COMMON /INPT1/ WW(60),ALFA0,ALFA1
      COMMON /BLC0/ NP,NPT,NX,NXT,NTR,IT
      COMMON /BLC1/ F(61,2),U(61,2),V(61,2),B(61,2),G(61,2),P(61,2),
     1              C(61,2),D(61,2),E(61,2),RMU(61),BC(61)
      COMMON /GRD/ X(60),ETA(61),DETA(61),A(61)
      COMMON /EDGE/ UE(60),TE(60),RHOE(60),RMUE(60),PE(60),P1(60),P2(60)
      COMMON /BLC3/ DELF(61),DELU(61),DELV(61),DELG(61),DELP(61)
      COMMON/AK1/GW,PR,PRT,RL
      COMMON /BLCS/ UC(60), GC(60)
      DIMENSION TITLE(20)
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      EPS = 0.0001
      ITMAX = 6
      NX    = 1
      NPT = 61
      PRT = 0.9
C
C  INPUT DATA
C
C     ADIABATIC                ALFA0 = 0.0       ALFA1 = 1.0
C
C     SPECIFIED WALL TEMP.     ALFA0 = 1.0       ALFA1 = 0.0
      OPEN(UNIT=5,FILE='pr11_6inp.txt')
      OPEN(UNIT=6,FILE='pr11_6out.txt')
      READ(5,8150) TITLE
      READ(5,8000) NXT,NTR
      READ(5,8100) ETAE,DETA(1),VGP,ALFA0,ALFA1,PR,RL
      READ(5,8100) (X(I),I=1,NXT)
      SQRL = SQRT(RL)
C
      WRITE(6,8150) TITLE
      WRITE(6,7000) NXT,NTR,PR,ETAE,DETA(1),VGP,RL
C
C  GRID GENERATION
      IF((VGP-1.0) .LE. 0.001) GO TO 5
      NP    = ALOG((ETAE/DETA(1))*(VGP-1.0)+1.0)/ALOG(VGP) + 1.0001
      GO TO 10
    5 NP    = ETAE/DETA(1) + 1.0001
   10 IF(NP .LE. 61) GO TO 15
      WRITE(6,9000)
      STOP
   15 ETA(1)= 0.0
      DO 20 J=2,NPT
      DETA(J)=VGP*DETA(J-1)
      A(J)  = 0.5*DETA(J-1)
   20 ETA(J)= ETA(J-1)+DETA(J-1)
      CALL IVPL
C
   30 WRITE(6,9100) NX,X(NX)
      P1(NX) = 1.0
      P2(NX) =-1.0
      IF(NX .EQ. 1) GO TO 90
      IT    = 0
C
   40 IT    = IT+1
      IF(IT .LE. ITMAX) GO TO 60
      WRITE(6,2500)
      GO TO 90
C
   60 CONTINUE
      IF(NX .LT. NTR) GO TO 80
C   CALCULATE EDDY VISCOSITY BASED ON SCHLICHTING FORMULA
C   EDDY = 0.037*B*UMAX, WHERE B IS HALF WIDTH
      EPS = 0.02
      UMAXH  = 0.5*U(1,2)
      DO 1 J=1,NP
      IF(U(J,2).LT.UMAXH) GOTO 2
    1 CONTINUE
      ETAB  = ETA(NP)
      GOTO 3
    2 ETAB  = ETA(J-1)+(ETA(J)-ETA(J-1))/(U(J,2)-U(J-1,2))*(UMAXH-
     1        U(J-1,2))
    3 EDV   = .037*ETAB*U(1,2)*SQRL*X(NX)**(1.0/3.0)
C
      DO 70 J=1,61
      E(J,2) = EDV/PRT
   70 B(J,2)= EDV
C
   80 CONTINUE
      CALL COEF
      CALL SOLV5
      WRITE(6,3000) U(1,2),DELU(1)
C
C  CHECK FOR CONVERGENCE
      IF(ABS(DELU(1)/U(1,2)) .GT. EPS) GO TO 40
      IF(U(1,2) .LT. 0.0) STOP
   90 CONTINUE
C
C  OUTPUT DATA
      WRITE(6,4400)
      WRITE(6,4500) (J,ETA(J),F(J,2),U(J,2),V(J,2),G(J,2),P(J,2),
     1               B(J,2),J=1,NP,5)
      WRITE(6,4500) NP,ETA(NP),F(NP,2),U(NP,2),V(NP,2),G(NP,2),P(NP,2),
     1       B(NP,2)
C
C SAVE RESULTS IN X- STATIONS AT THE WALL
      UC(NX) = U(1,2)
      GC(NX) = G(1,2)

      NX    = NX+1
      IF(NX .GT. NXT) GO TO 130
C
C  SHIFT PROFILES
      DO 110 J=1,NP
      F(J,1)= F(J,2)
      U(J,1)= U(J,2)
      V(J,1)= V(J,2)
      G(J,1)= G(J,2)
      P(J,1)= P(J,2)
      E(J,1)= E(J,2)
  110 B(J,1)= B(J,2)
C
      GO TO 30
  130 WRITE (6,9200) (I, X(I), UC(I), GC(I), I= 1, NX-1)
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 8000 FORMAT(8I3)
 8100 FORMAT(8F10.0)
 8150 FORMAT(20A4)
 3000 FORMAT(1H ,7HU(1,2)=,E13.6,2X,6HDELU =,E13.6)
 4400 FORMAT(1H0,2X,1HJ,4X,3HETA,9X,1HF,13X,1HU,13X,1HV,13X,1HG,13X,1HP,
     1       13X,1HB)
 4500 FORMAT(1H ,I3,F10.3,6E14.6)
 7000 FORMAT(1H0,6HNXT  =,I3,14X,6HNTR  =,I3,14X,6HPR   =,F5.3/
     1       1H ,6HETAE =,E14.6,3X,6HDETA1=,E14.6,3X,6HVGP  =,E14.6,3X,
     2       6HRL   =,E14.6/)
 2500 FORMAT(1H0,16X,25HITERATIONS EXCEEDED ITMAX)
 9000 FORMAT(1H0,'NP EXCEEDED NPT -- PROGRAM TERMINATED')
 9100 FORMAT(1H0,4HNX =,I3,5X,3HX =,F10.3/)
 9400 FORMAT(1H ,79X,2E14.6)
 9200 FORMAT(///2X, 'RESULT SUMMARY'/
     1   /2X, 'I', 6X, 'S ', 10X, 'UC', 10X, 'GC'/ (I3, 3E12.4))
      END
      SUBROUTINE IVPL
      COMMON /BLC0/ NP,NPT,NX,NXT,NTR,IT
      COMMON /BLC1/ F(61,2),U(61,2),V(61,2),B(61,2),G(61,2),P(61,2),
     1              C(61,2),D(61,2),E(61,2),RMU(61),BC(61)
      COMMON /GRD/ X(60),ETA(61),DETA(61),A(61)
      COMMON/AK1/GW,PR,PRT,RL
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C
      AA = 25.0
      SQRL  = SQRT(RL)
      F(1,2)= 0.0
      TERM   = 27.855*X(NX)**(2.0/3.0)/SQRL
      DO 30 J=1,NP
      ETAH = ETA(J)*ETA(J)/AA
      TANF   = TANH( TERM*(ETA(J)-16.9869) )
      U(J,2)= 0.5*X(NX)**(1.0/3.0)*3.0*(1.0-TANF)
      V(J,2)= -TERM*X(NX)**(1.0/3.0)*0.5*(1.0-TANF**2)*3.0
      G(J,2) = U(J,2)/3.0
      P(J,2) = V(J,2)/3.0
      C(J,2) = 1.0
      B(J,2) = 1.0
      E(J,2) = 1.0/PR
      D(J,2) = 0.0
      BC(J) = 1.0
      C(J,1) = 1.0
      D(J,1) = 0.0
      IF(J .EQ. 1) GO TO 30
      F(J,2) = F(J-1,2) + A(J)*(U(J,2)+U(J-1,2))
   30 CONTINUE
C
      IF(NX .LT. NTR) RETURN
C   CALCULATE EDDY VISCOSITY BASED ON SCHLICHTING FORMULA
C   EDDY = 0.037*B*UMAX, WHERE B IS HALF WIDTH
      UMAXH  = 0.5*U(1,2)
      DO 1 J=1,NP
      IF(U(J,2).LT.UMAXH) GOTO 2
    1 CONTINUE
      ETAB  = ETA(NP)
      GOTO 3
    2 ETAB  = ETA(J-1)+(ETA(J)-ETA(J-1))/(U(J,2)-U(J-1,2))*(UMAXH-
     1        U(J-1,2))
    3 EDV   = .037*ETAB*U(1,2)*SQRL*X(NX)**(1.0/3.0)
C
      DO 70 J=1,NP
      E(J,2) = EDV/PRT
   70 B(J,2)= EDV
      RETURN
      END
      SUBROUTINE COEF
      COMMON /INPT1/ WW(60),ALFA0,ALFA1
      COMMON /BLC0/ NP,NPT,NX,NXT,NTR,IT
      COMMON /BLC1/ F(61,2),U(61,2),V(61,2),B(61,2),G(61,2),P(61,2),
     1              C(61,2),D(61,2),E(61,2),RMU(61),BC(61)
      COMMON /GRD/ X(60),ETA(61),DETA(61),A(61)
      COMMON /EDGE/ UE(60),TE(60),RHOE(60),RMUE(60),PE(60),P1(60),P2(60)
      COMMON/BLC6/ S1(61),S2(61),S3(61),S4(61),S5(61),S6(61),S7(61),
     1             S8(61),B1(61),B2(61),B3(61),B4(61),B5(61),B6(61),
     2             B7(61),B8(61),B9(61),B10(61),R(5,61)
C
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C
      IF(IT .GT. 1) GO TO 5
      CEL = 1.5*(X(NX) + X(NX-1))/(X(NX) - X(NX-1))
      P1P = P1(NX) + CEL
      P2P = P2(NX) + CEL
    5 CONTINUE
C
      DO 100 J=2,NP
C  PRESENT STATION
      USB   = 0.5*(U(J,2)**2+U(J-1,2)**2)
      FVB   = 0.5*(F(J,2)*V(J,2)+F(J-1,2)*V(J-1,2))
      FPB   = 0.5*(F(J,2)*P(J,2)+F(J-1,2)*P(J-1,2))
      UGB   = 0.5*(U(J,2)*G(J,2)+U(J-1,2)*G(J-1,2))
      UB    = 0.5*(U(J,2)+U(J-1,2))
      VB    = 0.5*(V(J,2)+V(J-1,2))
      FB    = 0.5*(F(J,2)+F(J-1,2))
      GB    = 0.5*(G(J,2)+G(J-1,2))
      PB    = 0.5*(P(J,2)+P(J-1,2))
      CB    = 0.5*(C(J,2) + C(J-1,2))
      DERBV = (B(J,2)*V(J,2)-B(J-1,2)*V(J-1,2))/DETA(J-1)
      DEREP = (E(J,2)*P(J,2)-E(J-1,2)*P(J-1,2))/DETA(J-1)
      DRDUV = (D(J,2)*U(J,2)*V(J,2) - D(J-1,2)*U(J-1,2)*V(J-1,2))/
     1         DETA(J-1)
      CFB   = 0.5*(F(J,1)+F(J-1,1))
      CVB   = 0.5*(V(J,1)+V(J-1,1))
      CPB   = 0.5*(P(J,1)+P(J-1,1))
      CUB   = 0.5*(U(J,1)+U(J-1,1))
      CGB   = 0.5*(G(J,1)+G(J-1,1))
      CFVB  = 0.5*(F(J,1)*V(J,1)+F(J-1,1)*V(J-1,1))
      CFPB  = 0.5*(F(J,1)*P(J,1)+F(J-1,1)*P(J-1,1))
      CUGB  = 0.5*(U(J,1)*G(J,1)+U(J-1,1)*G(J-1,1))
      CUSB  = 0.5*(U(J,1)**2+U(J-1,1)**2)
      CCB = 0.5*(C(J,1) + C(J-1,1))
      CDERBV= (B(J,1)*V(J,1)-B(J-1,1)*V(J-1,1))/DETA(J-1)
      CDEREP= (E(J,1)*P(J,1)-E(J-1,1)*P(J-1,1))/DETA(J-1)
      CDRDUV = (D(J,1)*U(J,1)*V(J,1) - D(J-1,1)*U(J-1,1)*V(J-1,1))/
     1         DETA(J-1)
C
      CLB = CDERBV + P1(NX-1)*CFVB - P2(NX-1)*CUSB
      CRB = -CLB  - CEL*CUSB + CEL*CFVB
      CMB = CDEREP + CDRDUV + P1(NX-1)*CFPB
      CTB = -CMB + CEL*(CFPB-CUGB)
C
C  COEFFICIENTS OF THE DIFFERENCED MOMENTUM EQ.
      S1(J) = B(J,2)/DETA(J-1) + 0.5*P1P*F(J,2) - 0.5*CEL*CFB
      S2(J) = -B(J-1,2)/DETA(J-1) + 0.5*P1P*F(J-1,2) - 0.5*CEL*CFB
      S3(J) = 0.5*(P1P*V(J,2) + CEL*CVB)
      S4(J) = 0.5*(P1P*V(J-1,2) + CEL*CVB)
      S5(J) = -P2P*U(J,2)
      S6(J) = -P2P*U(J-1,2)
      S7(J) = 0.0
      S8(J) = S7(J)
C
      R(2,J) = CRB - (DERBV + P1P*FVB - P2P*USB + CEL*(FB*CVB-VB*CFB))
C
C  COEFFICIENTS OF DIFFERENCED ENERGY EQ.
      B1(J) = E(J,2)/DETA(J-1) + 0.5*P1P*F(J,2) - 0.5*CEL*CFB
      B2(J) = -E(J-1,2)/DETA(J-1) + 0.5*P1P*F(J-1,2) - 0.5*CEL*CFB
      B3(J) = 0.5*(P1P*P(J,2) + CEL*CPB)
      B4(J) = 0.5*(P1P*P(J-1,2) + CEL*CPB)
      B5(J) = D(J,2)*V(J,2)/DETA(J-1) - 0.5*CEL*(G(J,2)-CGB)
      B6(J) = -D(J-1,2)*V(J-1,2)/DETA(J-1) - 0.5*CEL*(G(J-1,2)-CGB)
      B7(J) = -0.5*CEL*(U(J,2)+CUB)
      B8(J) = -0.5*CEL*(U(J-1,2)+CUB)
      B9(J) = D(J,2)*U(J,2)/DETA(J-1)
      B10(J) = -D(J-1,2)*U(J-1,2)/DETA(J-1)
C
      R(3,J) = CTB - (DEREP + DRDUV + P1P*FPB - CEL*(UGB-CGB*UB+CUB*GB)+
     1           CEL*(CPB*FB-CFB*PB))
C
C  DEFINITIONS OF RJ
      R(1,J)= F(J-1,2)-F(J,2)+DETA(J-1)*UB
      R(4,J-1) = U(J-1,2)-U(J,2)+DETA(J-1)*VB
      R(5,J-1) = G(J-1,2)-G(J,2)+DETA(J-1)*PB
  100 CONTINUE
      R(1,1) = 0.0
      R(2,1) = 0.0
      R(3,1) = 0.0
      R(4,NP)=0.0
      R(5,NP)=0.0
      RETURN
      END
      SUBROUTINE SOLV5
      COMMON /INPT1/ WW(60),ALFA0,ALFA1
      COMMON /BLC0/ NP,NPT,NX,NXT,NTR,IT
      COMMON /GRD/ X(60),ETA(61),DETA(61),A(61)
      COMMON /BLC1/ F(61,2),U(61,2),V(61,2),B(61,2),G(61,2),P(61,2),
     1              C(61,2),D(61,2),E(61,2),RMU(61),BC(61)
      COMMON /BLC3/ DELF(61),DELU(61),DELV(61),DELG(61),DELP(61)
      COMMON/BLC6/ S1(61),S2(61),S3(61),S4(61),S5(61),S6(61),S7(61),
     1             S8(61),B1(61),B2(61),B3(61),B4(61),B5(61),B6(61),
     2             B7(61),B8(61),B9(61),B10(61),R(5,61)
      DIMENSION    A11(61),A12(61),A13(61),A14(61),A15(61),A21(61),
     1             A22(61),A23(61),A24(61),A25(61),A31(61),A32(61),
     2             A33(61),A34(61),A35(61),G11(61),G12(61),G13(61),
     3             G14(61),G15(61),G21(61),G22(61),G23(61),G24(61),
     4             G25(61),G31(61),G32(61),G33(61),G34(61),G35(61),
     5             W1(61),W2(61),W3(61),W4(61),W5(61)
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      A11(1)=1.0
      A12(1)=0.0
      A13(1)=0.0
      A14(1)=0.0
      A15(1)=0.0
C
      A21(1)=0.0
      A22(1)=0.0
      A23(1)=1.0
      A24(1)=0.0
      A25(1)=0.0
C
      A31(1)=0.0
      A32(1)=0.0
      A33(1)=0.0
      A34(1)=ALFA0
      A35(1)=ALFA1
C
      W1 (1)=R(1,1)
      W2 (1)=R(2,1)
      W3 (1)=R(3,1)
      W4 (1)=R(4,1)
      W5 (1)=R(5,1)
C - FORWARD SWEEP
      DO 30 J=2,NP
      AA1=A(J)*A24(J-1)-A25(J-1)
      AA2=A(J)*A34(J-1)-A35(J-1)
      AA3=A(J)*A12(J-1)-A13(J-1)
      AA4=A(J)*A22(J-1)-A23(J-1)
      AA5=A(J)*A32(J-1)-A33(J-1)
      AA6=A(J)*A14(J-1)-A15(J-1)
      AA7=A(J)*S6(J)-S2(J)
      AA8=S8(J)*A(J)
      AA9=A(J)*B6(J)-B10(J)
      AA10=A(J)*B8(J)-B2(J)
      DET=A11(J-1)*(AA4*AA2-AA1*AA5)-A21(J-1)*(AA3*AA2-AA5*AA6)+
     1    A31(J-1)*(AA3*AA1-AA4*AA6)
      G11(J)=(-(AA4*AA2-AA5*AA1)+A(J)**2*(A21(J-1)*AA2-A31(J-1)*AA1))/
     1       DET
      G12(J)=((AA3*AA2-AA5*AA6)-A(J)**2*(A11(J-1)*AA2-A31(J-1)*AA6))/DET
      G13(J)=(-(AA3*AA1-AA4*AA6)+A(J)**2*(A11(J-1)*AA1-A21(J-1)*AA6))/
     1       DET
      G14(J)=G11(J)*A12(J-1)+G12(J)*A22(J-1)+G13(J)*A32(J-1)+A(J)
      G15(J)=G11(J)*A14(J-1)+G12(J)*A24(J-1)+G13(J)*A34(J-1)
      G21(J)=(S4(J)*(AA2*AA4-AA1*AA5)+A31(J-1)*(AA1*AA7-AA4*AA8)+
     1       A21(J-1)*(AA5*AA8-AA7*AA2))/DET
      G22(J)=(A11(J-1)*(AA2*AA7-AA5*AA8)+A31(J-1)*(AA3*AA8-AA6*AA7)+
     1       S4(J)*(AA5*AA6-AA2*AA3))/DET
      G23(J)=(A11(J-1)*(AA4*AA8-AA1*AA7)+S4(J)*(AA3*AA1-AA4*AA6)+
     1       A21(J-1)*(AA7*AA6-AA3*AA8))/DET
      G24(J)=G21(J)*A12(J-1)+G22(J)*A22(J-1)+G23(J)*A32(J-1)-S6(J)
      G25(J)=G21(J)*A14(J-1)+G22(J)*A24(J-1)+G23(J)*A34(J-1)-S8(J)
      G31(J)=(B4(J)*(AA4*AA2-AA5*AA1)-AA9*(A21(J-1)*AA2-A31(J-1)*AA1)+
     1       AA10*(A21(J-1)*AA5-A31(J-1)*AA4))/DET
      G32(J)=(-B4(J)*(AA3*AA2-AA5*AA6)+AA9*(A11(J-1)*AA2-A31(J-1)*AA6)-
     1       AA10*(A11(J-1)*AA5-A31(J-1)*AA3))/DET
      G33(J)=(B4(J)*(AA3*AA1-AA4*AA6)-AA9*(A11(J-1)*AA1-A21(J-1)*AA6)+
     1       AA10*(A11(J-1)*AA4-A21(J-1)*AA3))/DET
      G34(J)=G31(J)*A12(J-1)+G32(J)*A22(J-1)+G33(J)*A32(J-1)-B6(J)
      G35(J)=G31(J)*A14(J-1)+G32(J)*A24(J-1)+G33(J)*A34(J-1)-B8(J)
      A11(J)=1.0
      A12(J)=-A(J)-G14(J)
      A13(J)=A(J)*G14(J)
      A14(J)=-G15(J)
      A15(J)=A(J)*G15(J)
      A21(J)=S3(J)
      A22(J)=S5(J)-G24(J)
      A23(J)=S1(J)+A(J)*G24(J)
      A24(J)=-G25(J)+S7(J)
      A25(J)=A(J)*G25(J)
      A31(J)=B3(J)
      A32(J)=B5(J)-G34(J)
      A33(J)=B9(J)+A(J)*G34(J)
      A34(J)=B7(J)-G35(J)
      A35(J)=B1(J)+A(J)*G35(J)
      W1(J) =R(1,J)-G11(J)*W1(J-1)-G12(J)*W2(J-1)-G13(J)*W3(J-1)-
     1       G14(J)*W4(J-1)-G15(J)*W5(J-1)
      W2(J) =R(2,J)-G21(J)*W1(J-1)-G22(J)*W2(J-1)-G23(J)*W3(J-1)-
     1       G24(J)*W4(J-1)-G25(J)*W5(J-1)
      W3(J) =R(3,J)-G31(J)*W1(J-1)-G32(J)*W2(J-1)-G33(J)*W3(J-1)-
     1       G34(J)*W4(J-1)-G35(J)*W5(J-1)
      W4(J) =R(4,J)
      W5(J) =R(5,J)
   30 CONTINUE
C - BACKWARD SWEEP
      J      =NP
      DP =    -(A31(J)*(A13(J)*W2(J)-W1(J)*A23(J))-A32(J)*(A11(J)*
     1       W2(J)-W1(J)*A21(J)) + W3(J)*(A11(J)*A23(J)-A13(J)*A21(J)))
      DV =    -(A31(J)*(W1(J)*A25(J)-W2(J)*A15(J))-W3(J)*(A11(J)*A25(J)
     1   -A15(J)*A21(J))+A35(J)*(A11(J)*W2(J)-W1(J)*A21(J)))
      DF =    -(W3(J)*(A13(J)*A25(J)-A23(J)*A15(J))-A33(J)*(W1(J)*A25(J)
     1   -A15(J)*W2(J)) + A35(J)*(W1(J)*A23(J)-A13(J)*W2(J)))
      D1 =   -(A31(J)*(A13(J)*A25(J)-A23(J)*A15(J))-A33(J)*(A11(J)*
     1    A25(J)-A21(J)*A15(J))+A35(J)*(A11(J)*A23(J)-A21(J)*A13(J)))
      DELP(J) = DP/D1
      DELV(J) = DV/D1
      DELF(J) = DF/D1
      DELG(J) = 0.0
      DELU(J) = 0.0
   40 J = J-1
      BB1=DELU(J+1)-A(J+1)*DELV(J+1)-W4(J)
      BB2=DELG(J+1)-A(J+1)*DELP(J+1)-W5(J)
      CC1=W1(J)-A12(J)*BB1-A14(J)*BB2
      CC2=W2(J)-A22(J)*BB1-A24(J)*BB2
      CC3=W3(J)-A32(J)*BB1-A34(J)*BB2
      DD1=A13(J)-A12(J)*A(J+1)
      DD2=A23(J)-A22(J)*A(J+1)
      DD3=A33(J)-A32(J)*A(J+1)
      EE1=A15(J)-A14(J)*A(J+1)
      EE2=A25(J)-A24(J)*A(J+1)
      EE3=A35(J)-A34(J)*A(J+1)
      DETT=A11(J)*DD2*EE3+A21(J)*DD3*EE1+A31(J)*DD1*EE2
     1     -A31(J)*DD2*EE1-A21(J)*DD1*EE3-A11(J)*DD3*EE2
      DELF(J)=(CC1*DD2*EE3+CC2*DD3*EE1+CC3*DD1*EE2-CC3*DD2*EE1
     1        -CC2*DD1*EE3-CC1*DD3*EE2)/DETT
      DELV(J)=(A11(J)*CC2*EE3+A21(J)*CC3*EE1+A31(J)*CC1*EE2-
     1        A31(J)*CC2*EE1-A21(J)*CC1*EE3-A11(J)*CC3*EE2)/DETT
      DELP(J)=(A11(J)*CC3*DD2+A21(J)*CC1*DD3+A31(J)*CC2*DD1-
     1        A31(J)*CC1*DD2-A21(J)*CC3*DD1-A11(J)*CC2*DD3)/DETT
      DELU(J)=BB1-A(J+1)*DELV(J)
      DELG(J)= BB2-A(J+1)*DELP(J)
      IF(J .GT. 1) GO TO 40
      DO 50 J=1,NP
      F(J,2)=F(J,2)+DELF(J)
      U(J,2)=U(J,2)+DELU(J)
      V(J,2)=V(J,2)+DELV(J)
      G(J,2)=G(J,2)+DELG(J)
      P(J,2)=P(J,2)+DELP(J)
 50   CONTINUE
      U(NP,2) = 0.0
      RETURN
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END
