C*********************************************************************
C
C 11.7 FORTRAN PROGRAM FOR MIXING LAYER BETWEEN TWO UNIFORM STREAMS
C      AT DIFFERENT TEMPERATURES
C
C*********************************************************************
C     MAIN
      COMMON /INPT1/ WW(60),ALFA0,ALFA1
      COMMON /BLC0/ NP,NPT,NX,NXT,NPH,IT
      COMMON /BLC1/ F(151,2),U(151,2),V(151,2),B(151,2),G(151,2),
     1              P(151,2),E(151,2)
      COMMON /GRD/ X(60),ETA(151),DETA(151),A(151)
      COMMON /EDGE/ UE(60),TE(60),RHOE(60),RMUE(60),PE(60),P1(60),P2(60)
      COMMON /BLC3/ DELF(151),DELU(151),DELV(151),DELG(151),DELP(151)
      COMMON /NCV1/ IPROB,RHG,BETA
      COMMON /AK1/ GW,PR,ALFA
      DIMENSION TITLE(20)
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      ITMAX = 6
      NX    = 1
C
C  INPUT DATA
      OPEN(UNIT=5,FILE='pr11_7inp.txt')
      OPEN(UNIT=6,FILE='pr11_7out.txt')
      READ(5,8150) TITLE
      READ(5,*) NXT,NPT
      READ(5,*) DETA(1),VGP,ALFA0,ALFA1
      READ(5,*) PR,ALFA,ETAE
      READ(5,*) (X(I),I=1,NXT)
      WRITE(6,8150) TITLE
      WRITE(6,7000) PR,ALFA,NXT,ETAE,DETA(1),VGP
C
C  GRID GENERATION
      IF((VGP-1.0) .LE. 0.001) GO TO 5
      NP    = ALOG((2.0*ETAE/DETA(1))*(VGP-1.0)+1.0)/ALOG(VGP) + 1.0001
      GO TO 10
    5 NP    = 2.0*ETAE/DETA(1) + 1.0001
   10 IF(NP .LE. NPT) GO TO 15
      print*, "NP=", NP
      WRITE(6,9000)
      STOP
   15 ETA(1)= -ETAE
      DO 20 J=2,NPT
      DETA(J)=VGP*DETA(J-1)
      A(J)  = 0.5*DETA(J-1)
   20 ETA(J)= ETA(J-1)+DETA(J-1)
      NPH = (NP + 1)/2
      CALL IVPL
C
   30 WRITE(6,9100) NX,X(NX)
      P1(NX) = 0.5
      P2(NX) = 0.0
      IT    = 0
      IPHI = 0
      WRITE(6,9410)
C
   40 IT    = IT+1
      IPROB = 1
      IF(IT .LE. ITMAX) GO TO 60
      WRITE(6,2500)
      IF(ABS(DELU(NPH)/U(NPH,2)) .LT. 0.1) GO TO 70
      STOP 1
C
   60 CONTINUE
      CALL COEF
      CALL SOLV5
      WRITE(6,3000) U(NPH,2),DELU(NPH)
C
C  CHECK FOR CONVERGENCE
      IF(ABS(DELU(NPH)) .GT. 1.0E-05) GO TO 40
C     IF(V(1,2) .LT. 0.0) STOP
C
C  SOLVE VARIATIONAL EQNS
C
   70 CONTINUE
      IF(IPHI .GT. 8) GO TO 80
      IPROB = 2
      CALL COEF
      CALL SOLV5
C
C  CHECK FOR Q/(DQ/DB)
      IPHI = IPHI + 1
      PHI = F(NPH,2)
      DPHI = DELF(NPH)
      TERM = PHI/DPHI
      WRITE(6,9400) F(1,2),TERM
      IF(ALFA .LT. 0.015) TERM = 0.5*TERM
      IF(ALFA .LT. 0.004) TERM = 0.7*TERM
      F(1,2) = F(1,2) - TERM
      IT = 0
      IF(ABS(TERM) .GT. 0.00005) GO TO 40
      IF(ALFA .LT. 0.0012 .AND. ABS(F(NPH,2)) .GT. 0.001) GO TO 40
   80 CONTINUE
C
      IF(NP .GE. NPT) GO TO 100
      IF(ABS(V(NP,2)) .LT. 0.001 .AND. ABS(V(1,2)) .LT. 0.001) GO TO 100
      IF(ABS(V(NP,2)) .LT. 0.001) GO TO 90
      CALL GROWTH
      IT = 1
      IPHI = 1
   90 IF(NP .GE. NPT) GO TO 40
      IF(ABS(V(1,2)) .LT. 0.001) GO TO 40
      CALL MYGRTH
      IT = 1
      IPHI = 1
      GO TO 40
  100 CONTINUE
C  OUTPUT DATA
      WRITE(6,4400)
      WRITE(6,4500) (J,ETA(J),F(J,2),U(J,2),V(J,2),G(J,2),P(J,2),
     1               B(J,2),J=1,NP)
C
      NX    = NX+1
      IF(NX .GT. NXT) STOP
C
C  SHIFT PROFILES
      DO 110 J=1,NP
      F(J,1)= F(J,2)
      U(J,1)= U(J,2)
      V(J,1)= V(J,2)
      G(J,1)= G(J,2)
      P(J,1)= P(J,2)
      E(J,1)= E(J,2)
  110 B(J,1)= B(J,2)
C
      GO TO 30
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 8000 FORMAT(8I3)
 8150 FORMAT(20A4)
 8100 FORMAT(8F10.0)
 3000 FORMAT(1H ,'U(NPH) =',E13.6,2X,6HDELU =,E13.6)
 4400 FORMAT(1H ,2X,1HJ,4X,3HETA,9X,1HF,13X,1HU,13X,1HV,13X,1HG,13X,1HP,
     1       13X,1HB)
 4500 FORMAT(1H ,I3,F10.3,6E14.6)
 7000 FORMAT(1H ,4HPR =,E12.5,5X,'ALFA  =',E12.5/1H0,5HNXT =,I3,
     1        5X,6HETAE =,E12.5,3X,6HDETA1=,E12.5,3X,6HVGP  =,E12.5)
 2500 FORMAT(1H ,16X,25HITERATIONS EXCEEDED ITMAX)
 9000 FORMAT(1H ,'NP EXCEEDED NPT -- PROGRAM TERMINATED')
 9100 FORMAT(1H ,4HNX =,I3,5X,3HX =,F10.3/)
 9400 FORMAT(1H ,79X,2E14.6)
 9410 FORMAT(1H ,84X,'F(1,2)',9X,'TERM')
      END
      SUBROUTINE IVPL
      COMMON /BLC0/ NP,NPT,NX,NXT,NPH,IT
      COMMON /BLC1/ F(151,2),U(151,2),V(151,2),B(151,2),G(151,2),
     1              P(151,2),E(151,2)
      COMMON /GRD/ X(60),ETA(151),DETA(151),A(151)
      COMMON /AK1/ GW,PR,ALFA
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C
      PY = ACOS(-1.0)
      SQPY = SQRT(PY)
      ALFAP = 0.5*(1.0 + ALFA)
      ALFAM = 0.5*(1.0 - ALFA)
      CNST = - 2.0/SQPY*ALFAM
C
      DO 30 J=1,NP
      ETAH = 0.5*ETA(J)
      CALL ERF(ETAH,ERFETA)
      ETAS = 0.25*ETA(J)*ETA(J)
      F(J,2) = ALFAP*ETA(J) + ALFAM*(ETA(J)*ERFETA + 2.0/SQPY*
     1         EXP(-ETAS)) + CNST
      U(J,2) = ALFAP + ALFAM*ERFETA
      V(J,2) = ALFAM*EXP(-ETAS)/SQPY
      G(J,2) = 0.5*(1.0 + ERFETA)
      P(J,2) = 0.5*EXP(-ETAS)/SQRT(PY)
      B(J,2) = 1.0
      E(J,2) = B(J,2)/PR
   30 CONTINUE
      RETURN
      END
      SUBROUTINE COEF
      COMMON /INPT1/ WW(60),ALFA0,ALFA1
      COMMON /NCV1/ IPROB,RHG,BETA
      COMMON /BLC0/ NP,NPT,NX,NXT,NPH,IT
      COMMON /BLC1/ F(151,2),U(151,2),V(151,2),B(151,2),G(151,2),
     1              P(151,2),E(151,2)
      COMMON /GRD/ X(60),ETA(151),DETA(151),A(151)
      COMMON /EDGE/ UE(60),TE(60),RHOE(60),RMUE(60),PE(60),P1(60),P2(60)
      COMMON /BLC6/ S1(151),S2(151),S3(151),S4(151),S5(151),S6(151),
     1             S7(151),S8(151),B1(151),B2(151),B3(151),B4(151),
     2         B5(151),B6(151),B7(151),B8(151),B9(151),B10(151),R(5,151)
C
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C
      IF(IT .GT. 1) GO TO 5
      IF(NX .GT. 1) GO TO 3
      CEL = 0.0
      P1P = 0.5
      P2P = 0.0
      XB  = 0.0
      GO TO 5
    3 CONTINUE
      XB = 0.5*(X(NX) + X(NX-1))
      CEL = 0.5*(X(NX) + X(NX-1))/(X(NX) - X(NX-1))
      P1P = P1(NX) + CEL
      P2P = P2(NX) + CEL
    5 CONTINUE
C
      DO 100 J=2,NP
      IF(IPROB .EQ. 2) GO TO 80
C  PRESENT STATION
      USB   = 0.5*(U(J,2)**2+U(J-1,2)**2)
      FVB   = 0.5*(F(J,2)*V(J,2)+F(J-1,2)*V(J-1,2))
      FPB   = 0.5*(F(J,2)*P(J,2)+F(J-1,2)*P(J-1,2))
      UGB   = 0.5*(U(J,2)*G(J,2)+U(J-1,2)*G(J-1,2))
      UB    = 0.5*(U(J,2)+U(J-1,2))
      VB    = 0.5*(V(J,2)+V(J-1,2))
      FB    = 0.5*(F(J,2)+F(J-1,2))
      GB    = 0.5*(G(J,2)+G(J-1,2))
      PB    = 0.5*(P(J,2)+P(J-1,2))
      DERBV = (B(J,2)*V(J,2)-B(J-1,2)*V(J-1,2))/DETA(J-1)
      DEREP = (E(J,2)*P(J,2)-E(J-1,2)*P(J-1,2))/DETA(J-1)
      IF(NX .GT. 1) GO TO 10
C  PREVIOUS STATION
      CFB   = 0.0
      CVB   = 0.0
      CPB   = 0.0
      CUB   = 0.0
      CGB   = 0.0
      CUGB  = 0.0
      CFPB  = 0.0
      CFVB  = 0.0
      CUSB  = 0.0
      CDERBV = 0.0
      CDEREP = 0.0
      CRB = -P2(NX)
      CTB = 0.0
      GO TO 20
   10 CFB   = 0.5*(F(J,1)+F(J-1,1))
      CVB   = 0.5*(V(J,1)+V(J-1,1))
      CPB   = 0.5*(P(J,1)+P(J-1,1))
      CUB   = 0.5*(U(J,1)+U(J-1,1))
      CGB   = 0.5*(G(J,1)+G(J-1,1))
      CFVB  = 0.5*(F(J,1)*V(J,1)+F(J-1,1)*V(J-1,1))
      CFPB  = 0.5*(F(J,1)*P(J,1)+F(J-1,1)*P(J-1,1))
      CUGB  = 0.5*(U(J,1)*G(J,1)+U(J-1,1)*G(J-1,1))
      CUSB  = 0.5*(U(J,1)**2+U(J-1,1)**2)
      CDERBV= (B(J,1)*V(J,1)-B(J-1,1)*V(J-1,1))/DETA(J-1)
      CDEREP= (E(J,1)*P(J,1)-E(J-1,1)*P(J-1,1))/DETA(J-1)
C
      CLB = CDERBV + P1(NX-1)*CFVB + P2(NX-1)*(1.0-CUSB)
      CRB = -CLB - P2(NX) - CEL*CUSB + CEL*CFVB
      CMB = CDEREP + CDRDUV + P1(NX-1)*CFPB
      CTB = -CMB + CEL*(CFPB-CUGB)
C
C  COEFFICIENTS OF THE DIFFERENCED MOMENTUM EQ.
   20 CONTINUE
      S1(J) = B(J,2)/DETA(J-1) + 0.5*P1P*F(J,2) - 0.5*CEL*CFB
      S2(J) = -B(J-1,2)/DETA(J-1) + 0.5*P1P*F(J-1,2) - 0.5*CEL*CFB
      S3(J) = 0.5*(P1P*V(J,2) + CEL*CVB)
      S4(J) = 0.5*(P1P*V(J-1,2) + CEL*CVB)
      S5(J) = -P2P*U(J,2)
      S6(J) = -P2P*U(J-1,2)
      S7(J) = 0.0
      S8(J) = S7(J)
C
      R(2,J) = CRB - (DERBV + P1P*FVB - P2P*USB + CEL*(FB*CVB-VB*CFB))
C
C  COEFFICIENTS OF DIFFERENCED ENERGY EQ.
      B1(J) = E(J,2)/DETA(J-1) + 0.5*P1P*F(J,2) - 0.5*CEL*CFB
      B2(J) = -E(J-1,2)/DETA(J-1) + 0.5*P1P*F(J-1,2) - 0.5*CEL*CFB
      B3(J) = 0.5*(P1P*P(J,2) + CEL*CPB)
      B4(J) = 0.5*(P1P*P(J-1,2) + CEL*CPB)
      B5(J) =  - 0.5*CEL*(G(J,2)-CGB)
      B6(J) =  - 0.5*CEL*(G(J-1,2)-CGB)
      B7(J) = -0.5*CEL*(U(J,2)+CUB)
      B8(J) = -0.5*CEL*(U(J-1,2)+CUB)
      B9(J) = 0.0
      B10(J) = 0.0
C
      R(3,J) = CTB - (DEREP + DRDUV + P1P*FPB - CEL*(UGB-CGB*UB+CUB*GB)+
     1           CEL*(CPB*FB-CFB*PB))
C
C  DEFINITIONS OF RJ FOR STANDARD PROBLEM
      R(1,J)= F(J-1,2)-F(J,2)+DETA(J-1)*UB
      R(4,J-1) = U(J-1,2)-U(J,2)+DETA(J-1)*VB
      R(5,J-1) = G(J-1,2)-G(J,2)+DETA(J-1)*PB
      GO TO 100
   80 CONTINUE
C  DEFINITIONS OF RJ FOR VARIATIONAL PROBLEM
      R(1,J) = 0.0
      R(2,J) = 0.0
      R(3,J) = 0.0
      R(4,J-1) = 0.0
      R(5,J-1) = 0.0
  100 CONTINUE
C  DEFINITIONS OF RJ FOR BOUNDARY CONDITIONS
      R(1,1) = 0.0
      R(2,1) = 0.0
      R(3,1) = 0.0
      R(4,NP)=0.0
      R(5,NP)=0.0
      IF(IPROB .EQ. 2) R(1,1) = 1.0
      RETURN
      END
      SUBROUTINE SOLV5
      COMMON /NCV1/ IPROB,RHG,BETA
      COMMON /INPT1/ WW(60),ALFA0,ALFA1
      COMMON /BLC0/ NP,NPT,NX,NXT,NPH,IT
      COMMON /GRD/ X(60),ETA(151),DETA(151),A(151)
      COMMON /BLC1/ F(151,2),U(151,2),V(151,2),B(151,2),G(151,2),
     1              P(151,2),E(151,2)
      COMMON /BLC3/ DELF(151),DELU(151),DELV(151),DELG(151),DELP(151)
      COMMON /BLC6/ S1(151),S2(151),S3(151),S4(151),S5(151),S6(151),
     1             S7(151),S8(151),B1(151),B2(151),B3(151),B4(151),
     2         B5(151),B6(151),B7(151),B8(151),B9(151),B10(151),R(5,151)
      DIMENSION    A11(151),A12(151),A13(151),A14(151),A15(151),A21(151)
      DIMENSION    A22(151),A23(151),A24(151),A25(151),A31(151),A32(151)
      DIMENSION    A33(151),A34(151),A35(151),G11(151),G12(151),G13(151)
      DIMENSION    G14(151),G15(151),G21(151),G22(151),G23(151),G24(151)
      DIMENSION    G25(151),G31(151),G32(151),G33(151),G34(151),G35(151)
      DIMENSION    W1(151),W2(151),W3(151),W4(151),W5(151)
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      A11(1)=1.0
      A12(1)=0.0
      A13(1)=0.0
      A14(1)=0.0
      A15(1)=0.0
C
      A21(1)=0.0
      A22(1)=1.0
      A23(1)=0.0
      A24(1)=0.0
      A25(1)=0.0
C
      A31(1)=0.0
      A32(1)=0.0
      A33(1)=0.0
      A34(1)=ALFA0
      A35(1)=ALFA1
C
      W1 (1)=R(1,1)
      W2 (1)=R(2,1)
      W3 (1)=R(3,1)
      W4 (1)=R(4,1)
      W5 (1)=R(5,1)
C - FORWARD SWEEP
      DO 30 J=2,NP
      AA1=A(J)*A24(J-1)-A25(J-1)
      AA2=A(J)*A34(J-1)-A35(J-1)
      AA3=A(J)*A12(J-1)-A13(J-1)
      AA4=A(J)*A22(J-1)-A23(J-1)
      AA5=A(J)*A32(J-1)-A33(J-1)
      AA6=A(J)*A14(J-1)-A15(J-1)
      AA7=A(J)*S6(J)-S2(J)
      AA8=S8(J)*A(J)
      AA9=A(J)*B6(J)-B10(J)
      AA10=A(J)*B8(J)-B2(J)
      DET=A11(J-1)*(AA4*AA2-AA1*AA5)-A21(J-1)*(AA3*AA2-AA5*AA6)+
     1    A31(J-1)*(AA3*AA1-AA4*AA6)
      G11(J)=(-(AA4*AA2-AA5*AA1)+A(J)**2*(A21(J-1)*AA2-A31(J-1)*AA1))/
     1       DET
      G12(J)=((AA3*AA2-AA5*AA6)-A(J)**2*(A11(J-1)*AA2-A31(J-1)*AA6))/DET
      G13(J)=(-(AA3*AA1-AA4*AA6)+A(J)**2*(A11(J-1)*AA1-A21(J-1)*AA6))/
     1       DET
      G14(J)=G11(J)*A12(J-1)+G12(J)*A22(J-1)+G13(J)*A32(J-1)+A(J)
      G15(J)=G11(J)*A14(J-1)+G12(J)*A24(J-1)+G13(J)*A34(J-1)
      G21(J)=(S4(J)*(AA2*AA4-AA1*AA5)+A31(J-1)*(AA1*AA7-AA4*AA8)+
     1       A21(J-1)*(AA5*AA8-AA7*AA2))/DET
      G22(J)=(A11(J-1)*(AA2*AA7-AA5*AA8)+A31(J-1)*(AA3*AA8-AA6*AA7)+
     1       S4(J)*(AA5*AA6-AA2*AA3))/DET
      G23(J)=(A11(J-1)*(AA4*AA8-AA1*AA7)+S4(J)*(AA3*AA1-AA4*AA6)+
     1       A21(J-1)*(AA7*AA6-AA3*AA8))/DET
      G24(J)=G21(J)*A12(J-1)+G22(J)*A22(J-1)+G23(J)*A32(J-1)-S6(J)
      G25(J)=G21(J)*A14(J-1)+G22(J)*A24(J-1)+G23(J)*A34(J-1)-S8(J)
      G31(J)=(B4(J)*(AA4*AA2-AA5*AA1)-AA9*(A21(J-1)*AA2-A31(J-1)*AA1)+
     1       AA10*(A21(J-1)*AA5-A31(J-1)*AA4))/DET
      G32(J)=(-B4(J)*(AA3*AA2-AA5*AA6)+AA9*(A11(J-1)*AA2-A31(J-1)*AA6)-
     1       AA10*(A11(J-1)*AA5-A31(J-1)*AA3))/DET
      G33(J)=(B4(J)*(AA3*AA1-AA4*AA6)-AA9*(A11(J-1)*AA1-A21(J-1)*AA6)+
     1       AA10*(A11(J-1)*AA4-A21(J-1)*AA3))/DET
      G34(J)=G31(J)*A12(J-1)+G32(J)*A22(J-1)+G33(J)*A32(J-1)-B6(J)
      G35(J)=G31(J)*A14(J-1)+G32(J)*A24(J-1)+G33(J)*A34(J-1)-B8(J)
      A11(J)=1.0
      A12(J)=-A(J)-G14(J)
      A13(J)=A(J)*G14(J)
      A14(J)=-G15(J)
      A15(J)=A(J)*G15(J)
      A21(J)=S3(J)
      A22(J)=S5(J)-G24(J)
      A23(J)=S1(J)+A(J)*G24(J)
      A24(J)=-G25(J)+S7(J)
      A25(J)=A(J)*G25(J)
      A31(J)=B3(J)
      A32(J)=B5(J)-G34(J)
      A33(J)=B9(J)+A(J)*G34(J)
      A34(J)=B7(J)-G35(J)
      A35(J)=B1(J)+A(J)*G35(J)
      W1(J) =R(1,J)-G11(J)*W1(J-1)-G12(J)*W2(J-1)-G13(J)*W3(J-1)-
     1       G14(J)*W4(J-1)-G15(J)*W5(J-1)
      W2(J) =R(2,J)-G21(J)*W1(J-1)-G22(J)*W2(J-1)-G23(J)*W3(J-1)-
     1       G24(J)*W4(J-1)-G25(J)*W5(J-1)
      W3(J) =R(3,J)-G31(J)*W1(J-1)-G32(J)*W2(J-1)-G33(J)*W3(J-1)-
     1       G34(J)*W4(J-1)-G35(J)*W5(J-1)
      W4(J) =R(4,J)
      W5(J) =R(5,J)
   30 CONTINUE
C - BACKWARD SWEEP
      J      =NP
      DP =    -(A31(J)*(A13(J)*W2(J)-W1(J)*A23(J))-A32(J)*(A11(J)*
     1       W2(J)-W1(J)*A21(J)) + W3(J)*(A11(J)*A23(J)-A13(J)*A21(J)))
      DV =    -(A31(J)*(W1(J)*A25(J)-W2(J)*A15(J))-W3(J)*(A11(J)*A25(J)
     1   -A15(J)*A21(J))+A35(J)*(A11(J)*W2(J)-W1(J)*A21(J)))
      DF =    -(W3(J)*(A13(J)*A25(J)-A23(J)*A15(J))-A33(J)*(W1(J)*A25(J)
     1   -A15(J)*W2(J)) + A35(J)*(W1(J)*A23(J)-A13(J)*W2(J)))
      D1 =   -(A31(J)*(A13(J)*A25(J)-A23(J)*A15(J))-A33(J)*(A11(J)*
     1    A25(J)-A21(J)*A15(J))+A35(J)*(A11(J)*A23(J)-A21(J)*A13(J)))
      DELP(J) = DP/D1
      DELV(J) = DV/D1
      DELF(J) = DF/D1
      DELG(J) = 0.0
      DELU(J) = 0.0
C
   40 J = J-1
      BB1=DELU(J+1)-A(J+1)*DELV(J+1)-W4(J)
      BB2=DELG(J+1)-A(J+1)*DELP(J+1)-W5(J)
      CC1=W1(J)-A12(J)*BB1-A14(J)*BB2
      CC2=W2(J)-A22(J)*BB1-A24(J)*BB2
      CC3=W3(J)-A32(J)*BB1-A34(J)*BB2
      DD1=A13(J)-A12(J)*A(J+1)
      DD2=A23(J)-A22(J)*A(J+1)
      DD3=A33(J)-A32(J)*A(J+1)
      EE1=A15(J)-A14(J)*A(J+1)
      EE2=A25(J)-A24(J)*A(J+1)
      EE3=A35(J)-A34(J)*A(J+1)
      DETT=A11(J)*DD2*EE3+A21(J)*DD3*EE1+A31(J)*DD1*EE2
     1     -A31(J)*DD2*EE1-A21(J)*DD1*EE3-A11(J)*DD3*EE2
      DELF(J)=(CC1*DD2*EE3+CC2*DD3*EE1+CC3*DD1*EE2-CC3*DD2*EE1
     1        -CC2*DD1*EE3-CC1*DD3*EE2)/DETT
      DELV(J)=(A11(J)*CC2*EE3+A21(J)*CC3*EE1+A31(J)*CC1*EE2-
     1        A31(J)*CC2*EE1-A21(J)*CC1*EE3-A11(J)*CC3*EE2)/DETT
      DELP(J)=(A11(J)*CC3*DD2+A21(J)*CC1*DD3+A31(J)*CC2*DD1-
     1        A31(J)*CC1*DD2-A21(J)*CC3*DD1-A11(J)*CC2*DD3)/DETT
      DELU(J)=BB1-A(J+1)*DELV(J)
      DELG(J)= BB2-A(J+1)*DELP(J)
      IF(J .GT. 1) GO TO 40
      IF(IPROB .EQ. 2) RETURN
C
      DO 50 J=1,NP
      F(J,2)=F(J,2)+DELF(J)
      U(J,2)=U(J,2)+DELU(J)
      V(J,2)=V(J,2)+DELV(J)
      G(J,2)=G(J,2)+DELG(J)
      P(J,2)=P(J,2)+DELP(J)
 50   CONTINUE
      RETURN
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END
      SUBROUTINE MYGRTH
      COMMON /BLC0/ NP,NPT,NX,NXT,NPH,IT
      COMMON /BLC1/ F(151,2),U(151,2),V(151,2),B(151,2),G(151,2),
     1              P(151,2),E(151,2)
      COMMON /GRD/ X(60),ETA(151),DETA(151),A(151)
      COMMON /AK1/ GW,PR,ALFA
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      NXP = 2
      J = NP + 1
   20 J = J-1
      ETA(J+NXP) = ETA(J)
      DETA(J+NXP) = DETA(J)
      A(J+NXP) = A(J)
      U(J+NXP,2) = U(J,2)
      F(J+NXP,2) = F(J,2)
      V(J+NXP,2) = V(J,2)
      G(J+NXP,2) = G(J,2)
      P(J+NXP,2) = P(J,2)
      B(J+NXP,2) = B(J,2)
      E(J+NXP,2) = E(J,2)
      IF(J .GT. 1) GO TO 20
C     NXP+1 IS KNOWN
C
      J = NXP + 1
   40 J = J - 1
      DETA(J) = DETA(J+1)
      A(J+1) = 0.5*DETA(J)
      ETA(J) = ETA(J+1) - DETA(J)
      B(J,2) = B(J+1,2)
      E(J,2) = E(J+1,2)
      G(J,2) = G(J+1,2)
      P(J,2) = P(J+1,2)
      IF(J .GT. 1) GO TO 40
C
      J = NXP + 1
   60 J = J - 1
      U(J,2) = U(NXP+1,2) + (ETA(J)-ETA(NXP+1))*(U(NXP+1,2)-ALFA)/
     1                      (ETA(NXP+1)-ETA(1))
      F(J,2) = F(J+1,2) + A(J+1)*(U(J,2)+U(J+1,2))
      V(J,2) = V(NXP+1,2) + (ETA(J)-ETA(NXP+1))*V(NXP+1,2)/
     1                      (ETA(NXP+1)-ETA(1))
      IF(J .GT. 1) GO TO 60
C
      NP = NP + NXP
      NPH = NPH + NXP
      IF(NP .GE. NPT) STOP
      RETURN
      END
      SUBROUTINE GROWTH
      COMMON /BLC0/ NP,NPT,NX,NXT,NPH,IT
      COMMON /BLC1/ F(151,2),U(151,2),V(151,2),B(151,2),G(151,2),
     1              P(151,2),E(151,2)
      COMMON /GRD/ X(60),ETA(151),DETA(151),A(151)
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      NP1 = NP + 1
      NP = NP + 2
      DO 20 J=NP1,NP
      DETA(J-1) = DETA(J-2)
      A(J)      = 0.5*DETA(J-1)
      ETA(J) = ETA(J-1) + DETA(J-1)
      U(J,2) = U(J-1,2)
      V(J,2) = 0.0
      F(J,2) = F(J-1,2) + A(J)*(U(J,2)+U(J-1,2))
      G(J,2) = 0.0
      P(J,2) = 0.0
      E(J,2) = E(J-1,2)
      B(J,2) = B(J-1,2)
   20 CONTINUE
      RETURN
      END
      SUBROUTINE ERF(Y,SUM)
      DIMENSION T(101)
      IF (Y .LE. 4.0 .AND. Y .GE. -4.0) GOTO 3
      IF (Y .GT. 4.0) SUM = 1.0
      IF (Y .LT.-4.0) SUM = -1.0
      RETURN
3     NT = 100
      DT = Y / FLOAT(NT)
      T(1) = 0.0
      DO 5 I = 2 , NT+1
      T(I) = T(I-1) + DT
5     CONTINUE
      SUM = 0.0
      U1  = 1.0
      DO 10 I = 2 , NT+1
      U2 = EXP(-T(I)**2)
      SUM = SUM + 0.5*(U1+U2)*(T(I)-T(I-1))
      U1 = U2
10    CONTINUE
      SUM = SUM*2.0/SQRT(3.141592)
      RETURN
      END
