c*********************************************************************
c
c     11.8b  fortran program for test 2
c     constant heat flux 
c*********************************************************************
c
      common/blc0/nxt,iwbcoe,iebcoe,iturb,icoord,index,n,np,npt,pr,vgp,
     +            gwa,rey,cel,eta(81),up(81),deta(81),a(81),yp(81),
     +            x(101),gw(101),pw(101),ge(101),g(81,2),p(81,2)
      common/blc1/ s1(81),s2(81),s3(81),r1(81),r2(81),a1(81,2),a2(81,2)
     +            ,etae
      common /blcs/ xs(101),anu(101), ag(101)
      dimension title(20)
	CHARACTER*80 input_name, output_name
c
c  read in and print out parameters
c
c     open(unit=5,file='pr11_8binp.txt',status='old')
c     open(unit=6,file='pr11_8bout.txt')
      WRITE(6,*) "Enter input file name (include extension name)"
	READ(5,*) input_name
	WRITE(6,*) "Enter output file name"
	READ(5,*) output_name
	OPEN(unit=5,file=input_name,STATUS="OLD")
	OPEN(unit=6,file=output_name)           

      npt = 61
      read(5,8150) title
      read(5,*) nxt,iwbcoe,iebcoe,iturb,etae,deta(1),vgp,pr,gwa,rey
      vgp = amin1(1.025,vgp)
      read(5,9300) (x(i),i=1,nxt)

      write(6,8150) title
      write(6,9000) nxt,iwbcoe,iebcoe,iturb,etae,deta(1),vgp,pr,gwa,rey
      if((vgp-1.0) .gt. 0.0001) go to 20
      np= etae/deta(1)+1.0001
      go to 30
  20  np=alog((etae/deta(1))*(vgp-1.0)+1.0)/alog(vgp)+1.0001
  30  if(np .le. npt) go to 40
      write(6,9100)
      stop
  40  eta(1)=0.0
      yp(1)=0.0
c
c initial temperature profile at x=x0
      g(1,2)=1.0
      p(1,2)= 1.0
      do  50  j= 2,npt
      yp(j)= 0.0
      a1(j,2)= 1.0
      a2(j,2)= 0.0
      a1(j,1)= a1(j,2)
      a2(j,1)= a2(j,2)
c
c generation of grid system
c
      deta(j)=deta(j-1)*vgp
      eta(j)=eta(j-1)+deta(j-1)
 50   a(j)=0.5*deta(j-1)
      do 51 j=1,np
      p(j,2)=exp(-50.0*eta(j)/eta(np))
      g(j,2)=-eta(np)/50.0*p(j,2)+1.0
      p(j,1)= p(j,2)
      g(j,1)= g(j,2)
 51   continue
      n=1
      icoord = 1
      index =0
      pw(1) = 1.0
 60   write(6,9200) n,x(n)
      if(n .eq. 1) go to 80
      if(icoord.eq. 2) cel = 1.0/(x(n)-x(n-1))
      if(icoord.eq. 1) cel = 0.5*(x(n)+x(n-1))/(x(n)-x(n-1))
      igrow= 0
 70   call coef
      call solv2
c
c check for boundary layer growth
c
      if(icoord.eq.2 .or. np.eq.npt) go to 80
      if(igrow.ge.3 .or. abs(p(np,2)).lt.1.e-03) go to 80
      xswitch= 1.0/eta(np+1)**2
      if(x(n).ge.xswitch) go to 80
      np= np+1
      igrow=igrow+1
      g(np,1)=g(np-1,1)
      p(np,1)=0.0
      go to 70
  80  call output
      go to 60
c-----------------------------------------------------------------
 8000 format(4i5,6f10.0)
 8100 format(8f10.0)
 8150 format(20a4)
 9000 format(1h0,7hnxt   =i3,14x,7hiwbcoe=,i3,14x,7hiebcoe=,i3,14x,
     1       7hiturb =,i3/1h ,7hetae  =,e14.6,3x,7hdeta1 =e14.6,3x,
     2    7hvgp   =,e14.6,3x,7hpr    =,e14.6/1h,7hgwa   =,e14.6,3x,
     3       7hrey   =,e14.6)
 9100 format(1h0,35hnp exceeded npt-- program terminated)
 9200 format(/1h0,2hn=,i3,5x,3hx =,e14.6)
 9300 format(4e14.6)
      end
      subroutine coef
      real k,kh
      common/blc0/ nxt,iwbcoe,iebcoe,iturb,icoord,index,n,np,npt,pr,vgp,
     1             gwa,rey,cel,eta(81),up(81),deta(81),a(81),yp(81),
     2             x(101),gw(101),pw(101),ge(101),g(81,2),p(81,2)
      common/blc1/ s1(81),s2(81),s3(81),r1(81),r2(81),a1(81,2),a2(81,2)
     1             ,etae
      dimension c(5),edv(81),dudy(81)
      data k,kh/0.4,0.44/
      data igwall,aplus,c/0,26.0,34.96,28.79,33.95,6.3,-1.186/
c---------------------------------------------------------------------
      switch=0.0
      xp1=1.0
      jj=np
      if(icoord.eq.2) go to 15
      switch=1.0
      xp1=sqrt(x(n))
      ge(n)=1.0
      do 5 j=1,npt
      yp(j)=xp1*eta(j)
      if(yp(j).gt.1.0) go to 10
   5  continue
      jj= npt
      go to 15
  10  jj=j-1
  15  if(iturb.eq.1) go to 25
c  velocity profile and coefficients of energy eq'n for laminar flow
      do 20 j=1,jj
      yp(j)=xp1*eta(j)
      rp=1.0-yp(j)
      up(j)=2.0*(1.0-rp**2)
      a1(j,2)=rp
   20 a2(j,2)=up(j)*rp
      go to 45
c velocity profile, eddy viscosity and turbulent prandtl number
c for turbulent flow
   25 continue
      f=0.3164/(2.*rey)**0.25
      alogpr=alog10(pr)
      sum=c(1)
      do 30 i=2,5
  30  sum=sum+c(i)*alogpr**(i-1)
      bplus=sum/sqrt(pr)
      prt=k/kh*bplus/aplus
      up(1)=0.0
      cy0a=0.5*rey/aplus*sqrt(0.5*f)
      cy0b=cy0a*aplus/bplus
      do 40 j=1,jj
      yp(j)=xp1*eta(j)
      rp=1.0-yp(j)
      y0a=yp(j)*cy0a
      y0b=yp(j)*cy0b
      expy0a=0.0
      expy0b=0.0
      if(y0a.lt.50.0) expy0a=exp(-y0a)
      if(y0b.lt.50.0)expy0b=exp(-y0b)
      cmix=(0.14-rp**2*(0.08+0.06*rp**2))*(1.-expy0a)
      dudy(j)=0.25*rey*f*rp/(1.+sqrt(1.+0.5*f*rp*(rey*cmix)**2))
      edv(j)=cmix**2*rey*dudy(j)
      if(j.eq.1)go to 35
      up(j)=up(j-1)+0.5*(dudy(j)+dudy(j-1))*(yp(j)-yp(j-1))
      prt=k/kh*(1.-expy0a)/(1.0-expy0b)
c   coeffs of the energy equation for turbulent flow
  35  a1(j,2)=rp*(1.0+pr/prt*edv(j))
      a2(j,2)=rp*up(j)
  40  continue
  45  pw(n)=1.0
      if(icoord.eq.2) pw(n)=etae
      go to 50
c coeffs of the finite difference equations
 50   do 55 j=2,np
      etab=0.5*(eta(j)+eta(j-1))
      cgb=0.5*(g(j,1)+g(j-1,1))
      cpb=0.5*(p(j,1)+p(j-1,1))
      a2b=0.5*(a2(j,2)+a2(j-1,2))
      a3b=0.5*a2b
      if (icoord.eq.2) a3b=0.0
      ca2b=0.5*(a2(j,1)+a2(j-1,1))
      ca3b=0.5*ca2b
      if (icoord.eq.2) ca3b=0.0
      dera1p=(a1(j,1)*p(j,1)-a1(j-1,1)*p(j-1,1))/deta(j-1)
      s1(j)=a1(j,2)/deta(j-1)+0.25*etab*a2b*switch
      s2(j)=-a1(j-1,2)/deta(j-1)+0.25*etab*a2b*switch
      s3(j)=-0.5*(ca2b+a2b)*cel-0.5*a3b
      r1(j)=2.0*(-0.5*(ca2b+a2b)*cel)*cgb-2.0*(0.5*(a3b+ca3b))-dera1p
     1 -0.5*ca2b*etab*cpb*switch+cgb*ca3b
  55  r2(j-1)=0.0
      return
      end
      subroutine output
      common/blc0/ nxt,iwbcoe,iebcoe,iturb,icoord,index,n,np,npt,pr,vgp,
     +             gwa,rey, cel, eta(81),up(81),deta(81),a(81),yp(81),
     +             x(101),gw(101),pw(101),ge(101),g(81,2),p(81,2)
      common/blc1/ s1(81),s2(81),s3(81),r1(81),r2(81),a1(81,2),a2(81,2)
     +             ,etae
      common /blcs/ xs(101),anu(101), ag(101)
c
c print out dimensionless temperature profile
c
      write(6,9100) (j,eta(j),g(j,2),p(j,2),up(j),yp(j),j=1,np)
      xs(n) = x(n)
      if(n.eq.1) go to 15
c calculate and print out dimensionless mix temperature and nusselt #
c
      cnuxo=2.0*p(1,2)
      c=0.0
      if(icoord.eq.2) go to 5
      c=1.0
      cnuxo=cnuxo/sqrt(x(n))
   5  gmix=0.0
      f2=0.0
      do 10 j=2,np
      f1=f2
      f2=2.*(1.-yp(j))*up(j)*(g(j,2)-c)
      gmix=gmix+0.5*(f1+f2)*(yp(j)-yp(j-1))
  10  continue
      gmix=gmix+c
      cnuxm=cnuxo/(gmix-g(1,2))
      write(6,9200)gmix,cnuxm
      ag(n)  = gmix
      anu(n) = cnuxm
  15  if(n.eq.nxt) then
        write (6,9555) (i, xs(i), ag(i), anu(i), i = 2, nxt)
 9555 format(///2x, 'result summary'/
     1   /2x, 'i', 6x, 's ', 10x, 'gn', 10x, 'nu'/ (i3, 3e12.4))
        stop
      endif
c
c  check for switch location
c
      eps = 1.e-6
      if(icoord.eq.1) then
         if(index .eq. 0) then
            xswitch = 1./eta(np)**2
            if(x(n+1).ge.(xswitch-eps)) then
               x(n+1) = xswitch
               x(n+2) = 0.25*(x(n+1)+2.*x(n+2)+x(n+3))
               index  = 1
            endif
            etae = eta(np)
         else
c
c switch to primitive variables
c
            sqx=sqrt(x(n))
            do j=1,np
               eta(j)=eta(j)*sqx
               deta(j)=deta(j)*sqx
               p(j,2)=p(j,2)/sqx
               if(j.gt.1) a(j)=0.5*deta(j-1)
            enddo
            icoord= 2
            iebcoe= 0
            index = 0
            write(6,9300)
         endif
      endif
c
c shift profiles for next station calculation
c
      if(n .le. 10) then
         do 32 j=1,npt
            g(j,1)=0.5*(g(j,1)+g(j,2))
            p(j,1)=0.5*(p(j,1)+p(j,2))
            a1(j,1)=0.5*(a1(j,2)+a1(j,1))
            a2(j,1)=0.5*(a2(j,2)+a2(j,1))
  32     continue
         X(N)=0.5*(X(N)+X(N-1))
      else
         do 40 j=1,npt
            g(j,1)=g(j,2)
            p(j,1)=p(j,2)
            a1(j,1)=a1(j,2)
            a2(j,1)=a2(j,2)
  40     continue
      endif
      n=n+1
      return
c
c----------------------------------------------------------------------
c
 9100 format(1h0,2x,1hj,3x,3heta,10x,1hg,13x,1hp,12x,2hup,12x,2hyp/
     1       (1h ,i3,f10.5,4e14.6))
 9200 format(1h0,6hgmix =,e14.6,3x,6hnuxm =,e14.6)
 9300 format(1h0,31h***** primitive variables *****)
 9500 format(2e14.6)
      end
      subroutine solv2
      common/blc0/ nxt,iwbcoe,iebcoe,iturb,icoord,index,n,np,npt,pr,vgp,
     1             gwa,rey,cel,eta(81),up(81),deta(81),a(81),yp(81),
     2             x(101),gw(101),pw(101),ge(101),g(81,2),p(81,2)
      common/blc1/ s1(81),s2(81),s3(81),r1(81),r2(81),a1(81,2),a2(81,2)
     1             ,etae
      dimension g11(81),g12(81),a11(81),a12(81),a21(81),a22(81),w1(81),
     1          w2(81),den(81)
c----------------------------------------------------------------------
      if(iwbcoe.eq.0) go to 10
c*****specified wall temperature boundary condition***************
      alfa0=1.0
      alfa1=0.0
      g(1,2)= gw(n)
      p(1,2)= 0.0
      go to 20
c
c*****specified wall heat flux*********************************
  10  alfa0=0.0
      alfa1=1.0
      g(1,2)=0.0
      p(1,2)=pw(n)
  20  gamma0=alfa0*g(1,2)+alfa1*p(1,2)
      r1(1)=gamma0
      if(iebcoe.eq.0) go to 30
c*****specified edge temperature
      beta0=1.0
      beta1=0.0
      g(np,2)=ge(n)
      p(np,2)=0.0
      go to 40
c*****specified edge temperature gradient*********************
  30  beta0=0.0
      beta1=1.0
      g(np,2)=0.0
      p(np,2)=0.0
  40  gamma1=beta0*g(np,2)+beta1*p(np,2)
      r2(np)=gamma1
c*****  w  elements for j=1
      w1(1)=r1(1)
      w2(1)=r2(1)
c*****  alfa elements for j=1***********************************
      a11(1)=alfa0
      a12(1)=alfa1
      a21(1)=-1.0
      a22(1)=-0.5*deta(1)
c*****  gamma elements for j=2*******************************
      det=alfa1-0.5*deta(1)*alfa0
      g11(2)=(s2(2)-0.5*deta(1)*s3(2))/det
      g12(2)=(alfa0*s2(2)-alfa1*s3(2))/det
c*****  forward sweep***************************************
      do 60 j=2,np
      den(j)=a11(j-1)*a22(j-1)-a21(j-1)*a12(j-1)
      if(j.eq.2) go to 50
      g11(j)=(s3(j)*a22(j-1)-s2(j)*a21(j-1))/den(j)
      g12(j)=(s2(j)*a11(j-1)-s3(j)*a12(j-1))/den(j)
 50   a11(j)=s3(j)-g12(j)
      a12(j)=s1(j)+a(j)*g12(j)
      a21(j)=-1.0
      a22(j)=-a(j+1)
      w1(j)=r1(j)-g11(j)*w1(j-1)-g12(j)*w2(j-1)
      w2(j)=r2(j)
  60  continue
c*****  backward sweep**************************************
      deno=a11(np)*beta1-a12(np)*beta0
      g(np,2)=(w1(np)*beta1-w2(np)*a12(np))/deno
      p(np,2)=(w2(np)*a11(np)-beta0*w1(np))/deno
      j=np
  70  j=j-1
      e1=w2(j)-g(j+1,2)+a(j+1)*p(j+1,2)
      g(j,2)=(w1(j)*a22(j)-e1*a12(j))/den(j+1)
      p(j,2)=(e1*a11(j)-w1(j)*a21(j))/den(j+1)
      if(j.gt.1) go to 70
      return
      end
