package samples.business;

import javacard.framework.ISO7816;
import javacard.framework.ISOException;

/**
 * A Business Card Record, as it is stored on the JavaCard.  Each record
 * has the same fixed size.
 */
public class BizCardRecord  {
	private BizCardField bcf0;
	private BizCardField bcf1;
	private BizCardField bcf2;
	private BizCardField bcf3;
	private BizCardField bcf4;

/**
 * Private function to initialize an empty BizCardRecord
 */
private void init() {
     	bcf0 = new BizCardField( (short)20);
     	bcf1 = new BizCardField( (short)14);
     	bcf2 = new BizCardField( (short)27);
     	bcf3 = new BizCardField( (short)20);
     	bcf4 = new BizCardField( (short)50);
}

/**
 * Construct an empty BizCardRecord
 */
public BizCardRecord () {
       this.init();
}

/**
 * Construct a BizCardRecord from five byte arrays
 */
public BizCardRecord ( byte[] f0, byte[] f1, byte[] f2, byte[] f3, byte[] f4) {
       this.init();
       bcf0.update(f0);
       bcf1.update(f1);
       bcf2.update(f2);
       bcf3.update(f3);
       bcf4.update(f4);
}

/**
 * Return the n-th field.  As with arrays, n starts with 0.
 */
public BizCardField getField(byte n) {
       BizCardField field = null;
       switch (n) {
           case 0x00 : field = bcf0; break;
           case 0x01 : field = bcf1; break;
           case 0x02 : field = bcf2; break;
           case 0x03 : field = bcf3; break;
           case 0x04 : field = bcf4; break;
           default   : ISOException.throwIt(ISO7816.SW_WRONG_P1P2);
       }
       return field;
}

/**
 * Set the n-th field.  As with arrays, n starts with 0.
 */
public void setField(byte n, byte[] bytes) {
       setField(n, bytes, (short)0, (short)bytes.length);
       return;
}

/**
 * Set the n-th field.  As with arrays, n starts with 0.
 */
public void setField(byte n, byte[] bytes, short offset, short length) {
       switch (n) {
           case 0x00 : bcf0.update(bytes, offset, length); break;
           case 0x01 : bcf1.update(bytes, offset, length); break;
           case 0x02 : bcf2.update(bytes, offset, length); break;
           case 0x03 : bcf3.update(bytes, offset, length); break;
           case 0x04 : bcf4.update(bytes, offset, length); break;
           default   : ISOException.throwIt(ISO7816.SW_WRONG_P1P2);
       }
       return;
}
};
