package samples.business;

/*
 * Copyright  1998 - 2002 IBM Corporation.
 *
 * Redistribution and use in source (source code) and binary (object code)
 * forms, with or without modification, are permitted provided that the
 * following conditions are met:
 * 1. Redistributed source code must retain the above copyright notice, this
 * list of conditions and the disclaimer below.
 * 2. Redistributed object code must reproduce the above copyright notice,
 * this list of conditions and the disclaimer below in the documentation
 * and/or other materials provided with the distribution.
 * 3. The name of IBM may not be used to endorse or promote products derived
 * from this software or in any other form without specific prior written
 * permission from IBM.
 * 4. Redistribution of any modified code must be labeled "Code derived from
 * the original OpenCard Framework".
 *
 * THIS SOFTWARE IS PROVIDED BY IBM "AS IS" FREE OF CHARGE. IBM SHALL NOT BE
 * LIABLE FOR INFRINGEMENTS OF THIRD PARTIES RIGHTS BASED ON THIS SOFTWARE.  ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IBM DOES NOT WARRANT THAT THE FUNCTIONS CONTAINED IN THIS
 * SOFTWARE WILL MEET THE USER'S REQUIREMENTS OR THAT THE OPERATION OF IT WILL
 * BE UNINTERRUPTED OR ERROR-FREE.  IN NO EVENT, UNLESS REQUIRED BY APPLICABLE
 * LAW, SHALL IBM BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.  ALSO, IBM IS UNDER NO OBLIGATION
 * TO MAINTAIN, CORRECT, UPDATE, CHANGE, MODIFY, OR OTHERWISE SUPPORT THIS
 * SOFTWARE.
 */

/**
 * BusinessInfo encapsulates a business information entry as can be stored by 
 * the BusinessCardApplet.
 *
 * @author  Thomas Schaeck (schaeck@de.ibm.com)
 * @version $Id: BusinessInfo.java,v 1.1 1998/09/02 16:12:08 cvsusers Exp $
 */
public class BusinessInfo {
	/** The name. */
	protected String name_ = null;

	/** The title. */
	protected String title_ = null;

	/** The e-mail address. */
	protected String email_ = null;

	/** The phone number. */
	protected String phone_ = null;

	/** The address. */
	protected String address_ = null;

/**
 * Creates a new BusinessInfo instance for a person.
 *
 * @param name    The name of the person.
 * @param title   The title of the person.
 * @param email   The E-mail address of the person.
 * @param phone   The phone number of the person.
 * @param address The address of the person.
 */
public BusinessInfo(String name, String title, String email, String phone, String address) {
	name_ = name;
	title_ = title;
	email_ = email;
	phone_ = phone;
	address_ = address;
}
/**
 * Gets the address.
 *
 * @return The address.
 */
public String getAddress() {
	return address_;
}
/**
 * Gets the e-mail address.
 *
 * @return The e-mail address.
 */
public String getEmail() {
	return email_;
}
/**
 * Gets the name.
 *
 * @return The name.
 */
public String getName() {
	return name_;
}
/**
 * Gets the phone number.
 *
 * @return The phone number.
 */
public String getPhone() {
	return phone_;
}
/**
 * Gets the title.
 *
 * @return The title.
 */
public String getTitle() {
	return title_;
}
/**
 * Sets the address.
 *
 * @param address The address.
 */
public void setAddress(String address) {
	address_ = address;
}
/**
 * Sets the E-mail address.
 *
 * @param email The E-mail address.
 */
public void setEmail(String email) {
	email_ = email;
}
/**
 * Sets the name.
 *
 * @param name The name.
 */
public void setName(String name) {
	name_ = name;
}
/**
 * Sets the phone number.
 *
 * @param phone The phone number.
 */
public void setPhone(String phone) {
	phone_ = phone;
}
/**
 * Sets the title.
 *
 * @param title The title.
 */
public void setTitle(String title) {
	title_ = title;
}
/**
 * Creates a string representing this BusinessInfo object.
 *
 * @return The string representing this object.
 */
public String toString() {
  StringBuffer sb = new StringBuffer();

  sb.append(">");
  sb.append(getTitle());
  sb.append(" ");
  sb.append(getName());
  sb.append("<\n Email: >");
  sb.append(getEmail());
  sb.append("<\n Phone: >");
  sb.append(getPhone());
  sb.append("<\n Address: >");
  sb.append(getAddress());
  sb.append("<");

  return sb.toString();
}
}
