package samples.business;

import java.util.Enumeration;
import java.util.Vector;
import java.util.Hashtable;
import opencard.core.OpenCardConstants;
import opencard.core.service.CardService;
import opencard.core.service.SmartCard;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardType;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminalException;
import opencard.core.util.HexString;
import opencard.core.util.Tracer;

/**
 * Creates instances of the Card Service <tt>AnyAppletProxy</tt>
 * for JavaCards. This class is cloned from the AnyAppletProxy
 * and serves testing purposes only to very the behavior with
 * concurrent Card Applets and associated Proxies.
 *
 * @author Frank Seliger (seliger@de.ibm.com)
 */
public class AnyAppletProxyFactory extends CardServiceFactory {

  public final static int JC_TYPE_2  = 0x02;

  private Tracer itracer = new Tracer(this, AnyAppletProxyFactory.class);
  /** Holds the services which are available. */
  private static Vector services_ = new Vector();

  static {
  	// This factory can create instances of AnyAppletProxy.
  	services_.addElement(AnyAppletProxy.class);
}
/**
 * Constructs an object of this class.
 */
public AnyAppletProxyFactory() {
}

/**
 * Returns an enumeration of known <tt>CardService</tt> classes.
 *
 * @param     type   The <tt>CardType</tt> for which to enumerate.
 *
 * @return    An <tt>Enumeration</tt> of class objects.
 */
protected Enumeration getClasses(CardType type)
{
    return services_.elements();
}

  /** Indicate whether this <tt>CardServiceFactory</tt> supports cards of this type
   * and/or installed card applications.  Would it be able
   * to instantiate a <tt>CardService</tt>s for cards of this type?
   * <p>
   * This factory does not read the card, rather it only judges from the card's ATR.
   *
   *
   * @param cid
   *	A <tt>CardID</tt> received from a <tt>Slot</tt>.
   * @param scheduler
   *   A <tt>CardServiceScheduler</tt> that could be used to communicate with
   *   the card to determine its type.  It is not used by this factory.
   *
   * @return A valid CardType if the factory can instantiate services for this
   *   card.
   *  CardType.UNSUPPORTED if the factory does not support the card.
   *
   * @see ##getClassFor
   *
   */
protected CardType getCardType(CardID cid,
                                 CardServiceScheduler scheduler)
                                 throws CardTerminalException
{
    byte[] historicalBytes = cid.getHistoricals();
    byte[] IBM_JC_HIST = {
 			(byte)0x80, (byte)0x31, (byte)0xC0, (byte)0x6B, (byte)0x49,
 			(byte)0x42, (byte)0x4D, (byte)0x20, (byte)0x4A, (byte)0x65,
 			(byte)0x74, (byte)0x5A, (byte)0x20, (byte)0x4D, (byte)0x32};
  	itracer.debug("getCardType", "historicalBytes = " + HexString.hexify(historicalBytes));
  	itracer.debug("getCardType", "IBM_JC_HIST = " + HexString.hexify(IBM_JC_HIST));
    short s;
    for (s = 0; s <= 12; s++) {
      if ( historicalBytes[s] != IBM_JC_HIST[s]) {
        itracer.debug("getCardType", "returns CardType.UNSUPPORTED.");
        return CardType.UNSUPPORTED;
      }
    }
    itracer.debug("getCardType", "returns new CardType(JC_TYPE_2).");
    return new CardType(JC_TYPE_2);
}
};
