package samples.business;

import opencard.core.util.Tracer;

/**
 * AnyAppletState represents the state of an arbitrary Applet
 * on a JavaCard. The state is mainly, if the CHV was entered after the applet
 * became selected.
 *
 * @author  Frank Seliger (seliger@de.ibm.com)
 *
 */
public class AnyAppletState extends AppletState {

   /** Remembers whether a successful card holder verification
   * has been performed. */
   protected boolean chvPerformed_ = false;
   private Tracer itracer = new Tracer(this, AnyAppletState.class);

public void appletDeselected() {
	chvPerformed_ = false;
}
/**
 * Check whether a successful card holder verification has already
 * been performed.
 *
 * @return true if a successful card holder verification has been
 *         performed, false otherwise.
 */
public boolean isCHVPerformed() {
	   itracer.debug("isCHVPerformed", "returns " + chvPerformed_);
	return chvPerformed_;
}
/**
 * Sets the card holder verification flag to the given value.
 *
 * @param chvPerformed Indicates whether a successful
 *                     card holder verification has been performed;
 *                     true indicates yes, false indicates no.
 */
public void setCHVPerformed(boolean chvPerformed) {
	chvPerformed_ = chvPerformed;
}
}
