package samples.business;

/**
 * Applet states are to be used for representing the state of an applet
 * to applet proxies associated with that applet. Different applet proxies
 * can cooperate via state objects.
 *
 * @author  Thomas Schaeck (schaeck@de.ibm.com)
 *
 * @version $Id: AppletProxy.java,v 1.2 1998/09/03 12:17:08 cvsusers Exp $
 */
public abstract class AppletState {
/**
 * This method is to be called when the applet to which the
 * <tt>AppletState</tt> belongs was deselected.
 * It gives the state the possibility to adapt to the change of the
 * applet state on the card caused by applet deselection.
 */
abstract void appletDeselected();
}
