package samples.business;

import javacard.framework.Util;

/**
 * A Field in a Business Card Record, as it is stored on the JavaCard
 *
 */
public class BizCardField  {
	byte[] data;
       short  length;


/**
 * Construct an empty Business Card Field
 * @param bufferSize - short specifying the size of the reusable buffer
 */
public BizCardField ( short bufferSize) {
       data = new byte[bufferSize];
       data[0] = (byte)'?';
       length = 1;
}

/**
 * Construct a Business Card Field from a byte array (deep copy).
 * @param bytes  - byte[] containing the data contents
 * @param bufferSize - short specifying the size of the reusable buffer
 */
public BizCardField ( byte[] bytes, short bufferSize) {
       data = new byte[bufferSize];
       this.update(bytes);
}

/**
 * Update a Business Card Field from a byte array (deep copy)
 * @param bytes - byte[] containing the new data
 */
public void update( byte[] bytes) {
       update(bytes, (short)0, (short)bytes.length);
}

/**
 * Update a Business Card Field from a byte array (deep copy)
 * @param bytes - byte[] containing the new data
 * @param offset - offset in the source bytes
 * @param lng - length of update data
 */
public void update( byte[] bytes, short offset, short lng) {
       length = lng;
       if (length > data.length) {     // Get a larger buffer.  This is not
           byte [] oldData = data;     // ... always a good strategy on a
           data = new byte[length];    // ... Java Card.  It could fail when
                                       // ... the memory is filled up.
       }
       Util.arrayCopy(bytes, offset, data, (short)0, length);
}

}
