package samples.business;
import samples.business.AppletState;

/**
 * BusinessCardState represents the state of an arbitrary Applet
 * on a JavaCard. The state is mainly, if the CHV was entered after the applet
 * became selected.
 *
 * @author Thomas Schaeck (schaeck@de.ibm.com)
 *
 * @version $Id: BusinessCardState.java,v 1.1 1998/09/02 16:12:08 cvsusers Exp $
 */
public class BusinessCardState extends AppletState {
	/** Remembers whether a successful card holder verificatio has been performed. */
	protected boolean chvPerformed_ = false;
  /**
   * This method is expected to be called by the select methods of proxies
   * which are not assiciated to the same applet as the state object
   * to indicate when the applet associated with this state is deselected.
   */
  public void appletDeselected() {
	chvPerformed_ = false;
  }
  /**
   * Checks whether a successful card holder verification has already
   * been performed.
   *
   * @return true if a successful card holder verification has been
   *         performed, false otherwise.
   */
  public boolean isCHVPerformed() {
	return chvPerformed_;
  }
  /**
   * Sets the card holder verification flag to the given value.
   *
   * @param chvPerformed Indicates whether a successful
   *                     card holder verification has been performed;
   *                     true indicates yes, false indicates no.
   */
  public void setCHVPerformed(boolean chvPerformed) {
	chvPerformed_ = chvPerformed;
  }
}
