package samples.business;

//?? Start of section for testing of selection change
import opencard.core.service.SmartCard;
import opencard.core.service.CardRequest;
//?? End of section for testing of selection change

/**
 * BusinessTest is a little test program for <tt>BusinessCard</tt>,
 * <tt>BusinessCardProxy</tt> and <tt>BusinessCardApplet</tt>.
 *
 * <tt>main</tt> creates and starts some instances of <tt>BusinessCardTest</tt>
 * which create their own <tt>SmartCard</tt> and <tt>BusinessCardProxy</tt>
 * object and concurrently access the data stored by <tt>BusinessCardApplet</tt>
 * on the JavaCard.
 *
 * @author  Thomas Schaeck (schaeck@de.ibm.com)
 *
 * @version $Id: BusinessTest.java,v 1.1 1998/09/02 16:12:08 cvsusers Exp $
 */
public class BusinessTest implements Runnable {
	/** The number of threads to be created. */
	final static int NUM_THREADS = 1;

	/** The object used for accessing data stored by the <tt>BusinessCardApplet</tt>
	  on the card. */
	BusinessCard businessCard = null;
	
	/** The thread running this instance. */
	protected Thread thread_ = null;

/**
 * Creates a new BusinessTest instance.
 */
public BusinessTest(boolean setInfo) {
	super();
	try {
		businessCard = new BusinessCard();
		if (setInfo == true) {
			businessCard.setBusinessInfo(0, new BusinessInfo("Thomas Schaeck", "Dipl. Inf.", "schaeck@de.ibm.com", "+49 7031 16 3479", "D-71032 Boeblingen"));
			businessCard.setBusinessInfo(1, new BusinessInfo("Frank Seliger", "Dipl. Phys.", "seliger@de.ibm.com", "+49 7031 16 3142", "D-71032 Boeblingen"));
		}
	} catch (BusinessCardException e) {
		e.printStackTrace();
		System.exit(0);
	}
	thread_ = new Thread(this);
}
/**
 * Starts the application.
 * @param args an array of command-line arguments
 */
public static void main(java.lang.String[] args) {
	BusinessTest[] businessTests = new BusinessTest[NUM_THREADS];
	boolean setInfo = true; // Default: set new info on card at first
	if (args.length > 0)
		setInfo = false; // Any argument passed: Do not init card

	// Create the test objects.
	for (int i = 0; i < NUM_THREADS; i++) {
		System.out.println("Creating thread " + i);
		if (i > 0)
			setInfo = false; // only on first thread
		if (setInfo == true)
			System.out.println("The card info is set in this thread");
		businessTests[i] = new BusinessTest(setInfo);
	}

	// Start the test objects.
	for (int i = 0; i < NUM_THREADS; i++) {
		System.out.println("Starting thread " + i);
		businessTests[i].start();
	}
}
/**
 * Prints the the thread belonging to this object, followed
 * by the given string.
 *
 * @param s The string to be printed.
 */
public void println(String s)
{
  System.out.println(thread_ + s);
}
public void run() {
	try {
		//?? Start of section for testing of selection change
		SmartCard card = SmartCard.waitForCard(new CardRequest());
		AnyAppletProxy otherAppletProxy = (AnyAppletProxy) card.getCardService(AnyAppletProxy.class, true);
		println("Retrieving info from AnyCardApplet now ...");
		println("Phone[1]: >" + otherAppletProxy.getPhone(1) + "<");
		//?? End of section for testing of selection change

		println("Reading business info 0 ...");
		BusinessInfo businessInfo0 = businessCard.getBusinessInfo(0);
		println("Business Info 0 = \n" + businessInfo0);
		println("Reading business info 1 ...");
		BusinessInfo businessInfo1 = businessCard.getBusinessInfo(1);
		println("Business Info 1 = \n" + businessInfo1);

		// long name to force buffer extension
		businessInfo0.setName("Thomas [no-middle-initial] Schaeck");
		businessInfo0.setPhone("+49 7031 / 16 - 3479");
		println("Business Info 0 = \n" + businessInfo0);

		//?? Start of section for testing of selection change
		// Force another pair of selection changes
		println("Storing info to AnyCardApplet now ...");
		otherAppletProxy.setPhone(1, "+49 7034 63 909");
		//?? End of section for testing of selection change

		println("Writing back business info 0 ...");
		businessCard.setBusinessInfo(0, businessInfo0);
		println("Re-reading business info 0 ...");
		businessInfo0 = businessCard.getBusinessInfo(0);
		println("Business Info 0 = \n" + businessInfo0);
	} catch (BusinessCardException e) {
		e.printStackTrace();
	} catch (Exception e) {
		e.printStackTrace();
	}
}
/**
 * Start the test.
 */
public void start() {
	thread_.start();
}
}