package samples.business;

import java.util.Hashtable;
import java.util.Enumeration;

import opencard.opt.management.ApplicationID;
import opencard.core.service.CardChannel;

import opencard.core.util.Tracer;

/**
 * Encapsulates the state of a JavaCard. All instances of the class
 * JavaCardService associated with the same physical JavaCard share
 * a common state object to assure a consistent view.
 *
 * @author  Thomas Schaeck (schaeck@de.ibm.com)
 * @author  Frank Seliger  (seliger@de.ibm.com
 *
 * @version $Id: CardExecutiveState.java,v 1.2 1998/09/03 12:17:08 cvsusers Exp $
 */
public class CardExecutiveState
{
  private Tracer itracer = new Tracer(this, CardExecutiveState.class);

  /** The application identifier of the currently selected applet. */
  protected ApplicationID selectedAppletAID_ = null;
 /**
  * Create a CardExecutive state object.
  */
  protected CardExecutiveState() {
	super();
  }
  /**
   * Gets the Application Identifier of the currently selected Applet.
   *
   * @return application ID of selected Applet
   */
  public ApplicationID getSelectedAppletAID()
  {
	return selectedAppletAID_;
  }
  /**
   * Sets the Application Identifier of the currently selected card applet.
   *
   * @param applicationID The application ID of new selected card applet.
   *
   * @return The applet ID of the previously selected applet.
   */
  public ApplicationID setSelectedAppletAID(ApplicationID applicationID) {
	// Remember the old selected applet ID to be returned.
	ApplicationID oldSelectedAppletID = selectedAppletAID_;
	selectedAppletAID_ = applicationID;
	return oldSelectedAppletID;
  }
}