package samples.readfile;

import opencard.core.service.SmartCard;
import opencard.core.service.CardRequest;
import opencard.opt.iso.fs.FileAccessCardService;
import opencard.opt.iso.fs.CardFile;

public class ReadFile {
   public static void main(String[] args)
   {
      System.out.println("Reading file from smart card... ");

      try {
         SmartCard.start();

         // Wait for a smart card with a FileAccessCardService
         CardRequest cr = new
            CardRequest(FileAccessCardService.class);
         SmartCard sc = SmartCard.waitForCard(cr);

         if (sc == null) {
            // A smart card was inserted that does not match
            // Handle how it would be appropriate in your app
         }
         else {
           FileAccessCardService facs = (FileAccessCardService)
              sc.getCardService(FileAccessCardService.class, true);
           CardFile file = new CardFile(facs, ":c009");

           byte[] data = facs.read(file.getPath(),
                            0,  file.getLength());
           System.out.println(new String(data));

           // We are done with this smart card.
           sc.close();
         }

      }  catch (Exception e) {
         e.printStackTrace();

      } finally { // even in case of an error..
         try{
            SmartCard.shutdown();
         } catch (Exception e) {
         e.printStackTrace();
         }
      }



      System.exit(0);
   }
}

